<?php

/**
 * This file is part of an ADDON for use with LEPTON Core.
 * This ADDON is released under the GNU GPL.
 * Additional license terms can be seen in the info.php of this module.
 *
 * @module			Twig Template Engine
 * @author			LEPTON Project
 * @copyright       2010-2025 LEPTON 
 * @link			https://lepton-cms.org
 * @license			http://www.gnu.org/licenses/gpl.html
 * @license_terms	please see info.php of this module
 *
 */

namespace lib_twig\classes\nodes;

#[\Twig\Attribute\YieldReady]
class Line extends \Twig\Node\Node
{
    public int $iMyLine = 0;
    public string $sMyPath = "";
    
    public function __construct($line, $path)
    {
        $this->iMyLine = $line;
        $this->sMyPath = str_replace(LEPTON_PATH, "~", $path);

        parent::__construct([], [], $line);
    }
    
    public function compile(\Twig\Compiler $compiler)
    {
        $compiler
            ->addDebugInfo($this)
            ->write('yield \'file: '.$this->sMyPath.'\'.\' -<br> \';')
            ->write('yield \'line: '.$this->iMyLine.'\';')
            ->write(PHP_EOL)
        ;
    }
}
