<?php

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 *
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 *
 * @author          LEPTON Project
 * @copyright       2010-2025 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         https://gnu.org/licenses/gpl-3.0.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */

// include secure.php to protect this file and the whole CMS!
if(!defined("SEC_FILE")){define("SEC_FILE",'/framework/secure.php' );}
if (defined('LEPTON_PATH')) {	
	include LEPTON_PATH.SEC_FILE;
} else {
	$oneback = "../";
	$root = $oneback;
	$level = 1;
	while (($level < 10) && (!file_exists($root.SEC_FILE))) {
		$root .= $oneback;
		$level += 1;
	}
	if (file_exists($root.SEC_FILE)) { 
		include $root.SEC_FILE;   
	} else {
		trigger_error(sprintf("[ <b>%s</b> ] Can't include secure.php!", $_SERVER['SCRIPT_NAME']), E_USER_ERROR);
	}
}
// end include secure file


$info = '@DEPRECATED_TEMP 20250823: this method will be removed in L* > 7.4.0, see "cookie" for an example how to solve it';
echo(LEPTON_tools::display_dev($info, 'pre','ui orange message'));
echo (LEPTON_tools::display(debug_print_backtrace(), 'pre','ui message'));


$admin = LEPTON_admin::getInstance('Addons', 'modules_install');

$aLookForValues = [
    "btn_showmodinfo"   => ["type"  => "string", "default" => "" ]
];

$aPostedValues = LEPTON_request::getInstance()->testPostValues( $aLookForValues );

if (("" !== $aPostedValues["btn_showmodinfo"]) && (class_exists($aPostedValues["btn_showmodinfo"], true)))
{
    eval("\$oMODULE= ".$aPostedValues["btn_showmodinfo"]."::getInstance();");

    // show the module info
    $sSource = $oMODULE->showmodinfo();
    if (true !== $sSource)
    {
	    echo $sSource;
    }
}

$admin->print_footer();
