<?php

declare(strict_types=1);

/**
 * This file is part of LEPTON Core, released under the GNU GPL
 * Please see LICENSE and COPYING files in your package for details, specially for terms and warranties.
 *
 * NOTICE:LEPTON CMS Package has several different licenses.
 * Please see the individual license in the header of each single file or info.php of modules and templates.
 *
 * @author          LEPTON Project
 * @copyright       2010-2025 LEPTON Project
 * @link            https://lepton-cms.org
 * @license         https://gnu.org/licenses/gpl.html
 * @license_terms   please see LICENSE and COPYING files in your package
 *
 */

class account
{
    use LEPTON_singleton;

	public object|null $oTWIG = null;	
    public static $instance;

    protected function __construct()
    {
		if(! isset($_SESSION['account_error_id']))
		{
			$_SESSION['account_error_id'] = '';
		}
		$this->initialize();		
    }
	
    protected function initialize(): void
    {
		// use the custom or standard path for lte files
		$this->oTWIG = lib_twig_box::getInstance();
		$this->oTWIG->registerPath(LEPTON_PATH.'/account/templates/');		
		if(file_exists(LEPTON_PATH.'/templates/'.DEFAULT_TEMPLATE.'/frontend/login/templates/index.php'))
		{
			$this->oTWIG->registerPath(LEPTON_PATH.'/templates/'.DEFAULT_TEMPLATE.'/frontend/login/templates/');
		}
	}		

    public function getErrorMesssage(): string
    {
		return (string)$_SESSION['account_error_id'] ?? '';
    }
	
	public static function print_error($err) 
	{
		$_SESSION['account_error_id'] = $err;
		header("Location: ".LEPTON_URL."/account/signup.php?err=".$err);
		exit();
	}
}