<?php
declare(strict_types = 1);

class_exists('DB') || die;

// Paramètres par défaut.
define('THEME_PARAMS_DEFAULT',
[
	'style' => 'clear',
	'style_change' => '0',
	'color' =>
	[
		'clear' => '#3B5EB5',
		'dark' => '#D54949'
	],
	'banner' =>
	[
		'clear' =>
		[
			'type' => 'texture',
			'texture' => 'diamond-upholstery.png',
			'file' => '',
			'height' => '120px'
		],
		'dark' =>
		[
			'type' => 'texture',
			'texture' => 'diamond-upholstery.png',
			'file' => '',
			'height' => '120px'
		]
	],
	'background' =>
	[
		'clear' =>
		[
			'type' => 'border',
			'fixed' => '1',
			'texture' => 'swirl-pattern.png',
			'file' => '',
			'bottom_texture' => '0'
		],
		'dark' =>
		[
			'type' => 'border',
			'fixed' => '1',
			'texture' => 'stardust.png',
			'file' => '',
			'bottom_texture' => '0',
			'internal_hatches' => '0'
		]
	],
	'buttons' =>
	[
		'clear' => ['style' => '1'],
		'dark' => ['style' => '1']
	],
	'css' =>
	[
		'clear' => '',
		'dark' => ''
	],
	'gallery' =>
	[
		'size' => 'small'
	],
	'menu' =>
	[
		'width' => '100'
	],
	'text' =>
	[
		'desc_width_limit' => '1',
		'size' => '100'
	],
	'thumbs_cat' =>
	[
		'layout' => 'landscape',
		'size' => 'small'
	],
	'thumbs_items' =>
	[
		'layout' => 'standard',
		'size' => 'small'
	],
	'display' =>
	[
		'item_pagination_bottom' => '1',
		'item_pagination_top' => '0',
		'item_prev_next' => '1',
		'item_properties' => '1',
		'item_stats' => '1',
		'item_title' => '1',
		'item_user' => '1',
		'menu' => '1',
		'menu_home' => '1'
	]
]);

$print = function($str, ...$values)
{
	vprintf("\t$str\n", $values);
};

// Paramètres en base de données.
$params =& Template::$data['theme']['params'];

// Mise à jour des paramètres.
$update = function(string $section, array &$values, array &$params) use (&$update): void
{
	foreach ($values as $name => &$v)
	{
		if (!array_key_exists($name, $params[$section]))
		{
			$params[$section][$name] = $v;
		}
		else if (is_array($v))
		{
			$update($name, $v, $params[$section]);
		}
	}
};
foreach (THEME_PARAMS_DEFAULT as $section => &$values)
{
	if (!array_key_exists($section, $params))
	{
		$params[$section] = $values;
	}
	else if (is_array($values))
	{
		$update($section, $values, $params);
	}
}

// Style.
$theme_edit = $tpl['user']['admin'] || $params['style_change'];
Template::set('theme', ['style' => $params['style']]);
Template::set('theme', ['user_style' => $params['style']]);
Template::set('theme', ['user_style_change' => (int) $params['style_change']]);

// Style utilisateur.
if ($params['style_change'] && is_object(Auth::$prefs))
{
	$user_style = (string) Auth::$prefs->read('theme_default_user_style');
	if (in_array($user_style, ['clear', 'dark']))
	{
		Template::set('theme', ['user_style' => $params['style'] = $user_style]);
	}
}

// Liste des textures disponibles.
$textures =
[
	'banner' =>
	[
		'clear' =>
		[
			'cubes.png' => '',
			'diamond-upholstery.png' => '',
			'dimension.png' => '',

			'foggy-birds.png' => '',
			'food.png' => '',
			'green-gobbler.png' => '',

			'light-wool.png' => '',
			'starring.png' => '',
			'tiny-grid.png' => ''
		],
		'dark' =>
		[
			'brushed-alum.png' => '#111',
			'climpek.png' => '#4c4c4c',
			'cubes.png' => '#4c4c4c',

			'diamond-upholstery.png' => '#3c3c3c',
			'dimension.png' => '#4c4c4c',
			'escheresque.png' => '#111',

			'foggy-birds.png' => '#4c4c4c',
			'light-wool.png' => '#4c4c4c',
			'subtle-stripes.png' => '#4c4c4c'
		]
	],
	'background' =>
	[
		'clear' =>
		[
			'arches.png' => '#fff',
			'batthern.png' => '#fff',
			'climpek.png' => '#fff',

			'dimension.png' => '#fff',
			'food.png' => '#fff',
			'hatches.png' => '#fff',

			'memphis-colorful.png' => '#fff',
			'swirl-pattern.png' => '#fff',
			'washi.png' => '#fff',

			'squares-2.png' => '#fff',
			'squares-15.png' => '#fff',
			'squares-30.png' => '#fff'
		],
		'dark' =>
		[
			'black-mamba.png' => '#111',
			'simple-dashed.png' => '#111',
			'stardust.png' => '#111'
		]
	]
];

// Répertoires.
$banners_dir = CONF_GALLERY_PATH . '/images/banners/';
$background_dir = CONF_GALLERY_PATH . '/images/background/';
$textures_dir = CONF_GALLERY_PATH . '/images/textures/';

// Classes pour <body> et variables CSS.
$body_class = [];
$variables = [];

// Style sombre.
if ($params['style'] == 'dark')
{
	$print('<link rel="stylesheet" type="text/css" media="screen" '
	. 'title="style" href="' . $tpl['gallery']['template']['path']()
	. '/style/dark.css?' . $tpl['version_key'] . '" id="style_dark">');
}

// Couleur du thème.
$params['color']['clear'] = '#' . str_replace(
	'#', '', strtolower((string) $params['color']['clear'])
);
$params['color']['dark'] = '#' . str_replace(
	'#', '', strtolower((string) $params['color']['dark'])
);
$color = substr($params['color'][$params['style']], 1);
$variables['--color'] = '#' . $color;

// Boutons de formulaires.
if ($params['style'] == 'clear' && $params['buttons']['clear']['style'] == '2')
{
	$body_class[] = 'btn_2_clear';
}
if ($params['style'] == 'dark' && $params['buttons']['dark']['style'] == '2')
{
	$body_class[] = 'btn_2_dark';
}

// Bannière.
$variables['--header-height'] = $params['banner'][$params['style']]['height'];
switch ($params['banner'][$params['style']]['type'])
{
	case 'file' :
	case 'texture' :
		$header_class = 'banner';
		break;

	case 'color' :
		$header_class = 'color';
		break;

	default :
		$header_class = 'none';
}

if ($params['banner'][$params['style']]['type'] == 'texture')
{
	$file = $params['banner'][$params['style']]['texture'];
	$color = $textures['banner'][$params['style']][$file] ?? '';
	$variables['--banner-color'] = $color
		? $color
		: ($params['style'] == 'clear' ? $variables['--color'] : '#4c4c4c');
	$variables['--banner-image'] = 'url(' . $textures_dir . $file . ')';
}

if ($params['banner'][$params['style']]['type'] == 'file')
{
	$file = $params['banner'][$params['style']]['file'] ?? '';
	$variables['--banner-color'] = 'transparent';
	$variables['--banner-image'] = 'url(' . $banners_dir . $file . ')';
	$variables['--banner-size'] = 'cover';
	$variables['--banner-position'] = 'center';
	$variables['--banner-repeat'] = 'no-repeat';
}

// Fond.
if ($params['background'][$params['style']]['type'] != 'none')
{
	$body_class[] = 'bg';
}
else if ($params['background'][$params['style']]['bottom_texture'])
{
	$body_class[] = 'bottom_bg';
}
if ($params['style'] == 'dark' && $params['background']['dark']['internal_hatches'])
{
	$body_class[] = 'hatches';
}

$variables['--background-color'] = $params['style'] == 'dark' ? '#111' : 'none';
$variables['--background-attachment'] = $params['background'][$params['style']]['fixed'] == 1
	? 'fixed'
	: 'scroll';

if ($params['background'][$params['style']]['type'] == 'texture')
{
	$file = $params['background'][$params['style']]['texture'];
	$variables['--background-color'] = $textures['background'][$params['style']][$file];
	$variables['--background-image'] = 'url(' . $textures_dir . $file . ')';
}

if ($params['background'][$params['style']]['type'] == 'file')
{
	$file = $background_dir . $params['background'][$params['style']]['file'];
	$variables['--background-image'] = 'url(' . $file . ')';
}

// Largeur du menu.
$variables['--menu-max-width'] = $params['menu']['width'] . '%';

// Largeur des descriptions.
$variables['--desc-max-width'] = $params['text']['desc_width_limit'] ? 'min(80%, 900px)' : 'none';

// Taille du texte.
$variables['--text-size'] = $params['text']['size'] . '%';

// Variables CSS.
$root = [];
foreach ($variables as $var => &$value)
{
	$root[] = "\t\t$var: $value;";
}
$print(
	"<style nonce=\"%s\" type=\"text/css\">\n\t:root\n\t{\n%s\n\t}\n\t</style>",
	CSP_NONCE, implode("\n", $root)
);

// Code CSS personnalisé.
$css = '';
if (trim($params['css'][$params['style']]))
{
	$tags = ['#color', '#gallery_path'];
	$tags_replace = ["#$color", $tpl['gallery']['path']];
	$css = preg_replace_callback(
		'`(\{(?:[\s\S](?![{}]))*?)(' . implode('|', $tags) . ')((?:[\s\S](?![{]))*?\})`i',
		function($m) use ($color, $tags, $tags_replace)
		{
			return str_ireplace($tags, $tags_replace, $m[0]);
		},
		$params['css'][$params['style']]
	);
	$css = str_replace(['&#039;', '&quot;', '&gt;', "\n"], ["'", '"', '>', "\n\t"], $css);
}
if ($css || $tpl['user']['admin'] || $params['style_change'])
{
	$print(
		"<style nonce=\"%s\" type=\"text/css\" id=\"style_custom\">%s</style>",
		CSP_NONCE, trim($css) ? "\n\t$css\n\t" : ''
	);
}

// Taille et type d'affichage des vignettes.
$thumbs_cat_size = $params['thumbs_cat']['size'];
$thumbs_items_size = $params['thumbs_items']['size'];
$thumbs_cat_layout = implode(' ', [$params['thumbs_cat']['layout'], $thumbs_cat_size]);
$thumbs_items_layout = implode(' ', [$params['thumbs_items']['layout'], $thumbs_items_size]);

// Taille de la galerie.
$gallery_size = in_array($params['gallery']['size'], ['small', 'large', 'superlarge'])
	? $params['gallery']['size']
	: 'small';

// Format des vignettes.
switch ($params['thumbs_items']['layout'])
{
	case 'landscape' :
		$thumbs_items_size = $thumbs_items_size == 'superlarge'
			? '378x252'
			: ($thumbs_items_size == 'large' ? '248x165' : '161x107');
		break;
	case 'portrait' :
		$thumbs_items_size = $thumbs_items_size == 'superlarge'
			? '378x566'
			: ($thumbs_items_size == 'large' ? '248x371' : '161x241');
		break;
	case 'square' :
		$thumbs_items_size = $thumbs_items_size == 'superlarge'
			? '378x378'
			: ($thumbs_items_size == 'large' ? '248x248' : '161x161');
		break;
	default :
		$thumbs_items_size = $thumbs_items_size == 'superlarge'
			? '368'
			: ($thumbs_items_size == 'large' ? '238' : '151');
		break;
}
switch ($params['thumbs_cat']['layout'])
{
	case 'portrait' :
		$thumbs_cat_size = $thumbs_cat_size == 'large' ? '363x544' : '232x348';
		break;
	case 'square' :
		$thumbs_cat_size = $thumbs_cat_size == 'large' ? '363x363' : '232x232';
		break;
	default :
		$thumbs_cat_size = $thumbs_cat_size == 'large' ? '363x262' : '232x167';
		break;
}

// Éléments à afficher.
foreach ($params['display'] as $k => $v)
{
	${'display_' . $k} = (bool) $params['display'][$k];
}

// Fichiers JavaScript externes.
$js_files =
[
	$tpl['gallery']['path'] =>
	[
		'app.js' => TRUE,
		'diaporama.js' => !empty($tpl['diaporama']),
		'iro.js' => $tpl['user']['admin'],
		'upload.js' => $_GET['section'] == 'user-upload',
		'videocaptures.js' => !empty($tpl['video_captures'])
	],
	$tpl['gallery']['template']['path']() =>
	[
		'gallery.js' => TRUE,
		'boxes.js' => TRUE,
		'theme.js' => $params['style_change'] || $tpl['user']['admin'],
	]
];
foreach ($js_files as $path => &$files)
{
	foreach ($files as $file => &$condition)
	{
		if ($condition)
		{
			$print('<script type="text/javascript" src="%s"></script>',
				$path . '/js/' . $file . '?' . $tpl['version_key']);
		}
	}
}

// Constantes JavaScript.
$js_constants = [];
$js_constants['GALLERY'] =
[
	'anticsrf' => $tpl['anticsrf'](),
	'page' => (int) $_GET['page'],
	'path' => $tpl['gallery']['path'],
	'q_pageless' => $_GET['q_pageless'],
	'thumbs_cat_size' => $thumbs_cat_size,
	'thumbs_items_size' => $thumbs_items_size,
	'url_rewrite' => (int) CONF_URL_REWRITE,
	'version_key' => $tpl['version_key']
];
$js_constants['BOX'] =
[
	'form' =>
	[
		'remember' => (bool) $tpl['remember']
	],
	'l10n' =>
	[
		'cancel' => __('Annuler'),
		'delete' => __('Supprimer'),
		'delete_tab' => __('Suppression'),
		'password_auth' => __('Veuillez entrer le mot de passe '
			. 'pour accéder à cette partie de la galerie :'),
		'password' => __('Mot de passe'),
		'remember' => __('Se souvenir de moi ?'),
		'save' => __('Enregistrer'),
		'submit' => __('Valider')
	]
];
if (!empty($tpl['category_edit']))
{
	$js_constants['BOX_CATEGORY'] =
	[
		'form' =>
		[
			'description' => $tpl['category']['description_edit'],
			'title' => $tpl['category']['title']
		]
	];
}
if (!empty($tpl['comments_edit']))
{
	$js_constants['BOX_COMMENT'] =
	[
		'edit' => $tpl['comments_edit'],
		'form' => $tpl['comments_form'],
		'l10n' =>
		[
			'author' => __('Auteur :'),
			'delete_confirm' => __('Supprimer le commentaire ?'),
			'delete_info' => __('Cette action supprimera de façon définitive le commentaire.'),
			'edit' => __('Édition'),
			'email' => __('Courriel :'),
			'message' => __('Message :'),
			'website' => __('Site Web :'),
			'website_link' => __('site')
		]
	];
}
if (!empty($tpl['category_edit']) || !empty($tpl['item_edit']))
{
	$js_constants['BOX_EDIT'] =
	[
		'l10n' =>
		[
			'description' => __('Description :'),
			'information' => __('Informations'),
			'title' => __('Titre :')
		]
	];
}
if (!empty($tpl['category']['user_favorites']))
{
	$js_constants['BOX_FAVORITES'] =
	[
		'l10n' =>
		[
			'delete_confirm' => __('Êtes-vous sûr ?'),
			'delete_info' => $tpl['category']['user_favorites_delete_text']
		]
	];
}
if (!empty($tpl['item_edit']))
{
	$js_constants['BOX_ITEM'] =
	[
		'form' =>
		[
			'description' => $tpl['item']['description_edit'],
			'filename' => $tpl['item']['filename'],
			'tags' => implode(', ', $tpl['item']['tags_list']),
			'title' => $tpl['item']['title']
		],
		'l10n' =>
		[
			'delete_confirm' => __('Supprimer le fichier ?'),
			'delete_info' => __('Cette action supprimera de façon définitive le fichier'
				. ' ainsi que tous les commentaires et votes qui lui sont liés.'),
			'filename' => __('Nom de fichier :'),
			'tags_field' => __('Tags (séparés par une virgule) :'),
			'tags' => __('Tags')
		],
		'params' =>
		[
			'is_tags' => (bool) $tpl['config']('tags'),
		]
	];
}
if (!empty($tpl['users']) && !$tpl['user']['auth'])
{
	$js_constants['BOX_LOGIN'] =
	[
		'form' =>
		[
			'username_maxlength' => User::COLUMNS_LENGTH_MAX['login'],
			'password_maxlength' => User::COLUMNS_LENGTH_MAX['password']
		],
		'l10n' =>
		[
			'login' => __('Connexion'),
			'username' => __('Nom d\'utilisateur :'),
			'password' => __('Mot de passe :'),
			'remember' => __('Rester connecté'),
			'forgot' => __('Mot de passe oublié')
		]
	];
}
if ((!empty($tpl['categories']) || !empty($tpl['items']) || !empty($tpl['random_item']))
&& !empty($tpl['selection']))
{
	$js_constants['BOX_SELECTION'] =
	[
		'l10n' =>
		[
			'add_all' => __('Tout sélectionner sur cette page'),
			'add_tags' => __('Ajouter des tags (séparés par une virgule) :'),
			'admin' => __('Administrer'),
			'delete_confirm' => __('Supprimer les fichiers sélectionnés ?'),
			'delete_info' => __('Cette action supprimera de façon définitive les fichiers'
				. ' sélectionnés ainsi que tous les commentaires et votes qui leurs sont liés.'),
			'delete_selection' => __('Vider la sélection'),
			'delete_tags' => __('Supprimer des tags (séparés par une virgule) :'),
			'delete_tags_all' => __('Supprimer tous les tags'),
			'delete_tags_all_confirm' => __('Supprimer tous les tags'
				. ' de tous les fichiers sélectionnés ?'),
			'download' => __('Téléchargement'),
			'download_button' => __('Télécharger (archive Zip)'),
			'favorites' => __('Favoris'),
			'favorites_add' => __('Ajouter les fichiers sélectionnés aux favoris'),
			'favorites_remove' => __('Retirer les fichiers sélectionnés des favoris'),
			'move' => __('Déplacement'),
			'move_info' => __('Déplace les fichiers sélectionnés dans l\'album actuel.'),
			'move_button' => __('Déplacer'),
			'remove_all' => __('Tout désélectionner sur cette page'),
			'selection' => __('Sélection'),
			'selection_filesize' => __('Poids des fichiers sélectionnés : %s'),
			'selection_info' => __('Cliquez sur le bouton "Démarrer" pour commencer une '
				. 'sélection de fichiers, ou "Arrêter" pour sortir du mode sélection. Cliquez '
				. 'sur "Vider la sélection" pour retirer tous les fichiers de la sélection.'),
			'start' => __('Démarrer'),
			'stop' => __('Arrêter'),
			'tags' => __('Tags')
		],
		'params' =>
		[
			'is_admin' => (bool) $tpl['user']['admin'],
			'is_favorites' => (bool) $tpl['favorites'],
			'is_album' => isset($tpl['category']) && $tpl['category']['type'] == 'album',
			'is_tags' => (bool) $tpl['config']('tags'),
			'link' => $tpl['selection_params']['link'],
			'link_admin' => $tpl['selection_params']['link_admin'],
			'max_items' => (int) $tpl['selection_params']['max_items'],
			'start' => (bool) $tpl['selection_params']['start'],
			'stats' => $tpl['selection_params']['stats'],
			'tools' => $tpl['user']['auth'] && !empty($tpl['items'])
		]
	];
}
if (!empty($tpl['categories_browse']) && is_array($tpl['categories_browse']))
{
	$js_constants['BROWSE'] = $tpl['categories_browse'];
}
if (!empty($tpl['video_captures']))
{
	$js_constants['CAPTURES'] = $tpl['video_captures'];
}
if (!empty($tpl['category']))
{
	$js_constants['CATEGORY'] = ['id' => (int) $tpl['category']['id']];
}
if (!empty($tpl['diaporama']))
{
	$diaporama_thumb_size = $tpl['diaporama_carousel_thumbs_ratio'] == 'square'
		? '161x161'
		: '151';
	$js_constants['DIAPORAMA'] =
	[
		'item_id' => 0,
		'key' => [$tpl['diaporama_key']($diaporama_thumb_size)],
		'options' => $tpl['diaporama_options'],
		'position' => $tpl['diaporama_position'],
		'query' => $tpl['diaporama_query'],
		'thumb_size' => $diaporama_thumb_size
	];
}
if (!empty($tpl['item']) && $tpl['user']['auth'])
{
	$js_constants['FAVORITES'] =
	[
		'l10n' =>
		[
			'add' => __('Ajouter à mes favoris'),
			'remove' => __('Retirer de mes favoris')
		]
	];
}
if (!empty($tpl['item']))
{
	$js_constants['ITEM'] =
	[
		'id' => $tpl['item']['id'],
		'link' => $tpl['item']['link_item']
	];
}
if ($tpl['lang_switch'])
{
	$js_constants['LANG_SWITCH'] = array_values($tpl['lang_switch']);
}
if (!empty($tpl['worldmap']))
{
	$coords = [];
	foreach ($tpl['coords'] as $c => &$infos)
	{
		$categories = [];
		foreach ($infos['categories'] as $k => &$i)
		{
			$categories[$k] =
			[
				'id' => $i['id'],
				'link' => $i['link'],
				'source' => $i['thumb_src']('232x167'),
				'title' => $i['title']
			];
		}
		$items = [];
		foreach ($infos['items'] as $k => &$i)
		{
			$items[$k] =
			[
				'duration' => $i['duration'],
				'id' => $i['id'],
				'link' => $i['link'],
				'source' => $i['thumb_src'](),
				'title' => $i['title'],
				'type' => $i['type']
			];
		}
		$coords[$c] =
		[
			'categories' => $categories,
			'items' => $items,
			'lat' => $infos['lat'],
			'lng' => $infos['long']
		];
	}
	$js_constants['MARKERS'] = $coords;
}
if ($tpl['search'])
{
	$js_constants['SEARCH'] =
	[
		'l10n' =>
		[
			'submit' => __('Chercher'),
			'advanced' => __('Recherche avancée')
		],
		'params' =>
		[
			'advanced' => (bool) $tpl['search_advanced'],
			'suggestion' => (bool) $tpl['search_suggestion']
		]
	];
}
if ($params['style_change'] || $tpl['user']['admin'])
{
	if (!$tpl['user']['admin'])
	{
		$t = [];
		foreach (['banner', 'background'] as $param)
		{
			foreach (['clear', 'dark'] as $style)
			{
				if ($params[$param][$style]['type'] == 'texture')
				{
					$file = $params[$param][$style]['texture'];
					$t[$param][$style][$file] = $textures[$param][$style][$file];
				}
			}
		}
		$textures = $t;
	}
	$js_constants['THEME'] =
	[
		'path' => $tpl['gallery']['template']['path'](),
		'style' => $tpl['theme']['style']
	];
	if (count($textures))
	{
		$js_constants['THEME']['textures'] = $textures;
	}
}
if ($tpl['user']['admin'])
{
	$js_constants['THEME_ADMIN'] =
	[
		'dir' => $tpl['gallery']['template']['dir'](),
		'params' => $params['style_change'] ? [] : $params
	];
}
$js_constants['THEME_USER'] =
[
	'style' => $tpl['theme']['user_style'],
	'change' => (int) $params['style_change'],
	'params' => $params['style_change'] ? $params : []
];
if (!empty($tpl['upload']['albums_list']))
{
	$js_constants['UPLOAD'] =
	[
		'cat_list' => $tpl['upload']['albums_list'],
		'cat_text' =>
		[
			'none' => __('Aucun album sélectionné.'),
			'select' => __('Sélectionnez un album')
		],
		'options' =>
		[
			'ajaxData' =>
			[
				'anticsrf' => $tpl['anticsrf'](),
				'from_admin' => 0,
				'section' => 'upload',
				'temp_dir'=> $tpl['upload']['temp_dir']
			],
			'ajaxScript' => $tpl['gallery']['path'] . '/ajax.php',
			'fileExts' => $tpl['upload']['fileexts'],
			'fileTypes' => $tpl['upload']['filetypes'],
			'maxFileSize' => $tpl['config']('upload_maxfilesize') * 1024 * 1024,
			'maxHeight' => $tpl['config']('upload_maxheight'),
			'maxTotalFiles' => $tpl['config']('upload_maxtotalfiles'),
			'maxTotalSize' => $tpl['upload_totalsize'](),
			'maxWidth' => $tpl['config']('upload_maxwidth'),
			'sliceSize' => $tpl['upload_slicesize'](),
			'text' =>
			[
				'decimalSeparator' => __(','),
				'failed' => __('Échec de l\'envoi du fichier.'),
				'files' => __('%s fichiers'),
				'sizeUnits' => [__('%s octets'), __('%s Ko'), __('%s Mo'), __('%s Go')],
				'success' => __('Envoi effectué.'),
				'warning' =>
				[
					'filename' => __('Nom de fichier incorrect.'),
					'filesize' => __('Poids du fichier trop grand.'),
					'filetype' => __('Type de fichier non valide.'),
					'imagesize' => __('Dimensions trop grandes.'),
					'imagevalid' => __('Image non valide.'),
					'totalfiles' => __('Nombre maximum de fichiers atteint.'),
					'totalsize' => __('Poids maximum atteint.')
				]
			]
		]
	];
}
$print('<script nonce="%s" type="text/javascript">', CSP_NONCE);
foreach ($js_constants as $name => &$params)
{
	$print('const %s = %s;', $name, Utility::jsonEncode(
		HTML::specialchars_decode($params, ENT_QUOTES)
	));
}
$print('</script>');

// Fichier "head.tpl.php" personnalisé.
if (file_exists($head = __DIR__ . '/custom/head.tpl.php'))
{
	include_once($head);
}
?>