<?php
declare(strict_types = 1);

/**
 * Gestion des messages d'interface.
 *
 * @license https://www.gnu.org/licenses/gpl-3.0.html
 * @link https://www.igalerie.org/
 */
class Report
{
	/**
	 * Message d'erreur par défaut.
	 *
	 * @return string
	 */
	public static function getErrorDefaultMessage(): string
	{
		return __('L\'opération a échouée car une erreur s\'est produite.');
	}

	/**
	 * Message de non changement par défaut.
	 *
	 * @return string
	 */
	public static function getNoChangeDefaultMessage(): string
	{
		return __('Aucun changement effectué.');
	}

	/**
	 * Message de succès par défaut.
	 *
	 * @return string
	 */
	public static function getSuccessDefaultMessage(): string
	{
		return __('Modifications enregistrées.');
	}

	/**
	 * Ajoute un message d'erreur à afficher par le template.
	 *
	 * @param string $message
	 *
	 * @return void
	 */
	public static function error(string $message = ''): void
	{
		Template::$data['report'] = [];
		Template::set('report',
		[
			'error' => $message ? $message : self::getErrorDefaultMessage()
		]);
	}

	/**
	 * Ajoute un message d'information à afficher par le template.
	 *
	 * @param string $message
	 *
	 * @return void
	 */
	public static function info(string $message = ''): void
	{
		Template::$data['report'] = [];
		Template::set('report', ['info' => $message]);
	}

	/**
	 * Ajoute un message d'information indiquant une absence de changement
	 * à afficher par le template.
	 *
	 * @return void
	 */
	public static function noChange(): void
	{
		Report::info(self::getNoChangeDefaultMessage());
	}

	/**
	 * Ajoute un message de succès à afficher par le template.
	 *
	 * @param string $message
	 *
	 * @return void
	 */
	public static function success(string $message = ''): void
	{
		Template::$data['report'] = [];
		Template::set('report',
		[
			'success' => $message ? $message : self::getSuccessDefaultMessage()
		]);
	}

	/**
	 * Ajoute un message d'avertissement à afficher par le template.
	 *
	 * @param string $message
	 *
	 * @return void
	 */
	public static function warning(string $message = ''): void
	{
		Template::$data['report'] = [];
		Template::set('report', ['warning' => $message]);
	}
}
?>