<?php
declare(strict_types = 1);

class_exists('DB') || die;

require_once(__DIR__ . '/classes/AdminUsers.class.php');

template:
{
	AdminUsers::tplSection('user_avatar');

	$maxfilesize = min([Utility::getUploadMaxFilesize(), Avatar::FILE_SIZE_MAX]);
	$types = Item::getTypesSupported('image');
	$text_limits = sprintf(__('Formats acceptés : %s.'), implode(', ', $types['text']));
	$text_limits .= ' ' . sprintf(
		__('Poids maximum : %s.'),
		L10N::formatFilesize($maxfilesize)
	);
	$text_limits .= ' ' . sprintf(
		__('Dimensions maximum : %s x %s pixels.'),
		Avatar::IMAGE_SIZE_MAX, Avatar::IMAGE_SIZE_MAX
	);
	Template::set('upload',
	[
		'filetypes' => $types['mime'],
		'maxfilesize' => $maxfilesize,
		'text_limits' => $text_limits
	]);
}

update:
{
	AdminUsers::editAvatar();
}

get_data:
{
	AdminUsers::getUser();

	AdminUsers::getUsersList();
}
?>