<?php
declare(strict_types = 1);

class_exists('DB') || die;

require_once(__DIR__ . '/classes/AdminCategory.class.php');
require_once(__DIR__ . '/classes/AdminItems.class.php');
require_once(__DIR__ . '/classes/AdminUsers.class.php');

template:
{
	AdminCategory::tplSection('album_items');

	if (isset($_GET['album_id']))
	{
		$types = Item::getTypesSupported();
		$text_limits = sprintf(__('Formats acceptés : %s.'), implode(', ', $types['text']));
		$text_limits .= ' ' . sprintf(
			__('Poids maximum des fichiers : %s.'),
			L10N::formatFilesize($_GET['section_1'] == 'album-upload'
				? Utility::getUploadMaxFilesize()
				: Config::$params['upload_maxfilesize'] * 1024 * 1024)
		);
		$text_limits .= ' ' . sprintf(
			__('Dimensions maximum des images : %s x %s pixels.'),
			Config::$params['upload_maxwidth'], Config::$params['upload_maxheight']
		);
		Template::set('upload',
		[
			'album_id' => $_GET['album_id'],
			'fileexts' => $types['ext'],
			'filetypes' => $types['mime'],
			'max_total_files' => Config::$params['upload_maxtotalfiles'],
			'temp_dir' => Security::key(40),
			'text_limits' => $text_limits
		]);
	}
}

update:
{
	Admin::displayOptions('album');

	if (Auth::$infos['user_prefs']['album']['display'] == 'list')
	{
		AdminItems::edit();

		AdminItems::actions();
	}

	AdminItems::upload();
}

get_data:
{
	AdminCategory::getInfos();

	AdminItems::getItems();

	AdminAlbums::getCategoriesLists();

	AdminAlbums::getTagsList();

	AdminUsers::getUsersList();
}
?>