<form class="page" action="<?php echo $tpl['current_url']; ?>" method="post">
<?php if ($tpl['user_delete']) : ?>
	<fieldset>
		<legend><?php echo __('Général'); ?></legend>
		<p class="field">
			<label for="status"><?php echo __('État :'); ?></label>
			<br>
			<select id="status" name="status">
<?php foreach ($tpl['user_status'] as &$i) : ?>
<?php if ($i['value'] == -1 && $i['current'] != -1) { continue; }; ?>
			<option<?php if ($i['current']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
			</select>
		</p>
		<p class="field">
			<label for="group_id"><?php echo __('Groupe :'); ?></label>
			<br>
			<select id="group_id" name="group_id">
<?php foreach ($tpl['groups'] as &$i) : ?>
<?php if ($i['id'] > 2) : ?>
			<option<?php if ($i['current']) : ?> selected<?php endif; ?> value="<?php echo $i['id']; ?>"><?php echo $i['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
			</select>
		</p>
	</fieldset>
<?php endif; ?>
	<fieldset<?php if ($_GET['user_id'] == 1 && $tpl['auth']['id'] != 1) : ?> disabled<?php endif; ?>>
		<legend><?php echo __('Informations de connexion'); ?></legend>
		<p class="field<?php if ($tpl['field_error'] == 'login') : ?> field_error<?php endif; ?>">
			<label for="login"><?php echo __('Nom d\'utilisateur :'); ?></label>
			<input class="large" value="<?php echo $tpl['profile']['login']; ?>" maxlength="<?php echo $tpl['profile_params']['login']['maxlength']; ?>" id="login" name="login" type="text" required>
		</p>
		<p class="field<?php if ($tpl['field_error'] == 'password') : ?> field_error<?php endif; ?>">
			<label for="password"><?php printf(__('Nouveau mot de passe (%s caractères minimum) :'), $tpl['config']('users_password_minlength')); ?></label>
			<input data-password-view="1" class="large" value="<?php echo $tpl['profile']['password']; ?>" maxlength="<?php echo $tpl['profile_params']['password']['maxlength']; ?>" id="password" name="password" type="password">
		</p>
		<p class="field<?php if ($tpl['field_error'] == 'password_confirm') : ?> field_error<?php endif; ?>">
			<label for="password_confirm"><?php echo __('Confirmez le mot de passe :'); ?></label>
			<input data-password-view="1" class="large" value="<?php echo $tpl['profile']['password_confirm']; ?>" maxlength="<?php echo $tpl['profile_params']['password']['maxlength']; ?>" id="password_confirm" name="password_confirm" type="password">
		</p>
	</fieldset>
<?php if ($tpl['profile_activated']) : ?>
	<fieldset<?php if ($_GET['user_id'] == 1 && $tpl['auth']['id'] != 1) : ?> disabled<?php endif; ?>>
		<legend><?php echo __('Informations personnelles'); ?></legend>
<?php if ($tpl['profile_params']['nickname']['activated']) : ?>
		<p class="field<?php if ($tpl['field_error'] == 'nickname') : ?> field_error<?php endif; ?>">
			<label for="nickname"><?php echo __('Pseudonyme (s\'affichera à la place du nom d\'utilisateur) :'); ?></label>
			<input class="large" value="<?php echo $tpl['profile']['nickname']; ?>" maxlength="<?php echo $tpl['profile_params']['nickname']['maxlength']; ?>" id="nickname" name="nickname" type="text">
		</p>
<?php endif; ?>
<?php if ($tpl['profile_params']['name']['activated']) : ?>
		<p class="field<?php if ($tpl['field_error'] == 'name') : ?> field_error<?php endif; ?>">
			<label for="name"><?php echo __('Nom :'); ?></label>
			<input class="large" value="<?php echo $tpl['profile']['name']; ?>" maxlength="<?php echo $tpl['profile_params']['name']['maxlength']; ?>" id="name" name="name" type="text">
		</p>
<?php endif; ?>
<?php if ($tpl['profile_params']['firstname']['activated']) : ?>
		<p class="field<?php if ($tpl['field_error'] == 'firstname') : ?> field_error<?php endif; ?>">
			<label for="firstname"><?php echo __('Prénom :'); ?></label>
			<input class="large" value="<?php echo $tpl['profile']['firstname']; ?>" maxlength="<?php echo $tpl['profile_params']['firstname']['maxlength']; ?>" id="firstname" name="firstname" type="text">
		</p>
<?php endif; ?>
<?php if ($tpl['profile_params']['gender']['activated']) : ?>
		<p class="field<?php if ($tpl['field_error'] == 'gender') : ?> field_error<?php endif; ?>">
			<label for="gender"><?php echo __('Genre :'); ?></label>
			<br>
			<select name="gender" id="gender">
<?php foreach ($tpl['profile']['gender'] as &$i) : ?>
				<option<?php if ($i['current']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
			</select>
		</p>
<?php endif; ?>
<?php if ($tpl['profile_params']['birthdate']['activated']) : ?>
		<p class="field<?php if ($tpl['field_error'] == 'birthdate') : ?> field_error<?php endif; ?>">
			<label for="birthdate_year"><?php echo __('Date de naissance :'); ?></label>
			<br>
			<input name="birthdate_year" class="dt_year" type="number" min="1900" max="<?php echo date('Y'); ?>" placeholder="<?php echo __('Année'); ?>" value="<?php echo $tpl['profile']['birthdate_year']; ?>" id="birthdate_year">
			<span>-</span>
			<input name="birthdate_month" class="dt_month" type="number" min="1" max="12" placeholder="<?php echo __('Mois'); ?>" value="<?php echo $tpl['profile']['birthdate_month'] !== '' ? sprintf("%'.02d", $tpl['profile']['birthdate_month']) : ''; ?>">
			<span>-</span>
			<input name="birthdate_day" class="dt_day" type="number" min="1" max="31" placeholder="<?php echo __('Jour'); ?>" value="<?php echo $tpl['profile']['birthdate_day'] !== '' ? sprintf("%'.02d", $tpl['profile']['birthdate_day']) : ''; ?>">
			<a href="javascript:;" class="dt_reset" title="<?php echo __('Supprimer'); ?>">&nbsp;</a>
		</p>
<?php endif; ?>
<?php if ($tpl['profile_params']['location']['activated']) : ?>
		<p class="field<?php if ($tpl['field_error'] == 'location') : ?> field_error<?php endif; ?>">
			<label for="location"><?php echo __('Localisation :'); ?></label>
			<input class="large" value="<?php echo $tpl['profile']['location']; ?>" maxlength="<?php echo $tpl['profile_params']['location']['maxlength']; ?>" id="location" name="location" type="text">
		</p>
<?php endif; ?>
<?php if ($tpl['profile_params']['email']['activated']) : ?>
		<p class="field<?php if ($tpl['field_error'] == 'email') : ?> field_error<?php endif; ?>">
			<label for="email"><?php echo __('Courriel :'); ?></label>
			<input class="large" value="<?php echo $tpl['profile']['email']; ?>" maxlength="<?php echo $tpl['profile_params']['email']['maxlength']; ?>" id="email" name="email" type="email">
		</p>
<?php endif; ?>
<?php if ($tpl['profile_params']['website']['activated']) : ?>
		<p class="field<?php if ($tpl['field_error'] == 'website') : ?> field_error<?php endif; ?>">
			<label for="website"><?php echo __('Site Web :'); ?></label>
			<input class="large" value="<?php echo $tpl['profile']['website']; ?>" maxlength="<?php echo $tpl['profile_params']['website']['maxlength']; ?>" id="website" name="website" type="url">
		</p>
<?php endif; ?>
<?php if ($tpl['profile_params']['description']['activated']) : ?>
		<p class="field<?php if ($tpl['field_error'] == 'description') : ?> field_error<?php endif; ?>">
			<label for="description"><?php echo __('Description :'); ?></label>
			<textarea maxlength="<?php echo $tpl['profile_params']['description']['maxlength']; ?>" rows="6" cols="50" id="description" name="description"><?php echo $tpl['profile']['description']; ?></textarea>
		</p>
<?php endif; ?>
<?php for ($n = 1; $n <= 5; $n++) : ?>
<?php if ($tpl['profile_params']['custom_' . $n]['activated']) : ?>
		<p class="field<?php if ($tpl['field_error'] == 'custom_' . $n) : ?> field_error<?php endif; ?>">
			<label for="custom_<?php echo $n; ?>"><?php echo $tpl['profile_custom'][$n]; ?> :</label>
			<input class="large" value="<?php echo $tpl['profile']['custom_' . $n]; ?>" maxlength="<?php echo $tpl['profile_params']['custom_' . $n]['maxlength']; ?>" id="custom_<?php echo $n; ?>" name="custom_<?php echo $n; ?>" type="text">
		</p>
<?php endif; ?>
<?php endfor; ?>
	</fieldset>
<?php endif; ?>
	<fieldset<?php if ($_GET['user_id'] == 1 && $tpl['auth']['id'] != 1) : ?> disabled<?php endif; ?>>
		<legend><?php echo __('Options'); ?></legend>
		<p class="field">
			<label for="lang"><?php echo __('Langue :'); ?></label>
			<select name="lang" id="lang">
<?php foreach ($tpl['langs'] as &$i) : ?>
				<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['code']; ?>"><?php echo $i['code']; ?> - <?php echo $i['name']; ?></option>
<?php endforeach; ?>
			</select>
		</p>
		<p class="field">
			<label for="tz"><?php echo __('Fuseau horaire :'); ?></label>
			<select name="tz" id="tz">
<?php foreach ($tpl['tz_identifiers'] as $region => $list) : ?>
				<optgroup label="<?php echo $region; ?>">
<?php foreach ($list as &$i) : ?>
					<option<?php if ($i == Auth::$tz) : ?> selected<?php endif; ?> value="<?php echo $i; ?>"><?php echo str_replace('_', ' ', $i); ?></option>
<?php endforeach; ?>
				</optgroup>
<?php endforeach; ?>
			</select>
		</p>
		<p class="field"><?php echo __('Notification par courriel pour :'); ?></p>
		<div class="field_sublvl">
<?php if ($tpl['config']('users') && $tpl['config']('users_registration') && $tpl['user']['admin']) : ?>
			<p class="field checkbox">
				<input name="notification[_checkboxes][]" type="hidden" value="0">
				<input<?php if ($tpl['profile']['notification'][0]) : ?> checked<?php endif; ?> type="checkbox" name="notification[0]" id="notification_registration">
				<label for="notification_registration"><?php echo __('Inscriptions'); ?></label>
			</p>
<?php endif; ?>
<?php if ($tpl['config']('comments')) : ?>
<?php if ($tpl['user']['admin']) : ?>
			<p class="field checkbox">
				<input name="notification[_checkboxes][]" type="hidden" value="1">
				<input<?php if ($tpl['profile']['notification'][1]) : ?> checked<?php endif; ?> type="checkbox" name="notification[1]" id="notification_comments">
				<label for="notification_comments"><?php echo __('Nouveaux commentaires'); ?></label>
			</p>
			<p class="field checkbox">
				<input name="notification[_checkboxes][]" type="hidden" value="2">
				<input<?php if ($tpl['profile']['notification'][2]) : ?> checked<?php endif; ?> type="checkbox" name="notification[2]" id="notification_comments_pending">
				<label for="notification_comments_pending"><?php echo __('Commentaires en attente de validation'); ?></label>
			</p>
<?php endif; ?>
			<p class="field checkbox">
				<input name="notification[_checkboxes][]" type="hidden" value="5">
				<input<?php if ($tpl['profile']['notification'][5]) : ?> checked<?php endif; ?> type="checkbox" name="notification[5]" id="notification_comments_follow">
				<label for="notification_comments_follow"><?php echo __('Nouveaux commentaires sur les photos ou vidéos où j\'ai posté'); ?></label>
			</p>
<?php endif; ?>
<?php if ($tpl['config']('users')) : ?>
			<p class="field checkbox">
				<input name="notification[_checkboxes][]" type="hidden" value="3">
				<input<?php if ($tpl['profile']['notification'][3]) : ?> checked<?php endif; ?> type="checkbox" name="notification[3]" id="notification_items">
				<label for="notification_items"><?php echo __('Nouvelles photos ou vidéos'); ?></label>
			</p>
<?php if ($tpl['user']['admin']) : ?>
			<p class="field checkbox">
				<input name="notification[_checkboxes][]" type="hidden" value="4">
				<input<?php if ($tpl['profile']['notification'][4]) : ?> checked<?php endif; ?> type="checkbox" name="notification[4]" id="notification_items_pending">
				<label for="notification_items_pending"><?php echo __('Photos ou vidéos en attente de validation'); ?></label>
			</p>
<?php endif; ?>
<?php endif; ?>
		</div>
	</fieldset>
<?php if ($_GET['user_id'] == 1 && $tpl['auth']['id'] != 1) : ?>
	<br>
	<div class="report_classic">
		<div class="report_msg report_info">
			<p><?php echo __('Vous n\'avez pas la permission de modifier ce profil.'); ?></p>
		</div>
	</div>
<?php else : ?>
	<div id="submit">
		<div>
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
			<input type="submit" value="<?php echo __('Enregistrer'); ?>">
		</div>
	</div>
<?php endif; ?>
</form>