<?php include('options_menu.tpl.php'); ?>

<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="page">
	<fieldset>
		<legend><?php echo __('Vignettes'); ?></legend>
		<p class="field">
			<label for="thumbs_cat_nb_per_page"><?php echo __('Nombre de vignettes par page :'); ?></label>
			<select name="config[thumbs_cat_nb_per_page]" id="thumbs_cat_nb_per_page">
<?php foreach ($tpl['categories_nb_per_page'] as &$i) : ?>
				<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
			</select>
		</p>
		<p class="field">
			<label><?php echo __('Ordre d\'affichage :'); ?></label>
		</p>
		<div class="field_sublvl">
<?php for ($n = 1; $n <= 3; $n++) : ?>
			<p class="field">
				<label for="categories_sortby_<?php echo $n; ?>"><?php printf(__('Critère n°%s :'), $n); ?></label>
				<select id="categories_sortby_<?php echo $n; ?>" class="block" name="config[categories][sortby_<?php echo $n; ?>]">
<?php foreach ($tpl['categories_sort_by_params'] as $col => $text) : ?>
<?php if ($n == 1 && $col == 'none') : continue; endif; ?>
					<option value="<?php echo $col; ?>"<?php if ($col == $tpl['categories_sort_by'][$n - 1][0]) : ?> selected<?php endif; ?>><?php echo $text; ?></option>
<?php endforeach; ?>
				</select>
				<select class="block" name="config[categories][orderby_<?php echo $n; ?>]">
<?php foreach ($tpl['order_by_params'] as $ascdesc => $text) : ?>
					<option value="<?php echo $ascdesc; ?>"<?php if ($ascdesc == $tpl['categories_sort_by'][$n - 1][1]) : ?> selected<?php endif; ?>><?php echo $text; ?></option>
<?php endforeach; ?>
				</select>
			</p>
<?php endfor; ?>
		</div>
		<p class="field">
			<?php echo __('Informations à afficher :'); ?>
		</p>
		<div class="field_sublvl">
			<p class="field">
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_cat_info_title">
					<input<?php if ($tpl['config']['thumbs_cat_info_title']) : ?> checked<?php endif; ?> id="thumbs_cat_info_title" name="config[thumbs_cat_info_title]" type="checkbox">
					<label for="thumbs_cat_info_title"><?php echo __('Titre'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_cat_info_rating">
					<input<?php if ($tpl['config']['thumbs_cat_info_rating']) : ?> checked<?php endif; ?> id="thumbs_cat_info_rating" name="config[thumbs_cat_info_rating]" type="checkbox">
					<label for="thumbs_cat_info_rating"><?php echo __('Note moyenne'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_cat_info_items">
					<input<?php if ($tpl['config']['thumbs_cat_info_items']) : ?> checked<?php endif; ?> id="thumbs_cat_info_items" name="config[thumbs_cat_info_items]" type="checkbox">
					<label for="thumbs_cat_info_items"><?php echo __('Nombre de photos et vidéos'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_cat_info_albums">
					<input<?php if ($tpl['config']['thumbs_cat_info_albums']) : ?> checked<?php endif; ?> id="thumbs_cat_info_albums" name="config[thumbs_cat_info_albums]" type="checkbox">
					<label for="thumbs_cat_info_albums"><?php echo __('Nombre d\'albums'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_cat_info_filesize">
					<input<?php if ($tpl['config']['thumbs_cat_info_filesize']) : ?> checked<?php endif; ?> id="thumbs_cat_info_filesize" name="config[thumbs_cat_info_filesize]" type="checkbox">
					<label for="thumbs_cat_info_filesize"><?php echo __('Poids des photos et vidéos'); ?></label>
				</span>
			</p>
			<p class="field">
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_cat_info_description">
					<input<?php if ($tpl['config']['thumbs_cat_info_description']) : ?> checked<?php endif; ?> id="thumbs_cat_info_description" name="config[thumbs_cat_info_description]" type="checkbox">
					<label for="thumbs_cat_info_description"><?php echo __('Description'); ?></label>
				</span>
				<span class="sep">&nbsp;-&nbsp;</span>
				<span class="block">
					<label for="thumbs_cat_info_description_limit"><?php echo __('Limiter la longueur de la description à'); ?></label>
					<input required value="<?php echo $tpl['config']['thumbs_cat_info_description_limit']; ?>" id="thumbs_cat_info_description_limit" name="config[thumbs_cat_info_description_limit]" type="text" maxlength="4" size="5">
					<?php echo __('caractères (0 pour aucune limite)'); ?>
				</span>
			</p>
			<p class="field">
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_cat_info_views">
					<input<?php if ($tpl['config']['thumbs_cat_info_views']) : ?> checked<?php endif; ?> id="thumbs_cat_info_views" name="config[thumbs_cat_info_views]" type="checkbox">
					<label for="thumbs_cat_info_views"><?php echo __('Nombre de vues'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_cat_info_comments">
					<input<?php if ($tpl['config']['thumbs_cat_info_comments']) : ?> checked<?php endif; ?> id="thumbs_cat_info_comments" name="config[thumbs_cat_info_comments]" type="checkbox">
					<label for="thumbs_cat_info_comments"><?php echo __('Nombre de commentaires'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_cat_info_votes">
					<input<?php if ($tpl['config']['thumbs_cat_info_votes']) : ?> checked<?php endif; ?> id="thumbs_cat_info_votes" name="config[thumbs_cat_info_votes]" type="checkbox">
					<label for="thumbs_cat_info_votes"><?php echo __('Nombre de votes'); ?></label>
				</span>
				<span class="sep">&nbsp;&nbsp;</span>
				<span class="block">
					<input name="config[_checkboxes][]" type="hidden" value="thumbs_cat_info_favorites">
					<input<?php if ($tpl['config']['thumbs_cat_info_favorites']) : ?> checked<?php endif; ?> id="thumbs_cat_info_favorites" name="config[thumbs_cat_info_favorites]" type="checkbox">
					<label for="thumbs_cat_info_favorites"><?php echo __('Nombre de favoris'); ?></label>
				</span>
			</p>
		</div>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Modèle de description'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="categories_description_model">
			<input<?php if ($tpl['config']['categories_description_model']) : ?> checked<?php endif; ?> id="categories_description_model" name="config[categories_description_model]" type="checkbox">
			<label data-help-icon="description_model" for="categories_description_model"><?php echo __('Utiliser un modèle de description :'); ?></label>
		</p>
		<div class="field_var_list">
			<div>
				<p class="field">
					<span class="html_outer">
						<span class="html_inner">
							<textarea rows="10" cols="50" id="categories_description_model_text" name="config[categories_description_model_text]"><?php echo $tpl['config']['categories_description_model_text']; ?></textarea>
							<span>HTML</span>
						</span>
					</span>
				</p>
			</div>
			<div>
				<ul>
					<li><?php echo __('Informations :'); ?><span>{TITLE}, {DESCRIPTION}, {ID}, {URL}<span></li>
					<li><?php echo __('Conditions :'); ?><span>{IF(DESCRIPTION)}...{ENDIF(DESCRIPTION)}, etc.</span></li>
				</ul>
			</div>
		</div>
	</fieldset>
	<div id="submit">
		<div>
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
			<input type="submit" value="<?php echo __('Enregistrer'); ?>">
		</div>
	</div>
</form>