<div id="dashboard">
	<div>
<?php if ($tpl['dashboard']['new_version']) : ?>
		<div class="dashboard_bloc" id="dashboard_new_version">
			<h3><?php printf(__('Nouvelle version de %s disponible !'), $tpl['app']['name']); ?></h3>
			<div class="inner">
				<p>
					<?php printf(__('La version %s est disponible.'), '<span>' . $tpl['dashboard']['new_version'] . '</span>'); ?><br><br>
<?php if ($tpl['dashboard']['new_version_php_ok']) : ?>
					<a href="<?php echo $tpl['link']('update/1'); ?>"><?php echo __('Cliquez ici pour l\'installer.'); ?></a></p>
<?php else : ?>
					<?php printf(__('Cependant, la version de PHP de votre système (%s) n\'est pas compatible avec la version minimum de PHP requise (%s) par la nouvelle version de l\'application.'), '<span>' . $tpl['dashboard']['php_version'] . '</span>', '<span>' . $tpl['dashboard']['new_version_php'] . '</span>'); ?>
<?php endif; ?>
				</p>
			</div>
		</div>
<?php endif; ?>

<?php if ($tpl['welcome']) : ?>
		<div class="dashboard_bloc" id="dashboard_welcome">
			<h3><?php echo __('Installation terminée'); ?></h3>
			<div class="inner">
<?php include_once(GALLERY_ROOT . '/locale/' . $tpl['lang'] . '/help/start.html'); ?>
			</div>
			<div id="dashboard_welcome_hide">
				<a href="javascript:;"><?php echo __('Ne plus afficher ce message'); ?></a>
				<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post">
					<div>
						<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
						<input name="welcome_hide" type="hidden" value="1">
						<input type="submit" value="<?php echo __('Ne plus afficher ce message'); ?>">
					</div>
				</form>
				<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
				const link = document.querySelector('#dashboard_welcome_hide a');
				const form = document.querySelector('#dashboard_welcome_hide form');
				form.style.display = 'none';
				link.style.display = 'inline';
				link.addEventListener('click', evt => { evt.preventDefault(); form.submit(); });
				</script>
			</div>
		</div>
<?php endif; ?>

<?php if ($tpl['dashboard']['errors']) : ?>
		<div class="dashboard_bloc" id="dashboard_errors">
			<h3><?php echo __('Incidents'); ?></h3>
			<div class="inner">
				<p><a href="<?php echo $tpl['link']('errors'); ?>"><?php printf($tpl['dashboard']['errors'] > 1 ? __('%s incidents') : __('%s incident'), $tpl['dashboard']['errors']); ?></a></p>
			</div>
		</div>
<?php endif; ?>

<?php if (!$tpl['welcome']) : ?>
<?php if (isset($tpl['dashboard']['pending'])) : ?>
		<div class="dashboard_bloc" id="dashboard_pending">
			<h3><?php echo __('En attente de validation'); ?></h3>
			<div class="inner">
				<ul>
<?php if (isset($tpl['dashboard']['pending']['items'])) : ?>
					<li><a href="<?php echo $tpl['link']('items-pending/1'); ?>"><?php echo $tpl['dashboard']['pending']['items']; ?></a></li>
<?php endif; ?>
<?php if (isset($tpl['dashboard']['pending']['comments'])) : ?>
					<li><a href="<?php echo $tpl['link']('comments/pending'); ?>"><?php echo $tpl['dashboard']['pending']['comments']; ?></a></li>
<?php endif; ?>
<?php if (isset($tpl['dashboard']['pending']['users'])) : ?>
					<li><a href="<?php echo $tpl['link']('users/pending'); ?>"><?php echo $tpl['dashboard']['pending']['users']; ?></a></li>
<?php endif; ?>
				</ul>
			</div>
		</div>
<?php endif; ?>

<?php if (isset($tpl['dashboard']['scheduled'])) : ?>
		<div class="dashboard_bloc" id="dashboard_scheduled">
			<h3><?php echo __('Fichiers programmés'); ?></h3>
<?php if (isset($tpl['dashboard']['scheduled']['expiration'])) : ?>
			<div class="inner">
				<h4><?php echo __('Dates d\'expiration'); ?></h4>
				<ul>
<?php foreach ($tpl['dashboard']['scheduled']['expiration'] as &$i) : ?>
					<li><?php printf($i['text'], '<span>' . $i['count'] . '</span>', '<span>' . $i['date'] . '</span>', '<a href="' . $i['cat_link'] . '">' . $i['cat_name'] . '</a>'); ?></li>
<?php endforeach; ?>
				</ul>
			</div>
<?php endif; ?>
<?php if (isset($tpl['dashboard']['scheduled']['publication'])) : ?>
			<div class="inner">
				<h4><?php echo __('Dates de publication'); ?></h4>
				<ul>
<?php foreach ($tpl['dashboard']['scheduled']['publication'] as &$i) : ?>
					<li><?php printf($i['text'], '<span>' . $i['count'] . '</span>', '<span>' . $i['date'] . '</span>', '<a href="' . $i['cat_link'] . '">' . $i['cat_name'] . '</a>'); ?></li>
<?php endforeach; ?>
				</ul>
			</div>
<?php endif; ?>
		</div>
<?php endif; ?>

<?php if (isset($tpl['dashboard']['last_users'])) : ?>
		<div class="dashboard_bloc" id="dashboard_lastusers">
<?php if ($tpl['dashboard']['admins_count'] + $tpl['dashboard']['members_count'] > 1) : ?>
			<div class="dashboard_nav">
				<a rel="user" class="dashboard_prev" href="javascript:;"></a>
				<span>1/<?php echo $tpl['dashboard']['last_users_count']; ?></span>
				<a rel="user" class="dashboard_next" href="javascript:;"></a>
			</div>
<?php endif; ?>
			<h3><?php echo __('Derniers utilisateurs'); ?></h3>
			<div class="inner">
<?php $n = 0; foreach ($tpl['dashboard']['last_users'] as &$i) : ?>
				<div class="user" id="user_<?php echo ++$n; ?>">
					<a class="thumb" href="<?php echo $tpl['link']('user/' . $i['user_id']); ?>">
						<img
							alt="<?php printf(__('Avatar de %s'), $i['user_nickname']); ?>"
							src="<?php echo $i['avatar_thumb_src']; ?>">
					</a>
					<p><?php printf(__('%s, inscrit le %s.'), '<a href="' . $tpl['link']('user/' . $i['user_id']) . '">' . $i['user_nickname'] . '</a>', '<span>' . $i['user_crtdt'] . '</span>'); ?></p>
				</div>
<?php endforeach; ?>
<?php if (!$n) : ?>
				<p class="empty"><?php echo __('Aucun utilisateur enregistré.'); ?></p>
<?php endif; ?>
			</div>
		</div>
<?php endif; ?>

		<div class="dashboard_bloc" id="dashboard_lastitems">
<?php if ($tpl['dashboard']['items_count'] > 1) : ?>
			<div class="dashboard_nav">
				<a rel="item" class="dashboard_prev" href="javascript:;"></a>
				<span>1/<?php echo $tpl['dashboard']['last_items_count']; ?></span>
				<a rel="item" class="dashboard_next" href="javascript:;"></a>
			</div>
<?php endif; ?>
			<h3><?php echo __('Derniers fichiers'); ?></h3>
			<div class="inner">
<?php $n = 0; foreach ($tpl['dashboard']['last_items'] as &$i) : ?>
				<div class="item" id="item_<?php echo ++$n; ?>">
					<a class="thumb" href="<?php echo $tpl['link']('item-edit/' . $i['id']); ?>" title="<?php echo $i['title']; ?>">
<?php if ($i['type'] == 'video') : ?>					
						<span class="duration" id="videoduration_<?php echo $i['id']; ?>"><?php echo $i['duration_text']; ?></span>
<?php endif; ?>
						<img alt="<?php echo $i['title']; ?>"
<?php if ($i['type'] == 'video') : ?>
							data-video-id="<?php echo $i['id']; ?>"
<?php endif; ?>
							src="<?php echo $i['thumb_src']('400'); ?>">
					</a>
					<p><?php printf(__('Publié le %s par %s dans l\'album %s.'),
						'<span>' . $i['pubdt'] . '</span>',
						$i['user_id'] == 2
							? '<span>' . $i['user_nickname'] . '</span>'
							: '<a href="' . $tpl['link']('user/' . $i['user_id']) . '">' . $i['user_nickname'] . '</a>',
						'<a href="' . $tpl['link']('album/' . $i['cat_id']) . '">' . $i['cat_name'] . '</a>'
					); ?></p>
				</div>
<?php endforeach; ?>
<?php if (!$n) : ?>
				<p class="empty"><?php echo __('Aucun fichier.'); ?></p>
<?php endif; ?>
			</div>
		</div>

<?php if (isset($tpl['dashboard']['last_comments'])) : ?>
		<div class="dashboard_bloc" id="dashboard_lastcomments">
<?php if ($tpl['dashboard']['last_comments_count'] > 1) : ?>
			<div class="dashboard_nav">
				<a rel="comment" class="dashboard_prev" href="javascript:;"></a>
				<span>1/<?php echo $tpl['dashboard']['last_comments_count']; ?></span>
				<a rel="comment" class="dashboard_next" href="javascript:;"></a>
			</div>
<?php endif; ?>
			<h3><?php echo __('Derniers commentaires'); ?></h3>
			<div class="inner">
<?php $n = 0; foreach ($tpl['dashboard']['last_comments'] as &$i) : ?>
				<div class="comment" id="comment_<?php echo ++$n; ?>">
					<p class="last_comment_message"><?php echo $tpl['format_comment']($i['message']); ?></p>
					<p class="last_comment_infos">
						<?php
							$date = '<span>' . $i['date_created'] . '</span>';
							$user = $i['user_link'] ? '<a href="' . $i['user_link'] . '">' . $i['user_name'] . '</a>' : '<span>' . $i['user_name'] . '</span>';
							$item = sprintf($i['item_text'], '<a href="' . $i['item_link'] . '">' . $i['item_name'] . '</a>');
							$album = '<a href="' . $i['album_link'] . '">' . $i['album_name'] . '</a>';
							printf(__('Posté le %s par %s sur %s de l\'album %s.'), $date, $user, $item, $album);
						?>
					</p>
				</div>
<?php endforeach; ?>
<?php if (!$n) : ?>
				<p class="empty"><?php echo __('Aucun commentaire.'); ?></p>
<?php endif; ?>
			</div>
		</div>
<?php endif; ?>

<?php endif; ?>
	</div>

	<div>
		<div class="dashboard_bloc" id="dashboard_stats">
			<h3><?php echo __('Statistiques de la galerie'); ?></h3>
			<div class="inner">
				<ul>
					<li><?php printf($tpl['dashboard']['images_count'] > 1 ? __('%s photos') : __('%s photo'), '<span>' . L10N::formatNumber((int) $tpl['dashboard']['images_count']) . '</span>'); ?></li>
					<li><?php printf($tpl['dashboard']['videos_count'] > 1 ? __('%s vidéos') : __('%s vidéo'), '<span>' . L10N::formatNumber((int) $tpl['dashboard']['videos_count']) . '</span>'); ?></li>
					<li><?php printf($tpl['dashboard']['albums_count'] > 1 ? __('%s albums') : __('%s album'), '<span>' . L10N::formatNumber((int) $tpl['dashboard']['albums_count']) . '</span>'); ?></li>
<?php if (isset($tpl['dashboard']['tags_count'])) : ?>
					<li><?php printf($tpl['dashboard']['tags_count'] > 1 ? __('%s tags') : __('%s tag'), '<span>' . L10N::formatNumber((int) $tpl['dashboard']['tags_count']) . '</span>'); ?></li>
<?php endif; ?>
<?php if (isset($tpl['dashboard']['comments_count'])) : ?>
					<li><?php printf($tpl['dashboard']['comments_count'] > 1 ? __('%s commentaires') : __('%s commentaire'), '<span>' . L10N::formatNumber((int) $tpl['dashboard']['comments_count']) . '</span>'); ?></li>
<?php endif; ?>
<?php if (isset($tpl['dashboard']['votes_count'])) : ?>
					<li><?php printf($tpl['dashboard']['votes_count'] > 1 ? __('%s votes') : __('%s vote'), '<span>' . L10N::formatNumber((int) $tpl['dashboard']['votes_count']) . '</span>'); ?></li>
<?php endif; ?>
				</ul>
				<ul>
<?php if (isset($tpl['dashboard']['admins_count'])) : ?>
					<li><?php printf($tpl['dashboard']['admins_count'] > 1 ? __('%s administrateurs') : __('%s administrateur'), '<span>' . L10N::formatNumber((int) $tpl['dashboard']['admins_count']) . '</span>'); ?></li>
<?php endif; ?>
<?php if (isset($tpl['dashboard']['members_count'])) : ?>
					<li><?php printf($tpl['dashboard']['members_count'] > 1 ? __('%s membres') : __('%s membre'), '<span>' . L10N::formatNumber((int) $tpl['dashboard']['members_count']) . '</span>'); ?></li>
<?php endif; ?>
<?php if (isset($tpl['dashboard']['groups_count'])) : ?>
					<li><?php printf($tpl['dashboard']['groups_count'] > 1 ? __('%s groupes') : __('%s groupe'), '<span>' . L10N::formatNumber((int) $tpl['dashboard']['groups_count']) . '</span>'); ?></li>
<?php endif; ?>
<?php if (isset($tpl['dashboard']['favorites_count'])) : ?>
					<li><?php printf($tpl['dashboard']['favorites_count'] > 1 ? __('%s favoris') : __('%s favori'), '<span>' . L10N::formatNumber((int) $tpl['dashboard']['favorites_count']) . '</span>'); ?></li>
<?php endif; ?>
					<li><?php printf($tpl['dashboard']['hits_count'] > 1 ? __('%s vues') : __('%s vue'), '<span>' . L10N::formatNumber((int) $tpl['dashboard']['hits_count']) . '</span>'); ?></li>
					<li><?php echo preg_replace('`^([^\s]+)(.*)$`', '<span>\1</span>\2', $tpl['dashboard']['filesize']); ?></li>
				</ul>
			</div>
		</div>

		<div class="dashboard_bloc" id="dashboard_sysinfos">
			<h3><?php echo __('Système'); ?></h3>
			<div class="inner">
				<ul>
					<li><?php printf(__('Version de %s : %s'), System::APP_NAME, '<span>' . $tpl['dashboard']['app_version'] . '</span>'); ?></li>
					<li><?php printf(__('Version de %s : %s'), 'PHP', '<span>' . $tpl['dashboard']['php_version'] . '</span>'); ?></li>
					<li><?php printf(__('Base de données : %s'), '<span>' . $tpl['dashboard']['db_type'] . ' ' . $tpl['dashboard']['db_version'] . '</span>'); ?></li>
					<li><?php printf(__('Système d\'exploitation : %s'), '<span>' . $tpl['dashboard']['os_infos'] . '</span>'); ?></li>
				</ul>
			</div>
		</div>

	</div>
</div>