<?php include('comments_menu.tpl.php'); ?>

<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="page">
	<fieldset>
		<legend><?php echo __('Général'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="comments_read_only">
			<input<?php if ($tpl['config']['comments_read_only']) : ?> checked<?php endif; ?> id="comments_read_only" name="config[comments_read_only]" type="checkbox">
			<label for="comments_read_only"><?php echo __('Commentaires en lecture seule'); ?></label>
		</p>
		<p class="field">
			<label for="comments_order_by"><?php echo __('Ordre d\'affichage des commentaires :'); ?></label>
			<select id="comments_order_by" name="config[comments_order_by]">
<?php foreach ($tpl['comments_order_by'] as &$i) : ?>
				<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
			</select>
		</p>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Ajout de commentaires'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="comments_moderate">
			<input <?php if ($tpl['config']['comments_moderate']) : ?> checked<?php endif; ?> id="comments_moderate" name="config[comments_moderate]" type="checkbox">
			<label data-help-icon="moderate" for="comments_moderate"><?php echo __('Modérer les commentaires'); ?></label>
		</p>
		<p class="field">
			<?php echo __('Renseignements obligatoires :'); ?>
		</p>
		<div class="field_sublvl">
			<p class="field">
				<input name="config[_checkboxes][]" type="hidden" value="comments_required_email">
				<input<?php if ($tpl['config']['comments_required_email']) : ?> checked<?php endif; ?> id="comments_required_email" name="config[comments_required_email]" type="checkbox">
				<label for="comments_required_email"><?php echo __('Courriel'); ?></label>
			</p>
			<p class="field">
				<input name="config[_checkboxes][]" type="hidden" value="comments_required_website">
				<input<?php if ($tpl['config']['comments_required_website']) : ?> checked<?php endif; ?> id="comments_required_website" name="config[comments_required_website]" type="checkbox">
				<label for="comments_required_website"><?php echo __('Site Web'); ?></label>
			</p>
		</div>
		<p class="field">
			<label for="comments_antiflood"><?php echo __('Anti-flood :'); ?></label>
			<input required value="<?php echo $tpl['config']['comments_antiflood']; ?>" id="comments_antiflood" name="config[comments_antiflood]" type="text" maxlength="3" size="3">
			<span data-help-icon="antiflood"><?php echo __('secondes'); ?></span>
		</p>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Émojis'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="comments_emoji_picker"/>
			<input<?php if ($tpl['config']['comments_emoji_picker']) : ?> checked<?php endif; ?> id="comments_emoji_picker" name="config[comments_emoji_picker]" type="checkbox"/>
			<label for="comments_emoji_picker"><?php echo __('Ajouter un sélecteur d\'émojis'); ?></label>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="comments_emoji_delete"/>
			<input<?php if ($tpl['config']['comments_emoji_delete']) : ?> checked<?php endif; ?> id="comments_emoji_delete" name="config[comments_emoji_delete]" type="checkbox"/>
			<label for="comments_emoji_delete"><?php echo __('Supprimer les émojis (avant enregistrement des commentaires)'); ?></label>
		</p>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Message'); ?></legend>
		<p class="field">
			<label for="comments_maxchars"><?php echo __('Nombre maximum de caractères :'); ?></label>
			<input required value="<?php echo $tpl['config']['comments_maxchars']; ?>" id="comments_maxchars" name="config[comments_maxchars]" type="text" maxlength="4" size="4">
		</p>
		<p class="field">
			<label for="comments_maxlines"><?php echo __('Nombre maximum de lignes :'); ?></label>
			<input required value="<?php echo $tpl['config']['comments_maxlines']; ?>" id="comments_maxlines" name="config[comments_maxlines]" type="text" maxlength="3" size="3">
		</p>
		<p class="field">
			<label for="comments_maxurls"><?php echo __('Nombre maximum d\'URL :'); ?></label>
			<input required data-help-icon="maxurls" value="<?php echo $tpl['config']['comments_maxurls']; ?>" id="comments_maxurls" name="config[comments_maxurls]" type="text" maxlength="2" size="2">
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="comments_url_to_link">
			<input<?php if ($tpl['config']['comments_url_to_link']) : ?> checked<?php endif; ?> id="comments_url_to_link" name="config[comments_url_to_link]" type="checkbox">
			<label for="comments_url_to_link"><?php echo __('Convertir les URL en liens'); ?></label>
		</p>
		<div class="field_sublvl">
			<p class="field">
				<label for="comments_url_to_link_maxlength"><?php echo __('Longueur maximale des liens :'); ?></label>
				<input required value="<?php echo $tpl['config']['comments_url_to_link_maxlength']; ?>" id="comments_url_to_link_maxlength" name="config[comments_url_to_link_maxlength]" type="text" maxlength="3" size="3">
			</p>
		</div>
	</fieldset>
	<div id="submit">
		<div>
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
			<input type="submit" value="<?php echo __('Enregistrer'); ?>">
		</div>
	</div>
</form>