<?php $confirm_delete = __('Supprimer les commentaires sélectionnés ?'); ?>
<?php include('comments_menu.tpl.php'); ?>
<div id="page_comments" class="page_content">
	<div>
<?php include('category_browse.tpl.php'); ?>

		<nav id="section_nav">
<?php include('breadcrumb.tpl.php'); ?>
		</nav>

<?php if (isset($_POST['action']) && $_POST['action'] == 'delete_confirm') : ?>
<?php include('delete_selection.tpl.php'); ?>
<?php else : ?>

		<div class="tools">
			<div><span class="icon icon_search show_tool"><a data-id="search" class="js<?php if (strstr($_GET['section_1'], 'search')) : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('comments' . (strstr($_GET['section_1'], 'search') ? '' : '-search') . '/page/' . $_GET['page']); ?>"><?php echo __('Recherche'); ?></a></span></div>
			<span class="sep">-</span>
			<div><span class="icon icon_options show_tool"><a data-id="options" class="js<?php if (strstr($_GET['section_1'], 'display')) : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('comments' . (strstr($_GET['section_1'], 'display') ? '' : '-display') . '/page/' . $_GET['page']); ?>"><?php echo __('Options d\'affichage'); ?></a></span></div>
		</div>

		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if (strstr($_GET['section_1'], 'search')) : ?> show<?php endif; ?>" id="search">
			<fieldset>
				<p class="field">
					<label for="search_query"><?php echo __('Rechercher :'); ?></label>
					<input<?php if (strstr($_GET['section_1'], 'search')) : ?> autofocus<?php endif; ?> required data-help-icon="search" value="<?php echo $tpl['search']['query']; ?>" class="focus" type="text" name="search_query" id="search_query" maxlength="255" size="50" data-reset="">
				</p>
				<p class="field">
					<input<?php echo $tpl['search']['all_words'] ? ' checked' : ''; ?> type="checkbox" name="search_options[all_words]" id="search_all_words" data-reset="1">
					<label for="search_all_words"><?php echo __('Rechercher tous les mots'); ?></label>
				</p>
				<p class="field">
					<span class="icon icon_search_options showhide" rel="#adv_search"><a class="js" href="<?php echo $tpl['link']('comments-' . (strstr($_GET['section_1'], 'advanced') ? 'search' : 'search-advanced') . '/page/' . $_GET['page']); ?>"><?php echo __('Options de recherche'); ?></a></span>
				</p>
				<div id="adv_search" class="adv_search_col<?php if (strstr($_GET['section_1'], 'advanced')) : ?> show<?php endif; ?>">
					<div>
						<p class="field">
							<?php echo __('Rechercher dans les champs suivants :'); ?>
						</p>
						<div class="field_sublvl">
							<p class="field">
								<input<?php echo $tpl['search']['columns']['com_message'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="com_message" id="search_com_message" data-reset="1">
								<label for="search_com_message"><?php echo __('Message'); ?></label>
								&nbsp;
								<input<?php echo $tpl['search']['columns']['com_author'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="com_author" id="search_com_author" data-reset="0">
								<label for="search_com_author"><?php echo __('Auteur'); ?></label>
								&nbsp;
								<input<?php echo $tpl['search']['columns']['com_email'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="com_email" id="search_com_email" data-reset="0">
								<label for="search_com_email"><?php echo __('Courriel'); ?></label>
								&nbsp;
								<input<?php echo $tpl['search']['columns']['com_website'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="com_website" id="search_com_website" data-reset="0">
								<label for="search_com_website"><?php echo __('Site Web'); ?></label>
								&nbsp;
								<input<?php echo $tpl['search']['columns']['com_ip'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="com_ip" id="search_com_ip" data-reset="0">
								<label for="search_com_ip"><?php echo __('IP'); ?></label>
							</p>
						</div>
						<p class="field">
							<label for="search_status"><?php echo __('Rechercher par état :'); ?></label>
							<select name="search_options[status]" id="search_status" data-reset="*">
<?php foreach ($tpl['search']['status'] as &$i) : ?>
								<option<?php echo $i['selected'] ? ' selected' : ''; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
							</select>
						</p>
					</div>
					<div>
						<p class="field">
							<input<?php echo $tpl['search']['date'] ? ' checked' : ''; ?> id="search_date" type="checkbox" name="search_options[date]" data-reset="0">
							<label for="search_date"><?php echo __('Rechercher par date :'); ?></label>
						</p>
						<div class="field_sublvl">
							<p class="field">
								<input<?php echo $tpl['search']['date_column'] == 'com_crtdt' ? ' checked' : ''; ?> id="search_date_column_com_crtdt" type="radio" name="search_options[date_column]" value="com_crtdt" data-reset="1">
								<label for="search_date_column_com_crtdt"><?php echo __('Date d\'ajout'); ?></label>
								&nbsp;
								<input<?php echo $tpl['search']['date_column'] == 'com_lastupddt' ? ' checked' : ''; ?> id="search_date_column_com_lastupddt" type="radio" name="search_options[date_column]" value="com_lastupddt" data-reset="0">
								<label for="search_date_column_com_lastupddt"><?php echo __('Date de dernière modification'); ?></label>
							</p>
<?php include('search_date.tpl.php'); ?>
						</div>
					</div>
				</div>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="search" type="submit" value="<?php echo __('Chercher'); ?>">
				<input class="button reset_js" type="reset" value="<?php echo __('Réinitialiser'); ?>">
			</fieldset>
		</form>

		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if ($_GET['section_1'] == 'comments-display') : ?> show<?php endif; ?>" id="options">
			<fieldset>
				<p class="field">
					<label for="nb_per_page"><?php echo __('Nombre de commentaires par page :'); ?></label>
					<input<?php if ($_GET['section_1'] == 'comments-display') : ?> autofocus<?php endif; ?> required maxlength="3" size="3" value="<?php echo $tpl['options']['nb_per_page']; ?>" name="nb_per_page" id="nb_per_page" type="text" class="focus">
				</p>
				<p class="field">
					<label for="order_by_column"><?php echo __('Trier par :'); ?></label>
					<select name="order_by_column" id="order_by_column">
<?php foreach ($tpl['options']['order_by_column'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
					<select name="order_by_order">
<?php foreach ($tpl['options']['order_by_order'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
				</p>
				<p class="field">
					<label for="thumbs_size"><?php echo __('Taille des vignettes :'); ?></label>
					<select name="thumbs_size" id="thumbs_size">
<?php foreach ($tpl['options']['thumbs_size'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
				</p>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="options" type="submit" value="<?php echo __('Valider'); ?>">
			</fieldset>
		</form>

<?php if ($tpl['objects_count'] > 0) : ?>

<?php include('pagination.tpl.php'); ?>

		<div id="obj_links_js">
			<form>
				<a class="js show_all" href="javascript:;"><?php echo __('Tout montrer'); ?></a>
				<span class="sep">-</span>
				<a class="js hide_all" href="javascript:;"><?php echo __('Tout cacher'); ?></a>
				&nbsp;<?php echo __('pour'); ?>&nbsp;
				<select id="show_items">
					<option value="obj_fold"><?php echo __('Tout'); ?></option>
					<option value="obj_fold_edit"><?php echo __('Édition'); ?></option>
					<option value="obj_fold_stats"><?php echo __('Statistiques'); ?></option>
				</select>
			</form>
<?php include('object_select.tpl.php'); ?>
		</div>

		<form<?php if ($tpl['options']['thumbs_size'][1]['selected']) : ?> class="large"<?php endif; ?> id="obj_form" action="<?php echo $tpl['current_url']; ?>" method="post">

<?php foreach ($tpl['comments'] as &$i) : ?>
			<div id="obj_<?php echo $i['id']; ?>" class="selectable_class obj<?php if ($i['pending']) : ?> obj_pending<?php endif; ?><?php if ($i['deactivated']) : ?> obj_deactivated<?php endif; ?><?php if (!$i['activated']) : ?> obj_invisible<?php endif; ?><?php if (isset($_POST['selected'][$i['id']])) : ?> selected<?php endif; ?>">
				<div class="obj_body">
					<div class="obj_image">
						<a href="<?php echo $i['item_link']; ?>">
<?php if ($i['item_type'] == 'video') : ?>					
							<span class="duration" id="videoduration_<?php echo $i['id']; ?>"><?php echo $i['item_duration_text']; ?></span>
<?php endif; ?>
							<img alt="<?php echo __('Vignette'); ?>" src="<?php echo $i['item_thumb_src'](); ?>"<?php if ($i['item_type'] == 'video') : ?> data-video-id="<?php echo $i['item_id']; ?>"<?php endif; ?>>
						</a>
					</div>
					<div class="obj_infos">
						<div class="obj_basics">
							<p class="obj_title">
								<span class="author"><?php if ($i['user_link']) : ?><a href="<?php echo $i['user_link']; ?>"><?php echo $i['user_name']; ?></a><?php else : ?><?php echo $i['user_name']; ?><?php endif; ?></span>
								<span class="obj_title_link"><?php echo $i['message']; ?></span>
<?php if ($i['gallery_link']) : ?>
								<a title="<?php echo __('Voir dans la galerie'); ?>" class="obj_gallery_link" href="<?php echo $i['gallery_link']; ?>"></a>
<?php endif; ?>
							</p>
							<p class="obj_status"><span><?php echo $i['status_text']; ?></span></p>
						</div>
						<div class="obj_details">
							<p class="obj_links">
								<span class="icon icon_edit show_parts"><a data-id="obj_fold_edit_<?php echo $i['id']; ?>" class="js show" href="javascript:;"><?php echo __('Édition'); ?></a></span>
								&nbsp;-&nbsp;
								<span class="icon icon_stats show_parts"><a data-id="obj_fold_stats_<?php echo $i['id']; ?>" class="js" href="javascript:;"><?php echo __('Statistiques'); ?></a></span>
							</p>
							<p class="obj_cat"><?php echo $i['date_created']; ?></p>
						</div>
					</div>
					<div class="obj_checkbox selectable_zone">
						<input<?php if (isset($_POST['selected'][$i['id']])) : ?> checked<?php endif; ?> class="selectable" name="selected[<?php echo $i['id']; ?>]" type="checkbox">
					</div>
				</div>
				<div class="obj_fold obj_fold_edit" id="obj_fold_edit_<?php echo $i['id']; ?>">
<?php if ($i['user_id'] == 2) : ?>
					<p class="field">
						<label for="author_<?php echo $i['id']; ?>"><?php echo __('Auteur :'); ?></label>
						<input class="large" name="comments[<?php echo $i['id']; ?>][author]" size="40" maxlength="24" id="author_<?php echo $i['id']; ?>" type="text" value="<?php echo $_POST['comments'][$i['id']]['author'] ?? $i['user_name']; ?>">
					</p>
					<p class="field">
						<label for="email_<?php echo $i['id']; ?>"><?php echo __('Courriel :'); ?></label>
						<input class="large" name="comments[<?php echo $i['id']; ?>][email]" size="40" maxlength="128" id="email_<?php echo $i['id']; ?>" type="text" value="<?php echo $_POST['comments'][$i['id']]['email'] ?? $i['user_email']; ?>">
					</p>
					<p class="field">
						<label for="website_<?php echo $i['id']; ?>"><?php echo __('Site Web :'); ?></label>
						<input class="large" name="comments[<?php echo $i['id']; ?>][website]" size="40" maxlength="128" id="website_<?php echo $i['id']; ?>" type="text" value="<?php echo $_POST['comments'][$i['id']]['website'] ?? $i['user_website']; ?>">
					</p>
<?php endif; ?>
					<p class="field">
						<label for="message_<?php echo $i['id']; ?>"><?php echo __('Message :'); ?></label>
						<textarea name="comments[<?php echo $i['id']; ?>][message]" rows="8" cols="50" maxlength="9999" id="message_<?php echo $i['id']; ?>"><?php echo $_POST['comments'][$i['id']]['message'] ?? $i['message']; ?></textarea>
					</p>
				</div>
				<div class="obj_fold obj_fold_stats" id="obj_fold_stats_<?php echo $i['id']; ?>">
					<table class="light">
						<tr>
							<td><?php echo __('Date d\'ajout'); ?></td>
							<td class="filter"><div><?php echo $i['datetime_created']; ?><a title="<?php echo __('Afficher tous les commentaires à cette date'); ?>" class="filter_link" href="<?php echo $i['filter_date_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a></div></td>
						</tr>
						<tr>
							<td><?php echo __('Date de dernière modification'); ?></td>
							<td><?php echo $i['datetime_updated'] == $i['datetime_created'] ? '/' : $i['datetime_updated']; ?></td>
						</tr>
						<tr>
							<td><?php echo __('Auteur'); ?></td>
							<td class="filter"><div><?php if ($i['user_link']) : ?><a href="<?php echo $i['user_link']; ?>"><?php echo $i['user_name']; ?></a><?php else : ?><?php echo $i['user_name']; ?><?php endif; ?><a title="<?php echo __('Afficher tous les commentaires de cet utilisateur'); ?>" class="filter_link" href="<?php echo $i['filter_user_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a></div></td>
						</tr>
						<tr>
							<td><?php echo __('IP'); ?></td>
							<td class="filter"><div><?php echo $i['user_ip']; ?><a title="<?php echo __('Afficher tous les commentaires en provenance de cette IP'); ?>" class="filter_link" href="<?php echo $i['filter_ip_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a></div></td>
						</tr>
						<tr>
							<td><?php echo __('Courriel'); ?></td>
							<td><?php if ($i['user_email']) : ?><a href="mailto:<?php echo $i['user_email']; ?>"><?php echo $i['user_email']; ?></a><?php else : ?>/<?php endif; ?></td>
						</tr>
						<tr>
							<td><?php echo __('Site Web'); ?></td>
							<td><?php if ($i['user_website']) : ?><a href="<?php echo $i['user_website']; ?>"><?php echo $i['user_website']; ?></a><?php else : ?>/<?php endif; ?></td>
						</tr>
						<tr>
							<td><?php echo __('Album'); ?></td>
							<td class="filter"><div><a href="<?php echo $i['album_link']; ?>"><?php echo $i['album_name']; ?></a><a title="<?php echo __('Afficher tous les commentaires de cet album'); ?>" class="filter_link" href="<?php echo $i['filter_album_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a></div></td>
						</tr>
						<tr>
							<td><?php echo __('Fichier'); ?></td>
							<td class="filter"><div><a href="<?php echo $i['item_link']; ?>"><?php echo $i['item_name']; ?></a><a title="<?php echo __('Afficher tous les commentaires de ce fichier'); ?>" class="filter_link" href="<?php echo $i['filter_item_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a></div></td>
						</tr>
					</table>
				</div>
			</div>
<?php endforeach; ?>

			<div id="submit" class="submit_actions<?php if ($tpl['nb_pages'] > 1) : ?> submit_pages<?php endif; ?>">
				<div>
					<p id="form_save">
						<input name="save" type="submit" value="<?php echo __('Enregistrer les modifications'); ?>">
					</p>
					<p id="form_actions">
						<label for="selection_action"><?php printf(__('Action sur la sélection (%s) :'), '<span id="select_num">' . (empty($_POST['selected']) ? 0 : count($_POST['selected'])) . '</span>'); ?></label>
						<select id="selection_action" name="action">
							<optgroup label="<?php echo __('État'); ?>">
								<option value="activate"><?php echo __('Activer'); ?></option>
								<option value="deactivate"><?php echo __('Désactiver'); ?></option>
							</optgroup>
							<optgroup label="<?php echo __('Bannissements (invités)'); ?>">
								<option value="ban_author"><?php echo __('Bannir l\'auteur'); ?></option>
								<option value="ban_ip"><?php echo __('Bannir l\'IP'); ?></option>
							</optgroup>
							<optgroup label="<?php echo __('Suppression'); ?>">
								<option value="delete_confirm"><?php echo __('Supprimer'); ?></option>
							</optgroup>
						</select>
						<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
						<input name="selection" type="submit" value="<?php echo __('Valider'); ?>">
					</p>
				</div>
			</div>
		</form>

		<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
		var confirm_delete = "<?php echo $tpl['php2js']($confirm_delete); ?>";
		document.querySelectorAll('.obj_links .show').forEach((e) => e.classList.remove('show'));
		</script>

<?php include('pagination.tpl.php'); ?>

<?php else : ?>
		<br>
		<div class="report_classic">
			<div class="report_msg report_info">
				<p><?php echo isset($_GET['search']) ? __('Aucun commentaire trouvé.') : (isset($_GET['pending_id']) ? __('Aucun commentaire en attente.') : __('Aucun commentaire')); ?></p>
			</div>
		</div>
<?php endif; ?>

<?php endif; ?>

	</div>
</div>