<?php $cat_type = $tpl['category']['type'] == 'album' ? __('l\'album') : __('la catégorie'); ?>
<div id="thumb_new">
	<form action="<?php echo $tpl['current_url']; ?>" method="post">
		<fieldset>
			<legend><?php echo __('Identifiant de fichier'); ?></legend>
			<p class="field">
				<label for="thumb_id"><?php printf(__('Identifiant du fichier de %s à utiliser comme vignette :'), $cat_type); ?></label>
				<input id="thumb_id" type="text" name="thumb_id" maxlength="12" size="10" value="<?php echo $tpl['category']['thumb_id']; ?>">
<?php if ($tpl['category']['thumb_id'] > 0) : ?>
			</p>
			<p class="field">
				<a id="thumb_new_current" href="<?php echo $tpl['link']('item-edit/' . $tpl['category']['thumb_id']); ?>"><?php echo __('Éditer ce fichier'); ?></a>
<?php endif; ?>
				<br>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input type="submit" value="<?php echo __('Enregistrer'); ?>">
			</p>
		</fieldset>
	</form>

	<form action="<?php echo $tpl['current_url']; ?>" method="post">
		<fieldset>
			<legend><?php echo __('Critère de sélection'); ?></legend>
			<p class="field">
				<label for="thumb_method"><?php echo __('Choisir une nouvelle vignette :'); ?></label>
				<select id="thumb_method" name="thumb_method">
					<option value="random"><?php echo __('Au hasard'); ?></option>
					<option value="last"><?php echo __('Dernier fichier ajouté'); ?></option>
					<option value="first"><?php echo __('Premier fichier ajouté'); ?></option>
				</select>
			</p>
<?php if ($tpl['category']['type'] == 'category') : ?>
			<div class="field_sublvl">
				<p class="field">
					<input id="thumb_method_subcats" name="thumb_method_subcats" type="checkbox">
					<label for="thumb_method_subcats"><?php echo __('Aussi pour les sous-catégories'); ?></span>
				</p>
			</div>
<?php endif; ?>
			<p class="field">
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input type="submit" value="<?php echo __('Enregistrer'); ?>">
			</p>
		</fieldset>
	</form>

	<form data-upload-check="1" action="<?php echo $tpl['current_url']; ?>" method="post" enctype="multipart/form-data">
		<fieldset>
			<legend><?php echo __('Image externe'); ?></legend>
			<p class="field">
				<?php echo __('Utiliser l\'image suivante comme vignette :'); ?>
			</p>
			<p class="field" id="thumb_new_file">
				<input required data-maxsize="<?php echo $tpl['upload_maxfilesize'](); ?>" class="file_hide" id="file" name="external" size="35" maxlength="2048" type="file"
					accept="<?php echo implode(',', $tpl['upload']['filetypes']); ?>">
				<label for="file" class="button_file"><?php echo __('Sélectionner un fichier'); ?></label>
			</p>
			<p class="field">
				<span class="text"><?php echo nl2br($tpl['upload']['text_limits']); ?></span>
			</p>
			<p class="field">
				<input name="MAX_FILE_SIZE" value="<?php echo $tpl['upload_maxfilesize'](); ?>" type="hidden">
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input type="submit" value="<?php echo __('Envoyer'); ?>">
			</p>
			<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
			var maxsize_text = "<?php echo $tpl['php2js'](__('Poids du fichier trop grand.')); ?>";
			</script>
		</fieldset>
	</form>

	<div id="thumbs"></div>

	<fieldset>
		<legend><?php printf(__('Fichier de %s'), $cat_type); ?></legend>
	</fieldset>

<?php include('pagination.tpl.php'); ?>

	<div class="std_thumbs">
		<div>
<?php foreach ($tpl['items'] as &$i) : ?>
			<dl data-id="<?php echo $i['id']; ?>">
				<dt>
<?php if ($i['type'] == 'video') : ?>					
					<span class="duration" id="videoduration_<?php echo $i['id']; ?>"><?php echo $i['duration_text']; ?></span>
<?php endif; ?>
					<img src="<?php echo $i['thumb_src'](); ?>">
				</dt>
				<dd>
					<?php echo $i['title']; ?>
				</dd>
			</dl>
<?php endforeach; ?>
		</div>
	</div>

<?php include('pagination.tpl.php'); ?>

</div>