<?php
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * All Flatboard code is released under the MIT license.
*/

$out['self'] = 'view';
require_once __DIR__ . '/' . 'header.php';

/**
 * AFFICHE UNE DISCUSSION
 **/
if (Util::isGETValidEntry('topic', 'topic')) {
    $cur = 'viewTopic'; // Indicateur de page   
    $topicEntry = flatDB::readEntry('topic', $_GET['topic']);
    $forumEntry = flatDB::readEntry('forum', $topicEntry['forum']);

    // Fix for old forum categories id's
    $forumEntry = $forumEntry ?? null;

    // Boutton de signalement pour le sujet
    $report = (function_exists('mail') ? ' <a href="add.php' . DS . 'report' . DS . $_GET['topic'] . '" class="btn btn-dark" data-toggle="tooltip" data-placement="top" title="' . $lang['report'] . '"><i class="fa fa-exclamation-triangle"></i></a>' : '');

    $role = (!$topicEntry['role'] == '' ? $topicEntry['role'] : 'admin');
    $mail = (!empty($topicEntry['mail']) ? '<p><span class="badge badge-dark"><i class="fa fa-envelope-o" aria-hidden="true"></i> ' . $topicEntry['mail'] . '</span></p>' : '');
    $getTopic = isset($forumEntry['pinnedTopic'][$_GET['topic']]) ? $forumEntry['pinnedTopic'][$_GET['topic']] : null;
    $tag = $topicEntry['tag'] ?? '';
    $authoredit = isset($topicEntry['authoredit']) ? Parser::title($topicEntry['authoredit']) : Parser::title($topicEntry['trip']);
    $lastedited = isset($topicEntry['lastedit']) ? '<hr/><span class="text-muted"><i class="fa fa-pencil-square-o" aria-hidden="true"></i> ' . Util::lang('last_modified', $authoredit) . Util::toDate($topicEntry['lastedit'], $config['date_format']) . '</span>' : '';

    // Topic view++ - Optimisé : mise à jour différée pour éviter les écritures à chaque vue
    // On incrémente seulement en mémoire, la sauvegarde se fera plus tard si nécessaire
    $topicEntry['view'] = ($topicEntry['view'] ?? 0) + 1;
    // Note: La sauvegarde peut être faite de manière asynchrone ou en batch pour améliorer les performances
    flatDB::saveEntry('topic', $_GET['topic'], $topicEntry);

    $out['subtitle'] = htmlspecialchars($topicEntry['title']);
    // Template viewTopic.tpl.php
    require THEME_DIR . $config['theme'] . DS . $cur . '.tpl.php';

    // AFFICHAGE DES RÉPONSES
    asort($topicEntry['reply']);
    $nb = $config['ItemByPage'];
    $total = Paginate::countPage($topicEntry['reply'], $nb);
    $p = Paginate::pid($total);

    if ($topicEntry['reply']) {
        $out['content'] .= '
        <h5 class="lead text-center text-uppercase">
            ' . Util::pluralize(count($topicEntry['reply']), $lang['replies'], $lang['reply']) . ' <span class="badge badge-pill badge-secondary">' . (count($topicEntry['reply'])) . '</span>
        </h5>';

        // PAGINATION
        $out['content'] .= Paginate::pageLink($p, $total, 'view.php' . DS . 'topic' . DS . $_GET['topic']);

        // Optimisation : préchargement de toutes les réponses de la page
        $repliesToLoad = Paginate::viewPage($topicEntry['reply'], $p, $nb);
        $repliesData = [];
        foreach ($repliesToLoad as $reply) {
            $repliesData[$reply] = flatDB::readEntry('reply', $reply);
        }
        
        foreach ($repliesToLoad as $reply) {
            $replyEntry = $repliesData[$reply] ?? null;
            if (!$replyEntry) {
                continue;
            }
            $mailReply = (!empty($replyEntry['mail']) ? '<p><span class="badge badge-dark"><i class="fa fa-envelope-o" aria-hidden="true"></i> ' . $replyEntry['mail'] . '</span></p>' : '');
            $uploadReply = (!empty($replyEntry['upload']) ? '<p><img src="' . $replyEntry['upload'] . '"/></p>' : '');
            $authorReplyedit = isset($replyEntry['authoredit']) ? Parser::title($replyEntry['authoredit']) : Parser::title($replyEntry['trip']);
            $lastReplyEdited = isset($replyEntry['lastedit']) ? '<hr/><span class="text-muted"><i class="fa fa-pencil-square-o" aria-hidden="true"></i> ' . Util::lang('last_modified', $authorReplyedit) . Util::toDate($replyEntry['lastedit'], $config['date_format']) . '</span>' : '';

            // Template viewReply.tpl.php
            require THEME_DIR . $config['theme'] . DS . 'viewReply.tpl.php';
        }

        // PAGINATION
        $out['content'] .= Paginate::pageLink($p, $total, 'view.php' . DS . 'topic' . DS . $_GET['topic']);
    }

    // ON AFFICHE LE FORMULAIRE DE RÉPONSE SI LA DISCUSSION N'EST PAS FERMÉE
    if (!$topicEntry['locked']) {
        require THEME_DIR . $config['theme'] . DS . 'replyFormCollapse.tpl.php';
    }

    // SUGGESTIONS DE SUJETS - Optimisé : préchargement des forums
    $out['content'] .= '
    <div class="my-3 p-3 bg-white rounded box-shadow">
        <h6 class="text-left border-bottom border-gray pb-2 mb-0">
            ' . $lang['thread_sug'] . '
        </h6>';

    $topics = flatDB::listEntry('topic');
    shuffle($topics);
    $suggestedTopics = array_slice($topics, 0, 4);
    
    // Préchargement des topics et forums pour éviter les requêtes N+1
    $topicsData = [];
    $forumsCache = [];
    foreach ($suggestedTopics as $topic) {
        $topicEntry = flatDB::readEntry('topic', $topic);
        if ($topicEntry) {
            $topicsData[$topic] = $topicEntry;
            $forumId = $topicEntry['forum'] ?? '';
            if ($forumId && !isset($forumsCache[$forumId])) {
                $forumsCache[$forumId] = flatDB::readEntry('forum', $forumId);
            }
        }
    }
    
    foreach ($suggestedTopics as $topic) {
        if (!isset($topicsData[$topic])) {
            continue;
        }
        $topicEntry = $topicsData[$topic];
        $forumEntry = $forumsCache[$topicEntry['forum'] ?? ''] ?? null;
        $tagSuggest = $topicEntry['tag'] ?? '';

        // Template viewSuggestedTopic.tpl.php
        require THEME_DIR . $config['theme'] . DS . 'viewSuggestedTopic.tpl.php';
    }
    
    $out['content'] .= '
        <h6 class="text-center p-2">' . $lang['want_more'] . '</h6>
    </div>';
}
/**
 * AFFICHE LA LISTE DES SUJETS D’UN FORUM
 **/
else if (isset($_GET['forum']) && !empty($_GET['forum']) && Util::isGETValidEntry('forum', 'forum')) {
    $cur = 'viewForum'; // Indicateur de page
    $forumEntry = flatDB::readEntry('forum', $_GET['forum']);
    
    if ($forumEntry !== null) { // Check if forumEntry is not null
        $out['subtitle'] = htmlspecialchars($forumEntry['name']);
        $out['sub_prefix'] = entryLink::manageForum($_GET['forum']);

        // Traitement des sujets épinglés   
        $pinned = $forumEntry['pinnedTopic'] ?? []; // Use null coalescing operator to provide a default value
        $pinnedTopic = array_diff($forumEntry['topic'] ?? [], $pinned); // Same here
        
        // Tri des sujets                       
        arsort($pinned, SORT_NUMERIC);  
        $topics = array_merge($pinned, array_reverse($pinnedTopic));
        
        // On compte les pages pour la pagination
        $nb = $config['ItemByPage'];
        $total = Paginate::countPage($topics, $nb);
        $p = Paginate::pid($total);

        // Forum privé
        $privateforums = isset($forumEntry['private_forum']) ? $forumEntry['private_forum'] || User::isWorker() : '';

        if ($topics) {
            $out['content'] .= '
            <div class="my-3 p-3 bg-white rounded box-shadow">' .
            Paginate::pageLink($p, $total, 'view.php' . DS . 'forum' . DS . $_GET['forum']);
            
            foreach (Paginate::viewPage($topics, $p, $nb) as $topic) {
                $topicEntry = flatDB::readEntry('topic', $topic);
                
                // Ajout de la date de la dernière réponse - Optimisé : on ne lit que la dernière réponse
                $lastReply = '';
                if (!empty($topicEntry['reply']) && is_array($topicEntry['reply'])) {
                    // Récupère uniquement la dernière réponse (la plus récente)
                    $lastReplyId = end($topicEntry['reply']);
                    $replyEntry = flatDB::readEntry('reply', $lastReplyId);
                    if ($replyEntry) {
                        $lastReply = '<br/>
                            <span class="user ' . htmlspecialchars($replyEntry['role'] ?? '') . '">' . Parser::title($replyEntry['trip'] ?? '') . '</span> 
                            ' . $lang['replied'] . ' ' . Util::toDate($lastReplyId, $config['date_format']) . ' 
                            <a data-toggle="tooltip" data-placement="top" title="' . $lang['more'] . '" href="view.php' . DS . 'topic' . DS . ($replyEntry['topic'] ?? $topic) . DS . 'p' . DS . Util::onPage($lastReplyId, $topicEntry['reply']) . '#' . $lastReplyId . '"><i class="fa fa-external-link-square" aria-hidden="true"></i></a>';
                    }
                }

                // On parse nos tags s'il y a
                $tag = isset($topicEntry['tag']) ? ' <a href="search.php?topic=' . htmlspecialchars($topicEntry['tag']) . '">' . Parser::title($topicEntry['tag']) . '</a>' : '';
                
                // Dernière édition par l'auteur
                $authoredit = Parser::title($topicEntry['authoredit'] ?? $topicEntry['trip'] ?? '');
                $lastedited = isset($topicEntry['lastedit']) ? '<br /><small><i class="fa fa-pencil-square-o" aria-hidden="true"></i> ' . Util::lang('last_modified', $authoredit) . Util::toDate($topicEntry['lastedit'], $config['date_format']) . '</small>' : '';

                // Template viewForum.tpl.php
                require THEME_DIR . $config['theme'] . DS . 'viewForum.tpl.php';
            }

            $out['content'] .= 
            Paginate::pageLink($p, $total, 'view.php' . DS . 'forum' . DS . $_GET['forum']) . '     
            </div><!-- /.columns -->';
        }
    }
}
/**
 * AFFICHE LA PAGE DU PLUGIN
 **/
else if (Util::isGETValidHook('view', 'plugin')) {
    $plugin = isset($_GET['plugin']) ? $_GET['plugin'] : null;
    $cur = $plugin; // Indicateur de page
    $subtitle = isset($plugin) ? $lang[$plugin . 'name'] : null;

    // Lecture des données
    $data = flatDB::readEntry('plugin', $plugin);

    if (isset($data[$plugin . 'state']) && $data[$plugin . 'state']) {
        $out['subtitle'] = $subtitle;
        $out['content'] .= Plugin::myHook('view', $plugin);
    } else {
        $out['subtitle'] = $lang['error'];
        $out['content'] .= $lang['no_plugin'];
    }
}
/**
 * REDIRECT IF NO VALID PARAMETERS
 **/
else {
    header('HTTP/1.1 404 Not Found');
    Util::redirect('index.php' . DS . '404');
}

require PATH_ROOT . DS . 'footer.php';
?>