// Notification by https://ned.im/noty/
// Template de la notification via callbacks
Noty.overrideDefaults({
  callbacks: {
    onTemplate: function() {
      if (this.options.type === 'alert') {    
        this.barDom.innerHTML = '<figure class="figure noty_body">';
        this.barDom.innerHTML += '<img class="figure-img img-thumbnail m-2" style="width:70px" src="' + this.options.img + '">';
        this.barDom.innerHTML += '<figcaption class="mb-1 text-center">' + this.options.text + '</figcaption>';
        this.barDom.innerHTML += '<div class="noty_progressbar"></div>';
        this.barDom.innerHTML += '</figure>';
      }
    }
  }
})
// Paramètres de la notification
const showNotif = (msg, img) => {
  let notif = 	 
	  new Noty({
	  	theme: 'sunset',
	  	type: 'alert',
	    text: msg,
	    img: img,
	    layout: 'bottomRight',
	  	timeout: '3000',
	  	progressBar: true,
	  	closeWith: ['click'],
	  	killer: true,			    
	  }).show();
}
// Rendus AJAX - Optimisé avec délégation d'événements et gestion d'erreurs
$(function(){
  // Utilisation de la délégation d'événements pour éviter les problèmes N+1
  // et gérer les éléments ajoutés dynamiquement
  $(document).on('change', "input[data-corepluginswitch='true']", function(e){
    const pluginSwitch = $(this);
    const checked = pluginSwitch.is(':checked');
    const pluginId = pluginSwitch.data("corepluginid");
    
    // Désactiver le switch pendant la requête pour éviter les clics multiples
    pluginSwitch.prop('disabled', true);
    
    // Ajouter un indicateur visuel de chargement
    const cardElement = $("[data-pluginid='"+pluginId+"']");
    const originalBorder = cardElement.attr('class').match(/border-\w+/);
    cardElement.addClass('opacity-50');
    
    $.ajax({
      url: "#",
      type: "POST",
      data: {
        corePluginSwitch: JSON.stringify({
          pluginId: pluginId,
          isEnable: checked
        })
      },
      timeout: 10000, // Timeout de 10 secondes
      success: function(response){
        try {
          // Optimisation : parser une seule fois
          const data = typeof response === 'string' ? JSON.parse(response) : response;
          
          if(data && data.good){
            // Cache du sélecteur pour éviter les requêtes répétées
            const pluginCard = $("[data-pluginid='"+data.id+"']");
            
            //notification
            showNotif(data.msg, data.img);
            
            //bordure - optimisation avec toggleClass
            pluginCard.removeClass('border-success border-secondary opacity-50')
                      .addClass('border-'+data.newStatut);
            
            //tooltip - optimisation avec une seule requête
            const tooltipElement = pluginCard.find("[data-plugincardtooltip='true']");
            tooltipElement.attr('data-original-title', data.newTooltip)
                         .tooltip('dispose') // Nettoyer l'ancien tooltip
                         .tooltip(); // Réinitialiser le tooltip
            
            //boutons
            pluginCard.find("[data-plugincardbutton='true']").html(data.newButton);
          } else {
            // En cas d'erreur, restaurer l'état précédent
            pluginSwitch.prop('checked', !checked);
            cardElement.removeClass('opacity-50');
            showNotif('Erreur lors de la modification du plugin', '');
          }
        } catch (e) {
          // Gestion d'erreur de parsing JSON
          console.error('Erreur de parsing JSON:', e);
          pluginSwitch.prop('checked', !checked);
          cardElement.removeClass('opacity-50');
          showNotif('Erreur lors du traitement de la réponse', '');
        }
      },
      error: function(xhr, status, error){
        // Gestion des erreurs AJAX
        console.error('Erreur AJAX:', status, error);
        pluginSwitch.prop('checked', !checked);
        cardElement.removeClass('opacity-50');
        
        let errorMsg = 'Erreur de connexion';
        if (status === 'timeout') {
          errorMsg = 'La requête a pris trop de temps';
        } else if (status === 'error') {
          errorMsg = 'Erreur serveur';
        }
        showNotif(errorMsg, '');
      },
      complete: function(){
        // Réactiver le switch après la requête (succès ou échec)
        pluginSwitch.prop('disabled', false);
      }
    });
  });
});