/*!
  * FlatBB Editor v3.2 (https://flatboard.org)
  * Copyright 2019-2024 Author: Frédéric Kaplon
  * Licensed under MIT (https://github.com/Fred89/flatboard/blob/master/LICENSE)
  * Minified with https://jscompress.com/
  */
function EditorTagInsert(e, n, t, a) {
    if ("" === a) return 0;
    0 != a && (n = n.replace("$1", a));
    var o = document.getElementById(e);
    if (void 0 === o || null == o) return 0;
    var i = o.selectionStart,
        a = o.selectionEnd,
        e = o.value;
    o.value = e.substring(0, i) + n + e.substring(i, a) + t + e.substring(a, e.length), o.selectionStart = i + n.length, o.selectionEnd = a + n.length, o.focus()
}
$(function() {
    bbcode()
});
var map = {
    "o/": "👋",
    "</3": "💔",
    "<3": "💗",
    "8-D": "😁",
    ":-D": "😁",
    ":-3": "😁",
    ":3": "😁",
    "B^D": "😁",
    "X-D": "😁",
    "x-D": "😁",
    xD: "😁",
    ':")': "😂",
    ':"-)': "😂",
    ":-))": "😃",
    "8)": "😄",
    ":)": "😊",
    ":-)": "😄",
    ":]": "😄",
    ":^)": "😄",
    ":o)": "😄",
    ":}": "😄",
    ":っ)": "😄",
    "0:)": "😇",
    "0:-)": "😇",
    "0:-3": "😇",
    "0:3": "😇",
    "0;^)": "😇",
    "O:-)": "😇",
    "3:)": "😈",
    "3:-)": "😈",
    "}:)": "😈",
    "}:-)": "😈",
    "*)": "😉",
    "*-)": "😉",
    ":-,": "😉",
    ";)": "😉",
    ";-)": "😉",
    ";-]": "😉",
    ";D": "😉",
    ";]": "😉",
    ";^)": "😉",
    ":-|": "😐",
    ":|": "😐",
    ":(": "😒",
    ":-(": "😒",
    ":-<": "😒",
    ":-[": "😒",
    ":-c": "😒",
    ":<": "😒",
    ":[": "😒",
    ":{": "😒",
    ":っC": "😒",
    "%)": "😖",
    "%-)": "😖",
    ":-P": "😜",
    ":-b": "😜",
    ":-p": "😜",
    ":-Þ": "😜",
    ":-þ": "😜",
    ":Þ": "😜",
    ":þ": "😜",
    ";(": "😜",
    "X-P": "😜",
    "x-p": "😜",
    ":-||": "😠",
    ":-.": "😡",
    ":-/": "😡",
    ':"(': "😢",
    ':"-(': "😢",
    "^5": "😤",
    "^<_<": "😤",
    "o/\\o": "😤",
    "|-O": "😫",
    "|;-)": "😫",
    ":###..": "😰",
    ":-###..": "😰",
    'D-":': "😱",
    "D:<": "😱",
    "D;": "😱",
    DX: "😱",
    "v.v": "😱",
    "8-0": "😲",
    ":-O": "😲",
    ":-o": "😲",
    "O-O": "😲",
    O_O: "😲",
    O_o: "😲",
    "o-o": "😲",
    o_O: "😲",
    o_o: "😲",
    ":#": "😶",
    ":&": "😶",
    ":-#": "😶",
    ":-&": "😶",
    ":-X": "😶",
    ":X": "😶",
    ":-J": "😼",
    ":*": "😽",
    ":^*": "😽",
    "ಠ_ಠ": "🙅",
    "*\\0/*": "🙆",
    "\\o/": "🙆",
    ":>": "😄",
    ">.<": "😡",
    ">:(": "😠",
    ">:)": "😈",
    ">:-)": "😈",
    ">:[": "😒",
    ">;)": "😈",
    ">_>^": "😤",
    "^^": "😊",
    ":sweat": "😅"
};

function escapeSpecialChars(e) {
    return e.replace(/([()[{*+.$^\\|?])/g, "\\$1")
}

function bbcode() {
    $('textarea[name="content"]').attr("data-emoji", "true"), window.EmojiPicker.init(), $("#fullscreen").click(function(e) {
        $("#form").toggleClass("fullscreen")
    })
}
document.getElementById("content").oninput = function() {
    for (var e in map) {
        var n = new RegExp(escapeSpecialChars(e), "gim");
        this.value = this.value = this.value.replace(n, map[e])
    }
};