<?php defined('FLATBOARD') or die('Flatboard Community.');
/**
 * FlatBBeditor
 *
 * @author 		Frédéric K.
 * @copyright	(c) 2025
 * @license		http://opensource.org/licenses/MIT
 * @package		FlatBoard
 * @version		3.7
 * @update		2025-10-01
 */	
   
/**
 *  Liste des boutons à paramètrer
**/
function btnBBcode_list()
{
	return array('font_size', 'font_color', 'bold', 'italic', 'underline', 'strike', 'code', 'quote', 'hide', 'align_center', 'align_right', 'insert_picture_width', 'insert_picture', 'insert_link', 'insert_youtube_video', 'insert_dailymotion_video', 'insert_video', 'fullscreen_editor');
}            	
/**
 * On pré-installe les paramètres par défauts.
**/
function FlatBBeditor_install()
{
	global $lang;
	$plugin = 'FlatBBeditor';
	if (flatDB::isValidEntry('plugin', $plugin))
		return;
	$data[$plugin.'state'] 	 	= true;
	foreach(btnBBcode_list() as $feature)
	{
		$data[$feature] = true;
	}                  
    flatDB::saveEntry('plugin', $plugin, $data);          
}
/**
 *  Admin
**/
function FlatBBeditor_config()
{     
	   global $config, $lang, $token;
       $plugin = 'FlatBBeditor';
       $out ='';      
       if(!empty($_POST) && CSRF::check($token) )
       {
	       	$data[$plugin.'state']		= Util::isPOST('state') ? $_POST['state'] : '';
			foreach(btnBBcode_list() as $feature)
			{
				$data[$feature] 		= Util::isPOST($feature) ? HTMLForm::clean($_POST[$feature]) : '';
			}                      
            flatDB::saveEntry('plugin', $plugin, $data);
            $out .= Plugin::redirectMsg($lang['plugin'].'&nbsp;<b>'.$lang[$plugin.'name']. '</b>','config.php' . DS . 'plugin' . DS . $plugin, $lang['data_save']);
       }
        else
       {
            if (flatDB::isValidEntry('plugin', $plugin))
            $data = flatDB::readEntry('plugin', $plugin);
			$controlStr = '';
			foreach(btnBBcode_list() as $feature)
			{
				$controlStr .= HTMLForm::checkBox($feature, isset($data[$feature])? $data[$feature] : '');
			}            
            $out .= HTMLForm::form('config.php' . DS . 'plugin' . DS . $plugin, 
            HTMLForm::checkBox('state', isset($data)? $data[$plugin.'state'] : ''). 
            '<h5>' .$lang['btn_toolbar']. '</h5>'.  
            $controlStr.        
            HTMLForm::simple_submit());
       }
       return $out;
}
/**
 *  Css
**/
function FlatBBeditor_head()
{
  global $config, $cur;
  $plugin = 'FlatBBeditor';
  # Lecture des données avec cache statique
  static $pluginDataCache = null;
  if ($pluginDataCache === null) {
    $pluginDataCache = flatDB::readEntry('plugin', $plugin);
  }
  $PluginActivate = isset($pluginDataCache[$plugin.'state']) ? $pluginDataCache[$plugin.'state'] : false;
  if($PluginActivate) {
	if ($config['editor'] == 'markdown')
	    return '	<link rel="stylesheet" type="text/css" href="' .HTML_PLUGIN_DIR . $plugin . DS . 'editor' . DS . 'md' . DS . 'bootstrap-markdown.min.css">'.PHP_EOL;
	else 
	    return '	<link rel="stylesheet" type="text/css" href="' .HTML_PLUGIN_DIR . $plugin . DS . 'css' . DS . 'FlatBBeditor.css">'.PHP_EOL; 
  }      
}
/**
 * Textarea
**/
function FlatBBeditor_editor()
{
  global $config, $cur, $lang;
  $plugin = 'FlatBBeditor';
  
  # Lecture des données avec cache statique
  static $pluginDataCache = null;
  if ($pluginDataCache === null) {
    $pluginDataCache = flatDB::readEntry('plugin', $plugin);
  }
  
  $html  = '';
  
  // Ne pas afficher sur les pages du plugin page (qui utilisent TinyMCE)
  // Vérifier si on est sur le plugin page (add/edit/manage)
  $isPagePlugin = (isset($cur) && $cur === 'page') && 
                  (isset($_GET['add']) || isset($_GET['edit']) || isset($_GET['manage']));
  
  // Charger l'éditeur si le plugin est activé ET qu'on n'est PAS sur le plugin page
  if (isset($pluginDataCache[$plugin.'state']) && $pluginDataCache[$plugin.'state'] && !$isPagePlugin)
  {	  
   	if ($config['editor'] == 'markdown') {
	   # Markdown	
	   include_once(__DIR__  . DS .  'editor' . DS . 'markdown.php');
   	} else {
	   # BBcode - On doit définir $data AVANT d'inclure bbcode.php
	   $data = $pluginDataCache; // Cette ligne est CRUCIALE !
	   include_once(__DIR__  . DS .  'editor' . DS . 'bbcode.php');
   	}	   	   
  }
  return $html;       
}
/**
 *  JavaScript
**/
function FlatBBeditor_footerJS()
{
  global $config, $lang, $cur;
  $plugin = 'FlatBBeditor';
  $uploadROOT = PATH_ROOT . DS . 'upload.php';
  # Lecture des données avec cache statique
  static $pluginDataCache = null;
  if ($pluginDataCache === null) {
    $pluginDataCache = flatDB::readEntry('plugin', $plugin);
  }
  $PluginActivate = isset($pluginDataCache[$plugin.'state']) ? $pluginDataCache[$plugin.'state'] : false;
  
  // Ne pas afficher sur les pages du plugin page (qui utilisent TinyMCE)
  $isPagePlugin = (isset($cur) && $cur === 'page') && 
                  (isset($_GET['add']) || isset($_GET['edit']) || isset($_GET['manage']));
  
  # Fichier Langue en javascript pour l'éditeur Markdown
  $MDlang = '';
  $MDl = substr($config['lang'], 0, -3);
  $MDlangFile = PLUGIN_DIR . $plugin . DS . 'editor' . DS . 'md' . DS . 'lang' . DS . $MDl. '.js';
  if (file_exists($MDlangFile)) 
  	$MDlang = '<script src="' .HTML_PLUGIN_DIR . $plugin . DS . 'editor' . DS . 'md' . DS . 'lang' . DS . $MDl. '.js"></script>'.PHP_EOL;
  	
  # On insère le javascript du plugin	    
  $html  = '';
  if($PluginActivate && !$isPagePlugin)
  {
	if ($config['editor'] == 'markdown') {
		$html .= '	<script src="' .HTML_PLUGIN_DIR . $plugin . DS . 'editor' . DS . 'md' . DS . 'markdown.js"></script>'.PHP_EOL;
		$html .= '	<script src="' .HTML_PLUGIN_DIR . $plugin . DS . 'editor' . DS . 'md' . DS . 'to-markdown.js"></script>'.PHP_EOL;
		$html .= '	<script src="' .HTML_PLUGIN_DIR . $plugin . DS . 'editor' . DS . 'md' . DS . 'bootstrap-markdown.js"></script>'.PHP_EOL;
		$html .= 	$MDlang;
		$html .= '	<script>$(\'#content\').markdown({iconlibrary: \'fa\',language:\'fr\'});</script>'.PHP_EOL;
	} else {
		$html .= '	<script src="' .HTML_PLUGIN_DIR . $plugin . DS . 'js' . DS . 'FlatBBeditor.js"></script>'.PHP_EOL;		
	}
	$html .= '	<script src="' .HTML_PLUGIN_DIR . $plugin . DS . 'js' . DS . 'emojiPicker.js"></script>'.PHP_EOL;
	$html .= '	<script>'.PHP_EOL;
	$html .= '		function reload(){var img=document.images["cap-img"];img.src=img.src.substring(0,img.src.lastIndexOf("?"))+"?rand="+Math.random()*1000;}
    $(document).ready(function(){ 
      $(\'.btn[href^="add.php/topic"],.btn[href^="add.php/reply"],.btn[href^="add.php/report"]\').click(function(event) {
        event.preventDefault();
        if($(this).siblings("#form").length > 0) {
          $(this).siblings("#form").slideUp("slow", function(){ $(this).remove(); });
        } else {
          $("#form").remove();
          $(\'<div id="form" class="card fixed-bottom p-3 bg-light fixed-modal"></div>\').hide().insertAfter(this).load($(this).attr("href") + " form", function() {
          if(typeof bbcode == "function") bbcode();
          	' .($config['editor'] == 'markdown' ? '$(\'#content\').markdown({iconlibrary: \'fa\',language:\'fr\'});' : ''). '
            $(\'[data-toggle="tooltip"]\').tooltip();
            $(\'[data-toggle="popover"]\').popover();						
            $(this).slideDown("slow");
          });	  
        }
      });
	});     	  																		
  </script>'.PHP_EOL;	  	   
  }
  return $html;    
}
?>