<?php
/*
 * Nom du projet : Flatboard
 * URL du projet : https://flatboard.org
 * Auteur : Frédéric Kaplon et contributeurs
 * Tout le code de Flatboard est publié sous la licence MIT.
 */

// Démarrer la session de manière sécurisée
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Générer un code CAPTCHA complexe
function generateCaptchaCode($length = 6)
{
    $chars = 'ABCDEFGHJKLMNPQRSTUVWXYZabcdefghjkmnpqrstuvwxyz23456789';
    $code = '';
    for ($i = 0; $i < $length; $i++) {
        $code .= $chars[random_int(0, strlen($chars) - 1)];
    }
    return $code;
}

$captcha_code = generateCaptchaCode();
$_SESSION['captcha'] = $captcha_code;

// Créer une image CAPTCHA avec bruit et distorsion
$width = 200;
$height = 60;
$layer = imagecreatetruecolor($width, $height);

// Couleurs
$bgColor = imagecolorallocate($layer, 233, 236, 239); // Fond blanc
$textColor = imagecolorallocate($layer, 0, 0, 0); // Texte noir
$noiseColor = imagecolorallocate($layer, 150, 150, 150); // Bruit gris plus visible

// Remplir le fond
imagefill($layer, 0, 0, $bgColor);

// Ajouter du bruit (plus de pixels)
for ($i = 0; $i < 200; $i++) {
    imagesetpixel($layer, random_int(0, $width), random_int(0, $height), $noiseColor);
}

// Ajouter des lignes de distorsion (plus de lignes)
for ($i = 0; $i < 5; $i++) {
    imageline($layer, 0, random_int(0, $height), $width, random_int(0, $height), $noiseColor);
}

// Ajouter des cercles aléatoires
for ($i = 0; $i < 10; $i++) {
    imageellipse($layer, random_int(0, $width), random_int(0, $height), random_int(5, 15), random_int(5, 15), $noiseColor);
}

// Ajouter des arcs aléatoires
for ($i = 0; $i < 5; $i++) {
    imagearc($layer, random_int(0, $width), random_int(0, $height), random_int(10, 30), random_int(10, 30), random_int(0, 360), random_int(0, 360), $noiseColor);
}

// Utiliser une police TTF si disponible
$fontPath = 'captcha.ttf'; // Remplacez par le chemin vers une police TTF sur votre serveur
$fontSize = 20;
$xStart = 20;

// Écrire le texte avec une police TTF
if (file_exists($fontPath)) {
    for ($i = 0; $i < strlen($captcha_code); $i++) {
        $angle = random_int(-10, 10);
        $x = $xStart + ($i * 30);
        $y = random_int(35, 45);
        imagettftext($layer, $fontSize, $angle, $x, $y, $textColor, $fontPath, $captcha_code[$i]);
    }
} else {
    // Utiliser une police intégrée si la police TTF n'est pas disponible
    $font = [5];
    $fontSize = $font[0];
    for ($i = 0; $i < strlen($captcha_code); $i++) {
        $angle = random_int(-10, 10);
        $x = $xStart + ($i * 20);
        $y = random_int(25, 35);
        imagestring($layer, $fontSize, $x, $y, $captcha_code[$i], $textColor);
    }
}

// Envoyer l'image
header('Content-Type: image/png');
imagepng($layer);
imagedestroy($layer);
?>