<?php defined('FLATBOARD') or die('Flatboard Community.');
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * All Flatboard code is released under the MIT license.
 */

/*
 *---------------------------------------------------------------
 * DEFINITION DE CONSTANTES
 *---------------------------------------------------------------
 */
# Version de FlatBoard
const VERSION = '4.0';
# Nom de code de la version de Flatboard 
const CODENAME = 'SPITZ'; // mb_strtoupper('tromsø', 'UTF-8') for uppercase
# Date de la build
const BUILD = '251130';
# Formatage du timestamp
const TIMESTAMP = TRUE;
# Limitation de requete par secondes
const LIMIT_REQUETE = 10;
// Mots clés à filtrer dans plusieurs langues
const CONTENT_FILTER = '/viagra|cialis|poker|casino|medicines|gambling|adult|' .
                       '药|赌博|成人|药品|' .         // Chinois
                       '바이아그라|카지노|성인|도박|의약품|' . // Coréen
                       'виагра|казино|взрослые|азартные игры|медицина|' . // Russe
                       'viagra|casino|adultes|jeux d\'argent|médicaments|' . // Français
                       'viagra|casinò|adulti|giochi d\'azzardo|medicinali|' . // Italien
                       'viagra|casino|adultos|juegos de azar|medicamentos/'; // Espagnol
# Nombre d'éléments à afficher sur la liste des plugins
const PLUGS_PAGINATION = 12; 
# Charset par défaut
const CHARSET = 'UTF-8';
# Les différents dossiers
const UPLOADS_DIR = PATH_ROOT . DS . 'uploads' . DS;
const DATA_DIR = PATH_ROOT . DS . 'data' . DS;
const DATA_PLUGIN = DATA_DIR . 'plugin' . DS;
const BAN_DIR = PATH_ROOT . DS . 'data' . DS . 'ban' . DS;
const BAN_FILE = BAN_DIR . 'blocklist.txt';
const LANG_DIR = PATH_ROOT . DS . 'lang' . DS;
const LIB_DIR = PATH_ROOT . DS . 'lib' . DS;
const PLUGIN_DIR = PATH_ROOT . DS . 'plugin' . DS;
const THEME_DIR = BASEPATH . DS . 'theme' . DS;
# JSON pretty print
if (!defined('JSON_PRETTY_PRINT')) define('JSON_PRETTY_PRINT', 128);
# Mode de débogage: NULL, FALSE & TRUE
const DEBUG_MODE = FALSE;

/**
 * Configure le mode de débogage et la gestion des logs d'erreurs.
 *
 * @param mixed $debugMode Peut être true, false ou null.
 *                        - true : Affiche toutes les erreurs et les loggue dans error.log.
 *                        - false : Désactive toutes les erreurs.
 *                        - null : Configure avec un niveau par défaut (affiche erreurs warnings & notices).
 * @param string $logPath Chemin complet vers le fichier de log des erreurs.
 *                        Par défaut, error.log à la racine du projet.
 */
function configureDebugMode($debugMode = null, $logPath = null)
{
    // Définitions par défaut
    if ($logPath === null) {
        // Définissez PATH_ROOT et DS avant ou adaptez ce chemin
        if (defined('PATH_ROOT') && defined('DS')) {
            $logPath = PATH_ROOT . DS . 'error.log';
        } else {
            // fallback si PATH_ROOT/DS non défini
            $logPath = __DIR__ . '/error.log';
        }
    }

    ini_set('error_log', $logPath);

    if ($debugMode === true) {
        error_reporting(E_ALL | E_NOTICE);
        ini_set('display_errors', '1');
        ini_set('display_startup_errors', '1');
        ini_set('track_errors', '1');
        ini_set('html_errors', '1');
    } elseif ($debugMode === false) {
        error_reporting(0);
        ini_set('display_errors', '0');
        ini_set('display_startup_errors', '0');
        ini_set('track_errors', '0');
        ini_set('html_errors', '0');
    } else {
        // mode par défaut (null ou autre valeur)
        error_reporting(E_ALL & ~E_DEPRECATED);
        ini_set('display_errors', '0'); // Ne pas afficher à l'écran
        ini_set('display_startup_errors', '0');
        ini_set('track_errors', '1');
        ini_set('html_errors', '0');
    }
}
configureDebugMode(DEBUG_MODE);

# Multibyte string extension loaded.
mb_internal_encoding(CHARSET);
mb_http_output(CHARSET);

/*
 *---------------------------------------------------------------
 * INCLUSION DES LIBS NÉCESSAIRES
 *---------------------------------------------------------------
 */
require_once LIB_DIR . 'Flatdb.lib.php';
require_once LIB_DIR . 'Asset.lib.php';
require_once LIB_DIR . 'Utils.lib.php';
require_once LIB_DIR . 'CSRF.lib.php';
require_once LIB_DIR . 'GlobalRequestLimiter.php';

/*
 *---------------------------------------------------------------
 * BLOQUE AUTOMATIQUEMENT SI PLUS DE 10 REQUÊTES/SECONDE
 *---------------------------------------------------------------
 */
$globalLimiter = new GlobalRequestLimiter(DATA_DIR . 'rate_limits/', LIMIT_REQUETE, 1);
if ($_SERVER['REQUEST_METHOD'] === 'POST' || !empty($_GET)) {
    $globalLimiter->checkGlobalLimit();
}

/*
 *---------------------------------------------------------------
 * FICHIER CONTENANT LA CLÉ ENCRYPTÉE POUR LE MOT DE PASSE
 *---------------------------------------------------------------
 */
if (file_exists(DATA_DIR . 'key.php')) include(DATA_DIR . 'key.php');

/*
 *---------------------------------------------------------------
 * RETOURNE LA LISTE DES LANGUES DISPONIBLES
 *---------------------------------------------------------------
 */
function langpack() {
    global $lang;
    return [
        'en-US' => $lang['en-US'],
        'fr-FR' => $lang['fr-FR'],
        'ru-RU' => $lang['ru-RU'],
        'de-DE' => $lang['de-DE'],
        'it-IT' => $lang['it-IT'],
        'es-ES' => $lang['es-ES'],
        'zh-CN' => $lang['zh-CN']
    ];
}
?>