
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `drupal1132`
--
-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]batch`
--

CREATE TABLE `[[dbprefix]]batch` (
  `bid` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique batch ID.',
  `token` varchar(64) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'A string token generated against the current user''s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',
  `timestamp` int NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',
  `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',
  PRIMARY KEY (`bid`),
  KEY `token` (`token`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='Stores details about batches (processes that run in…' AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_content`
--

CREATE TABLE `[[dbprefix]]block_content` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `revision_id` int unsigned DEFAULT NULL,
  `type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `uuid` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `block_content_field__uuid__value` (`uuid`),
  UNIQUE KEY `block_content__revision_id` (`revision_id`),
  KEY `block_content_field__type__target_id` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for block_content entities.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_content_field_data`
--

CREATE TABLE `[[dbprefix]]block_content_field_data` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL,
  `type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `status` tinyint NOT NULL,
  `info` varchar(255) DEFAULT NULL,
  `changed` int DEFAULT NULL,
  `reusable` tinyint DEFAULT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`,`langcode`),
  KEY `block_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`),
  KEY `block_content__revision_id` (`revision_id`),
  KEY `block_content_field__type__target_id` (`type`),
  KEY `block_content_field__reusable` (`reusable`),
  KEY `block_content__status_type` (`status`,`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The data table for block_content entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_content_field_revision`
--

CREATE TABLE `[[dbprefix]]block_content_field_revision` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `status` tinyint NOT NULL,
  `info` varchar(255) DEFAULT NULL,
  `changed` int DEFAULT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`revision_id`,`langcode`),
  KEY `block_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision data table for block_content entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_content_revision`
--

CREATE TABLE `[[dbprefix]]block_content_revision` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL AUTO_INCREMENT,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `revision_user` int unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `revision_created` int DEFAULT NULL,
  `revision_log` longtext,
  `revision_default` tinyint DEFAULT NULL,
  PRIMARY KEY (`revision_id`),
  KEY `block_content__id` (`id`),
  KEY `block_content_field__revision_user__target_id` (`revision_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision table for block_content entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_content_revision__body`
--

CREATE TABLE `[[dbprefix]]block_content_revision__body` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext NOT NULL,
  `body_summary` longtext,
  `body_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for block_content field body.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_content__body`
--

CREATE TABLE `[[dbprefix]]block_content__body` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext NOT NULL,
  `body_summary` longtext,
  `body_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for block_content field body.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cachetags`
--

CREATE TABLE `[[dbprefix]]cachetags` (
  `tag` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'Namespace-prefixed tag string.',
  `invalidations` int NOT NULL DEFAULT '0' COMMENT 'Number incremented when the tag is invalidated.',
  PRIMARY KEY (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Cache table for tracking cache tag invalidations.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_bootstrap`
--

CREATE TABLE `[[dbprefix]]cache_bootstrap` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_bootstrap`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_config`
--

CREATE TABLE `[[dbprefix]]cache_config` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_config`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_container`
--

CREATE TABLE `[[dbprefix]]cache_container` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_container`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_data`
--

CREATE TABLE `[[dbprefix]]cache_data` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_data`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_default`
--

CREATE TABLE `[[dbprefix]]cache_default` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_default`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_discovery`
--

CREATE TABLE `[[dbprefix]]cache_discovery` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_discovery`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_dynamic_page_cache`
--

CREATE TABLE `[[dbprefix]]cache_dynamic_page_cache` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_dynamic_page_cache`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_entity`
--

CREATE TABLE `[[dbprefix]]cache_entity` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_entity`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_menu`
--

CREATE TABLE `[[dbprefix]]cache_menu` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_menu`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache_render`
--

CREATE TABLE `[[dbprefix]]cache_render` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';

--
-- Dumping data for table `[[dbprefix]]cache_render`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comment`
--

CREATE TABLE `[[dbprefix]]comment` (
  `cid` int unsigned NOT NULL AUTO_INCREMENT,
  `comment_type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `uuid` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  PRIMARY KEY (`cid`),
  UNIQUE KEY `comment_field__uuid__value` (`uuid`),
  KEY `comment_field__comment_type__target_id` (`comment_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for comment entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comment_entity_statistics`
--

CREATE TABLE `[[dbprefix]]comment_entity_statistics` (
  `entity_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'The entity_id of the entity for which the statistics are compiled.',
  `entity_type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT 'node' COMMENT 'The entity_type of the entity to which this comment is a reply.',
  `field_name` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field_name of the field that was used to add this comment.',
  `cid` int NOT NULL DEFAULT '0' COMMENT 'The "[[dbprefix]]comment".cid of the last comment.',
  `last_comment_timestamp` bigint NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp of the last comment that was posted within this node, from "[[dbprefix]]comment".changed.',
  `last_comment_name` varchar(60) DEFAULT NULL COMMENT 'The name of the latest author to post a comment on this node, from "[[dbprefix]]comment".name.',
  `last_comment_uid` int unsigned NOT NULL DEFAULT '0' COMMENT 'The user ID of the latest author to post a comment on this node, from "[[dbprefix]]comment".uid.',
  `comment_count` int unsigned NOT NULL DEFAULT '0' COMMENT 'The total number of comments on this entity.',
  PRIMARY KEY (`entity_id`,`entity_type`,`field_name`),
  KEY `last_comment_timestamp` (`last_comment_timestamp`),
  KEY `comment_count` (`comment_count`),
  KEY `last_comment_uid` (`last_comment_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Maintains statistics of entity and comments posts to show …';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comment_field_data`
--

CREATE TABLE `[[dbprefix]]comment_field_data` (
  `cid` int unsigned NOT NULL,
  `comment_type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `status` tinyint NOT NULL,
  `uid` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `pid` int unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `entity_id` int unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `subject` varchar(64) DEFAULT NULL,
  `name` varchar(60) DEFAULT NULL,
  `mail` varchar(254) DEFAULT NULL,
  `homepage` varchar(255) DEFAULT NULL,
  `hostname` varchar(128) DEFAULT NULL,
  `created` int NOT NULL,
  `changed` int DEFAULT NULL,
  `thread` varchar(255) NOT NULL,
  `entity_type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `field_name` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `default_langcode` tinyint NOT NULL,
  PRIMARY KEY (`cid`,`langcode`),
  KEY `comment__id__default_langcode__langcode` (`cid`,`default_langcode`,`langcode`),
  KEY `comment_field__comment_type__target_id` (`comment_type`),
  KEY `comment_field__uid__target_id` (`uid`),
  KEY `comment_field__created` (`created`),
  KEY `comment__status_comment_type` (`status`,`comment_type`,`cid`),
  KEY `comment__status_pid` (`pid`,`status`),
  KEY `comment__num_new` (`entity_id`,`entity_type`,`comment_type`,`status`,`created`,`cid`,`thread`(191)),
  KEY `comment__entity_langcode` (`entity_id`,`entity_type`,`comment_type`,`default_langcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The data table for comment entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comment__comment_body`
--

CREATE TABLE `[[dbprefix]]comment__comment_body` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to, which for an unversioned entity type is the same as the entity id',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext NOT NULL,
  `comment_body_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for comment field comment_body.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `collection` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'Primary Key: Config object collection.',
  `name` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'Primary Key: Config object name.',
  `data` longblob COMMENT 'A serialized configuration object data.',
  PRIMARY KEY (`collection`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for configuration data.';

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('', 'announcements_feed.settings', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0G5pZBcxbg8ONYzNLd1RJIsvuFFewm9htnS4I-ABKJ8";}s:7:"max_age";i:86400;s:13:"cron_interval";i:21600;s:5:"limit";i:10;}'),
('', 'automated_cron.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fUksROt4FfkAU9BV4hV2XvhTBSS2nTNrZS4U7S-tKrs";}s:8:"interval";i:10800;}'),
('', 'block.block.claro_breadcrumbs', 'a:13:{s:4:"uuid";s:36:"957b3ee4-22d1-45dd-9811-96dda860caf8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NjcxOBrPOiK5-38t56DwFBDVY4yer7YSlbRWXFuHe7A";}s:2:"id";s:17:"claro_breadcrumbs";s:5:"theme";s:5:"claro";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_content', 'a:13:{s:4:"uuid";s:36:"039b45d8-7159-4d5b-b919-669eb9515a94";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"a0Yyx1GeyKarZ4T_yXQBR_ZFKnXiFLtxAb6gWLd8nr0";}s:2:"id";s:13:"claro_content";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_help', 'a:13:{s:4:"uuid";s:36:"3d9762d2-6246-473d-b4ff-605dc30c81a0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jccFSSVqV0WCDb6NtML1VWAWTtDbZ-zn5YgTRMgMrIM";}s:2:"id";s:10:"claro_help";s:5:"theme";s:5:"claro";s:6:"region";s:4:"help";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"help";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_help_search', 'a:13:{s:4:"uuid";s:36:"db7069ab-ff58-4aa3-91da-1baf582a2132";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"module";a:2:{i:0;s:6:"search";i:1;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}s:8:"enforced";a:1:{s:6:"config";a:1:{i:0;s:23:"search.page.help_search";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2ToeZLvlHKTeFY74gpgu1PejLoFyCECLO_gw6rAZwqw";}s:2:"id";s:17:"claro_help_search";s:5:"theme";s:5:"claro";s:6:"region";s:4:"help";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:11:"Search help";s:13:"label_display";s:7:"visible";s:8:"provider";s:6:"search";s:7:"page_id";s:11:"help_search";}s:10:"visibility";a:1:{s:12:"request_path";a:4:{s:2:"id";s:12:"request_path";s:6:"negate";b:0;s:15:"context_mapping";a:0:{}s:5:"pages";s:11:"/admin/help";}}}'),
('', 'block.block.claro_local_actions', 'a:13:{s:4:"uuid";s:36:"b1fa4822-928d-44be-b7aa-f15f4ec918f8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CdXfDmRgAvms7EQovxxWPdYi0GitxeRbVtScYK16ZH0";}s:2:"id";s:19:"claro_local_actions";s:5:"theme";s:5:"claro";s:6:"region";s:7:"content";s:6:"weight";i:-10;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_messages', 'a:13:{s:4:"uuid";s:36:"a6d0b1c5-2a18-4957-b129-00e6705d21ac";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-Ac3ISpIT0PQ-whzD7_dw0SdKi6dAbRFNWdSjOiVDqg";}s:2:"id";s:14:"claro_messages";s:5:"theme";s:5:"claro";s:6:"region";s:11:"highlighted";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_page_title', 'a:13:{s:4:"uuid";s:36:"4e44dc37-b872-4807-8919-979f13a5b4a9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fNwDdW063tk_ktzSWzZVeQS9wzvLooVO280BQ9WrsIs";}s:2:"id";s:16:"claro_page_title";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:-30;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_primary_local_tasks', 'a:13:{s:4:"uuid";s:36:"25bfbe62-b4f0-42f4-8210-a49ada240e5c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ACjBZI5shAMiiUpsz-inLYVXDqNNXRnSzAWV3kV_8Hw";}s:2:"id";s:25:"claro_primary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}'),
('', 'block.block.claro_secondary_local_tasks', 'a:13:{s:4:"uuid";s:36:"4961daf1-1b60-4bad-8cee-ba97f8b32365";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"claro";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2L0geP-ixCbCkEpW6BVF6H7vDUZN4ea07_Y9CociQm4";}s:2:"id";s:27:"claro_secondary_local_tasks";s:5:"theme";s:5:"claro";s:6:"region";s:11:"pre_content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_account_menu', 'a:13:{s:4:"uuid";s:36:"7c904b36-4624-43fc-8b43-3ec638277c0d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:19:"system.menu.account";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gmxYWWHmgbe0Pnv8y48ZLSLH5mEHejOjAP6RLxUfdzU";}s:2:"id";s:20:"olivero_account_menu";s:5:"theme";s:7:"olivero";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:25:"system_menu_block:account";s:8:"settings";a:7:{s:2:"id";s:25:"system_menu_block:account";s:5:"label";s:17:"User account menu";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:1;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_breadcrumbs', 'a:13:{s:4:"uuid";s:36:"076ff6ea-c044-4dc6-81fb-88dad627e818";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VhBzWb7lMRtIOg9G7VSw_0uopi-7zXeHq4vXqqV1HFE";}s:2:"id";s:19:"olivero_breadcrumbs";s:5:"theme";s:7:"olivero";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_content', 'a:13:{s:4:"uuid";s:36:"6563a256-cb0d-4de5-9c6f-468e53e2f956";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"erQSEZF2XUjNmgTl0uNRBzmg18ZGXwUcw2FhApoeuHk";}s:2:"id";s:15:"olivero_content";s:5:"theme";s:7:"olivero";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_help', 'a:13:{s:4:"uuid";s:36:"631f6613-7fba-4fe7-98ac-1279a781dcd1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VfPFqqxfkomud5CO8DUijw85QIl9GIxh_nIxLOYESxg";}s:2:"id";s:12:"olivero_help";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"content_above";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"help";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_main_menu', 'a:13:{s:4:"uuid";s:36:"f56e2555-789d-4358-83d0-921637c8b5d7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KWAiziL39uEzmOJEql_wbUP2RtqGceL3WM2CfxhMelE";}s:2:"id";s:17:"olivero_main_menu";s:5:"theme";s:7:"olivero";s:6:"region";s:12:"primary_menu";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:22:"system_menu_block:main";s:8:"settings";a:7:{s:2:"id";s:22:"system_menu_block:main";s:5:"label";s:15:"Main navigation";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:5:"level";i:1;s:5:"depth";i:2;s:16:"expand_all_items";b:1;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_messages', 'a:13:{s:4:"uuid";s:36:"1aa66bf1-43d8-4947-a1cd-0f1c9e0674a0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BZ5tpW7H8X4PVGRm3MImTIHd2tN0eF7zOtp4SpRYUA0";}s:2:"id";s:16:"olivero_messages";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_page_title', 'a:13:{s:4:"uuid";s:36:"f520c3bc-dbce-4292-8fcd-cd63744cd792";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6aOgWsNTXjqrDm98TXSAjP6qd2nCijD1xw45MrnbK-Y";}s:2:"id";s:18:"olivero_page_title";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"content_above";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_powered', 'a:13:{s:4:"uuid";s:36:"7e3cc22b-9d21-4f96-b434-c1b491ae83a7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eYL19CLDyinGTWYQfBD1DswWzglEotE_kHnHx3AxTXM";}s:2:"id";s:15:"olivero_powered";s:5:"theme";s:7:"olivero";s:6:"region";s:13:"footer_bottom";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_powered_by_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_powered_by_block";s:5:"label";s:17:"Powered by Drupal";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_primary_admin_actions', 'a:13:{s:4:"uuid";s:36:"2c5ef16c-8223-4cdd-ae2a-880434b6fe8b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q9_2whdOj1YIomfvsIfopROW4FT_X5pY0DjdOiOaQ5U";}s:2:"id";s:29:"olivero_primary_admin_actions";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_primary_local_tasks', 'a:13:{s:4:"uuid";s:36:"1a5ad090-d53b-45e0-9456-c52b610fdbdc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nGE3EoPQQaQCuqTUtZgw0-KIzmrqdKDzdNQf2JyPUt4";}s:2:"id";s:27:"olivero_primary_local_tasks";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_search_form_narrow', 'a:13:{s:4:"uuid";s:36:"99cfe3c7-2b85-470d-8446-9ad8838efa52";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"_nZjxxdypO6xrOAJkCYD81v0L7wh2zbCAVO7_C-UKIc";}s:2:"id";s:26:"olivero_search_form_narrow";s:5:"theme";s:7:"olivero";s:6:"region";s:12:"primary_menu";s:6:"weight";i:-4;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:20:"Search form (narrow)";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"search";s:7:"page_id";N;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_search_form_wide', 'a:13:{s:4:"uuid";s:36:"4fa28caa-a20a-444d-aea3-d9d35d689ede";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"pbbed0hdqGDF-_QWVVTWRAwgDIotFuAvWH5mWUZu0fA";}s:2:"id";s:24:"olivero_search_form_wide";s:5:"theme";s:7:"olivero";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:-5;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:18:"Search form (wide)";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"search";s:7:"page_id";N;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_secondary_local_tasks', 'a:13:{s:4:"uuid";s:36:"5d42de84-933b-477f-9028-d23c8f3e7586";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ydSxdq7R66I8UMC460rOzlfzvlUL4VRbdwc6z9DWaUI";}s:2:"id";s:29:"olivero_secondary_local_tasks";s:5:"theme";s:7:"olivero";s:6:"region";s:11:"highlighted";s:6:"weight";i:-2;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:13:"label_display";s:1:"0";s:8:"provider";s:4:"core";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}'),
('', 'block.block.olivero_site_branding', 'a:13:{s:4:"uuid";s:36:"a7b01d17-9530-46f6-8aff-0c9677d26b9a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:7:"olivero";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-OAAZDw1OR_UyAEPEKX0Hu4LaZD149vW9PmMnIC-v0o";}s:2:"id";s:21:"olivero_site_branding";s:5:"theme";s:7:"olivero";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_branding_block";s:8:"settings";a:7:{s:2:"id";s:21:"system_branding_block";s:5:"label";s:13:"Site branding";s:13:"label_display";s:1:"0";s:8:"provider";s:6:"system";s:13:"use_site_logo";b:1;s:13:"use_site_name";b:1;s:15:"use_site_slogan";b:1;}s:10:"visibility";a:0:{}}'),
('', 'block_content.type.basic', 'a:9:{s:4:"uuid";s:36:"c0b47f08-3da8-4dd0-911b-d20a2fe9e8a8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"pQP5iQy4SdhAMVcjDUncCfkJmTofnHVtXrsMzx4k6Yk";}s:2:"id";s:5:"basic";s:5:"label";s:11:"Basic block";s:8:"revision";b:0;s:11:"description";s:42:"A basic block contains a title and a body.";}'),
('', 'claro.settings', 'a:1:{s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}}'),
('', 'comment.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YNUW2Ij5uE7a4oaXp3i_2lvaFdYM1zNKPPfnEjB0jEc";}s:16:"log_ip_addresses";b:0;}'),
('', 'comment.type.comment', 'a:9:{s:4:"uuid";s:36:"d01ae017-105e-4a2a-860e-6bd834393d3d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"bqZsN31T2n0UjcbyCpOPi9D2iO0sAOHR7FnEs9qMvaA";}s:2:"id";s:7:"comment";s:5:"label";s:16:"Default comments";s:21:"target_entity_type_id";s:4:"node";s:11:"description";s:28:"Allows commenting on content";}'),
('', 'core.base_field_override.node.article.promote', 'a:17:{s:4:"uuid";s:36:"e9aa9d0f-2442-484d-a01c-083d6217aeeb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:17:"node.type.article";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RDuP1jcZGVZtdt1bNaMJ-KSp72XRKpYXwIK4_kOq6K8";}s:2:"id";s:20:"node.article.promote";s:10:"field_name";s:7:"promote";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:22:"Promoted to front page";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:1;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:8:"on_label";s:2:"On";s:9:"off_label";s:3:"Off";}s:10:"field_type";s:7:"boolean";}'),
('', 'core.date_format.fallback', 'a:9:{s:4:"uuid";s:36:"fcecd840-ecfa-466c-904b-307ab45b1090";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"iIBLu1j9n6Oo5PW-wpu5gdyNs9Kvv4LMRqtQUdJjRz8";}s:2:"id";s:8:"fallback";s:5:"label";s:20:"Fallback date format";s:6:"locked";b:1;s:7:"pattern";s:14:"D, j M Y - H:i";}'),
('', 'core.date_format.html_date', 'a:9:{s:4:"uuid";s:36:"49286c40-1916-406e-9773-ed6da4a5b7ee";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EOQltUQPmgc6UQ2rcJ4Xi_leCEJj5ui0TR-12duS-Tk";}s:2:"id";s:9:"html_date";s:5:"label";s:9:"HTML Date";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-m-d";}'),
('', 'core.date_format.html_datetime', 'a:9:{s:4:"uuid";s:36:"f55a3b0a-81cd-43b4-907b-dbdfb37b086a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jxfClwZIRXIdcvMrE--WkcZxDGUVoOIE3Sm2NRZlFuE";}s:2:"id";s:13:"html_datetime";s:5:"label";s:13:"HTML Datetime";s:6:"locked";b:1;s:7:"pattern";s:13:"Y-m-d\\TH:i:sO";}'),
('', 'core.date_format.html_month', 'a:9:{s:4:"uuid";s:36:"61a12bbb-ee36-4f4d-9499-1d243cf00f95";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Z7KuCUwM_WdTNvLcoltuX3_8d-s-8FZkTN6KgNwF0eM";}s:2:"id";s:10:"html_month";s:5:"label";s:10:"HTML Month";s:6:"locked";b:1;s:7:"pattern";s:3:"Y-m";}'),
('', 'core.date_format.html_time', 'a:9:{s:4:"uuid";s:36:"bf842bc5-5850-46fe-aadc-37445acb3836";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M7yqicYkU36hRy5p9drAaGBBihhUD1OyujFrAaQ93ZE";}s:2:"id";s:9:"html_time";s:5:"label";s:9:"HTML Time";s:6:"locked";b:1;s:7:"pattern";s:5:"H:i:s";}'),
('', 'core.date_format.html_week', 'a:9:{s:4:"uuid";s:36:"4f97b2bd-3072-4d6c-b54d-b651d2d62736";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wKD4WsoV_wFgv2vgI4mcAAFSIzrye17ykzdwrnApkfY";}s:2:"id";s:9:"html_week";s:5:"label";s:9:"HTML Week";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-\\WW";}'),
('', 'core.date_format.html_year', 'a:9:{s:4:"uuid";s:36:"e08502e2-f029-4b5f-b8fa-83c2e3d51599";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OjekiQuX9RbVQ2_8jOHBL94RgYLePqX7wpfNGgcQzrk";}s:2:"id";s:9:"html_year";s:5:"label";s:9:"HTML Year";s:6:"locked";b:1;s:7:"pattern";s:1:"Y";}'),
('', 'core.date_format.html_yearless_date', 'a:9:{s:4:"uuid";s:36:"5208561a-cfd2-4765-a458-2c6b9e38242f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5VpawMrKPEPCkoO4YpPa0TDFO2dgiIHfTziJtwlmUxc";}s:2:"id";s:18:"html_yearless_date";s:5:"label";s:18:"HTML Yearless date";s:6:"locked";b:1;s:7:"pattern";s:3:"m-d";}'),
('', 'core.date_format.long', 'a:9:{s:4:"uuid";s:36:"2cc9688f-693a-4a19-8598-fba4c3bd3373";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5B4_r5Vd0_9UaJwtAC5yFCm9-k8NNvp1xiQNhFFkknU";}s:2:"id";s:4:"long";s:5:"label";s:17:"Default long date";s:6:"locked";b:0;s:7:"pattern";s:14:"l, j F Y - H:i";}'),
('', 'core.date_format.medium', 'a:9:{s:4:"uuid";s:36:"f1efcf24-d048-4b22-a883-a8642bd10374";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"q7pDV2d9qFh1IVqvymOxUUYGSziZDeg961wURC0cSLs";}s:2:"id";s:6:"medium";s:5:"label";s:19:"Default medium date";s:6:"locked";b:0;s:7:"pattern";s:14:"D, j M Y - H:i";}'),
('', 'core.date_format.olivero_medium', 'a:9:{s:4:"uuid";s:36:"886d2262-34c9-4664-b126-7d10809ee1c2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:8:"enforced";a:1:{s:5:"theme";a:1:{i:0;s:7:"olivero";}}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z7ynTCss9wwEi8ojENJ08qx44RN6leI-tqoN2o5QzdE";}s:2:"id";s:14:"olivero_medium";s:5:"label";s:14:"Olivero Medium";s:6:"locked";b:0;s:7:"pattern";s:5:"j F Y";}'),
('', 'core.date_format.short', 'a:9:{s:4:"uuid";s:36:"850d4f0b-b5e7-40e4-84a9-2664fe3d7bc3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SAeixlV7Djy_Ggv_1P95TiqD4KUihA5icvU521tA84Y";}s:2:"id";s:5:"short";s:5:"label";s:18:"Default short date";s:6:"locked";b:0;s:7:"pattern";s:11:"j M Y - H:i";}'),
('', 'core.entity_form_display.block_content.basic.default', 'a:11:{s:4:"uuid";s:36:"0db9303f-8a7e-4a2d-9802-371f2aa02617";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jAps3FCxvKecABS_tgExbhCZrBLQB3bNPWw18WjE3ss";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:4:"info";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_form_display.comment.comment.default', 'a:11:{s:4:"uuid";s:36:"2ffd3fb9-98b8-4e74-97ec-afc924942d1d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"I0Pa0aQvT_jawlPo9oz4FE3h_ickc55dYKTPl6gILes";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:3:{s:6:"author";a:2:{s:6:"weight";i:-2;s:6:"region";s:7:"content";}s:12:"comment_body";a:5:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:11;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:7:"subject";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_form_display.node.article.default', 'a:11:{s:4:"uuid";s:36:"389bad0b-dd7d-494a-ac23-47a496652bb8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:29:"field.field.node.article.body";i:1;s:32:"field.field.node.article.comment";i:2;s:36:"field.field.node.article.field_image";i:3;s:35:"field.field.node.article.field_tags";i:4;s:21:"image.style.thumbnail";i:5;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"path";i:3;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ewbd6G2uX456-bgwseM2Q-KQG3RkASoyHmTh-XR3oLU";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:11:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:2;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"comment";a:5:{s:4:"type";s:15:"comment_default";s:6:"weight";i:20;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:11:"field_image";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}s:10:"field_tags";a:5:{s:4:"type";s:34:"entity_reference_autocomplete_tags";s:6:"weight";i:3;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:15;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:16;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_form_display.node.page.default', 'a:11:{s:4:"uuid";s:36:"eb0e9eb2-793c-489d-a546-f6f864d17d45";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"path";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"MzSYzZbqqlwSM8mtLwEdCerBZRNGvHZntu5u_Gao8LY";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:6:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:31;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:6:"weight";i:120;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:2:{s:7:"promote";b:1;s:6:"sticky";b:1;}}'),
('', 'core.entity_form_display.user.user.default', 'a:11:{s:4:"uuid";s:36:"dcb8569c-55af-4b2b-8d68-dacd30b45e02";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Yj33guGRXeB-uq182k6bwtAUtKGpO17nkYxn8FnjhBM";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:4:{s:7:"account";a:2:{s:6:"weight";i:-10;s:6:"region";s:7:"content";}s:8:"language";a:2:{s:6:"weight";i:0;s:6:"region";s:7:"content";}s:8:"timezone";a:2:{s:6:"weight";i:6;s:6:"region";s:7:"content";}s:12:"user_picture";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_form_mode.user.register', 'a:10:{s:4:"uuid";s:36:"2e662d14-cd40-41d9-9fe8-2f35a346f1f0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1TFiplNN7Wmj_DtVLLLP-NLPYpZJdAswKY-vTrYgFyo";}s:2:"id";s:13:"user.register";s:5:"label";s:8:"Register";s:11:"description";N;s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}'),
('', 'core.entity_view_display.block_content.basic.default', 'a:11:{s:4:"uuid";s:36:"a44b58b1-3a16-458b-8812-8d1849341b86";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hBNNDTFwakREOTa6GGMqN899Iyrii0hInwSJtQ7Kj30";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_view_display.comment.comment.default', 'a:11:{s:4:"uuid";s:36:"e67c1834-989b-46d4-af84-d434954ce5aa";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"aBQUGsQ46M4048fIlFuTXwl2zV0j2cJX89CTUobh9hA";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:12:"comment_body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_view_display.node.article.default', 'a:11:{s:4:"uuid";s:36:"7084985d-0c48-43e4-a7ca-47477fa0015c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:48:"core.entity_view_display.comment.comment.default";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:16:"image.style.wide";i:6;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"text";i:3;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"br6izr-iGEu--JvNbCJNtOBpRnxpFLXfoV5y61U9Nqc";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:7:"comment";a:6:{s:4:"type";s:15:"comment_default";s:5:"label";s:5:"above";s:8:"settings";a:2:{s:9:"view_mode";s:7:"default";s:8:"pager_id";i:0;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:110;s:6:"region";s:7:"content";}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:10:"image_link";s:0:"";s:11:"image_style";s:4:"wide";s:13:"image_loading";a:1:{s:9:"attribute";s:5:"eager";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-1;s:6:"region";s:7:"content";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:10;s:6:"region";s:7:"content";}s:5:"links";a:4:{s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_view_display.node.article.rss', 'a:11:{s:4:"uuid";s:36:"6d8d2384-7f8c-4c9e-bcf0-be33f2eed3ad";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2rIr6K5Q0UQ9khg0zE_CK-PtJH76UL-BDDZcZnZzwCc";}s:2:"id";s:16:"node.article.rss";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:3:"rss";s:7:"content";a:1:{s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:4:"body";b:1;s:7:"comment";b:1;s:11:"field_image";b:1;s:10:"field_tags";b:1;}}'),
('', 'core.entity_view_display.node.article.teaser', 'a:11:{s:4:"uuid";s:36:"08c6677d-24a3-42c0-bbad-7ddd3d4312ea";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:18:"image.style.medium";i:6;s:17:"node.type.article";}s:6:"module";a:3:{i:0;s:5:"image";i:1;s:4:"text";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"O8PxzfG8DOHHRu6M23kwR6TDPq_MNfYQ10Mp367ICUQ";}s:2:"id";s:19:"node.article.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:6:"teaser";s:7:"content";a:4:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:10:"image_link";s:7:"content";s:11:"image_style";s:6:"medium";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-1;s:6:"region";s:7:"content";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:10;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:7:"comment";b:1;}}'),
('', 'core.entity_view_display.node.page.default', 'a:11:{s:4:"uuid";s:36:"79cad384-2fe0-4ac9-87e5-c85417837561";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Y8L5tfmhx7DR143E05YyZSpvgil6VFvqcfBWykalg";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:5:"label";s:6:"hidden";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_view_display.node.page.teaser', 'a:11:{s:4:"uuid";s:36:"9e5ac929-589b-4354-baa5-472db76cbff8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:26:"field.field.node.page.body";i:2;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8BgdRtLbtQ0F__o0FHSH0Mx5fvXOra9tfT1GmNKbRYw";}s:2:"id";s:16:"node.page.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:6:"teaser";s:7:"content";a:2:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:5:"label";s:6:"hidden";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:6:"weight";i:100;s:6:"region";s:7:"content";}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_view_display.user.user.compact', 'a:11:{s:4:"uuid";s:36:"49e9fcc5-c6e0-42eb-b6d1-c27c4d48edb8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:34:"core.entity_view_mode.user.compact";i:1;s:34:"field.field.user.user.user_picture";i:2;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"00zr_RBdTjPjBGITD3h4c1ESQZimjdVCcHGt1trLqIY";}s:2:"id";s:17:"user.user.compact";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"compact";s:7:"content";a:1:{s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:7:"content";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:1:{s:10:"member_for";b:1;}}'),
('', 'core.entity_view_display.user.user.default', 'a:11:{s:4:"uuid";s:36:"61dd8385-d13d-4143-ac08-a482edd18c64";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mZLyuWM9CQx2ZJVqFGSbzgFnHzudVbHBYmdU256A5Wk";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:10:"member_for";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:5:"label";s:6:"hidden";s:8:"settings";a:3:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:7:"content";s:13:"image_loading";a:1:{s:9:"attribute";s:4:"lazy";}}s:20:"third_party_settings";a:0:{}s:6:"weight";i:0;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),
('', 'core.entity_view_mode.block_content.full', 'a:10:{s:4:"uuid";s:36:"9712ea61-4524-4a11-9646-6939cc07f6ee";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:13:"block_content";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q7yUUYeRLByl-MCGveKKF_KhAtNICLCMJuKWfugCvso";}s:2:"id";s:18:"block_content.full";s:5:"label";s:4:"Full";s:11:"description";s:0:"";s:16:"targetEntityType";s:13:"block_content";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.comment.full', 'a:10:{s:4:"uuid";s:36:"3777ff69-eb99-42b6-862a-311761752fb3";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N4mUjXpPckUkVRY1PbKw4GGoL1i2ECU7PL3EreiKStk";}s:2:"id";s:12:"comment.full";s:5:"label";s:12:"Full comment";s:11:"description";s:0:"";s:16:"targetEntityType";s:7:"comment";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.full', 'a:10:{s:4:"uuid";s:36:"ac828f09-37a7-490e-90b7-c0a2c264e404";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QJ2aZ1xfVf59aq6Pz5X7fyUOa2HxuCoTwQ_RQjoulAU";}s:2:"id";s:9:"node.full";s:5:"label";s:12:"Full content";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.rss', 'a:10:{s:4:"uuid";s:36:"3ea8bfc7-bcb6-49bb-9a77-dbbbec98cce4";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"l8fiAFE3Kng_6bhLlUDnVTkTDzXWxzYFrCWTrngVXEA";}s:2:"id";s:8:"node.rss";s:5:"label";s:3:"RSS";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.search_index', 'a:10:{s:4:"uuid";s:36:"19281bfd-4c0b-4b1c-bac6-d76b3920a0fe";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"r_A0T3aTqGDwLyvoH7wLps-0PM--RHlS8UsiJe_Ac64";}s:2:"id";s:17:"node.search_index";s:5:"label";s:12:"Search index";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.search_result', 'a:10:{s:4:"uuid";s:36:"3163d64b-fe58-4295-ba61-2c31d8439e8c";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"d8wBEm7XvJ6H3S0IneDD9PfTBklPIH7GMpxElVemPf8";}s:2:"id";s:18:"node.search_result";s:5:"label";s:32:"Search result highlighting input";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.node.teaser', 'a:10:{s:4:"uuid";s:36:"30e9d73b-013d-4148-8815-44e2d0f7a832";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KgGJDZFpMaz_8bTv6fN1bXS3Qi5LWmRJI9R53kEGsNQ";}s:2:"id";s:11:"node.teaser";s:5:"label";s:6:"Teaser";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.taxonomy_term.full', 'a:10:{s:4:"uuid";s:36:"5c8ef4a5-8137-46f7-96a4-2405b537d3e1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"iukUENpf8CFvjZbGGacKX_Ges0-lU9z6zvsd32P6kbo";}s:2:"id";s:18:"taxonomy_term.full";s:5:"label";s:18:"Taxonomy term page";s:11:"description";s:0:"";s:16:"targetEntityType";s:13:"taxonomy_term";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.user.compact', 'a:10:{s:4:"uuid";s:36:"7cf0b28a-b08f-48c9-a203-8fd2bcd37b48";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TtD7OuGskOsQfoGyxXkrdtllBpR37J19d5BMQDZWJgA";}s:2:"id";s:12:"user.compact";s:5:"label";s:7:"Compact";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}'),
('', 'core.entity_view_mode.user.full', 'a:10:{s:4:"uuid";s:36:"a7f72fa1-6515-4213-9b2d-60e79c402274";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZbXunWS_xAvMZXFfinyvClDAb_RCVLt7gAzE3v16E-Q";}s:2:"id";s:9:"user.full";s:5:"label";s:12:"User account";s:11:"description";s:0:"";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}'),
('', 'core.extension', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4GIX5Esnc_umpXUBj4IIocRX7Mt5fPhm4AgXfE3E56E";}s:6:"module";a:41:{s:18:"announcements_feed";i:0;s:14:"automated_cron";i:0;s:8:"big_pipe";i:0;s:5:"block";i:0;s:13:"block_content";i:0;s:10:"breakpoint";i:0;s:9:"ckeditor5";i:0;s:7:"comment";i:0;s:6:"config";i:0;s:10:"contextual";i:0;s:8:"datetime";i:0;s:5:"dblog";i:0;s:18:"dynamic_page_cache";i:0;s:6:"editor";i:0;s:5:"field";i:0;s:8:"field_ui";i:0;s:4:"file";i:0;s:6:"filter";i:0;s:4:"help";i:0;s:7:"history";i:0;s:5:"image";i:0;s:4:"link";i:0;s:17:"menu_link_content";i:0;s:7:"menu_ui";i:0;s:5:"mysql";i:0;s:4:"node";i:0;s:7:"options";i:0;s:10:"page_cache";i:0;s:4:"path";i:0;s:10:"path_alias";i:0;s:6:"search";i:0;s:8:"shortcut";i:0;s:6:"system";i:0;s:8:"taxonomy";i:0;s:4:"text";i:0;s:7:"toolbar";i:0;s:6:"update";i:0;s:4:"user";i:0;s:8:"views_ui";i:0;s:5:"views";i:10;s:8:"standard";i:1000;}s:5:"theme";a:2:{s:7:"olivero";i:0;s:5:"claro";i:0;}s:7:"profile";s:8:"standard";}'),
('', 'core.menu.static_menu_link_overrides', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jdY7AU0tU-QsjmiOw3W8vwpYMb-By--_MSFgbqKUTYM";}s:11:"definitions";a:0:{}}'),
('', 'dblog.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"e883aGsrt1wFrsydlYU584PZONCSfRy0DtkZ9KzHb58";}s:9:"row_limit";i:1000;}'),
('', 'editor.editor.basic_html', 'a:9:{s:4:"uuid";s:36:"5b1d662d-f47c-4c13-81b7-2d78ff1f01b4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"filter.format.basic_html";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JrKgrmvARpUBMILom2cUF4pz3mwrBnCYSlHjGwsKZ64";}s:6:"format";s:10:"basic_html";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:15:{i:0;s:4:"bold";i:1;s:6:"italic";i:2;s:1:"|";i:3;s:4:"link";i:4;s:1:"|";i:5;s:12:"bulletedList";i:6;s:12:"numberedList";i:7;s:1:"|";i:8;s:10:"blockQuote";i:9;s:17:"drupalInsertImage";i:10;s:1:"|";i:11;s:7:"heading";i:12;s:4:"code";i:13;s:1:"|";i:14;s:13:"sourceEditing";}}s:7:"plugins";a:4:{s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:21:"ckeditor5_imageResize";a:1:{s:12:"allow_resize";b:1;}s:14:"ckeditor5_list";a:2:{s:10:"properties";a:3:{s:8:"reversed";b:0;s:10:"startIndex";b:1;s:6:"styles";b:1;}s:10:"multiBlock";b:1;}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:11:{i:0;s:6:"<cite>";i:1;s:4:"<dl>";i:2;s:4:"<dt>";i:3;s:4:"<dd>";i:4;s:12:"<a hreflang>";i:5;s:17:"<blockquote cite>";i:6;s:7:"<h2 id>";i:7;s:7:"<h3 id>";i:8;s:7:"<h4 id>";i:9;s:7:"<h5 id>";i:10;s:7:"<h6 id>";}}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";N;s:14:"max_dimensions";a:2:{s:5:"width";N;s:6:"height";N;}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'editor.editor.full_html', 'a:9:{s:4:"uuid";s:36:"883c06ee-0d97-4555-a289-ad537a55ec3e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"filter.format.full_html";}s:6:"module";a:1:{i:0;s:9:"ckeditor5";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4mmJmN8kEiUf9aytnx0QPOORBNL5JaF_ijXRwOm2stg";}s:6:"format";s:9:"full_html";s:6:"editor";s:9:"ckeditor5";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:5:"items";a:21:{i:0;s:4:"bold";i:1;s:6:"italic";i:2;s:13:"strikethrough";i:3;s:11:"superscript";i:4;s:9:"subscript";i:5;s:12:"removeFormat";i:6;s:1:"|";i:7;s:4:"link";i:8;s:1:"|";i:9;s:12:"bulletedList";i:10;s:12:"numberedList";i:11;s:1:"|";i:12;s:10:"blockQuote";i:13;s:17:"drupalInsertImage";i:14;s:11:"insertTable";i:15;s:14:"horizontalLine";i:16;s:1:"|";i:17;s:7:"heading";i:18;s:9:"codeBlock";i:19;s:1:"|";i:20;s:13:"sourceEditing";}}s:7:"plugins";a:5:{s:19:"ckeditor5_codeBlock";a:1:{s:9:"languages";a:14:{i:0;a:2:{s:5:"label";s:10:"Plain text";s:8:"language";s:9:"plaintext";}i:1;a:2:{s:5:"label";s:1:"C";s:8:"language";s:1:"c";}i:2;a:2:{s:5:"label";s:2:"C#";s:8:"language";s:2:"cs";}i:3;a:2:{s:5:"label";s:3:"C++";s:8:"language";s:3:"cpp";}i:4;a:2:{s:5:"label";s:3:"CSS";s:8:"language";s:3:"css";}i:5;a:2:{s:5:"label";s:4:"Diff";s:8:"language";s:4:"diff";}i:6;a:2:{s:5:"label";s:4:"HTML";s:8:"language";s:4:"html";}i:7;a:2:{s:5:"label";s:4:"Java";s:8:"language";s:4:"java";}i:8;a:2:{s:5:"label";s:10:"JavaScript";s:8:"language";s:10:"javascript";}i:9;a:2:{s:5:"label";s:3:"PHP";s:8:"language";s:3:"php";}i:10;a:2:{s:5:"label";s:6:"Python";s:8:"language";s:6:"python";}i:11;a:2:{s:5:"label";s:4:"Ruby";s:8:"language";s:4:"ruby";}i:12;a:2:{s:5:"label";s:10:"TypeScript";s:8:"language";s:10:"typescript";}i:13;a:2:{s:5:"label";s:3:"XML";s:8:"language";s:3:"xml";}}}s:17:"ckeditor5_heading";a:1:{s:16:"enabled_headings";a:5:{i:0;s:8:"heading2";i:1;s:8:"heading3";i:2;s:8:"heading4";i:3;s:8:"heading5";i:4;s:8:"heading6";}}s:21:"ckeditor5_imageResize";a:1:{s:12:"allow_resize";b:1;}s:14:"ckeditor5_list";a:2:{s:10:"properties";a:3:{s:8:"reversed";b:1;s:10:"startIndex";b:1;s:6:"styles";b:1;}s:10:"multiBlock";b:1;}s:23:"ckeditor5_sourceEditing";a:1:{s:12:"allowed_tags";a:0:{}}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";N;s:14:"max_dimensions";a:2:{s:5:"width";N;s:6:"height";N;}}}'),
('', 'field.field.block_content.basic.body', 'a:17:{s:4:"uuid";s:36:"a32fc862-d85e-4041-b7e4-56aa3f47ae4b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:32:"field.storage.block_content.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"j00Gfs9AFqwK4x9RIsISLbPO7vA12psPR4s60wOIwQo";}s:2:"id";s:24:"block_content.basic.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:6:"bundle";s:5:"basic";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:3:{s:15:"display_summary";b:0;s:16:"required_summary";b:0;s:15:"allowed_formats";a:0:{}}s:10:"field_type";s:17:"text_with_summary";}'),
('', 'field.field.comment.comment.comment_body', 'a:17:{s:4:"uuid";s:36:"0de65d6d-ae9c-409c-9a6d-c4e3c72828a5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:34:"field.storage.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"62rlTOx3sPVrYhBnSBHZStXwiO02v1UpHSMrhWDsuG8";}s:2:"id";s:28:"comment.comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:6:"bundle";s:7:"comment";s:5:"label";s:7:"Comment";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:1:{s:15:"allowed_formats";a:0:{}}s:10:"field_type";s:9:"text_long";}'),
('', 'field.field.node.article.body', 'a:17:{s:4:"uuid";s:36:"23b0dad8-62ee-48fd-8f69-5d5499e6ebe6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4Wxs1LseZ8JsNwD9uJVIbzZqG35yQXN8Eo1Hub6NMuI";}s:2:"id";s:17:"node.article.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:3:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;s:15:"allowed_formats";a:0:{}}s:10:"field_type";s:17:"text_with_summary";}'),
('', 'field.field.node.article.comment', 'a:17:{s:4:"uuid";s:36:"538aec69-54b4-4c20-b500-fd6f69b71fc4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.storage.node.comment";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UqXlkKC4v2-bDfWx4zcXQrD5YIi3d5byENEmWv-G_Uc";}s:2:"id";s:20:"node.article.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:8:"Comments";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:6:{s:6:"status";i:2;s:3:"cid";i:0;s:22:"last_comment_timestamp";i:0;s:17:"last_comment_name";N;s:16:"last_comment_uid";i:0;s:13:"comment_count";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:5:{s:12:"default_mode";i:1;s:8:"per_page";i:50;s:9:"anonymous";i:0;s:13:"form_location";b:1;s:7:"preview";i:1;}s:10:"field_type";s:7:"comment";}'),
('', 'field.field.node.article.field_image', 'a:17:{s:4:"uuid";s:36:"c7055c45-2e00-418a-b3c3-59214d19d1dc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"field.storage.node.field_image";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"j0riO_-77ZFWNLtj0iJ31HnohiNjdn8HUL86RueCF-M";}s:2:"id";s:24:"node.article.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:5:"Image";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:21:"png gif jpg jpeg webp";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:18:"alt_field_required";b:1;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}'),
('', 'field.field.node.article.field_tags', 'a:17:{s:4:"uuid";s:36:"57bf3544-0aed-4537-961f-ec8fbf43d56a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:29:"field.storage.node.field_tags";i:1;s:17:"node.type.article";i:2;s:24:"taxonomy.vocabulary.tags";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QdUgf_beeoaPiyKorFv0q1fcJpWH_uZTqe_xoVJacrw";}s:2:"id";s:23:"node.article.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Tags";s:11:"description";s:84:"Enter a comma-separated list. For example: Amsterdam, Mexico City, "Cleveland, Ohio"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:21:"default:taxonomy_term";s:16:"handler_settings";a:3:{s:14:"target_bundles";a:1:{s:4:"tags";s:4:"tags";}s:4:"sort";a:1:{s:5:"field";s:5:"_none";}s:11:"auto_create";b:1;}}s:10:"field_type";s:16:"entity_reference";}'),
('', 'field.field.node.page.body', 'a:17:{s:4:"uuid";s:36:"335cccdd-6d9b-4c99-99ee-a5a9d87d5428";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KHu9I-pR4FnP79crRJ5gVD_1mKGSZcJsdIm9bn64iFg";}s:2:"id";s:14:"node.page.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:3:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;s:15:"allowed_formats";a:0:{}}s:10:"field_type";s:17:"text_with_summary";}'),
('', 'field.field.user.user.user_picture', 'a:17:{s:4:"uuid";s:36:"989c1a7a-8afb-4e4c-9147-4f4c3aef2fc9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:31:"field.storage.user.user_picture";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TE3gYVzd6g0deXqUl8SEu2azHwVG-SdXm3kwbrz0kHw";}s:2:"id";s:22:"user.user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:6:"bundle";s:4:"user";s:5:"label";s:7:"Picture";s:11:"description";s:29:"Your virtual face or picture.";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}s:14:"file_directory";s:40:"pictures/[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:21:"png gif jpg jpeg webp";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:0;s:18:"alt_field_required";b:0;s:11:"title_field";b:0;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:10:"field_type";s:5:"image";}'),
('', 'field.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nJk0TAQBzlNo52ehiHI7bIEPLGi0BYqZvPdEn7Chfu0";}s:16:"purge_batch_size";i:50;}'),
('', 'field.storage.block_content.body', 'a:17:{s:4:"uuid";s:36:"d3f48260-50f5-499c-bf7e-61dc35431d97";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc";}s:2:"id";s:18:"block_content.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}'),
('', 'field.storage.comment.comment_body', 'a:17:{s:4:"uuid";s:36:"82226e61-a370-4e28-928c-9dfce10d7c0b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw";}s:2:"id";s:20:"comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:4:"type";s:9:"text_long";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}'),
('', 'field.storage.node.body', 'a:17:{s:4:"uuid";s:36:"a6ca6360-6e0c-4a92-a944-15bf37fde198";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY";}s:2:"id";s:9:"node.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}'),
('', 'field.storage.node.comment', 'a:17:{s:4:"uuid";s:36:"c7a22ee7-de36-4f0c-8c0c-7ccd115c015b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ktCna9xmWvYZIUfOCUyDQvedn5RtnS4CRmEIwNmvYjc";}s:2:"id";s:12:"node.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:4:"type";s:7:"comment";s:8:"settings";a:1:{s:12:"comment_type";s:7:"comment";}s:6:"module";s:7:"comment";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.node.field_image', 'a:17:{s:4:"uuid";s:36:"b52fd2fa-b3d1-45f4-8ac7-52a7e90a9fdc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EymokncRIZ7SgQT2IdOQhQJicX4nNc0K89ik-LxmOHE";}s:2:"id";s:16:"node.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.node.field_tags', 'a:17:{s:4:"uuid";s:36:"3c619f34-8241-489a-b3f6-7acb3af2e10b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs";}s:2:"id";s:15:"node.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field.storage.user.user_picture', 'a:17:{s:4:"uuid";s:36:"e5277c22-8a09-42ab-9808-dae455e3b895";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0q8-mw8y-Ls5I578sIPQFLp4ljpH7WvVYpzY-I9O-8E";}s:2:"id";s:17:"user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),
('', 'field_ui.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q1nMi90W6YQxKzZAgJQw7Ag9U4JrsEUwkomF0lhvbIM";}s:12:"field_prefix";s:6:"field_";}'),
('', 'file.settings', 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2bwjZB1IjEYbppgZT3g7YW_5h_LDZYNa3DaDEfWX82U";}s:11:"description";a:2:{s:4:"type";s:9:"textfield";s:6:"length";i:128;}s:4:"icon";a:1:{s:9:"directory";s:23:"core/modules/file/icons";}s:35:"make_unused_managed_files_temporary";b:0;s:21:"filename_sanitization";a:6:{s:13:"transliterate";b:0;s:18:"replace_whitespace";b:0;s:24:"replace_non_alphanumeric";b:0;s:22:"deduplicate_separators";b:0;s:9:"lowercase";b:0;s:21:"replacement_character";s:1:"-";}}'),
('', 'filter.format.basic_html', 'a:9:{s:4:"uuid";s:36:"f3dfa71d-702d-4d86-b5c7-5fce05633753";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mclCbTlJwWJORez4Y1eX2MqA0aGjSMAoJb3TaBABcK8";}s:4:"name";s:10:"Basic HTML";s:6:"format";s:10:"basic_html";s:6:"weight";i:0;s:7:"filters";a:6:{s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:7;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:243:"<br> <p> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id> <cite> <dl> <dt> <dd> <a hreflang href> <blockquote cite> <ul type> <ol start type> <strong> <em> <code> <li> <img src alt data-entity-uuid data-entity-type height width data-caption data-align>";s:16:"filter_html_help";b:0;s:20:"filter_html_nofollow";b:0;}}s:24:"filter_html_image_secure";a:5:{s:2:"id";s:24:"filter_html_image_secure";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:22:"filter_image_lazy_load";a:5:{s:2:"id";s:22:"filter_image_lazy_load";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:15;s:8:"settings";a:0:{}}}}'),
('', 'filter.format.full_html', 'a:9:{s:4:"uuid";s:36:"0943672d-ea16-4240-805f-0668ce7b6560";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vpZysv3RHJjhYzq7O_q5q8mVlHdrSzKELmXyiX6RtV0";}s:4:"name";s:9:"Full HTML";s:6:"format";s:9:"full_html";s:6:"weight";i:2;s:7:"filters";a:5:{s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:20:"filter_htmlcorrector";a:5:{s:2:"id";s:20:"filter_htmlcorrector";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:10;s:8:"settings";a:0:{}}s:22:"filter_image_lazy_load";a:5:{s:2:"id";s:22:"filter_image_lazy_load";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:15;s:8:"settings";a:0:{}}}}'),
('', 'filter.format.plain_text', 'a:9:{s:4:"uuid";s:36:"ebdb6db1-2c16-40e5-b7c7-f3069447e5d8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JLMwODO0epnA_H-jFlH9ezVfa5YBJniRv3MmLqYNl_Q";}s:4:"name";s:10:"Plain text";s:6:"format";s:10:"plain_text";s:6:"weight";i:10;s:7:"filters";a:3:{s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:18:"filter_html_escape";a:5:{s:2:"id";s:18:"filter_html_escape";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}}}'),
('', 'filter.format.restricted_html', 'a:9:{s:4:"uuid";s:36:"e6cb0308-805d-4b04-906d-69baad9d95fb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QiKqQS_YGAT3Qr4vaAgZICJknm-MGCzt_xBAMqg-tRM";}s:4:"name";s:15:"Restricted HTML";s:6:"format";s:15:"restricted_html";s:6:"weight";i:1;s:7:"filters";a:3:{s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:149:"<a href hreflang> <em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id>";s:16:"filter_html_help";b:1;s:20:"filter_html_nofollow";b:0;}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}}}'),
('', 'filter.settings', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FiPjM3WdB__ruFA7B6TLwni_UcZbmek5G4b2dxQItxA";}s:15:"fallback_format";s:10:"plain_text";s:27:"always_show_fallback_choice";b:0;}'),
('', 'image.settings', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k-yDFHbqNfpe-Srg4sdCSqaosCl2D8uwyEY5esF8gEw";}s:13:"preview_image";s:29:"core/modules/image/sample.png";s:26:"allow_insecure_derivatives";b:0;s:20:"suppress_itok_output";b:0;}'),
('', 'image.style.large', 'a:8:{s:4:"uuid";s:36:"35a14c3a-b96b-4a7c-bf5b-822709d002b6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yrvYt4IlFH9AKX1vx-_N6OfeG_6HgylGP7hhB9AMH3k";}s:4:"name";s:5:"large";s:5:"label";s:16:"Large (480×480)";s:7:"effects";a:2:{s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";a:4:{s:4:"uuid";s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:480;s:6:"height";i:480;s:7:"upscale";b:0;}}s:36:"6e8fe467-84c1-4ef0-a73b-7eccf1cc20e8";a:4:{s:4:"uuid";s:36:"6e8fe467-84c1-4ef0-a73b-7eccf1cc20e8";s:2:"id";s:18:"image_convert_avif";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.medium', 'a:8:{s:4:"uuid";s:36:"258cb9cd-abda-49c2-b59c-2c7fca89cc23";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"aUG-EM9kKTKhcsdttoYmG5tug7pU2mNOQzcpp91jfFQ";}s:4:"name";s:6:"medium";s:5:"label";s:17:"Medium (220×220)";s:7:"effects";a:2:{s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";a:4:{s:4:"uuid";s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:220;s:6:"height";i:220;s:7:"upscale";b:0;}}s:36:"c410ed2f-aa30-4d9c-a224-d2865d9188cd";a:4:{s:4:"uuid";s:36:"c410ed2f-aa30-4d9c-a224-d2865d9188cd";s:2:"id";s:18:"image_convert_avif";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.thumbnail', 'a:8:{s:4:"uuid";s:36:"e18b659f-c06b-471d-8897-2cb82292dc24";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JXYDC3SLZUXSwnTjR9rBo6uZF3vDSZd8S7EA5ZOH7kM";}s:4:"name";s:9:"thumbnail";s:5:"label";s:20:"Thumbnail (100×100)";s:7:"effects";a:2:{s:36:"1cfec298-8620-4749-b100-ccb6c4500779";a:4:{s:4:"uuid";s:36:"1cfec298-8620-4749-b100-ccb6c4500779";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:100;s:6:"height";i:100;s:7:"upscale";b:0;}}s:36:"c4eb9942-2c9e-4a81-949f-6161a44b6559";a:4:{s:4:"uuid";s:36:"c4eb9942-2c9e-4a81-949f-6161a44b6559";s:2:"id";s:18:"image_convert_avif";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'image.style.wide', 'a:8:{s:4:"uuid";s:36:"fccebbc5-bcb5-4c9c-b6f3-52f6db75ec89";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vbPSqe3wbFSkaEY0zGy3NVpofBxcTZYrT6N2YPQX7nI";}s:4:"name";s:4:"wide";s:5:"label";s:11:"Wide (1090)";s:7:"effects";a:2:{s:36:"09959c15-59ce-4f6d-90df-e2d7cf32bce5";a:4:{s:4:"uuid";s:36:"09959c15-59ce-4f6d-90df-e2d7cf32bce5";s:2:"id";s:11:"image_scale";s:6:"weight";i:1;s:4:"data";a:3:{s:5:"width";i:1090;s:6:"height";N;s:7:"upscale";b:0;}}s:36:"294c5f76-42a4-43ce-82c2-81c2f4723da0";a:4:{s:4:"uuid";s:36:"294c5f76-42a4-43ce-82c2-81c2f4723da0";s:2:"id";s:18:"image_convert_avif";s:6:"weight";i:2;s:4:"data";a:1:{s:9:"extension";s:4:"webp";}}}}'),
('', 'menu_ui.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SqMarzIjxC3F8dZo9FEOxfqDKD_sdW1tbcFTV1BA2zU";}s:24:"override_parent_selector";b:0;}'),
('', 'node.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"W0cgFPhPJ3gAdqm06-az48BLf5MVcoZVS0HdByoofi0";}s:15:"use_admin_theme";b:1;}'),
('', 'node.type.article', 'a:12:{s:4:"uuid";s:36:"6b3743ec-a515-4a8f-a20d-73cfbc86c43d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Fe3N1uqaAyyKJbVkqT-btXy3t98puW8GCRD822xjl10";}s:4:"name";s:7:"Article";s:4:"type";s:7:"article";s:11:"description";s:89:"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.";s:4:"help";N;s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:1;}'),
('', 'node.type.page', 'a:12:{s:4:"uuid";s:36:"c27c63a0-6743-411d-b890-26b6953f746d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"i0snV8Wj--OkRW12UdachUiYiz3FbeMwHu_pZYfzKLc";}s:4:"name";s:10:"Basic page";s:4:"type";s:4:"page";s:11:"description";s:77:"Use <em>basic pages</em> for your static content, such as an ''About us'' page.";s:4:"help";N;s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:0;}'),
('', 'olivero.settings', 'a:8:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1TswGK46jyu77aIM7Z-0JVQs5bxHmo-gtgrvrQGMXxc";}s:7:"favicon";a:1:{s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:0;}s:4:"logo";a:1:{s:11:"use_default";b:0;}s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}s:22:"mobile_menu_all_widths";i:0;s:22:"site_branding_bg_color";s:7:"default";s:18:"base_primary_color";s:7:"#1b9ae4";}'),
('', 'search.page.help_search', 'a:11:{s:4:"uuid";s:36:"de7580a4-9320-47be-abdc-c717dcb874f7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"help";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RZ-bcSekNSsAbIPLW7Gmyd3uUjIOSrPvnb8RCCZYJm8";}s:2:"id";s:11:"help_search";s:5:"label";s:4:"Help";s:4:"path";s:4:"help";s:6:"weight";i:0;s:6:"plugin";s:11:"help_search";s:13:"configuration";a:0:{}}'),
('', 'search.page.node_search', 'a:11:{s:4:"uuid";s:36:"4daf9186-72d5-4b07-98d6-9e64ab8e7443";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"97tvtzGOa8_flb22CzSjgtm_YkiGMHvEBO-6q2K9V_U";}s:2:"id";s:11:"node_search";s:5:"label";s:7:"Content";s:4:"path";s:4:"node";s:6:"weight";i:-10;s:6:"plugin";s:11:"node_search";s:13:"configuration";a:1:{s:8:"rankings";a:0:{}}}'),
('', 'search.page.user_search', 'a:11:{s:4:"uuid";s:36:"6acc91f3-2808-43b8-956c-6c9ec57a2f5a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k3aUaZXGDuhkek2TZIee0PApOPTvYZLadziekdyHA5A";}s:2:"id";s:11:"user_search";s:5:"label";s:5:"Users";s:4:"path";s:4:"user";s:6:"weight";i:0;s:6:"plugin";s:11:"user_search";s:13:"configuration";a:0:{}}'),
('', 'search.settings', 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hvVxL1G-ZCxaq32IZws0YsfuhvaDiQE_np-0g35KjUk";}s:12:"and_or_limit";i:7;s:12:"default_page";s:11:"node_search";s:5:"index";a:4:{s:10:"cron_limit";i:100;s:11:"overlap_cjk";b:1;s:17:"minimum_word_size";i:3;s:11:"tag_weights";a:12:{s:2:"h1";i:25;s:2:"h2";i:18;s:2:"h3";i:15;s:2:"h4";i:14;s:2:"h5";i:9;s:2:"h6";i:6;s:1:"u";i:3;s:1:"b";i:3;s:1:"i";i:3;s:6:"strong";i:3;s:2:"em";i:3;s:1:"a";i:10;}}s:7:"logging";b:0;}'),
('', 'shortcut.set.default', 'a:7:{s:4:"uuid";s:36:"812e013a-4ca9-4ca3-8fd6-08ac3f632ce6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U5VlGjd_SfV0Qm_EfnaynOfc549cNscFAx48JfYoMRI";}s:2:"id";s:7:"default";s:5:"label";s:7:"Default";}'),
('', 'system.action.comment_delete_action', 'a:10:{s:4:"uuid";s:36:"ec47b796-f587-438f-8d4a-c571b9f05230";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vpBH8OmL4sdesCdeZLsW8KOutB5gkbreWJbfjhfFKaQ";}s:2:"id";s:21:"comment_delete_action";s:5:"label";s:14:"Delete comment";s:4:"type";s:7:"comment";s:6:"plugin";s:28:"entity:delete_action:comment";s:13:"configuration";a:0:{}}'),
('', 'system.action.comment_publish_action', 'a:10:{s:4:"uuid";s:36:"4b665fe6-057d-4d5e-ba99-d77a587a267b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C00dyL_W_5M0nFlgUB3lWUTUs96jn51Jw1MLHVEHZD0";}s:2:"id";s:22:"comment_publish_action";s:5:"label";s:15:"Publish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:29:"entity:publish_action:comment";s:13:"configuration";a:0:{}}'),
('', 'system.action.comment_save_action', 'a:10:{s:4:"uuid";s:36:"5e95dde3-f90b-4c50-8679-b18589b4cb57";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lfyE_snmvfg_EQ3VDyhUtGAXgmqtEiqa46I3bTMg8DU";}s:2:"id";s:19:"comment_save_action";s:5:"label";s:12:"Save comment";s:4:"type";s:7:"comment";s:6:"plugin";s:26:"entity:save_action:comment";s:13:"configuration";a:0:{}}'),
('', 'system.action.comment_unpublish_action', 'a:10:{s:4:"uuid";s:36:"9676248b-d65b-498f-8680-2d1a4fabe525";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"tWOIjSMobEWOFZddMkNqb9JySbOVwE1diC6NRqcfLTk";}s:2:"id";s:24:"comment_unpublish_action";s:5:"label";s:17:"Unpublish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:31:"entity:unpublish_action:comment";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_delete_action', 'a:10:{s:4:"uuid";s:36:"52c23b61-4713-4690-b895-3e3f8200f34f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t43OqwzP3CTbcAagSsWKNy6KwMm_zShXo3c4-So6rQg";}s:2:"id";s:18:"node_delete_action";s:5:"label";s:14:"Delete content";s:4:"type";s:4:"node";s:6:"plugin";s:25:"entity:delete_action:node";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_make_sticky_action', 'a:10:{s:4:"uuid";s:36:"71b4dc8a-c5e0-47e9-a74c-5aabcb648d87";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sOb26JSy3fGpWkvR0WYN6_hMqj_6d1rvbvrkzp1yya0";}s:2:"id";s:23:"node_make_sticky_action";s:5:"label";s:19:"Make content sticky";s:4:"type";s:4:"node";s:6:"plugin";s:23:"node_make_sticky_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_make_unsticky_action', 'a:10:{s:4:"uuid";s:36:"d68e41ef-d173-4c52-8429-5d1cca49ba82";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lDM9mvIGAu8Sw8rt-uCO4Sr7yX5VPrDPxYcawkbKd6k";}s:2:"id";s:25:"node_make_unsticky_action";s:5:"label";s:21:"Make content unsticky";s:4:"type";s:4:"node";s:6:"plugin";s:25:"node_make_unsticky_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_promote_action', 'a:10:{s:4:"uuid";s:36:"d59099f7-0fec-429b-83fb-6bc2aa851e2f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N0RDBTqiK4dKoN4p4oW2j0SGWycdHyALUe9M-Ofp89U";}s:2:"id";s:19:"node_promote_action";s:5:"label";s:29:"Promote content to front page";s:4:"type";s:4:"node";s:6:"plugin";s:19:"node_promote_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_publish_action', 'a:10:{s:4:"uuid";s:36:"91e2606f-d5bd-4e90-a19a-6e963c4aac81";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2B9uF8NL5gutNKSdPRAhhAsDWFZZG1PJOBmx0aBGd_0";}s:2:"id";s:19:"node_publish_action";s:5:"label";s:15:"Publish content";s:4:"type";s:4:"node";s:6:"plugin";s:26:"entity:publish_action:node";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_save_action', 'a:10:{s:4:"uuid";s:36:"a31b5669-63c8-4855-970e-af72b01d0943";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LhdsoZPL_pFas2fjaAWue4zvrQ_tEVofLYtcNec-JGM";}s:2:"id";s:16:"node_save_action";s:5:"label";s:12:"Save content";s:4:"type";s:4:"node";s:6:"plugin";s:23:"entity:save_action:node";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_unpromote_action', 'a:10:{s:4:"uuid";s:36:"1a548669-40f4-4aa4-806e-b8a185196cb7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JBptjnfuOMtsdKygklXxoOgeOCTMtQxlkymjnnj-cC0";}s:2:"id";s:21:"node_unpromote_action";s:5:"label";s:30:"Remove content from front page";s:4:"type";s:4:"node";s:6:"plugin";s:21:"node_unpromote_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.node_unpublish_action', 'a:10:{s:4:"uuid";s:36:"2b71f04d-800a-4887-9099-e41b0d474a20";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C7X8h9FWlwkQ9y5mnU2JzgaZICAdc6HFbPVbhvjlAYE";}s:2:"id";s:21:"node_unpublish_action";s:5:"label";s:17:"Unpublish content";s:4:"type";s:4:"node";s:6:"plugin";s:28:"entity:unpublish_action:node";s:13:"configuration";a:0:{}}'),
('', 'system.action.taxonomy_term_publish_action', 'a:10:{s:4:"uuid";s:36:"be896854-cf36-4d5c-bcc5-1e9f23947c6f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DoVt_VGgVLcDD4XmVbSFzr0K17SJy9imFiYusKkJBgY";}s:2:"id";s:28:"taxonomy_term_publish_action";s:5:"label";s:21:"Publish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:35:"entity:publish_action:taxonomy_term";s:13:"configuration";a:0:{}}'),
('', 'system.action.taxonomy_term_unpublish_action', 'a:10:{s:4:"uuid";s:36:"46a37773-0779-4666-a153-7c4691a0f6cb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z2sNRM3ECa7FPCGnSNje_9SmZJQgwhD_6fG_L4Mr8zI";}s:2:"id";s:30:"taxonomy_term_unpublish_action";s:5:"label";s:23:"Unpublish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:37:"entity:unpublish_action:taxonomy_term";s:13:"configuration";a:0:{}}'),
('', 'system.action.user_add_role_action.administrator', 'a:9:{s:4:"uuid";s:36:"a615d59d-d535-42e7-9d44-a17f1553afee";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:34:"user_add_role_action.administrator";s:5:"label";s:50:"Add the Administrator role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}'),
('', 'system.action.user_add_role_action.content_editor', 'a:9:{s:4:"uuid";s:36:"43edffcf-08b2-4ac5-920c-1aa8d0dfc0c2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:35:"user_add_role_action.content_editor";s:5:"label";s:51:"Add the Content editor role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}'),
('', 'system.action.user_block_user_action', 'a:10:{s:4:"uuid";s:36:"5a80305c-a333-4a3f-8fd6-c76e98b417e2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DyypzTfThX10FFQw-399qPfEbLLyrhXgQrKPVsmAoJ4";}s:2:"id";s:22:"user_block_user_action";s:5:"label";s:26:"Block the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:22:"user_block_user_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.user_cancel_user_action', 'a:10:{s:4:"uuid";s:36:"2bedf296-28c3-4ebe-916a-3e52516bf54c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nvrL9bFilzBvm2bjO9rQnFDpBA7dBBUjShSSt6NS-DU";}s:2:"id";s:23:"user_cancel_user_action";s:5:"label";s:35:"Cancel the selected user account(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_cancel_user_action";s:13:"configuration";a:0:{}}'),
('', 'system.action.user_remove_role_action.administrator', 'a:9:{s:4:"uuid";s:36:"29effef3-81ad-4e28-a62b-ef82a8a7a905";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:37:"user_remove_role_action.administrator";s:5:"label";s:55:"Remove the Administrator role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}'),
('', 'system.action.user_remove_role_action.content_editor', 'a:9:{s:4:"uuid";s:36:"e9ff8c46-aff8-4811-a5c1-bb130d9b274b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"user.role.content_editor";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:38:"user_remove_role_action.content_editor";s:5:"label";s:56:"Remove the Content editor role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:14:"content_editor";}}'),
('', 'system.action.user_unblock_user_action', 'a:10:{s:4:"uuid";s:36:"ff880698-222e-4d5e-a78f-4966b995681a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SPsUXsR3Rc8d1y3gewzaAKWa1ncea_ywXX3f7LTn7k0";}s:2:"id";s:24:"user_unblock_user_action";s:5:"label";s:28:"Unblock the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:24:"user_unblock_user_action";s:13:"configuration";a:0:{}}'),
('', 'system.advisories', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"x0FuQ_7Cg81mSDQwG028_Z0CjH3R9ib5IDlHeV2BbAo";}s:7:"enabled";b:1;s:14:"interval_hours";i:6;}'),
('', 'system.cron', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"f3yToH8v8EaBZU0NFFw2qR8ogSCuWVmQaN0hpYR1BD8";}s:9:"threshold";a:2:{s:20:"requirements_warning";i:172800;s:18:"requirements_error";i:1209600;}s:7:"logging";b:1;}'),
('', 'system.date', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"IVsFTD1mvR2NGBP_1myt9kFIFmGepH4PyaN5aQBYpno";}s:9:"first_day";i:0;s:7:"country";a:1:{s:7:"default";N;}s:8:"timezone";a:2:{s:7:"default";s:3:"UTC";s:4:"user";a:3:{s:12:"configurable";b:1;s:7:"default";i:0;s:4:"warn";b:0;}}}'),
('', 'system.diff', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1WanmaEhxW_vM8_5Ktsdntj8MaO9UBHXg0lN603PsWM";}s:7:"context";a:2:{s:13:"lines_leading";i:2;s:14:"lines_trailing";i:2;}}'),
('', 'system.feature_flags', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZYyVj1FtPGV40Cf65YDVTUIc7YgLH6trXlotuevfs2I";}s:16:"linkset_endpoint";b:0;}'),
('', 'system.file', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mguGHCYb9Dw5EcpfjwoShGV1Vjkbz3QuPRCLfxiye-g";}s:22:"allow_insecure_uploads";b:0;s:14:"default_scheme";s:6:"public";s:21:"temporary_maximum_age";i:21600;}'),
('', 'system.image', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"durWHaKeBaq4d9Wpi4RqwADj1OufDepcnJuhVLmKN24";}s:7:"toolkit";s:2:"gd";}'),
('', 'system.image.gd', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eNXaHfkJJUThHeF0nvkoXyPLRrKYGxgHRjORvT4F5rQ";}s:12:"jpeg_quality";i:75;}'),
('', 'system.logging', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"u3-njszl92FaxjrCMiq0yDcjAfcdx72w1zT1O9dx6aA";}s:11:"error_level";s:4:"hide";}'),
('', 'system.mail', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5PvD9swkqWUeHkabdvbJ2SQqdhrzjkCT21wtD4BLfk4";}s:9:"interface";a:1:{s:7:"default";s:8:"php_mail";}s:10:"mailer_dsn";a:6:{s:6:"scheme";s:8:"sendmail";s:4:"host";s:7:"default";s:4:"user";N;s:8:"password";N;s:4:"port";N;s:7:"options";a:0:{}}}'),
('', 'system.maintenance', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1SNdA25INsV5YjlgAJtfC-6AM8VcWe_00xneMLb2yFg";}s:8:"langcode";s:2:"en";s:7:"message";s:93:"@site is currently under maintenance. We should be back shortly. Thank you for your patience.";}'),
('', 'system.menu.account', 'a:9:{s:4:"uuid";s:36:"89af7f3b-5160-4749-a547-67b77e97931a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Bh81osDyUQ4wV0GgU_NdBNqkzM87sLxjaCdFj9mnw";}s:2:"id";s:7:"account";s:5:"label";s:17:"User account menu";s:11:"description";s:40:"Links related to the active user account";s:6:"locked";b:1;}'),
('', 'system.menu.admin', 'a:9:{s:4:"uuid";s:36:"4f0ce0c2-4cda-43fe-9841-61ce1f833185";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sapEi2YDGoI9yQIT_WgIV2vUdQ6DScH0V3fAyTadAL0";}s:2:"id";s:5:"admin";s:5:"label";s:14:"Administration";s:11:"description";s:25:"Administrative task links";s:6:"locked";b:1;}'),
('', 'system.menu.footer', 'a:9:{s:4:"uuid";s:36:"235a132e-19d1-47f0-b176-95965a47dc9d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7yrlW5z9zdg2eBucB2GPqXKSMQfH9lSRSO4DbWF7AFc";}s:2:"id";s:6:"footer";s:5:"label";s:6:"Footer";s:11:"description";s:22:"Site information links";s:6:"locked";b:1;}'),
('', 'system.menu.main', 'a:9:{s:4:"uuid";s:36:"ced03791-fd16-4b35-a82b-ba02195e8542";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q2Ra3jfoIVk0f3SjxJX61byRQFVBAbpzYDQOiY-kno8";}s:2:"id";s:4:"main";s:5:"label";s:15:"Main navigation";s:11:"description";s:18:"Site section links";s:6:"locked";b:1;}'),
('', 'system.menu.tools', 'a:9:{s:4:"uuid";s:36:"0dea0a7b-11dd-42e4-8b00-4785e61e0254";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BCM-vV1zzRaLHN18dqAR_CuGOj8AFJvTx7BKl_8Gcxc";}s:2:"id";s:5:"tools";s:5:"label";s:5:"Tools";s:11:"description";s:39:"User tool links, often added by modules";s:6:"locked";b:1;}'),
('', 'system.performance', 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jtno5biznHZbrIgKwzq-ze-7XaQxLCGe6PeUOR7bRiQ";}s:5:"cache";a:1:{s:4:"page";a:1:{s:7:"max_age";i:0;}}s:3:"css";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:8:"fast_404";a:4:{s:7:"enabled";b:1;s:5:"paths";s:69:"/\\.(?:txt|png|gif|jpe?g|css|js|ico|swf|flv|cgi|bat|pl|dll|exe|asp)$/i";s:13:"exclude_paths";s:27:"/\\/(?:styles|imagecache)\\//";s:4:"html";s:162:"<!DOCTYPE html><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL "@path" was not found on this server.</p></body></html>";}s:2:"js";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}}'),
('', 'system.site', 'a:11:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ijfbzDTN4CbE7Sr-6ubWzy_t1vH4OtU1doNCLssVz-4";}s:8:"langcode";s:2:"en";s:4:"uuid";s:36:"338a54d8-5230-458d-851f-1d93173d4c5f";s:4:"name";[[ser_site_name]]s:4:"mail";[[site_mail]]s:6:"slogan";s:0:"";s:4:"page";a:3:{i:403;s:0:"";i:404;s:0:"";s:5:"front";s:5:"/node";}s:18:"admin_compact_mode";b:0;s:17:"weight_select_max";i:100;s:16:"default_langcode";s:2:"en";s:17:"mail_notification";N;}'),
('', 'system.theme', 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eJ529VM1gSIA_vgTy2PdiDvJuG0xhSxfQjCyl5WKlv4";}s:5:"admin";s:5:"claro";s:7:"default";s:7:"olivero";}'),
('', 'system.theme.global', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KZiV2LB312xgJBphfq5BTjmp16xiR5KM8InBJ-pff7Y";}s:7:"favicon";a:4:{s:8:"mimetype";s:24:"image/vnd.microsoft.icon";s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:1;}s:4:"logo";a:3:{s:4:"path";s:0:"";s:3:"url";N;s:11:"use_default";b:1;}}'),
('', 'taxonomy.settings', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zKpaWT6cJc1tVQQaTqatGELaCqU_oyRym6zTl27Yias";}s:20:"maintain_index_table";b:1;s:17:"override_selector";b:0;s:20:"terms_per_page_admin";i:100;}'),
('', 'taxonomy.vocabulary.tags', 'a:10:{s:4:"uuid";s:36:"b2932e3b-5f8b-4847-a70b-cf08b0aae5da";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"iTEzwrEQ_4JIb-OYGiqzyF2TmMgWyWayresXcWgwGWM";}s:4:"name";s:4:"Tags";s:3:"vid";s:4:"tags";s:11:"description";s:61:"Use tags to group articles on similar topics into categories.";s:6:"weight";i:0;s:12:"new_revision";b:0;}'),
('', 'text.settings', 'a:2:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Bkewb77RBOK3_aXMPsp8p87gbc03NvmC5gBLzPl7hVA";}s:22:"default_summary_length";i:600;}'),
('', 'update.settings', 'a:4:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cceqUa945af6yMPEeM1pWJQoA-tumoAqhThW2xGoZ04";}s:5:"check";a:2:{s:19:"disabled_extensions";b:1;s:13:"interval_days";i:1;}s:5:"fetch";a:3:{s:3:"url";N;s:12:"max_attempts";i:2;s:7:"timeout";i:30;}s:12:"notification";a:2:{s:6:"emails";a:1:{i:0;[[site_mail]]}s:9:"threshold";s:3:"all";}}'),
('', 'user.flood', 'a:6:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UYfMzeP1S8jKm9PSvxf7nQNe8DsNS-3bc2WSNNXBQWs";}s:8:"uid_only";b:0;s:8:"ip_limit";i:50;s:9:"ip_window";i:3600;s:10:"user_limit";i:5;s:11:"user_window";i:21600;}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'user.mail', 'a:11:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6CZIzFifRq3qbdq3n3nDpEOO4hWIQtKOAQNPvGNGKeM";}s:8:"langcode";s:2:"en";s:14:"cancel_confirm";a:2:{s:7:"subject";s:67:"Account cancellation request for [user:display-name] at [site:name]";s:4:"body";s:376:"[user:display-name]\n\nA request to cancel your account has been made at [site:name].\n\nYou may now cancel your account on [site:url-brief] by clicking this link or copying and pasting it into your browser:\n\n[user:cancel-url]\n\nNOTE: The cancellation of your account is not reversible.\n\nThis link expires in one day and nothing will happen if it is not used.\n\n--  [site:name] team";}s:14:"password_reset";a:2:{s:7:"subject";s:68:"Replacement login information for [user:display-name] at [site:name]";s:4:"body";s:407:"[user:display-name],\n\nA request to reset the password for your account has been made at [site:name].\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password. It expires after one day and nothing will happen if it''s not used.\n\n--  [site:name] team";}s:22:"register_admin_created";a:2:{s:7:"subject";s:58:"An administrator created an account for you at [site:name]";s:4:"body";s:473:"[user:display-name],\n\nA site administrator at [site:name] has created an account for you. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team";}s:29:"register_no_approval_required";a:2:{s:7:"subject";s:54:"Account details for [user:display-name] at [site:name]";s:4:"body";s:447:"[user:display-name],\n\nThank you for registering at [site:name]. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team";}s:25:"register_pending_approval";a:2:{s:7:"subject";s:79:"Account details for [user:display-name] at [site:name] (pending admin approval)";s:4:"body";s:288:"[user:display-name],\n\nThank you for registering at [site:name]. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\n\n--  [site:name] team";}s:31:"register_pending_approval_admin";a:2:{s:7:"subject";s:79:"Account details for [user:display-name] at [site:name] (pending admin approval)";s:4:"body";s:64:"[user:display-name] has applied for an account.\n\n[user:edit-url]";}s:16:"status_activated";a:2:{s:7:"subject";s:65:"Account details for [user:display-name] at [site:name] (approved)";s:4:"body";s:462:"[user:display-name],\n\nYour account at [site:name] has been activated.\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:account-name]\npassword: Your password\n\n--  [site:name] team";}s:14:"status_blocked";a:2:{s:7:"subject";s:64:"Account details for [user:display-name] at [site:name] (blocked)";s:4:"body";s:89:"[user:display-name],\n\nYour account on [site:name] has been blocked.\n\n--  [site:name] team";}s:15:"status_canceled";a:2:{s:7:"subject";s:65:"Account details for [user:display-name] at [site:name] (canceled)";s:4:"body";s:90:"[user:display-name],\n\nYour account on [site:name] has been canceled.\n\n--  [site:name] team";}}'),
('', 'user.role.administrator', 'a:10:{s:4:"uuid";s:36:"b1044a22-b35d-4389-8a8f-8fccbafdb543";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OeKGIkmZA_c-t6QLH81WNQx8gDCc1MRmxaTuQgxBByU";}s:2:"id";s:13:"administrator";s:5:"label";s:13:"Administrator";s:6:"weight";i:3;s:8:"is_admin";b:1;s:11:"permissions";a:0:{}}'),
('', 'user.role.anonymous', 'a:10:{s:4:"uuid";s:36:"baec04dc-2816-45fc-9df7-03102e568922";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:29:"filter.format.restricted_html";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:6:"filter";i:2;s:6:"search";i:3;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"xLG41YbRo2NP-0SgRNTkMzLEuaeibanGXgUTbdIcIIg";}s:2:"id";s:9:"anonymous";s:5:"label";s:14:"Anonymous user";s:6:"weight";i:0;s:8:"is_admin";b:0;s:11:"permissions";a:4:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:14:"search content";i:3;s:31:"use text format restricted_html";}}'),
('', 'user.role.authenticated', 'a:10:{s:4:"uuid";s:36:"60b01fb2-c502-4c22-aa7e-0a7dfa56b164";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"filter.format.basic_html";}s:6:"module";a:6:{i:0;s:7:"comment";i:1;s:4:"file";i:2;s:6:"filter";i:3;s:6:"search";i:4;s:8:"shortcut";i:5;s:6:"system";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hcfESiA8tr3D1muRk2KF7tbcun16ZJlG1R5SzKGed6g";}s:2:"id";s:13:"authenticated";s:5:"label";s:18:"Authenticated user";s:6:"weight";i:1;s:8:"is_admin";b:0;s:11:"permissions";a:8:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:16:"access shortcuts";i:3;s:16:"delete own files";i:4;s:13:"post comments";i:5;s:14:"search content";i:6;s:21:"skip comment approval";i:7;s:26:"use text format basic_html";}}'),
('', 'user.role.content_editor', 'a:10:{s:4:"uuid";s:36:"09c90c57-06f1-4689-a04b-fe1b6e025e98";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:17:"node.type.article";i:1;s:14:"node.type.page";i:2;s:24:"taxonomy.vocabulary.tags";}s:6:"module";a:8:{i:0;s:7:"comment";i:1;s:10:"contextual";i:2;s:4:"file";i:3;s:4:"node";i:4;s:4:"path";i:5;s:6:"system";i:6;s:8:"taxonomy";i:7;s:7:"toolbar";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"e_wG1u7SrGaJbY2-Szgbgl-c8T3kdirU3uTNq2c_QJQ";}s:2:"id";s:14:"content_editor";s:5:"label";s:14:"Content editor";s:6:"weight";i:2;s:8:"is_admin";b:0;s:11:"permissions";a:23:{i:0;s:27:"access administration pages";i:1;s:23:"access content overview";i:2;s:23:"access contextual links";i:3;s:21:"access files overview";i:4;s:14:"access toolbar";i:5;s:22:"administer url aliases";i:6;s:22:"create article content";i:7;s:19:"create page content";i:8;s:20:"create terms in tags";i:9;s:18:"create url aliases";i:10;s:24:"delete article revisions";i:11;s:26:"delete own article content";i:12;s:16:"delete own files";i:13;s:23:"delete own page content";i:14;s:21:"delete page revisions";i:15;s:24:"edit own article content";i:16;s:17:"edit own comments";i:17;s:21:"edit own page content";i:18;s:18:"edit terms in tags";i:19;s:20:"revert all revisions";i:20;s:18:"view all revisions";i:21;s:28:"view own unpublished content";i:22;s:29:"view the administration theme";}}'),
('', 'user.settings', 'a:9:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Y-Xpk050V3opj3WiFb4oUbVT9S7fDA1XLpigO-qVMVQ";}s:8:"langcode";s:2:"en";s:9:"anonymous";s:9:"Anonymous";s:11:"verify_mail";b:1;s:6:"notify";a:8:{s:14:"cancel_confirm";b:1;s:14:"password_reset";b:1;s:16:"status_activated";b:1;s:14:"status_blocked";b:0;s:15:"status_canceled";b:0;s:22:"register_admin_created";b:1;s:29:"register_no_approval_required";b:1;s:25:"register_pending_approval";b:1;}s:8:"register";s:10:"admin_only";s:13:"cancel_method";s:17:"user_cancel_block";s:22:"password_reset_timeout";i:86400;s:17:"password_strength";b:1;}'),
('', 'views.settings', 'a:5:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"_XeIJp8HLFXacGTv7BbJQAA0otRUXl0XxnqovpotgYQ";}s:17:"display_extenders";a:0:{}s:13:"sql_signature";b:0;s:2:"ui";a:3:{s:4:"show";a:6:{s:18:"additional_queries";b:0;s:15:"default_display";b:0;s:22:"performance_statistics";b:0;s:19:"preview_information";b:1;s:9:"sql_query";a:2:{s:7:"enabled";b:0;s:5:"where";s:5:"above";}s:13:"display_embed";b:0;}s:19:"always_live_preview";b:1;s:24:"exposed_filter_any_label";s:7:"old_any";}s:22:"field_rewrite_elements";a:29:{s:3:"div";s:3:"DIV";s:4:"span";s:4:"SPAN";s:2:"h1";s:2:"H1";s:2:"h2";s:2:"H2";s:2:"h3";s:2:"H3";s:2:"h4";s:2:"H4";s:2:"h5";s:2:"H5";s:2:"h6";s:2:"H6";s:1:"p";s:1:"P";s:6:"header";s:6:"HEADER";s:6:"footer";s:6:"FOOTER";s:7:"article";s:7:"ARTICLE";s:7:"section";s:7:"SECTION";s:5:"aside";s:5:"ASIDE";s:7:"details";s:7:"DETAILS";s:10:"blockquote";s:10:"BLOCKQUOTE";s:6:"figure";s:6:"FIGURE";s:7:"address";s:7:"ADDRESS";s:4:"code";s:4:"CODE";s:3:"pre";s:3:"PRE";s:3:"var";s:3:"VAR";s:4:"samp";s:4:"SAMP";s:3:"kbd";s:3:"KBD";s:6:"strong";s:6:"STRONG";s:2:"em";s:2:"EM";s:3:"del";s:3:"DEL";s:3:"ins";s:3:"INS";s:1:"q";s:1:"Q";s:1:"s";s:1:"S";}}'),
('', 'views.view.archive', 'a:13:{s:4:"uuid";s:36:"e3f50aa4-3fb5-435d-ad09-a72b8c080912";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"exIF08PTvYSK6tJCsAzBqMEKUBKIptPorMn74SVhevc";}s:2:"id";s:7:"archive";s:5:"label";s:7:"Archive";s:6:"module";s:4:"node";s:11:"description";s:22:"All content, by month.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:15:"Monthly archive";s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:15:"date_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:15:"summary_options";a:2:{s:8:"override";b:1;s:14:"items_per_page";i:30;}s:7:"summary";a:2:{s:10:"sort_order";s:4:"desc";s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:0;s:6:"expose";a:3:{s:8:"operator";s:1:"0";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:15:"date_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:15:"summary_options";a:1:{s:14:"items_per_page";i:30;}s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:7:"archive";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.block_content', 'a:13:{s:4:"uuid";s:36:"625c1d00-619c-402e-91a8-4991879c28cc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"04nFIsNzLdUjlangTCvxrNUJ9vRQldlR9gekgNrRsOM";}s:2:"id";s:13:"block_content";s:5:"label";s:14:"Content blocks";s:6:"module";s:5:"views";s:11:"description";s:31:"Find and manage content blocks.";s:3:"tag";s:7:"default";s:10:"base_table";s:24:"block_content_field_data";s:10:"base_field";s:2:"id";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:14:"Content blocks";s:6:"fields";a:4:{s:4:"info";a:37:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";N;s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:5:"field";s:5:"label";s:17:"Block description";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Block type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:13:"block_content";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:20:"access block library";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:38:"There are no content blocks available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:4:"info";a:16:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"info_op";s:5:"label";s:17:"Block description";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"info_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"info";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:10:"Block type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"reusable";a:16:{s:2:"id";s:8:"reusable";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:8:"reusable";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:8:"reusable";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:13:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:4:{s:4:"info";s:4:"info";s:4:"type";s:4:"type";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:7:"default";s:7:"changed";s:4:"info";a:4:{s:4:"info";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/content/block";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:6:"Blocks";s:11:"description";s:31:"Create and edit content blocks.";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:20:"system.admin_content";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.comment', 'a:13:{s:4:"uuid";s:36:"a40530d5-e959-4383-a67a-ec8005553b35";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CHAjzSss2YXSSIH7snaB7Zc9GEubxXtV0XE--SpzCB8";}s:2:"id";s:7:"comment";s:5:"label";s:8:"Comments";s:6:"module";s:7:"comment";s:11:"description";s:25:"Find and manage comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:26:{s:5:"title";s:8:"Comments";s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"comment_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:24:"comment_unpublish_action";}}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:8:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"next ›";s:8:"previous";s:12:"‹ previous";s:5:"first";s:8:"« first";s:4:"last";s:7:"last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:19:"administer comments";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:22:"No comments available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"changed";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:13:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:6:{s:17:"comment_bulk_form";s:17:"comment_bulk_form";s:7:"subject";s:7:"subject";s:3:"uid";s:3:"uid";s:9:"entity_id";s:9:"entity_id";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:7:"default";s:7:"changed";s:4:"info";a:6:{s:17:"comment_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"subject";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:3:"uid";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"entity_id";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:9:"css_class";s:0:"";s:8:"use_ajax";b:0;s:8:"group_by";b:0;s:16:"show_admin_links";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:1;s:13:"use_more_text";s:4:"more";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:23:"hide_attachment_summary";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}s:14:"page_published";a:6:{s:2:"id";s:14:"page_published";s:13:"display_title";s:18:"Published comments";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:19:"display_description";s:30:"The approved comments listing.";s:15:"display_comment";s:0:"";s:13:"exposed_block";b:0;s:17:"display_extenders";a:0:{}s:4:"path";s:21:"admin/content/comment";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:8:"Comments";s:11:"description";s:18:"Comments published";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}s:15:"page_unapproved";a:6:{s:2:"id";s:15:"page_unapproved";s:13:"display_title";s:19:"Unapproved comments";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:8:{s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"comment_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:22:"comment_publish_action";}}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author Name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:8:"defaults";a:3:{s:6:"fields";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:19:"display_description";s:32:"The unapproved comments listing.";s:17:"display_extenders";a:0:{}s:4:"path";s:30:"admin/content/comment/approval";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:19:"Unapproved comments";s:11:"description";s:19:"Comments unapproved";s:6:"weight";i:1;s:9:"menu_name";s:5:"admin";s:6:"parent";s:0:"";s:7:"context";s:1:"0";}}s:14:"cache_metadata";a:4:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}s:9:"cacheable";b:0;}}}}'),
('', 'views.view.comments_recent', 'a:13:{s:4:"uuid";s:36:"cf63099b-31e0-4639-92be-32892f368594";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:7:"comment";i:1;s:4:"node";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cFOucxH8PAXDQ2kViCcAHgK-JMCcxVkpIMzD56EfpZo";}s:2:"id";s:15:"comments_recent";s:5:"label";s:15:"Recent comments";s:6:"module";s:5:"views";s:11:"description";s:16:"Recent comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:14:{s:5:"title";s:15:"Recent comments";s:6:"fields";a:2:{s:7:"subject";a:26:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:1:{s:4:"type";s:5:"basic";}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:15:"access comments";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:11:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"label";s:0:"";s:5:"empty";b:1;s:7:"content";s:22:"No comments available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:2:{s:7:"created";a:12:{s:2:"id";s:7:"created";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;}s:3:"cid";a:12:{s:2:"id";s:3:"cid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"cid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"cid";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:3:"cid";}s:7:"exposed";b:0;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:11:"status_node";a:10:{s:2:"id";s:11:"status_node";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"node";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:2:{s:22:"default_field_elements";b:1;s:10:"hide_empty";b:0;}}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:1:{s:4:"node";a:5:{s:2:"id";s:4:"node";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"node";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:17:"block_description";s:15:"Recent comments";s:14:"block_category";s:13:"Lists (Views)";s:5:"allow";a:1:{s:14:"items_per_page";b:1;}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.content', 'a:13:{s:4:"uuid";s:36:"aa65fa57-33c9-4660-ac81-1033729ddf18";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"VhgEYFEzezna1qjycmr6NgssQgyiLfUvOv-iB_a_I6o";}s:2:"id";s:7:"content";s:5:"label";s:7:"Content";s:6:"module";s:4:"node";s:11:"description";s:24:"Find and manage content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:7:"Content";s:6:"fields";a:8:{s:14:"node_bulk_form";a:14:{s:2:"id";s:14:"node_bulk_form";s:5:"table";s:4:"node";s:5:"field";s:14:"node_bulk_form";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:14:"node_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"title";a:17:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Content type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"name";a:17:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:17:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:11:"Unpublished";s:18:"format_custom_true";s:9:"Published";}}s:7:"changed";a:17:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}s:8:"langcode";a:37:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:14:"field_language";s:5:"label";s:8:"Language";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:8:"language";s:8:"settings";a:2:{s:14:"link_to_entity";b:0;s:15:"native_language";b:0;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:10:"operations";a:23:{s:2:"id";s:10:"operations";s:5:"table";s:4:"node";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:3:{s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:23:"access content overview";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:5:{s:5:"title";a:16:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:8:"title_op";s:5:"label";s:5:"Title";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:8:"title_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:5:"title";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:12:"Content type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:16:"Published status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:12:"status_extra";a:9:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:6:"expose";a:2:{s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:13:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:10:{s:14:"node_bulk_form";s:14:"node_bulk_form";s:5:"title";s:5:"title";s:4:"type";s:4:"type";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:7:"changed";s:7:"changed";s:9:"edit_node";s:9:"edit_node";s:11:"delete_node";s:11:"delete_node";s:10:"dropbutton";s:10:"dropbutton";s:9:"timestamp";s:5:"title";}s:7:"default";s:7:"changed";s:4:"info";a:10:{s:14:"node_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"title";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:11:"delete_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"timestamp";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:1;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:13:"relationships";a:1:{s:3:"uid";a:6:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:11:"admin_label";s:6:"author";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"display_extenders";a:0:{}s:4:"path";s:18:"admin/content/node";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:7:"Content";s:11:"description";s:0:"";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:7:"Content";s:11:"description";s:23:"Find and manage content";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.content_recent', 'a:13:{s:4:"uuid";s:36:"b7e1370e-264d-4e83-aabe-c65c522578bf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YqZN5rc7XDQcFcInc8wkzuaHJmC5YvirhTmDcrarT6M";}s:2:"id";s:14:"content_recent";s:5:"label";s:14:"Recent content";s:6:"module";s:4:"node";s:11:"description";s:15:"Recent content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:22:{s:5:"title";s:14:"Recent content";s:6:"fields";a:2:{s:5:"title";a:26:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"changed";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:12:"status_extra";a:15:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:8:"required";b:1;}}s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"More";s:12:"link_display";s:1:"0";s:8:"link_url";s:0:"";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:1:{s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.files', 'a:13:{s:4:"uuid";s:36:"17be1b85-2fa5-42eb-a206-ad3bb89a71b3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"file";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LTTOi-7sByeB_teJJcm_LiTiEciHUIU-ZdjYcnQS--I";}s:2:"id";s:5:"files";s:5:"label";s:5:"Files";s:6:"module";s:4:"file";s:11:"description";s:22:"Find and manage files.";s:3:"tag";s:7:"default";s:10:"base_table";s:12:"file_managed";s:10:"base_field";s:3:"fid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:19:{s:5:"title";s:5:"Files";s:6:"fields";a:9:{s:3:"fid";a:24:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:5:"field";s:5:"label";s:3:"Fid";s:7:"exclude";b:1;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:8:"filename";a:36:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Name";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"file_link";s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:8:"filemime";a:25:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:5:"field";s:5:"label";s:9:"MIME type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"file_filemime";}s:8:"filesize";a:25:{s:2:"id";s:8:"filesize";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filesize";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filesize";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"Size";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"file_size";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:9:"Temporary";s:18:"format_custom_true";s:9:"Permanent";}}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Upload date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:12:"Changed date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:3:"fid";s:10:"group_type";s:3:"sum";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:7:"Used in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:1;s:4:"path";s:35:"admin/content/files/usage/{{ fid }}";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:1;s:20:"format_plural_string";s:26:"@count place@count places";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:12:"file_managed";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:21:"access files overview";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:19:"No files available.";}}s:5:"sorts";a:0:{}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:8:"filename";a:16:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:8:"Filename";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filename_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filename";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"filemime";a:16:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";s:9:"plugin_id";s:6:"string";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:9:"MIME type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filemime_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"filemime";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:11:"file_status";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:9:"status_op";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:13:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:3:"fid";s:3:"fid";s:8:"filename";s:8:"filename";s:8:"filemime";s:8:"filemime";s:8:"filesize";s:8:"filesize";s:6:"status";s:6:"status";s:7:"created";s:7:"created";s:7:"changed";s:7:"changed";s:5:"count";s:5:"count";}s:7:"default";s:7:"changed";s:4:"info";a:8:{s:3:"fid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filename";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filemime";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:8:"filesize";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:1;s:16:"show_admin_links";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:14:"Files overview";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:2:{s:5:"pager";b:1;s:13:"relationships";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:0;}}s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/content/files";s:4:"menu";a:6:{s:4:"type";s:3:"tab";s:5:"title";s:5:"Files";s:11:"description";s:0:"";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_2";a:6:{s:2:"id";s:6:"page_2";s:13:"display_title";s:10:"File usage";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:15:{s:5:"title";s:10:"File usage";s:6:"fields";a:4:{s:12:"entity_label";a:23:{s:2:"id";s:12:"entity_label";s:5:"table";s:10:"file_usage";s:5:"field";s:12:"entity_label";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:12:"entity_label";s:5:"label";s:6:"Entity";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:14:"link_to_entity";b:1;}s:4:"type";a:22:{s:2:"id";s:4:"type";s:5:"table";s:10:"file_usage";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:11:"Entity type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:6:"module";a:22:{s:2:"id";s:6:"module";s:5:"table";s:10:"file_usage";s:5:"field";s:6:"module";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:18:"Registering module";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"numeric";s:5:"label";s:9:"Use count";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:0;s:20:"format_plural_string";s:8:"1@count";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:5:"empty";a:0:{}s:9:"arguments";a:1:{s:3:"fid";a:22:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";s:9:"plugin_id";s:8:"file_fid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:46:"File usage information for {{ arguments.fid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:12:"break_phrase";b:0;s:3:"not";b:0;}}s:7:"filters";a:0:{}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:0:{}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:13:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:4:{s:12:"entity_label";s:12:"entity_label";s:4:"type";s:4:"type";s:6:"module";s:6:"module";s:5:"count";s:5:"count";}s:7:"default";s:12:"entity_label";s:4:"info";a:4:{s:12:"entity_label";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:6:"module";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:7:"caption";s:0:"";s:11:"description";s:0:"";s:5:"class";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:0:{}}s:8:"defaults";a:11:{s:5:"empty";b:0;s:5:"title";b:0;s:5:"pager";b:0;s:8:"group_by";b:0;s:5:"style";b:0;s:3:"row";b:0;s:13:"relationships";b:0;s:6:"fields";b:0;s:9:"arguments";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:8:"group_by";b:0;s:19:"display_description";s:0:"";s:17:"display_extenders";a:0:{}s:4:"path";s:27:"admin/content/files/usage/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.frontpage', 'a:13:{s:4:"uuid";s:36:"ed7a5af8-78fd-4cee-b91e-a798406c9cd2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OEEnRQIjfIaCFRsz8U3VqDrE82ltQKlo8wNbQJRZXu0";}s:2:"id";s:9:"frontpage";s:5:"label";s:9:"Frontpage";s:6:"module";s:4:"node";s:11:"description";s:39:"All content promoted to the front page.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:0:"";s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:8:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:3:{s:16:"area_text_custom";a:11:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"label";s:0:"";s:5:"empty";b:1;s:7:"content";s:181:"No front page content has been created yet.<br/>Follow the <a target="_blank" href="https://www.drupal.org/docs/user_guide/en/index.html">User Guide</a> to start building your site.";s:8:"tokenize";b:0;}s:18:"node_listing_empty";a:10:{s:2:"id";s:18:"node_listing_empty";s:5:"table";s:4:"node";s:5:"field";s:18:"node_listing_empty";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:18:"node_listing_empty";s:5:"label";s:0:"";s:5:"empty";b:1;}s:5:"title";a:10:{s:2:"id";s:5:"title";s:5:"table";s:5:"views";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:5:"title";s:5:"label";s:0:"";s:5:"empty";b:1;s:5:"title";s:8:"Welcome!";}}s:5:"sorts";a:2:{s:6:"sticky";a:12:{s:2:"id";s:6:"sticky";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"sticky";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"sticky";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"sticky";}s:7:"exposed";b:0;}s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:3:{s:7:"promote";a:16:{s:2:"id";s:7:"promote";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"promote";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"promote";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:3:"rss";}}s:17:"display_extenders";a:0:{}s:4:"path";s:7:"rss.xml";s:14:"sitename_title";b:1;s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:28:"languages:language_interface";i:1;s:21:"user.node_grants:view";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:2:{s:17:"display_extenders";a:0:{}s:4:"path";s:4:"node";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.glossary', 'a:13:{s:4:"uuid";s:36:"4774c894-d515-44f9-9109-48415c9f10be";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"msJ3UFBLYSIFO9zalGlk3_7z1reoZ7EHJ4qeRzO5iAE";}s:2:"id";s:8:"glossary";s:5:"label";s:8:"Glossary";s:6:"module";s:4:"node";s:11:"description";s:23:"All content, by letter.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:6:"fields";a:3:{s:5:"title";a:24:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:5:"field";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Last update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:5:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:7:"tooltip";a:2:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";}s:9:"time_diff";a:5:{s:7:"enabled";b:0;s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;s:7:"refresh";i:60;}}}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:36;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:0:{}s:9:"arguments";a:1:{s:5:"title";a:26:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:7:"default";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:15:"summary_options";a:0:{}s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:13:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;s:7:"columns";a:3:{s:5:"title";s:5:"title";s:4:"name";s:4:"name";s:7:"changed";s:7:"changed";}s:7:"default";s:5:"title";s:4:"info";a:3:{s:5:"title";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:4:"name";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:7:"changed";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:5:"order";s:3:"asc";s:11:"empty_table";b:0;s:5:"class";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:4:{s:22:"default_field_elements";b:1;s:6:"inline";a:0:{}s:9:"separator";s:0:"";s:10:"hide_empty";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:8:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:8:"use_ajax";b:1;s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:12:"attachment_1";a:6:{s:2:"id";s:12:"attachment_1";s:13:"display_title";s:10:"Attachment";s:14:"display_plugin";s:10:"attachment";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"none";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:0;}}s:9:"arguments";a:1:{s:5:"title";a:26:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:9:"plugin_id";s:6:"string";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:0;s:5:"title";s:0:"";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:15:"summary_options";a:3:{s:14:"items_per_page";i:25;s:6:"inline";b:1;s:9:"separator";s:3:" | ";}s:7:"summary";a:1:{s:6:"format";s:19:"unformatted_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:12:"break_phrase";b:0;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:17:"display_extenders";a:0:{}s:8:"displays";a:2:{s:7:"default";s:7:"default";s:6:"page_1";s:6:"page_1";}s:17:"inherit_arguments";b:0;}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:8:"glossary";s:4:"menu";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:8:"Glossary";s:6:"weight";i:0;s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.taxonomy_term', 'a:13:{s:4:"uuid";s:36:"98e6d44c-471e-4adb-8e5b-bede0826fab0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:3:{i:0;s:4:"node";i:1;s:8:"taxonomy";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"3o-ZjKjvMBpgaHiS3k8RvejhwJB4yX81fbjQjWc-tC8";}s:2:"id";s:13:"taxonomy_term";s:5:"label";s:13:"Taxonomy term";s:6:"module";s:8:"taxonomy";s:11:"description";s:45:"Content belonging to a certain taxonomy term.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:6:"fields";a:0:{}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:10;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:2:{s:6:"sticky";a:10:{s:2:"id";s:6:"sticky";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"sticky";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"sticky";}s:7:"exposed";b:0;}s:7:"created";a:11:{s:2:"id";s:7:"created";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:3:"tid";a:22:{s:2:"id";s:3:"tid";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:3:"tid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:18:"taxonomy_index_tid";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:0:"";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:19:"{{ arguments.tid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:8:"override";b:0;s:14:"items_per_page";i:25;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:20:"entity:taxonomy_term";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:4:{s:7:"bundles";a:0:{}s:6:"access";b:1;s:9:"operation";s:4:"view";s:8:"multiple";i:0;}s:12:"break_phrase";b:0;s:9:"add_table";b:0;s:13:"require_value";b:0;s:17:"reduce_duplicates";b:0;}}s:7:"filters";a:2:{s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:6:"status";a:14:{s:2:"id";s:6:"status";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:6:"header";a:1:{s:20:"entity_taxonomy_term";a:12:{s:2:"id";s:20:"entity_taxonomy_term";s:5:"table";s:5:"views";s:5:"field";s:20:"entity_taxonomy_term";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:6:"entity";s:5:"empty";b:1;s:6:"target";s:23:"{{ raw_arguments.tid }}";s:9:"view_mode";s:4:"full";s:8:"tokenize";b:1;s:13:"bypass_access";b:0;}}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;s:11:"description";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:3:"rss";}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:20:"taxonomy/term/%/feed";s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:1:"0";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:17:"display_extenders";a:0:{}s:4:"path";s:15:"taxonomy/term/%";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.user_admin_people', 'a:13:{s:4:"uuid";s:36:"e872479a-08cd-49b2-990a-89aaf849e5a2";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hZxrM4LiKjRy1g-zZSX1RExTVK8SKQAtMrsRER1420I";}s:2:"id";s:17:"user_admin_people";s:5:"label";s:6:"People";s:6:"module";s:4:"user";s:11:"description";s:50:"Find and manage people interacting with your site.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:25:{s:5:"title";s:6:"People";s:6:"fields";a:8:{s:14:"user_bulk_form";a:23:{s:2:"id";s:14:"user_bulk_form";s:5:"table";s:5:"users";s:5:"field";s:14:"user_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:14:"user_bulk_form";s:5:"label";s:11:"Bulk update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:8:"Username";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:5:"field";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:7:"Blocked";s:18:"format_custom_true";s:6:"Active";}}s:15:"roles_target_id";a:24:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:5:"label";s:5:"Roles";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:2:"ul";s:9:"separator";s:2:", ";}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:5:"field";s:5:"label";s:10:"Member for";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:9:"@interval";s:11:"past_format";s:9:"@interval";s:11:"granularity";i:2;}}s:6:"access";a:26:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";s:9:"plugin_id";s:5:"field";s:5:"label";s:11:"Last access";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:5:"users";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:17:"entity_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;}s:4:"mail";a:37:{s:2:"id";s:4:"mail";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"mail";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"mail";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:12:"basic_string";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:8:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";i:0;s:2:"id";i:0;s:4:"tags";a:4:{s:4:"next";s:8:"Next ›";s:8:"previous";s:12:"‹ Previous";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:16:"administer users";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:20:"No people available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:7:"filters";a:6:{s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:7:"combine";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:22:"Name or email contains";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"user";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:4:"mail";s:4:"mail";}}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:6:"Active";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:7:"Blocked";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}}s:15:"roles_target_id";a:15:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:10:"user_roles";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:18:"roles_target_id_op";s:5:"label";s:4:"Role";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:18:"roles_target_id_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"role";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:10:"permission";a:15:{s:2:"id";s:10:"permission";s:5:"table";s:11:"user__roles";s:5:"field";s:10:"permission";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:16:"user_permissions";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:13:"permission_op";s:5:"label";s:10:"Permission";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:13:"permission_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:10:"permission";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;}s:16:"default_langcode";a:16:{s:2:"id";s:16:"default_langcode";s:5:"table";s:16:"users_field_data";s:5:"field";s:16:"default_langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:16:"default_langcode";s:9:"plugin_id";s:7:"boolean";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:7:"uid_raw";a:15:{s:2:"id";s:7:"uid_raw";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"uid_raw";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:7:"numeric";s:8:"operator";s:2:"!=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:1:"0";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:1:"0";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:11:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:14:"user_bulk_form";s:14:"user_bulk_form";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:3:"rid";s:3:"rid";s:7:"created";s:7:"created";s:6:"access";s:6:"access";s:9:"edit_node";s:9:"edit_node";s:10:"dropbutton";s:10:"dropbutton";}s:7:"default";s:7:"created";s:4:"info";a:8:{s:14:"user_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:3:"rid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"access";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:1;s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:9:"css_class";s:0:"";s:8:"use_ajax";b:0;s:8:"group_by";b:0;s:16:"show_admin_links";b:1;s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"more";s:12:"link_display";s:6:"page_1";s:8:"link_url";s:0:"";s:15:"display_comment";s:0:"";s:23:"hide_attachment_summary";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:6:{s:8:"defaults";a:1:{s:16:"show_admin_links";b:0;}s:16:"show_admin_links";b:0;s:17:"display_extenders";a:0:{}s:4:"path";s:17:"admin/people/list";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:4:"List";s:11:"description";s:50:"Find and manage people interacting with your site.";s:6:"weight";i:-10;s:9:"menu_name";s:5:"admin";s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:6:"People";s:11:"description";s:45:"Manage user accounts, roles, and permissions.";s:6:"weight";i:0;s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:0;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `[[dbprefix]]config` VALUES
('', 'views.view.watchdog', 'a:13:{s:4:"uuid";s:36:"dfbb06a2-9f9c-4d18-bd36-42a226b664bf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:5:"dblog";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QxV85zTbzQHWnwqOjUQ9k-Hza0YP94TJebVvD1rVucg";}s:2:"id";s:8:"watchdog";s:5:"label";s:8:"Watchdog";s:6:"module";s:5:"views";s:11:"description";s:19:"Recent log messages";s:3:"tag";s:0:"";s:10:"base_table";s:8:"watchdog";s:10:"base_field";s:3:"wid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:19:{s:5:"title";s:19:"Recent log messages";s:6:"fields";a:8:{s:7:"nothing";a:22:{s:2:"id";s:7:"nothing";s:5:"table";s:5:"views";s:5:"field";s:7:"nothing";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:4:"Icon";s:9:"plugin_id";s:6:"custom";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:1;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:4:"icon";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:0;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:0;}s:3:"wid";a:22:{s:2:"id";s:3:"wid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"wid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:3:"WID";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:8:"severity";a:23:{s:2:"id";s:8:"severity";s:5:"table";s:8:"watchdog";s:5:"field";s:8:"severity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:12:"machine_name";s:5:"label";s:8:"Severity";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"machine_name";b:0;}s:4:"type";a:22:{s:2:"id";s:4:"type";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"label";s:4:"Type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}s:9:"timestamp";a:25:{s:2:"id";s:9:"timestamp";s:5:"table";s:8:"watchdog";s:5:"field";s:9:"timestamp";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:4:"date";s:5:"label";s:4:"Date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:7:"message";a:23:{s:2:"id";s:7:"message";s:5:"table";s:8:"watchdog";s:5:"field";s:7:"message";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:13:"dblog_message";s:5:"label";s:7:"Message";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:1;s:4:"path";s:35:"admin/reports/dblog/event/{{ wid }}";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:13:"{{ message }}";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:56;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:1;s:4:"trim";b:1;s:13:"preserve_tags";s:0:"";s:4:"html";b:1;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"replace_variables";b:1;}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:4:"User";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;}s:4:"link";a:22:{s:2:"id";s:4:"link";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"link";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:16:"dblog_operations";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:7:{s:6:"offset";i:0;s:24:"pagination_heading_level";s:2:"h4";s:14:"items_per_page";i:50;s:11:"total_pages";N;s:2:"id";i:0;s:4:"tags";a:2:{s:4:"next";s:6:"››";s:8:"previous";s:6:"‹‹";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:0;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:19:"access site reports";}}s:5:"cache";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:4:"area";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:26:"No log messages available.";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:26:"No log messages available.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:3:"wid";a:10:{s:2:"id";s:3:"wid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"wid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:8:"standard";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:3:"wid";}s:7:"exposed";b:0;}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:4:"type";a:14:{s:2:"id";s:4:"type";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"dblog_types";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:4:"Type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:1;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}s:8:"severity";a:14:{s:2:"id";s:8:"severity";s:5:"table";s:8:"watchdog";s:5:"field";s:8:"severity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"in_operator";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"severity_op";s:5:"label";s:8:"Severity";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"severity_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:8:"severity";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:1;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:13:{s:8:"grouping";a:0:{}s:9:"row_class";s:25:"{{ type }} {{ severity }}";s:17:"default_row_class";b:1;s:7:"columns";a:8:{s:7:"nothing";s:7:"nothing";s:3:"wid";s:3:"wid";s:8:"severity";s:8:"severity";s:4:"type";s:4:"type";s:9:"timestamp";s:9:"timestamp";s:7:"message";s:7:"message";s:4:"name";s:4:"name";s:4:"link";s:4:"link";}s:7:"default";s:3:"wid";s:4:"info";a:8:{s:7:"nothing";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:3:"wid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:8:"severity";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:9:"timestamp";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"message";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:4:"link";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}}s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:11:"empty_table";b:0;s:7:"caption";s:0:"";s:11:"description";s:0:"";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:1:{s:3:"uid";a:8:{s:2:"id";s:3:"uid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:4:"User";s:9:"plugin_id";s:8:"standard";s:8:"required";b:0;}}s:9:"css_class";s:11:"admin-dblog";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:4:"page";a:6:{s:2:"id";s:4:"page";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:2:{s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/reports/dblog";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.who_s_new', 'a:13:{s:4:"uuid";s:36:"811fa183-e3f7-47d6-8b4f-7328c04e30b6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zji0_13MyVGK7Bn1lUMDeZyyOIZedWvqpYUeM_SioPI";}s:2:"id";s:9:"who_s_new";s:5:"label";s:9:"Who''s new";s:6:"module";s:4:"user";s:11:"description";s:53:"Shows a list of the newest user accounts on the site.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:9:"Who''s new";s:6:"fields";a:1:{s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:5;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:0:{}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:7:"created";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:1:"0";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:6:"access";a:16:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";s:9:"plugin_id";s:4:"date";s:8:"operator";s:1:">";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:10:"1970-01-01";s:4:"type";s:4:"date";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:1:"0";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:1:{s:4:"type";s:9:"html_list";}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:9:"Who''s new";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:19:"display_description";s:19:"A list of new users";s:17:"display_extenders";a:0:{}s:17:"block_description";s:9:"Who''s new";s:14:"block_category";s:4:"User";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}'),
('', 'views.view.who_s_online', 'a:13:{s:4:"uuid";s:36:"8807e88b-e554-4d63-a22d-7ab2172449c3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ls1UO6IE5YEFa6zde68C6HZeKgnFZYmPj4bJW8L_XuQ";}s:2:"id";s:12:"who_s_online";s:5:"label";s:18:"Who''s online block";s:6:"module";s:4:"user";s:11:"description";s:93:"Shows the user names of the most recently active users, and the total number of active users.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:7:"Default";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"title";s:12:"Who''s online";s:6:"fields";a:1:{s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"trim";b:0;s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"user_name";}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:10;}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:20:"access user profiles";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:11:"text_custom";s:5:"empty";b:1;s:7:"content";s:35:"There are currently 0 users online.";s:8:"tokenize";b:0;}}s:5:"sorts";a:1:{s:6:"access";a:13:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";s:9:"plugin_id";s:4:"date";s:5:"order";s:4:"DESC";s:6:"expose";a:2:{s:5:"label";s:0:"";s:16:"field_identifier";s:6:"access";}s:7:"exposed";b:0;s:11:"granularity";s:6:"second";}}s:9:"arguments";a:0:{}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:5:"value";s:1:"1";s:5:"group";i:1;s:6:"expose";a:3:{s:8:"operator";s:1:"0";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}s:6:"access";a:16:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";s:9:"plugin_id";s:4:"date";s:8:"operator";s:2:">=";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:11:"-15 minutes";s:4:"type";s:6:"offset";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:9:"access_op";s:5:"label";s:11:"Last access";s:11:"description";s:77:"A user is considered online for this long after they have last viewed a page.";s:12:"use_operator";b:0;s:8:"operator";s:9:"access_op";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}s:10:"identifier";s:6:"access";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:13:"relationships";a:0:{}s:6:"header";a:1:{s:6:"result";a:9:{s:2:"id";s:6:"result";s:5:"table";s:5:"views";s:5:"field";s:6:"result";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:9:"plugin_id";s:6:"result";s:5:"empty";b:0;s:7:"content";s:40:"There are currently @total users online.";}}s:6:"footer";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:18:"who_s_online_block";a:6:{s:2:"id";s:18:"who_s_online_block";s:13:"display_title";s:12:"Who''s online";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:3:{s:19:"display_description";s:45:"A list of users that are currently logged in.";s:17:"display_extenders";a:0:{}s:17:"block_description";s:12:"Who''s online";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_managed`
--

CREATE TABLE `[[dbprefix]]file_managed` (
  `fid` int unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `uid` int unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `filename` varchar(255) DEFAULT NULL,
  `uri` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `filemime` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  `filesize` bigint unsigned DEFAULT NULL,
  `status` tinyint NOT NULL,
  `created` int DEFAULT NULL,
  `changed` int NOT NULL,
  PRIMARY KEY (`fid`),
  UNIQUE KEY `file_field__uuid__value` (`uuid`),
  KEY `file_field__uid__target_id` (`uid`),
  KEY `file_field__uri` (`uri`(191)),
  KEY `file_field__status` (`status`),
  KEY `file_field__changed` (`changed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for file entities.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_usage`
--

CREATE TABLE `[[dbprefix]]file_usage` (
  `fid` int unsigned NOT NULL COMMENT 'File ID.',
  `module` varchar(50) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The name of the module that is using the file.',
  `type` varchar(64) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The name of the object type in which the file is used.',
  `id` varchar(64) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '0' COMMENT 'The primary key of the object using the file.',
  `count` int unsigned NOT NULL DEFAULT '0' COMMENT 'The number of times this file is used by this object.',
  PRIMARY KEY (`fid`,`type`,`id`,`module`),
  KEY `type_id` (`type`,`id`),
  KEY `fid_count` (`fid`,`count`),
  KEY `fid_module` (`fid`,`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Track where a file is used.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]help_search_items`
--

CREATE TABLE `[[dbprefix]]help_search_items` (
  `sid` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Numeric index of this item in the search index',
  `section_plugin_id` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The help section the item comes from',
  `permission` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The permission needed to view this item',
  `topic_id` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The topic ID of the item',
  PRIMARY KEY (`sid`),
  KEY `section_plugin_id` (`section_plugin_id`),
  KEY `topic_id` (`topic_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='Stores information about indexed help search items' AUTO_INCREMENT=79 ;

--
-- Dumping data for table `[[dbprefix]]help_search_items`
--

INSERT INTO `[[dbprefix]]help_search_items` VALUES
(1, 'help_topics', '', 'announcements_feed.overview'),
(2, 'help_topics', '', 'block.configure'),
(3, 'help_topics', '', 'block.overview'),
(4, 'help_topics', '', 'block.place'),
(5, 'help_topics', '', 'block_content.add'),
(6, 'help_topics', '', 'block_content.type'),
(7, 'help_topics', '', 'breakpoint.overview'),
(8, 'help_topics', '', 'config.export_full'),
(9, 'help_topics', '', 'config.export_single'),
(10, 'help_topics', '', 'config.import_full'),
(11, 'help_topics', '', 'config.import_single'),
(12, 'help_topics', '', 'editor.overview'),
(13, 'help_topics', '', 'filter.overview'),
(14, 'help_topics', '', 'core.appearance'),
(15, 'help_topics', '', 'core.config_overview'),
(16, 'help_topics', '', 'core.content_structure'),
(17, 'help_topics', '', 'core.cron'),
(18, 'help_topics', '', 'core.extending'),
(19, 'help_topics', '', 'core.maintenance'),
(20, 'help_topics', '', 'core.media'),
(21, 'help_topics', '', 'core.menus'),
(22, 'help_topics', '', 'core.performance'),
(23, 'help_topics', '', 'core.security'),
(24, 'help_topics', '', 'core.settings_tray'),
(25, 'help_topics', '', 'core.translations'),
(26, 'help_topics', '', 'core.ui_accessibility'),
(27, 'help_topics', '', 'core.ui_components'),
(28, 'help_topics', '', 'core.web_services'),
(29, 'help_topics', '', 'help.help_topic_search'),
(30, 'help_topics', '', 'help.overview'),
(31, 'help_topics', '', 'search.configuring'),
(32, 'help_topics', '', 'search.index'),
(33, 'help_topics', '', 'search.overview'),
(34, 'help_topics', '', 'system.cache'),
(35, 'help_topics', '', 'system.config_basic'),
(36, 'help_topics', '', 'system.config_error'),
(37, 'help_topics', '', 'system.maintenance_mode'),
(38, 'help_topics', '', 'system.module_install'),
(39, 'help_topics', '', 'system.module_uninstall'),
(40, 'help_topics', '', 'system.reports'),
(41, 'help_topics', '', 'system.theme_install'),
(42, 'help_topics', '', 'system.theme_uninstall'),
(43, 'help_topics', '', 'user.create'),
(44, 'help_topics', '', 'user.new_role'),
(45, 'help_topics', '', 'user.overview'),
(46, 'help_topics', '', 'user.permissions'),
(47, 'help_topics', '', 'user.security_account_settings'),
(48, 'help_topics', '', 'user.update'),
(49, 'help_topics', '', 'comment.configuring'),
(50, 'help_topics', '', 'comment.creating_type'),
(51, 'help_topics', '', 'comment.disabling'),
(52, 'help_topics', '', 'comment.moderating'),
(53, 'help_topics', '', 'comment.overview'),
(54, 'help_topics', '', 'contextual.overview'),
(55, 'help_topics', '', 'field_ui.add_field'),
(56, 'help_topics', '', 'field_ui.manage_display'),
(57, 'help_topics', '', 'field_ui.manage_form'),
(58, 'help_topics', '', 'field_ui.reference_field'),
(59, 'help_topics', '', 'image.style'),
(60, 'help_topics', '', 'menu_ui.content_type_configuration'),
(61, 'help_topics', '', 'menu_ui.menu_item_add'),
(62, 'help_topics', '', 'menu_ui.menu_operations'),
(63, 'help_topics', '', 'menu_ui.overriding'),
(64, 'help_topics', '', 'node.creating_content'),
(65, 'help_topics', '', 'node.creating_type'),
(66, 'help_topics', '', 'node.editing'),
(67, 'help_topics', '', 'node.overview'),
(68, 'help_topics', '', 'path.creating_alias'),
(69, 'help_topics', '', 'path.editing_alias'),
(70, 'help_topics', '', 'path.overview'),
(71, 'help_topics', '', 'shortcut.overview'),
(72, 'help_topics', '', 'taxonomy.configuring'),
(73, 'help_topics', '', 'taxonomy.overview'),
(74, 'help_topics', '', 'views.overview'),
(75, 'help_topics', '', 'views_ui.add_display'),
(76, 'help_topics', '', 'views_ui.bulk_operations'),
(77, 'help_topics', '', 'views_ui.create'),
(78, 'help_topics', '', 'views_ui.edit');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]history`
--

CREATE TABLE `[[dbprefix]]history` (
  `uid` int NOT NULL DEFAULT '0' COMMENT 'The "[[dbprefix]]users".uid that read the "[[dbprefix]]node" nid.',
  `nid` int unsigned NOT NULL DEFAULT '0' COMMENT 'The "[[dbprefix]]node".nid that was read.',
  `timestamp` bigint NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp at which the read occurred.',
  PRIMARY KEY (`uid`,`nid`),
  KEY `nid` (`nid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='A record of which "[[dbprefix]]users" have read which "[[dbprefix]]node…';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]key_value`
--

CREATE TABLE `[[dbprefix]]key_value` (
  `collection` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'A named collection of key and value pairs.',
  `name` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The key of the key-value pair. As KEY is a SQL reserved keyword, name was chosen instead.',
  `value` longblob NOT NULL COMMENT 'The value.',
  PRIMARY KEY (`collection`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Generic key-value storage table. See the state system for…';

--
-- Dumping data for table `[[dbprefix]]key_value`
--

INSERT INTO `[[dbprefix]]key_value` VALUES
('config.entity.key_store.action', 'uuid:1a548669-40f4-4aa4-806e-b8a185196cb7', 'a:1:{i:0;s:35:"system.action.node_unpromote_action";}'),
('config.entity.key_store.action', 'uuid:29effef3-81ad-4e28-a62b-ef82a8a7a905', 'a:1:{i:0;s:51:"system.action.user_remove_role_action.administrator";}'),
('config.entity.key_store.action', 'uuid:2b71f04d-800a-4887-9099-e41b0d474a20', 'a:1:{i:0;s:35:"system.action.node_unpublish_action";}'),
('config.entity.key_store.action', 'uuid:2bedf296-28c3-4ebe-916a-3e52516bf54c', 'a:1:{i:0;s:37:"system.action.user_cancel_user_action";}'),
('config.entity.key_store.action', 'uuid:43edffcf-08b2-4ac5-920c-1aa8d0dfc0c2', 'a:1:{i:0;s:49:"system.action.user_add_role_action.content_editor";}'),
('config.entity.key_store.action', 'uuid:46a37773-0779-4666-a153-7c4691a0f6cb', 'a:1:{i:0;s:44:"system.action.taxonomy_term_unpublish_action";}'),
('config.entity.key_store.action', 'uuid:4b665fe6-057d-4d5e-ba99-d77a587a267b', 'a:1:{i:0;s:36:"system.action.comment_publish_action";}'),
('config.entity.key_store.action', 'uuid:52c23b61-4713-4690-b895-3e3f8200f34f', 'a:1:{i:0;s:32:"system.action.node_delete_action";}'),
('config.entity.key_store.action', 'uuid:5a80305c-a333-4a3f-8fd6-c76e98b417e2', 'a:1:{i:0;s:36:"system.action.user_block_user_action";}'),
('config.entity.key_store.action', 'uuid:5e95dde3-f90b-4c50-8679-b18589b4cb57', 'a:1:{i:0;s:33:"system.action.comment_save_action";}'),
('config.entity.key_store.action', 'uuid:71b4dc8a-c5e0-47e9-a74c-5aabcb648d87', 'a:1:{i:0;s:37:"system.action.node_make_sticky_action";}'),
('config.entity.key_store.action', 'uuid:91e2606f-d5bd-4e90-a19a-6e963c4aac81', 'a:1:{i:0;s:33:"system.action.node_publish_action";}'),
('config.entity.key_store.action', 'uuid:9676248b-d65b-498f-8680-2d1a4fabe525', 'a:1:{i:0;s:38:"system.action.comment_unpublish_action";}'),
('config.entity.key_store.action', 'uuid:a31b5669-63c8-4855-970e-af72b01d0943', 'a:1:{i:0;s:30:"system.action.node_save_action";}'),
('config.entity.key_store.action', 'uuid:a615d59d-d535-42e7-9d44-a17f1553afee', 'a:1:{i:0;s:48:"system.action.user_add_role_action.administrator";}'),
('config.entity.key_store.action', 'uuid:be896854-cf36-4d5c-bcc5-1e9f23947c6f', 'a:1:{i:0;s:42:"system.action.taxonomy_term_publish_action";}'),
('config.entity.key_store.action', 'uuid:d59099f7-0fec-429b-83fb-6bc2aa851e2f', 'a:1:{i:0;s:33:"system.action.node_promote_action";}'),
('config.entity.key_store.action', 'uuid:d68e41ef-d173-4c52-8429-5d1cca49ba82', 'a:1:{i:0;s:39:"system.action.node_make_unsticky_action";}'),
('config.entity.key_store.action', 'uuid:e9ff8c46-aff8-4811-a5c1-bb130d9b274b', 'a:1:{i:0;s:52:"system.action.user_remove_role_action.content_editor";}'),
('config.entity.key_store.action', 'uuid:ec47b796-f587-438f-8d4a-c571b9f05230', 'a:1:{i:0;s:35:"system.action.comment_delete_action";}'),
('config.entity.key_store.action', 'uuid:ff880698-222e-4d5e-a78f-4966b995681a', 'a:1:{i:0;s:38:"system.action.user_unblock_user_action";}'),
('config.entity.key_store.base_field_override', 'uuid:e9aa9d0f-2442-484d-a01c-083d6217aeeb', 'a:1:{i:0;s:45:"core.base_field_override.node.article.promote";}'),
('config.entity.key_store.block', 'theme:claro', 'a:9:{i:0;s:31:"block.block.claro_local_actions";i:1;s:28:"block.block.claro_page_title";i:2;s:37:"block.block.claro_primary_local_tasks";i:3;s:39:"block.block.claro_secondary_local_tasks";i:4;s:22:"block.block.claro_help";i:5;s:29:"block.block.claro_help_search";i:6;s:29:"block.block.claro_breadcrumbs";i:7;s:25:"block.block.claro_content";i:8;s:26:"block.block.claro_messages";}'),
('config.entity.key_store.block', 'theme:olivero', 'a:14:{i:0;s:24:"block.block.olivero_help";i:1;s:30:"block.block.olivero_page_title";i:2;s:41:"block.block.olivero_primary_admin_actions";i:3;s:39:"block.block.olivero_primary_local_tasks";i:4;s:41:"block.block.olivero_secondary_local_tasks";i:5;s:38:"block.block.olivero_search_form_narrow";i:6;s:36:"block.block.olivero_search_form_wide";i:7;s:31:"block.block.olivero_breadcrumbs";i:8;s:27:"block.block.olivero_content";i:9;s:28:"block.block.olivero_messages";i:10;s:27:"block.block.olivero_powered";i:11;s:33:"block.block.olivero_site_branding";i:12;s:32:"block.block.olivero_account_menu";i:13;s:29:"block.block.olivero_main_menu";}'),
('config.entity.key_store.block', 'uuid:039b45d8-7159-4d5b-b919-669eb9515a94', 'a:1:{i:0;s:25:"block.block.claro_content";}'),
('config.entity.key_store.block', 'uuid:076ff6ea-c044-4dc6-81fb-88dad627e818', 'a:1:{i:0;s:31:"block.block.olivero_breadcrumbs";}'),
('config.entity.key_store.block', 'uuid:1a5ad090-d53b-45e0-9456-c52b610fdbdc', 'a:1:{i:0;s:39:"block.block.olivero_primary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:1aa66bf1-43d8-4947-a1cd-0f1c9e0674a0', 'a:1:{i:0;s:28:"block.block.olivero_messages";}'),
('config.entity.key_store.block', 'uuid:25bfbe62-b4f0-42f4-8210-a49ada240e5c', 'a:1:{i:0;s:37:"block.block.claro_primary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:2c5ef16c-8223-4cdd-ae2a-880434b6fe8b', 'a:1:{i:0;s:41:"block.block.olivero_primary_admin_actions";}'),
('config.entity.key_store.block', 'uuid:3d9762d2-6246-473d-b4ff-605dc30c81a0', 'a:1:{i:0;s:22:"block.block.claro_help";}'),
('config.entity.key_store.block', 'uuid:4961daf1-1b60-4bad-8cee-ba97f8b32365', 'a:1:{i:0;s:39:"block.block.claro_secondary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:4e44dc37-b872-4807-8919-979f13a5b4a9', 'a:1:{i:0;s:28:"block.block.claro_page_title";}'),
('config.entity.key_store.block', 'uuid:4fa28caa-a20a-444d-aea3-d9d35d689ede', 'a:1:{i:0;s:36:"block.block.olivero_search_form_wide";}'),
('config.entity.key_store.block', 'uuid:5d42de84-933b-477f-9028-d23c8f3e7586', 'a:1:{i:0;s:41:"block.block.olivero_secondary_local_tasks";}'),
('config.entity.key_store.block', 'uuid:631f6613-7fba-4fe7-98ac-1279a781dcd1', 'a:1:{i:0;s:24:"block.block.olivero_help";}'),
('config.entity.key_store.block', 'uuid:6563a256-cb0d-4de5-9c6f-468e53e2f956', 'a:1:{i:0;s:27:"block.block.olivero_content";}'),
('config.entity.key_store.block', 'uuid:7c904b36-4624-43fc-8b43-3ec638277c0d', 'a:1:{i:0;s:32:"block.block.olivero_account_menu";}'),
('config.entity.key_store.block', 'uuid:7e3cc22b-9d21-4f96-b434-c1b491ae83a7', 'a:1:{i:0;s:27:"block.block.olivero_powered";}'),
('config.entity.key_store.block', 'uuid:957b3ee4-22d1-45dd-9811-96dda860caf8', 'a:1:{i:0;s:29:"block.block.claro_breadcrumbs";}'),
('config.entity.key_store.block', 'uuid:99cfe3c7-2b85-470d-8446-9ad8838efa52', 'a:1:{i:0;s:38:"block.block.olivero_search_form_narrow";}'),
('config.entity.key_store.block', 'uuid:a6d0b1c5-2a18-4957-b129-00e6705d21ac', 'a:1:{i:0;s:26:"block.block.claro_messages";}'),
('config.entity.key_store.block', 'uuid:a7b01d17-9530-46f6-8aff-0c9677d26b9a', 'a:1:{i:0;s:33:"block.block.olivero_site_branding";}'),
('config.entity.key_store.block', 'uuid:b1fa4822-928d-44be-b7aa-f15f4ec918f8', 'a:1:{i:0;s:31:"block.block.claro_local_actions";}'),
('config.entity.key_store.block', 'uuid:db7069ab-ff58-4aa3-91da-1baf582a2132', 'a:1:{i:0;s:29:"block.block.claro_help_search";}'),
('config.entity.key_store.block', 'uuid:f520c3bc-dbce-4292-8fcd-cd63744cd792', 'a:1:{i:0;s:30:"block.block.olivero_page_title";}'),
('config.entity.key_store.block', 'uuid:f56e2555-789d-4358-83d0-921637c8b5d7', 'a:1:{i:0;s:29:"block.block.olivero_main_menu";}'),
('config.entity.key_store.block_content_type', 'uuid:c0b47f08-3da8-4dd0-911b-d20a2fe9e8a8', 'a:1:{i:0;s:24:"block_content.type.basic";}'),
('config.entity.key_store.comment_type', 'uuid:d01ae017-105e-4a2a-860e-6bd834393d3d', 'a:1:{i:0;s:20:"comment.type.comment";}'),
('config.entity.key_store.date_format', 'uuid:2cc9688f-693a-4a19-8598-fba4c3bd3373', 'a:1:{i:0;s:21:"core.date_format.long";}'),
('config.entity.key_store.date_format', 'uuid:49286c40-1916-406e-9773-ed6da4a5b7ee', 'a:1:{i:0;s:26:"core.date_format.html_date";}'),
('config.entity.key_store.date_format', 'uuid:4f97b2bd-3072-4d6c-b54d-b651d2d62736', 'a:1:{i:0;s:26:"core.date_format.html_week";}'),
('config.entity.key_store.date_format', 'uuid:5208561a-cfd2-4765-a458-2c6b9e38242f', 'a:1:{i:0;s:35:"core.date_format.html_yearless_date";}'),
('config.entity.key_store.date_format', 'uuid:61a12bbb-ee36-4f4d-9499-1d243cf00f95', 'a:1:{i:0;s:27:"core.date_format.html_month";}'),
('config.entity.key_store.date_format', 'uuid:850d4f0b-b5e7-40e4-84a9-2664fe3d7bc3', 'a:1:{i:0;s:22:"core.date_format.short";}'),
('config.entity.key_store.date_format', 'uuid:886d2262-34c9-4664-b126-7d10809ee1c2', 'a:1:{i:0;s:31:"core.date_format.olivero_medium";}'),
('config.entity.key_store.date_format', 'uuid:bf842bc5-5850-46fe-aadc-37445acb3836', 'a:1:{i:0;s:26:"core.date_format.html_time";}'),
('config.entity.key_store.date_format', 'uuid:e08502e2-f029-4b5f-b8fa-83c2e3d51599', 'a:1:{i:0;s:26:"core.date_format.html_year";}'),
('config.entity.key_store.date_format', 'uuid:f1efcf24-d048-4b22-a883-a8642bd10374', 'a:1:{i:0;s:23:"core.date_format.medium";}'),
('config.entity.key_store.date_format', 'uuid:f55a3b0a-81cd-43b4-907b-dbdfb37b086a', 'a:1:{i:0;s:30:"core.date_format.html_datetime";}'),
('config.entity.key_store.date_format', 'uuid:fcecd840-ecfa-466c-904b-307ab45b1090', 'a:1:{i:0;s:25:"core.date_format.fallback";}'),
('config.entity.key_store.editor', 'uuid:5b1d662d-f47c-4c13-81b7-2d78ff1f01b4', 'a:1:{i:0;s:24:"editor.editor.basic_html";}'),
('config.entity.key_store.editor', 'uuid:883c06ee-0d97-4555-a289-ad537a55ec3e', 'a:1:{i:0;s:23:"editor.editor.full_html";}'),
('config.entity.key_store.entity_form_display', 'uuid:0db9303f-8a7e-4a2d-9802-371f2aa02617', 'a:1:{i:0;s:52:"core.entity_form_display.block_content.basic.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:2ffd3fb9-98b8-4e74-97ec-afc924942d1d', 'a:1:{i:0;s:48:"core.entity_form_display.comment.comment.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:389bad0b-dd7d-494a-ac23-47a496652bb8', 'a:1:{i:0;s:45:"core.entity_form_display.node.article.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:dcb8569c-55af-4b2b-8d68-dacd30b45e02', 'a:1:{i:0;s:42:"core.entity_form_display.user.user.default";}'),
('config.entity.key_store.entity_form_display', 'uuid:eb0e9eb2-793c-489d-a546-f6f864d17d45', 'a:1:{i:0;s:42:"core.entity_form_display.node.page.default";}'),
('config.entity.key_store.entity_form_mode', 'uuid:2e662d14-cd40-41d9-9fe8-2f35a346f1f0', 'a:1:{i:0;s:35:"core.entity_form_mode.user.register";}'),
('config.entity.key_store.entity_view_display', 'uuid:08c6677d-24a3-42c0-bbad-7ddd3d4312ea', 'a:1:{i:0;s:44:"core.entity_view_display.node.article.teaser";}'),
('config.entity.key_store.entity_view_display', 'uuid:49e9fcc5-c6e0-42eb-b6d1-c27c4d48edb8', 'a:1:{i:0;s:42:"core.entity_view_display.user.user.compact";}'),
('config.entity.key_store.entity_view_display', 'uuid:61dd8385-d13d-4143-ac08-a482edd18c64', 'a:1:{i:0;s:42:"core.entity_view_display.user.user.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:6d8d2384-7f8c-4c9e-bcf0-be33f2eed3ad', 'a:1:{i:0;s:41:"core.entity_view_display.node.article.rss";}'),
('config.entity.key_store.entity_view_display', 'uuid:7084985d-0c48-43e4-a7ca-47477fa0015c', 'a:1:{i:0;s:45:"core.entity_view_display.node.article.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:79cad384-2fe0-4ac9-87e5-c85417837561', 'a:1:{i:0;s:42:"core.entity_view_display.node.page.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:9e5ac929-589b-4354-baa5-472db76cbff8', 'a:1:{i:0;s:41:"core.entity_view_display.node.page.teaser";}'),
('config.entity.key_store.entity_view_display', 'uuid:a44b58b1-3a16-458b-8812-8d1849341b86', 'a:1:{i:0;s:52:"core.entity_view_display.block_content.basic.default";}'),
('config.entity.key_store.entity_view_display', 'uuid:e67c1834-989b-46d4-af84-d434954ce5aa', 'a:1:{i:0;s:48:"core.entity_view_display.comment.comment.default";}'),
('config.entity.key_store.entity_view_mode', 'uuid:19281bfd-4c0b-4b1c-bac6-d76b3920a0fe', 'a:1:{i:0;s:39:"core.entity_view_mode.node.search_index";}'),
('config.entity.key_store.entity_view_mode', 'uuid:30e9d73b-013d-4148-8815-44e2d0f7a832', 'a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}'),
('config.entity.key_store.entity_view_mode', 'uuid:3163d64b-fe58-4295-ba61-2c31d8439e8c', 'a:1:{i:0;s:40:"core.entity_view_mode.node.search_result";}'),
('config.entity.key_store.entity_view_mode', 'uuid:3777ff69-eb99-42b6-862a-311761752fb3', 'a:1:{i:0;s:34:"core.entity_view_mode.comment.full";}'),
('config.entity.key_store.entity_view_mode', 'uuid:3ea8bfc7-bcb6-49bb-9a77-dbbbec98cce4', 'a:1:{i:0;s:30:"core.entity_view_mode.node.rss";}'),
('config.entity.key_store.entity_view_mode', 'uuid:5c8ef4a5-8137-46f7-96a4-2405b537d3e1', 'a:1:{i:0;s:40:"core.entity_view_mode.taxonomy_term.full";}'),
('config.entity.key_store.entity_view_mode', 'uuid:7cf0b28a-b08f-48c9-a203-8fd2bcd37b48', 'a:1:{i:0;s:34:"core.entity_view_mode.user.compact";}'),
('config.entity.key_store.entity_view_mode', 'uuid:9712ea61-4524-4a11-9646-6939cc07f6ee', 'a:1:{i:0;s:40:"core.entity_view_mode.block_content.full";}'),
('config.entity.key_store.entity_view_mode', 'uuid:a7f72fa1-6515-4213-9b2d-60e79c402274', 'a:1:{i:0;s:31:"core.entity_view_mode.user.full";}'),
('config.entity.key_store.entity_view_mode', 'uuid:ac828f09-37a7-490e-90b7-c0a2c264e404', 'a:1:{i:0;s:31:"core.entity_view_mode.node.full";}'),
('config.entity.key_store.field_config', 'uuid:0de65d6d-ae9c-409c-9a6d-c4e3c72828a5', 'a:1:{i:0;s:40:"field.field.comment.comment.comment_body";}'),
('config.entity.key_store.field_config', 'uuid:23b0dad8-62ee-48fd-8f69-5d5499e6ebe6', 'a:1:{i:0;s:29:"field.field.node.article.body";}'),
('config.entity.key_store.field_config', 'uuid:335cccdd-6d9b-4c99-99ee-a5a9d87d5428', 'a:1:{i:0;s:26:"field.field.node.page.body";}'),
('config.entity.key_store.field_config', 'uuid:538aec69-54b4-4c20-b500-fd6f69b71fc4', 'a:1:{i:0;s:32:"field.field.node.article.comment";}'),
('config.entity.key_store.field_config', 'uuid:57bf3544-0aed-4537-961f-ec8fbf43d56a', 'a:1:{i:0;s:35:"field.field.node.article.field_tags";}'),
('config.entity.key_store.field_config', 'uuid:989c1a7a-8afb-4e4c-9147-4f4c3aef2fc9', 'a:1:{i:0;s:34:"field.field.user.user.user_picture";}'),
('config.entity.key_store.field_config', 'uuid:a32fc862-d85e-4041-b7e4-56aa3f47ae4b', 'a:1:{i:0;s:36:"field.field.block_content.basic.body";}'),
('config.entity.key_store.field_config', 'uuid:c7055c45-2e00-418a-b3c3-59214d19d1dc', 'a:1:{i:0;s:36:"field.field.node.article.field_image";}'),
('config.entity.key_store.field_storage_config', 'uuid:3c619f34-8241-489a-b3f6-7acb3af2e10b', 'a:1:{i:0;s:29:"field.storage.node.field_tags";}'),
('config.entity.key_store.field_storage_config', 'uuid:82226e61-a370-4e28-928c-9dfce10d7c0b', 'a:1:{i:0;s:34:"field.storage.comment.comment_body";}'),
('config.entity.key_store.field_storage_config', 'uuid:a6ca6360-6e0c-4a92-a944-15bf37fde198', 'a:1:{i:0;s:23:"field.storage.node.body";}'),
('config.entity.key_store.field_storage_config', 'uuid:b52fd2fa-b3d1-45f4-8ac7-52a7e90a9fdc', 'a:1:{i:0;s:30:"field.storage.node.field_image";}'),
('config.entity.key_store.field_storage_config', 'uuid:c7a22ee7-de36-4f0c-8c0c-7ccd115c015b', 'a:1:{i:0;s:26:"field.storage.node.comment";}'),
('config.entity.key_store.field_storage_config', 'uuid:d3f48260-50f5-499c-bf7e-61dc35431d97', 'a:1:{i:0;s:32:"field.storage.block_content.body";}'),
('config.entity.key_store.field_storage_config', 'uuid:e5277c22-8a09-42ab-9808-dae455e3b895', 'a:1:{i:0;s:31:"field.storage.user.user_picture";}'),
('config.entity.key_store.filter_format', 'uuid:0943672d-ea16-4240-805f-0668ce7b6560', 'a:1:{i:0;s:23:"filter.format.full_html";}'),
('config.entity.key_store.filter_format', 'uuid:e6cb0308-805d-4b04-906d-69baad9d95fb', 'a:1:{i:0;s:29:"filter.format.restricted_html";}'),
('config.entity.key_store.filter_format', 'uuid:ebdb6db1-2c16-40e5-b7c7-f3069447e5d8', 'a:1:{i:0;s:24:"filter.format.plain_text";}'),
('config.entity.key_store.filter_format', 'uuid:f3dfa71d-702d-4d86-b5c7-5fce05633753', 'a:1:{i:0;s:24:"filter.format.basic_html";}'),
('config.entity.key_store.image_style', 'uuid:258cb9cd-abda-49c2-b59c-2c7fca89cc23', 'a:1:{i:0;s:18:"image.style.medium";}'),
('config.entity.key_store.image_style', 'uuid:35a14c3a-b96b-4a7c-bf5b-822709d002b6', 'a:1:{i:0;s:17:"image.style.large";}'),
('config.entity.key_store.image_style', 'uuid:e18b659f-c06b-471d-8897-2cb82292dc24', 'a:1:{i:0;s:21:"image.style.thumbnail";}'),
('config.entity.key_store.image_style', 'uuid:fccebbc5-bcb5-4c9c-b6f3-52f6db75ec89', 'a:1:{i:0;s:16:"image.style.wide";}'),
('config.entity.key_store.menu', 'uuid:0dea0a7b-11dd-42e4-8b00-4785e61e0254', 'a:1:{i:0;s:17:"system.menu.tools";}'),
('config.entity.key_store.menu', 'uuid:235a132e-19d1-47f0-b176-95965a47dc9d', 'a:1:{i:0;s:18:"system.menu.footer";}'),
('config.entity.key_store.menu', 'uuid:4f0ce0c2-4cda-43fe-9841-61ce1f833185', 'a:1:{i:0;s:17:"system.menu.admin";}'),
('config.entity.key_store.menu', 'uuid:89af7f3b-5160-4749-a547-67b77e97931a', 'a:1:{i:0;s:19:"system.menu.account";}'),
('config.entity.key_store.menu', 'uuid:ced03791-fd16-4b35-a82b-ba02195e8542', 'a:1:{i:0;s:16:"system.menu.main";}'),
('config.entity.key_store.node_type', 'uuid:6b3743ec-a515-4a8f-a20d-73cfbc86c43d', 'a:1:{i:0;s:17:"node.type.article";}'),
('config.entity.key_store.node_type', 'uuid:c27c63a0-6743-411d-b890-26b6953f746d', 'a:1:{i:0;s:14:"node.type.page";}'),
('config.entity.key_store.search_page', 'uuid:4daf9186-72d5-4b07-98d6-9e64ab8e7443', 'a:1:{i:0;s:23:"search.page.node_search";}'),
('config.entity.key_store.search_page', 'uuid:6acc91f3-2808-43b8-956c-6c9ec57a2f5a', 'a:1:{i:0;s:23:"search.page.user_search";}'),
('config.entity.key_store.search_page', 'uuid:de7580a4-9320-47be-abdc-c717dcb874f7', 'a:1:{i:0;s:23:"search.page.help_search";}'),
('config.entity.key_store.shortcut_set', 'uuid:812e013a-4ca9-4ca3-8fd6-08ac3f632ce6', 'a:1:{i:0;s:20:"shortcut.set.default";}'),
('config.entity.key_store.taxonomy_vocabulary', 'uuid:b2932e3b-5f8b-4847-a70b-cf08b0aae5da', 'a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}'),
('config.entity.key_store.user_role', 'uuid:09c90c57-06f1-4689-a04b-fe1b6e025e98', 'a:1:{i:0;s:24:"user.role.content_editor";}'),
('config.entity.key_store.user_role', 'uuid:60b01fb2-c502-4c22-aa7e-0a7dfa56b164', 'a:1:{i:0;s:23:"user.role.authenticated";}'),
('config.entity.key_store.user_role', 'uuid:b1044a22-b35d-4389-8a8f-8fccbafdb543', 'a:1:{i:0;s:23:"user.role.administrator";}'),
('config.entity.key_store.user_role', 'uuid:baec04dc-2816-45fc-9df7-03102e568922', 'a:1:{i:0;s:19:"user.role.anonymous";}'),
('config.entity.key_store.view', 'uuid:17be1b85-2fa5-42eb-a206-ad3bb89a71b3', 'a:1:{i:0;s:16:"views.view.files";}'),
('config.entity.key_store.view', 'uuid:4774c894-d515-44f9-9109-48415c9f10be', 'a:1:{i:0;s:19:"views.view.glossary";}'),
('config.entity.key_store.view', 'uuid:625c1d00-619c-402e-91a8-4991879c28cc', 'a:1:{i:0;s:24:"views.view.block_content";}'),
('config.entity.key_store.view', 'uuid:811fa183-e3f7-47d6-8b4f-7328c04e30b6', 'a:1:{i:0;s:20:"views.view.who_s_new";}'),
('config.entity.key_store.view', 'uuid:8807e88b-e554-4d63-a22d-7ab2172449c3', 'a:1:{i:0;s:23:"views.view.who_s_online";}'),
('config.entity.key_store.view', 'uuid:98e6d44c-471e-4adb-8e5b-bede0826fab0', 'a:1:{i:0;s:24:"views.view.taxonomy_term";}'),
('config.entity.key_store.view', 'uuid:a40530d5-e959-4383-a67a-ec8005553b35', 'a:1:{i:0;s:18:"views.view.comment";}'),
('config.entity.key_store.view', 'uuid:aa65fa57-33c9-4660-ac81-1033729ddf18', 'a:1:{i:0;s:18:"views.view.content";}'),
('config.entity.key_store.view', 'uuid:b7e1370e-264d-4e83-aabe-c65c522578bf', 'a:1:{i:0;s:25:"views.view.content_recent";}'),
('config.entity.key_store.view', 'uuid:cf63099b-31e0-4639-92be-32892f368594', 'a:1:{i:0;s:26:"views.view.comments_recent";}'),
('config.entity.key_store.view', 'uuid:dfbb06a2-9f9c-4d18-bd36-42a226b664bf', 'a:1:{i:0;s:19:"views.view.watchdog";}'),
('config.entity.key_store.view', 'uuid:e3f50aa4-3fb5-435d-ad09-a72b8c080912', 'a:1:{i:0;s:18:"views.view.archive";}'),
('config.entity.key_store.view', 'uuid:e872479a-08cd-49b2-990a-89aaf849e5a2', 'a:1:{i:0;s:28:"views.view.user_admin_people";}'),
('config.entity.key_store.view', 'uuid:ed7a5af8-78fd-4cee-b91e-a798406c9cd2', 'a:1:{i:0;s:20:"views.view.frontpage";}'),
('entity.definitions.bundle_field_map', 'block_content', 'a:1:{s:4:"body";a:2:{s:4:"type";s:17:"text_with_summary";s:7:"bundles";a:1:{s:5:"basic";s:5:"basic";}}}'),
('entity.definitions.bundle_field_map', 'comment', 'a:1:{s:12:"comment_body";a:2:{s:4:"type";s:9:"text_long";s:7:"bundles";a:1:{s:7:"comment";s:7:"comment";}}}'),
('entity.definitions.bundle_field_map', 'node', 'a:4:{s:11:"field_image";a:2:{s:4:"type";s:5:"image";s:7:"bundles";a:1:{s:7:"article";s:7:"article";}}s:7:"comment";a:2:{s:4:"type";s:7:"comment";s:7:"bundles";a:1:{s:7:"article";s:7:"article";}}s:10:"field_tags";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:7:"article";s:7:"article";}}s:4:"body";a:2:{s:4:"type";s:17:"text_with_summary";s:7:"bundles";a:2:{s:4:"page";s:4:"page";s:7:"article";s:7:"article";}}}'),
('entity.definitions.bundle_field_map', 'user', 'a:1:{s:12:"user_picture";a:2:{s:4:"type";s:5:"image";s:7:"bundles";a:1:{s:4:"user";s:4:"user";}}}'),
('entity.definitions.installed', 'action.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:6:"action";s:8:"\0*\0class";s:27:"Drupal\\system\\Entity\\Action";s:11:"\0*\0provider";s:6:"system";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:27:"Drupal\\system\\Entity\\Action";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:27:"Drupal\\system\\Entity\\Action";}s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:18:"administer actions";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Action";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Actions";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"action";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"actions";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:13:"@count action";s:6:"plural";s:14:"@count actions";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"config:action_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:4:"type";i:3;s:6:"plugin";i:4;s:13:"configuration";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'base_field_override.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:19:"base_field_override";s:8:"\0*\0class";s:42:"Drupal\\Core\\Field\\Entity\\BaseFieldOverride";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:42:"Drupal\\Core\\Field\\Entity\\BaseFieldOverride";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:42:"Drupal\\Core\\Field\\Entity\\BaseFieldOverride";}s:11:"\0*\0handlers";a:2:{s:7:"storage";s:42:"Drupal\\Core\\Field\\BaseFieldOverrideStorage";s:6:"access";s:55:"Drupal\\Core\\Field\\BaseFieldOverrideAccessControlHandler";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Base field override";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";N;s:15:"\0*\0label_plural";N;s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:base_field_override_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:5:{i:0;s:2:"id";i:1;s:11:"entity_type";i:2;s:6:"bundle";i:3;s:10:"field_name";i:4;s:10:"field_type";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:19:"base_field_override";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:6:"bundle";i:4;s:5:"label";i:5;s:11:"description";i:6;s:8:"required";i:7;s:12:"translatable";i:8;s:13:"default_value";i:9;s:22:"default_value_callback";i:10;s:8:"settings";i:11;s:10:"field_type";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'block.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:5:"block";s:8:"\0*\0class";s:25:"Drupal\\block\\Entity\\Block";s:11:"\0*\0provider";s:5:"block";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:25:"Drupal\\block\\Entity\\Block";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:25:"Drupal\\block\\Entity\\Block";}s:11:"\0*\0handlers";a:5:{s:6:"access";s:38:"Drupal\\block\\BlockAccessControlHandler";s:12:"view_builder";s:29:"Drupal\\block\\BlockViewBuilder";s:12:"list_builder";s:29:"Drupal\\block\\BlockListBuilder";s:4:"form";a:2:{s:7:"default";s:22:"Drupal\\block\\BlockForm";s:6:"delete";s:33:"Drupal\\block\\Form\\BlockDeleteForm";}s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:17:"administer blocks";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:11:"delete-form";s:44:"/admin/structure/block/manage/{block}/delete";s:9:"edit-form";s:37:"/admin/structure/block/manage/{block}";s:6:"enable";s:44:"/admin/structure/block/manage/{block}/enable";s:7:"disable";s:45:"/admin/structure/block/manage/{block}/disable";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:12:"@count block";s:6:"plural";s:13:"@count blocks";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:17:"config:block_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:2:{i:0;s:5:"theme";i:1;s:4:"uuid";}s:16:"\0*\0config_export";a:8:{i:0;s:2:"id";i:1;s:5:"theme";i:2;s:6:"region";i:3;s:6:"weight";i:4;s:8:"provider";i:5;s:6:"plugin";i:6;s:8:"settings";i:7;s:10:"visibility";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'block_content.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:5:"\0*\0id";s:13:"block_content";s:8:"\0*\0class";s:40:"Drupal\\block_content\\Entity\\BlockContent";s:11:"\0*\0provider";s:13:"block_content";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:0;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:8:"revision";s:11:"revision_id";s:6:"bundle";s:4:"type";s:5:"label";s:4:"info";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:40:"Drupal\\block_content\\Entity\\BlockContent";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:40:"Drupal\\block_content\\Entity\\BlockContent";}s:11:"\0*\0handlers";a:9:{s:7:"storage";s:46:"Drupal\\Core\\Entity\\Sql\\SqlContentEntityStorage";s:14:"storage_schema";s:46:"Drupal\\block_content\\BlockContentStorageSchema";s:6:"access";s:53:"Drupal\\block_content\\BlockContentAccessControlHandler";s:12:"list_builder";s:44:"Drupal\\block_content\\BlockContentListBuilder";s:12:"view_builder";s:44:"Drupal\\block_content\\BlockContentViewBuilder";s:10:"views_data";s:42:"Drupal\\block_content\\BlockContentViewsData";s:4:"form";a:6:{s:3:"add";s:37:"Drupal\\block_content\\BlockContentForm";s:4:"edit";s:37:"Drupal\\block_content\\BlockContentForm";s:6:"delete";s:48:"Drupal\\block_content\\Form\\BlockContentDeleteForm";s:7:"default";s:37:"Drupal\\block_content\\BlockContentForm";s:15:"revision-delete";s:42:"Drupal\\Core\\Entity\\Form\\RevisionDeleteForm";s:15:"revision-revert";s:42:"Drupal\\Core\\Entity\\Form\\RevisionRevertForm";}s:14:"route_provider";a:2:{s:4:"html";s:54:"Drupal\\block_content\\Routing\\BlockContentRouteProvider";s:8:"revision";s:52:"Drupal\\Core\\Entity\\Routing\\RevisionHtmlRouteProvider";}s:11:"translation";s:51:"Drupal\\block_content\\BlockContentTranslationHandler";}s:19:"\0*\0admin_permission";s:24:"administer block content";s:24:"\0*\0collection_permission";s:20:"access block library";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:10:{s:8:"add-page";s:10:"/block/add";s:8:"add-form";s:31:"/block/add/{block_content_type}";s:9:"canonical";s:36:"/admin/content/block/{block_content}";s:11:"delete-form";s:43:"/admin/content/block/{block_content}/delete";s:9:"edit-form";s:36:"/admin/content/block/{block_content}";s:10:"collection";s:20:"/admin/content/block";s:6:"create";s:6:"/block";s:20:"revision-delete-form";s:77:"/admin/content/block/{block_content}/revision/{block_content_revision}/delete";s:20:"revision-revert-form";s:77:"/admin/content/block/{block_content}/revision/{block_content_revision}/revert";s:15:"version-history";s:46:"/admin/content/block/{block_content}/revisions";}s:21:"\0*\0bundle_entity_type";s:18:"block_content_type";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Block type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:13:"block_content";s:22:"\0*\0revision_data_table";s:28:"block_content_field_revision";s:17:"\0*\0revision_table";s:22:"block_content_revision";s:13:"\0*\0data_table";s:24:"block_content_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:1;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Content block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Content blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"content block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"content blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:20:"@count content block";s:6:"plural";s:21:"@count content blocks";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:35:"entity.block_content_type.edit_form";s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"block_content_list";}s:14:"\0*\0constraints";a:2:{s:26:"EntityUntranslatableFields";N;s:25:"BlockContentEntityChanged";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:4:{s:13:"revision_user";s:13:"revision_user";s:16:"revision_created";s:16:"revision_created";s:20:"revision_log_message";s:12:"revision_log";s:16:"revision_default";s:16:"revision_default";}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'block_content.field_storage_definitions', 'a:16:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Content block ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:21:"The content block ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:2:"id";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The content block UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"The revision ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:32:"The content block language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:115;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Block type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"The block type.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:4:"type";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:18:"block_content_type";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:155;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision create time";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:16:"revision_created";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:193;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:13:"revision_user";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Revision user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:13:"revision_user";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:223;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"revision_log";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision log message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:54:"The log entry explaining the changes in this revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:25;s:8:"settings";a:1:{s:4:"rows";i:4;}}}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:12:"revision_log";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:260;}s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:6:"status";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:302;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"info";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Block description";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"A brief description of your block.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"required";b:1;s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:4:"info";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:341;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:48:"The time that the content block was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:384;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"reusable";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Reusable";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"A boolean indicating whether this block is reusable.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:0;s:12:"revisionable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:8:"reusable";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:415;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:458;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:501;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:543;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"body";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";N;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:18:"block_content.body";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"d3f48260-50f5-499c-bf7e-61dc35431d97";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc";}s:14:"\0*\0trustedData";b:0;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"text";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:18:"block_content.body";s:13:"\0*\0field_name";s:4:"body";s:14:"\0*\0entity_type";s:13:"block_content";s:7:"\0*\0type";s:17:"text_with_summary";s:9:"\0*\0module";s:4:"text";s:11:"\0*\0settings";a:0:{}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:18:"block_content.body";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"d3f48260-50f5-499c-bf7e-61dc35431d97";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"text";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:18:"block_content.body";s:13:"\0*\0field_name";s:4:"body";s:14:"\0*\0entity_type";s:13:"block_content";s:7:"\0*\0type";s:17:"text_with_summary";s:9:"\0*\0module";s:4:"text";s:11:"\0*\0settings";a:0:{}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}}'),
('entity.definitions.installed', 'block_content_type.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:18:"block_content_type";s:8:"\0*\0class";s:44:"Drupal\\block_content\\Entity\\BlockContentType";s:11:"\0*\0provider";s:13:"block_content";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:44:"Drupal\\block_content\\Entity\\BlockContentType";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:44:"Drupal\\block_content\\Entity\\BlockContentType";}s:11:"\0*\0handlers";a:5:{s:6:"access";s:50:"Drupal\\block_content\\BlockTypeAccessControlHandler";s:4:"form";a:4:{s:7:"default";s:41:"Drupal\\block_content\\BlockContentTypeForm";s:3:"add";s:41:"Drupal\\block_content\\BlockContentTypeForm";s:4:"edit";s:41:"Drupal\\block_content\\BlockContentTypeForm";s:6:"delete";s:52:"Drupal\\block_content\\Form\\BlockContentTypeDeleteForm";}s:14:"route_provider";a:2:{s:4:"html";s:58:"Drupal\\block_content\\Routing\\BlockContentTypeRouteProvider";s:11:"permissions";s:49:"Drupal\\user\\Entity\\EntityPermissionsRouteProvider";}s:12:"list_builder";s:48:"Drupal\\block_content\\BlockContentTypeListBuilder";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:22:"administer block types";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:5:{s:8:"add-form";s:34:"/admin/structure/block-content/add";s:11:"delete-form";s:65:"/admin/structure/block-content/manage/{block_content_type}/delete";s:9:"edit-form";s:58:"/admin/structure/block-content/manage/{block_content_type}";s:23:"entity-permissions-form";s:70:"/admin/structure/block-content/manage/{block_content_type}/permissions";s:10:"collection";s:30:"/admin/structure/block-content";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:13:"block_content";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Block type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Block types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"block type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"block types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:17:"@count block type";s:6:"plural";s:18:"@count block types";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:30:"config:block_content_type_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:4:"type";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:8:"revision";i:3;s:11:"description";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'comment.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:5:"\0*\0id";s:7:"comment";s:8:"\0*\0class";s:29:"Drupal\\comment\\Entity\\Comment";s:11:"\0*\0provider";s:7:"comment";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:3:"cid";s:6:"bundle";s:12:"comment_type";s:5:"label";s:7:"subject";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:5:"owner";s:3:"uid";s:8:"revision";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:29:"Drupal\\comment\\Entity\\Comment";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:29:"Drupal\\comment\\Entity\\Comment";}s:11:"\0*\0handlers";a:8:{s:7:"storage";s:29:"Drupal\\comment\\CommentStorage";s:14:"storage_schema";s:35:"Drupal\\comment\\CommentStorageSchema";s:6:"access";s:42:"Drupal\\comment\\CommentAccessControlHandler";s:12:"list_builder";s:36:"Drupal\\Core\\Entity\\EntityListBuilder";s:12:"view_builder";s:33:"Drupal\\comment\\CommentViewBuilder";s:10:"views_data";s:31:"Drupal\\comment\\CommentViewsData";s:4:"form";a:2:{s:7:"default";s:26:"Drupal\\comment\\CommentForm";s:6:"delete";s:30:"Drupal\\comment\\Form\\DeleteForm";}s:11:"translation";s:40:"Drupal\\comment\\CommentTranslationHandler";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:5:{s:9:"canonical";s:18:"/comment/{comment}";s:11:"delete-form";s:25:"/comment/{comment}/delete";s:20:"delete-multiple-form";s:29:"/admin/content/comment/delete";s:9:"edit-form";s:23:"/comment/{comment}/edit";s:6:"create";s:8:"/comment";}s:21:"\0*\0bundle_entity_type";s:12:"comment_type";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Comment type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:7:"comment";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";s:18:"comment_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Comment";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"comment";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"comments";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:14:"@count comment";s:6:"plural";s:15:"@count comments";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:29:"entity.comment_type.edit_form";s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:12:"comment_list";}s:14:"\0*\0constraints";a:3:{s:11:"CommentName";a:0:{}s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'comment.field_storage_definitions', 'a:20:{s:3:"cid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Comment ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"The comment ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:3:"cid";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"The comment UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"The comment language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"comment_type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Comment Type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"The comment type.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:12:"comment_type";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:12:"comment_type";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:116;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:22:"default_value_callback";s:47:"Drupal\\comment\\Entity\\Comment::getDefaultStatus";s:8:"provider";s:7:"comment";s:10:"field_name";s:6:"status";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:154;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"User ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:22:"default_value_callback";s:52:"Drupal\\comment\\Entity\\Comment::getDefaultEntityOwner";s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"The user ID of the comment author.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:194;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"pid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Parent ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:54:"The parent comment ID if this is a reply to a comment.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:3:"pid";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:7:"comment";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:232;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:9:"entity_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Entity ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:54:"The ID of the entity of which this comment is a reply.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:9:"entity_id";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"node";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:268;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"subject";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Subject";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:10;}s:12:"configurable";b:1;}}s:8:"provider";s:7:"comment";s:10:"field_name";s:7:"subject";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:64;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:305;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"The comment author''s name.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:8:"provider";s:7:"comment";s:10:"field_name";s:4:"name";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:60;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:342;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:60;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"mail";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Email";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The comment author''s email address.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:4:"mail";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:16:"field_item:email";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:380;}s:7:"\0*\0type";s:5:"email";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:7:"varchar";s:6:"length";i:254;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"homepage";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Homepage";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"The comment author''s home page address.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:8:"homepage";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:14:"field_item:uri";s:8:"settings";a:2:{s:10:"max_length";i:255;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:411;}s:7:"\0*\0type";s:3:"uri";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"hostname";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Hostname";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:30:"The comment author''s hostname.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:22:"default_value_callback";s:49:"Drupal\\comment\\Entity\\Comment::getDefaultHostname";s:8:"provider";s:7:"comment";s:10:"field_name";s:8:"hostname";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:445;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Created";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:38:"The time that the comment was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:7:"created";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:481;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:42:"The time that the comment was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:511;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"thread";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Thread place";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:144:"The alphadecimal representation of the comment''s place in a thread, consisting of a base 36 string prefixed by an integer indicating its length.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:6:"thread";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:541;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"entity_type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Entity type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The entity type to which this comment is attached.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:11:"entity_type";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:32;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:575;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:10:"field_name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"Comment field name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"The field name through which this comment was added.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:10:"field_name";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:32;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:610;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:7:"comment";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:645;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"comment_body";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";N;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:20:"comment.comment_body";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"82226e61-a370-4e28-928c-9dfce10d7c0b";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw";}s:14:"\0*\0trustedData";b:0;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"text";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:20:"comment.comment_body";s:13:"\0*\0field_name";s:12:"comment_body";s:14:"\0*\0entity_type";s:7:"comment";s:7:"\0*\0type";s:9:"text_long";s:9:"\0*\0module";s:4:"text";s:11:"\0*\0settings";a:0:{}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:20:"comment.comment_body";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"82226e61-a370-4e28-928c-9dfce10d7c0b";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"text";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:20:"comment.comment_body";s:13:"\0*\0field_name";s:12:"comment_body";s:14:"\0*\0entity_type";s:7:"comment";s:7:"\0*\0type";s:9:"text_long";s:9:"\0*\0module";s:4:"text";s:11:"\0*\0settings";a:0:{}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}}'),
('entity.definitions.installed', 'comment_type.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:12:"comment_type";s:8:"\0*\0class";s:33:"Drupal\\comment\\Entity\\CommentType";s:11:"\0*\0provider";s:7:"comment";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:33:"Drupal\\comment\\Entity\\CommentType";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:33:"Drupal\\comment\\Entity\\CommentType";}s:11:"\0*\0handlers";a:5:{s:4:"form";a:4:{s:7:"default";s:30:"Drupal\\comment\\CommentTypeForm";s:3:"add";s:30:"Drupal\\comment\\CommentTypeForm";s:4:"edit";s:30:"Drupal\\comment\\CommentTypeForm";s:6:"delete";s:41:"Drupal\\comment\\Form\\CommentTypeDeleteForm";}s:14:"route_provider";a:1:{s:11:"permissions";s:49:"Drupal\\user\\Entity\\EntityPermissionsRouteProvider";}s:12:"list_builder";s:37:"Drupal\\comment\\CommentTypeListBuilder";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:24:"administer comment types";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:5:{s:11:"delete-form";s:53:"/admin/structure/comment/manage/{comment_type}/delete";s:9:"edit-form";s:46:"/admin/structure/comment/manage/{comment_type}";s:8:"add-form";s:34:"/admin/structure/comment/types/add";s:23:"entity-permissions-form";s:58:"/admin/structure/comment/manage/{comment_type}/permissions";s:10:"collection";s:24:"/admin/structure/comment";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:7:"comment";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Comment type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"comment type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"comment types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:19:"@count comment type";s:6:"plural";s:20:"@count comment types";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:comment_type_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:4:"type";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:21:"target_entity_type_id";i:3;s:11:"description";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'date_format.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:11:"date_format";s:8:"\0*\0class";s:38:"Drupal\\Core\\Datetime\\Entity\\DateFormat";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:38:"Drupal\\Core\\Datetime\\Entity\\DateFormat";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:38:"Drupal\\Core\\Datetime\\Entity\\DateFormat";}s:11:"\0*\0handlers";a:4:{s:6:"access";s:44:"Drupal\\system\\DateFormatAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";s:4:"form";a:3:{s:3:"add";s:36:"Drupal\\system\\Form\\DateFormatAddForm";s:4:"edit";s:37:"Drupal\\system\\Form\\DateFormatEditForm";s:6:"delete";s:39:"Drupal\\system\\Form\\DateFormatDeleteForm";}s:12:"list_builder";s:35:"Drupal\\system\\DateFormatListBuilder";}s:19:"\0*\0admin_permission";s:29:"administer site configuration";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"edit-form";s:61:"/admin/config/regional/date-time/formats/manage/{date_format}";s:11:"delete-form";s:68:"/admin/config/regional/date-time/formats/manage/{date_format}/delete";s:10:"collection";s:40:"/admin/config/regional/date-time/formats";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Date format";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";N;s:15:"\0*\0label_plural";N;s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:8:"rendered";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"locked";i:3;s:7:"pattern";}s:21:"\0*\0mergedConfigExport";a:10:{s:4:"uuid";s:4:"uuid";s:8:"langcode";s:8:"langcode";s:6:"status";s:6:"status";s:12:"dependencies";s:12:"dependencies";s:20:"third_party_settings";s:20:"third_party_settings";s:5:"_core";s:5:"_core";s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:6:"locked";s:6:"locked";s:7:"pattern";s:7:"pattern";}}'),
('entity.definitions.installed', 'editor.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:6:"editor";s:8:"\0*\0class";s:27:"Drupal\\editor\\Entity\\Editor";s:11:"\0*\0provider";s:6:"editor";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:7:{s:2:"id";s:6:"format";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:27:"Drupal\\editor\\Entity\\Editor";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:27:"Drupal\\editor\\Entity\\Editor";}s:11:"\0*\0handlers";a:2:{s:6:"access";s:40:"Drupal\\editor\\EditorAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Text editor";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Text editors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"text editor";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"text editors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:18:"@count text editor";s:6:"plural";s:19:"@count text editors";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"config:editor_list";}s:14:"\0*\0constraints";a:1:{s:26:"RequiredConfigDependencies";a:1:{i:0;s:13:"filter_format";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:6:"format";i:1;s:6:"editor";i:2;s:8:"settings";i:3;s:12:"image_upload";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'entity_form_display.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:19:"entity_form_display";s:8:"\0*\0class";s:43:"Drupal\\Core\\Entity\\Entity\\EntityFormDisplay";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:43:"Drupal\\Core\\Entity\\Entity\\EntityFormDisplay";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:43:"Drupal\\Core\\Entity\\Entity\\EntityFormDisplay";}s:11:"\0*\0handlers";a:2:{s:6:"access";s:70:"Drupal\\Core\\Entity\\Entity\\Access\\EntityFormDisplayAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Entity form display";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";N;s:15:"\0*\0label_plural";N;s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:entity_form_display_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:4:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:6:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";i:4;s:7:"content";i:5;s:6:"hidden";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'entity_form_mode.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:16:"entity_form_mode";s:8:"\0*\0class";s:40:"Drupal\\Core\\Entity\\Entity\\EntityFormMode";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:11:"description";s:11:"description";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:40:"Drupal\\Core\\Entity\\Entity\\EntityFormMode";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:40:"Drupal\\Core\\Entity\\Entity\\EntityFormMode";}s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Form mode";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";N;s:15:"\0*\0label_plural";N;s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:28:"config:entity_form_mode_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:2:{i:0;s:2:"id";i:1;s:16:"targetEntityType";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:16:"targetEntityType";i:4;s:5:"cache";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'entity_view_display.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:19:"entity_view_display";s:8:"\0*\0class";s:43:"Drupal\\Core\\Entity\\Entity\\EntityViewDisplay";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:43:"Drupal\\Core\\Entity\\Entity\\EntityViewDisplay";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:43:"Drupal\\Core\\Entity\\Entity\\EntityViewDisplay";}s:11:"\0*\0handlers";a:2:{s:6:"access";s:70:"Drupal\\Core\\Entity\\Entity\\Access\\EntityViewDisplayAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Entity view display";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";N;s:15:"\0*\0label_plural";N;s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:entity_view_display_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:4:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:6:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";i:4;s:7:"content";i:5;s:6:"hidden";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'entity_view_mode.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:16:"entity_view_mode";s:8:"\0*\0class";s:40:"Drupal\\Core\\Entity\\Entity\\EntityViewMode";s:11:"\0*\0provider";s:4:"core";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:11:"description";s:11:"description";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:40:"Drupal\\Core\\Entity\\Entity\\EntityViewMode";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:40:"Drupal\\Core\\Entity\\Entity\\EntityViewMode";}s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"View mode";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";N;s:17:"\0*\0label_singular";N;s:15:"\0*\0label_plural";N;s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:28:"config:entity_view_mode_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:2:{i:0;s:2:"id";i:1;s:16:"targetEntityType";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:16:"targetEntityType";i:4;s:5:"cache";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'field_config.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:12:"field_config";s:8:"\0*\0class";s:31:"Drupal\\field\\Entity\\FieldConfig";s:11:"\0*\0provider";s:5:"field";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:31:"Drupal\\field\\Entity\\FieldConfig";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:31:"Drupal\\field\\Entity\\FieldConfig";}s:11:"\0*\0handlers";a:2:{s:6:"access";s:44:"Drupal\\field\\FieldConfigAccessControlHandler";s:7:"storage";s:31:"Drupal\\field\\FieldConfigStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Field";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Fields";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"field";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"fields";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:12:"@count field";s:6:"plural";s:13:"@count fields";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:field_config_list";}s:14:"\0*\0constraints";a:2:{s:26:"RequiredConfigDependencies";a:1:{i:0;s:20:"field_storage_config";}s:19:"ImmutableProperties";a:5:{i:0;s:2:"id";i:1;s:11:"entity_type";i:2;s:10:"field_name";i:3;s:6:"bundle";i:4;s:10:"field_type";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:5:"field";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:6:"bundle";i:4;s:5:"label";i:5;s:11:"description";i:6;s:8:"required";i:7;s:12:"translatable";i:8;s:13:"default_value";i:9;s:22:"default_value_callback";i:10;s:8:"settings";i:11;s:10:"field_type";}s:21:"\0*\0mergedConfigExport";a:0:{}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'field_storage_config.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:20:"field_storage_config";s:8:"\0*\0class";s:38:"Drupal\\field\\Entity\\FieldStorageConfig";s:11:"\0*\0provider";s:5:"field";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:2:"id";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:38:"Drupal\\field\\Entity\\FieldStorageConfig";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:38:"Drupal\\field\\Entity\\FieldStorageConfig";}s:11:"\0*\0handlers";a:2:{s:6:"access";s:51:"Drupal\\field\\FieldStorageConfigAccessControlHandler";s:7:"storage";s:38:"Drupal\\field\\FieldStorageConfigStorage";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Field storage";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Field storages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"field storage";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"field storages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:20:"@count field storage";s:6:"plural";s:21:"@count field storages";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:32:"config:field_storage_config_list";}s:14:"\0*\0constraints";a:1:{s:19:"ImmutableProperties";a:4:{i:0;s:2:"id";i:1;s:11:"entity_type";i:2;s:10:"field_name";i:3;s:4:"type";}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:7:"storage";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:4:"type";i:4;s:8:"settings";i:5;s:6:"module";i:6;s:6:"locked";i:7;s:11:"cardinality";i:8;s:12:"translatable";i:9;s:7:"indexes";i:10;s:22:"persist_with_no_fields";i:11;s:14:"custom_storage";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'file.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:5:"\0*\0id";s:4:"file";s:8:"\0*\0class";s:23:"Drupal\\file\\Entity\\File";s:11:"\0*\0provider";s:4:"file";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:3:"fid";s:5:"label";s:8:"filename";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:5:"owner";s:3:"uid";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:23:"Drupal\\file\\Entity\\File";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:23:"Drupal\\file\\Entity\\File";}s:11:"\0*\0handlers";a:9:{s:7:"storage";s:23:"Drupal\\file\\FileStorage";s:14:"storage_schema";s:29:"Drupal\\file\\FileStorageSchema";s:6:"access";s:36:"Drupal\\file\\FileAccessControlHandler";s:10:"views_data";s:25:"Drupal\\file\\FileViewsData";s:12:"list_builder";s:36:"Drupal\\Core\\Entity\\EntityListBuilder";s:4:"form";a:1:{s:6:"delete";s:42:"Drupal\\Core\\Entity\\ContentEntityDeleteForm";}s:14:"route_provider";a:1:{s:4:"html";s:36:"Drupal\\file\\Entity\\FileRouteProvider";}s:11:"link_target";a:2:{s:4:"view";s:33:"Drupal\\file\\Entity\\FileLinkTarget";s:8:"download";s:33:"Drupal\\file\\Entity\\FileLinkTarget";}s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:1:{s:11:"delete-form";s:19:"/file/{file}/delete";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:12:"file_managed";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"File";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Files";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"file";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"files";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:11:"@count file";s:6:"plural";s:12:"@count files";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:9:"file_list";}s:14:"\0*\0constraints";a:2:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'file.field_storage_definitions', 'a:11:{s:3:"fid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"File ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"The file ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:3:"fid";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"The file UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The file language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"User ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:0;s:22:"default_value_callback";s:46:"Drupal\\file\\Entity\\File::getDefaultEntityOwner";s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"The user ID of the file.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:115;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"filename";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Filename";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:41:"Name of the file with no path components.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"filename";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:153;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"uri";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"URI";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"The URI to access the file (either local or remote).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"constraints";a:1:{s:13:"FileUriUnique";N;}s:8:"provider";s:4:"file";s:10:"field_name";s:3:"uri";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:file_uri";s:8:"settings";a:2:{s:10:"max_length";i:255;s:14:"case_sensitive";b:1;}}s:18:"\0*\0fieldDefinition";r:187;}s:7:"\0*\0type";s:8:"file_uri";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:1;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"filemime";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"File MIME type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:21:"The file''s MIME type.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"filemime";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:222;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"filesize";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"File size";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:30:"The size of the file in bytes.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"filesize";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:3:"big";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:256;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Status";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:63:"The status of the file, temporary (FALSE) and permanent (TRUE).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:8:"provider";s:4:"file";s:10:"field_name";s:6:"status";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:293;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Created";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:40:"The timestamp that the file was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:7:"created";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:334;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:45:"The timestamp that the file was last changed.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:363;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}}'),
('entity.definitions.installed', 'filter_format.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:13:"filter_format";s:8:"\0*\0class";s:33:"Drupal\\filter\\Entity\\FilterFormat";s:11:"\0*\0provider";s:6:"filter";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:6:"format";s:5:"label";s:4:"name";s:6:"weight";s:6:"weight";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:33:"Drupal\\filter\\Entity\\FilterFormat";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:33:"Drupal\\filter\\Entity\\FilterFormat";}s:11:"\0*\0handlers";a:4:{s:4:"form";a:4:{s:3:"add";s:33:"Drupal\\filter\\FilterFormatAddForm";s:4:"edit";s:34:"Drupal\\filter\\FilterFormatEditForm";s:7:"disable";s:36:"Drupal\\filter\\Form\\FilterDisableForm";s:6:"enable";s:35:"Drupal\\filter\\Form\\FilterEnableForm";}s:12:"list_builder";s:37:"Drupal\\filter\\FilterFormatListBuilder";s:6:"access";s:46:"Drupal\\filter\\FilterFormatAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:18:"administer filters";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"edit-form";s:52:"/admin/config/content/formats/manage/{filter_format}";s:7:"disable";s:60:"/admin/config/content/formats/manage/{filter_format}/disable";s:6:"enable";s:59:"/admin/config/content/formats/manage/{filter_format}/enable";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Text format";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Text formats";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"text format";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"text formats";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:18:"@count text format";s:6:"plural";s:19:"@count text formats";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:25:"config:filter_format_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:6:"format";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:4:"name";i:1;s:6:"format";i:2;s:6:"weight";i:3;s:5:"roles";i:4;s:7:"filters";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'image_style.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:11:"image_style";s:8:"\0*\0class";s:30:"Drupal\\image\\Entity\\ImageStyle";s:11:"\0*\0provider";s:5:"image";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:4:"name";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:30:"Drupal\\image\\Entity\\ImageStyle";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:30:"Drupal\\image\\Entity\\ImageStyle";}s:11:"\0*\0handlers";a:4:{s:4:"form";a:4:{s:3:"add";s:35:"Drupal\\image\\Form\\ImageStyleAddForm";s:4:"edit";s:36:"Drupal\\image\\Form\\ImageStyleEditForm";s:6:"delete";s:38:"Drupal\\image\\Form\\ImageStyleDeleteForm";s:5:"flush";s:37:"Drupal\\image\\Form\\ImageStyleFlushForm";}s:12:"list_builder";s:34:"Drupal\\image\\ImageStyleListBuilder";s:7:"storage";s:30:"Drupal\\image\\ImageStyleStorage";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";}s:19:"\0*\0admin_permission";s:23:"administer image styles";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:10:"flush-form";s:59:"/admin/config/media/image-styles/manage/{image_style}/flush";s:9:"edit-form";s:53:"/admin/config/media/image-styles/manage/{image_style}";s:11:"delete-form";s:60:"/admin/config/media/image-styles/manage/{image_style}/delete";s:10:"collection";s:32:"/admin/config/media/image-styles";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Image style";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Image styles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"image style";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"image styles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:18:"@count image style";s:6:"plural";s:19:"@count image styles";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:23:"config:image_style_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:5:"style";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:3:{i:0;s:4:"name";i:1;s:5:"label";i:2;s:7:"effects";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'menu.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:4:"menu";s:8:"\0*\0class";s:25:"Drupal\\system\\Entity\\Menu";s:11:"\0*\0provider";s:6:"system";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:25:"Drupal\\system\\Entity\\Menu";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:25:"Drupal\\system\\Entity\\Menu";}s:11:"\0*\0handlers";a:2:{s:6:"access";s:38:"Drupal\\system\\MenuAccessControlHandler";s:7:"storage";s:25:"Drupal\\system\\MenuStorage";}s:19:"\0*\0admin_permission";s:15:"administer menu";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Menu";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Menus";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"menu";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"menus";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:11:"@count menu";s:6:"plural";s:12:"@count menus";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:16:"config:menu_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:6:"locked";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'menu_link_content.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:5:"\0*\0id";s:17:"menu_link_content";s:8:"\0*\0class";s:47:"Drupal\\menu_link_content\\Entity\\MenuLinkContent";s:11:"\0*\0provider";s:17:"menu_link_content";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:8:"revision";s:11:"revision_id";s:5:"label";s:5:"title";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:6:"bundle";s:6:"bundle";s:9:"published";s:7:"enabled";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:47:"Drupal\\menu_link_content\\Entity\\MenuLinkContent";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:47:"Drupal\\menu_link_content\\Entity\\MenuLinkContent";}s:11:"\0*\0handlers";a:8:{s:7:"storage";s:47:"Drupal\\menu_link_content\\MenuLinkContentStorage";s:14:"storage_schema";s:53:"Drupal\\menu_link_content\\MenuLinkContentStorageSchema";s:6:"access";s:60:"Drupal\\menu_link_content\\MenuLinkContentAccessControlHandler";s:4:"form";a:2:{s:7:"default";s:49:"Drupal\\menu_link_content\\Form\\MenuLinkContentForm";s:6:"delete";s:55:"Drupal\\menu_link_content\\Form\\MenuLinkContentDeleteForm";}s:11:"link_target";a:1:{s:4:"view";s:57:"Drupal\\menu_link_content\\Entity\\MenuLinkContentLinkTarget";}s:12:"list_builder";s:44:"Drupal\\menu_link_content\\MenuLinkListBuilder";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";s:10:"moderation";s:0:"";}s:19:"\0*\0admin_permission";s:15:"administer menu";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"canonical";s:51:"/admin/structure/menu/item/{menu_link_content}/edit";s:9:"edit-form";s:51:"/admin/structure/menu/item/{menu_link_content}/edit";s:11:"delete-form";s:53:"/admin/structure/menu/item/{menu_link_content}/delete";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:17:"menu_link_content";s:22:"\0*\0revision_data_table";s:32:"menu_link_content_field_revision";s:17:"\0*\0revision_table";s:26:"menu_link_content_revision";s:13:"\0*\0data_table";s:22:"menu_link_content_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Custom menu link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Custom menu links";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"custom menu link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"custom menu links";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:23:"@count custom menu link";s:6:"plural";s:24:"@count custom menu links";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:22:"menu_link_content_list";}s:14:"\0*\0constraints";a:3:{s:17:"MenuTreeHierarchy";a:0:{}s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:1:{s:17:"stringTranslation";s:18:"string_translation";}s:18:"\0*\0_entityStorages";a:0:{}s:25:"\0*\0revision_metadata_keys";a:4:{s:13:"revision_user";s:13:"revision_user";s:16:"revision_created";s:16:"revision_created";s:20:"revision_log_message";s:20:"revision_log_message";s:16:"revision_default";s:16:"revision_default";}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'menu_link_content.field_storage_definitions', 'a:22:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Entity ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:48:"The entity ID for this menu link content entity.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:2:"id";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:27:"The content menu link UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:28:"The menu link language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:111;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"bundle";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";s:23:"Custom menu link bundle";s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"The content menu link bundle.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:6:"bundle";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:32;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:151;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision create time";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:16:"revision_created";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:184;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:13:"revision_user";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Revision user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:13:"revision_user";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:214;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:20:"revision_log_message";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision log message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Briefly describe the changes you have made.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:20:"revision_log_message";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:251;}s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"enabled";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Enabled";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:65:"A flag for whether the link should be enabled in menus or hidden.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:7:"boolean";s:6:"weight";i:0;}}s:4:"form";a:1:{s:7:"options";a:2:{s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:-1;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:7:"enabled";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:290;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"title";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"Menu link title";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"translatable";b:1;s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:-5;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:5:"title";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:344;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"description";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Description";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"Shown when hovering over the menu link.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:0;}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:0;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:11:"description";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:388;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:9:"menu_name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Menu name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:93:"The menu name. All links with the same menu name (such as "tools") are part of the same menu.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:5:"tools";}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:9:"menu_name";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:434;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"link";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"required";b:1;s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:12:"link_default";s:6:"weight";i:-2;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:4:"link";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:link";s:8:"settings";a:2:{s:5:"title";i:0;s:9:"link_type";i:17;}}s:18:"\0*\0fieldDefinition";r:471;}s:7:"\0*\0type";s:4:"link";s:9:"\0*\0schema";a:4:{s:7:"columns";a:3:{s:3:"uri";a:3:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;}s:5:"title";a:3:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;}s:7:"options";a:4:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;}}s:7:"indexes";a:1:{s:3:"uri";a:1:{i:0;a:2:{i:0;s:3:"uri";i:1;i:30;}}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"external";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"External";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:120:"A flag to indicate if the link points to a full URL starting with a protocol, like http:// (1 = external, 0 = internal).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:8:"external";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:520;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:10:"rediscover";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:54:"Indicates whether the menu link should be rediscovered";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:10:"rediscover";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:562;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"weight";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Weight";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:172:"Link weight among links in the same menu at the same depth. In the menu, the links with high weight will sink and links with a low weight will be positioned nearer the top.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:14:"number_integer";s:6:"weight";i:0;}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:6:"number";s:6:"weight";i:20;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:6:"weight";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:599;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"expanded";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Show as expanded";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:164:"If selected and this menu link has children, the menu will always appear expanded. This option may be overridden for the entire menu tree when placing a menu block.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:7:"boolean";s:6:"weight";i:0;}}s:4:"form";a:1:{s:7:"options";a:2:{s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:0;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:8:"expanded";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:649;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"parent";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Parent plugin ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:94:"The ID of the parent menu link plugin, or empty string when at the top level of the hierarchy.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:6:"parent";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:701;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:44:"The time that the menu link was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:735;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:766;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:809;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:851;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}}'),
('entity.definitions.installed', 'node.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:5:"\0*\0id";s:4:"node";s:8:"\0*\0class";s:23:"Drupal\\node\\Entity\\Node";s:11:"\0*\0provider";s:4:"node";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:12:{s:2:"id";s:3:"nid";s:8:"revision";s:3:"vid";s:6:"bundle";s:4:"type";s:5:"label";s:5:"title";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:6:"status";s:6:"status";s:9:"published";s:6:"status";s:3:"uid";s:3:"uid";s:5:"owner";s:3:"uid";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:23:"Drupal\\node\\Entity\\Node";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:23:"Drupal\\node\\Entity\\Node";}s:11:"\0*\0handlers";a:9:{s:7:"storage";s:23:"Drupal\\node\\NodeStorage";s:14:"storage_schema";s:29:"Drupal\\node\\NodeStorageSchema";s:12:"view_builder";s:27:"Drupal\\node\\NodeViewBuilder";s:6:"access";s:36:"Drupal\\node\\NodeAccessControlHandler";s:10:"views_data";s:25:"Drupal\\node\\NodeViewsData";s:4:"form";a:4:{s:7:"default";s:25:"Drupal\\node\\Form\\NodeForm";s:6:"delete";s:31:"Drupal\\node\\Form\\NodeDeleteForm";s:4:"edit";s:25:"Drupal\\node\\Form\\NodeForm";s:23:"delete-multiple-confirm";s:31:"Drupal\\node\\Form\\DeleteMultiple";}s:14:"route_provider";a:1:{s:4:"html";s:36:"Drupal\\node\\Entity\\NodeRouteProvider";}s:12:"list_builder";s:27:"Drupal\\node\\NodeListBuilder";s:11:"translation";s:34:"Drupal\\node\\NodeTranslationHandler";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";s:23:"access content overview";s:25:"\0*\0permission_granularity";s:6:"bundle";s:8:"\0*\0links";a:9:{s:9:"canonical";s:12:"/node/{node}";s:8:"add-page";s:9:"/node/add";s:8:"add-form";s:21:"/node/add/{node_type}";s:9:"edit-form";s:17:"/node/{node}/edit";s:11:"delete-form";s:19:"/node/{node}/delete";s:20:"delete-multiple-form";s:26:"/admin/content/node/delete";s:15:"version-history";s:22:"/node/{node}/revisions";s:8:"revision";s:43:"/node/{node}/revisions/{node_revision}/view";s:6:"create";s:5:"/node";}s:21:"\0*\0bundle_entity_type";s:9:"node_type";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Content type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:4:"node";s:22:"\0*\0revision_data_table";s:19:"node_field_revision";s:17:"\0*\0revision_table";s:13:"node_revision";s:13:"\0*\0data_table";s:15:"node_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:1;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"content item";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"content items";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:19:"@count content item";s:6:"plural";s:20:"@count content items";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:26:"entity.node_type.edit_form";s:26:"\0*\0common_reference_target";b:1;s:22:"\0*\0list_cache_contexts";a:1:{i:0;s:21:"user.node_grants:view";}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:9:"node_list";}s:14:"\0*\0constraints";a:3:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;s:12:"MenuSettings";a:0:{}}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:4:{s:13:"revision_user";s:12:"revision_uid";s:16:"revision_created";s:18:"revision_timestamp";s:20:"revision_log_message";s:12:"revision_log";s:16:"revision_default";s:16:"revision_default";}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'node.field_storage_definitions', 'a:22:{s:3:"nid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:3:"nid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:36;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"vid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:3:"vid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:69;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:103;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";s:12:"Content type";s:8:"required";b:1;s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:4:"type";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:9:"node_type";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:139;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:18:"revision_timestamp";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision create time";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:18:"revision_timestamp";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:170;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"revision_uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Revision user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:12:"revision_uid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:200;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"revision_log";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision log message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Briefly describe the changes you have made.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:25;s:8:"settings";a:1:{s:4:"rows";i:4;}}}}s:8:"provider";s:4:"node";s:10:"field_name";s:12:"revision_log";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:237;}s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:120;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:6:"status";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:279;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Authored by";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:22:"default_value_callback";s:46:"Drupal\\node\\Entity\\Node::getDefaultEntityOwner";s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The username of the content author.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"author";s:6:"weight";i:0;}}s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:8:"settings";a:3:{s:14:"match_operator";s:8:"CONTAINS";s:4:"size";s:2:"60";s:11:"placeholder";s:0:"";}}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:326;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"title";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Title";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"translatable";b:1;s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:-5;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:5:"title";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:380;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Authored on";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The date and time that the content was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:9:"timestamp";s:6:"weight";i:0;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:7:"created";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:424;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"The time that the node was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:466;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"promote";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:22:"Promoted to front page";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:7:"promote";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:497;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"sticky";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:22:"Sticky at top of lists";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:6:"sticky";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:541;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:585;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:628;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:670;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"field_image";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";N;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:16:"node.field_image";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"b52fd2fa-b3d1-45f4-8ac7-52a7e90a9fdc";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"EymokncRIZ7SgQT2IdOQhQJicX4nNc0K89ik-LxmOHE";}s:14:"\0*\0trustedData";b:0;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"node";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:16:"node.field_image";s:13:"\0*\0field_name";s:11:"field_image";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:5:"image";s:9:"\0*\0module";s:5:"image";s:11:"\0*\0settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:10:"\0*\0deleted";b:0;}s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:16:"node.field_image";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"b52fd2fa-b3d1-45f4-8ac7-52a7e90a9fdc";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"EymokncRIZ7SgQT2IdOQhQJicX4nNc0K89ik-LxmOHE";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"node";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:16:"node.field_image";s:13:"\0*\0field_name";s:11:"field_image";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:5:"image";s:9:"\0*\0module";s:5:"image";s:11:"\0*\0settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:10:"\0*\0deleted";b:0;}s:7:"comment";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";N;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:12:"node.comment";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"c7a22ee7-de36-4f0c-8c0c-7ccd115c015b";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"ktCna9xmWvYZIUfOCUyDQvedn5RtnS4CRmEIwNmvYjc";}s:14:"\0*\0trustedData";b:0;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"node";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:12:"node.comment";s:13:"\0*\0field_name";s:7:"comment";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:7:"comment";s:9:"\0*\0module";s:7:"comment";s:11:"\0*\0settings";a:1:{s:12:"comment_type";s:7:"comment";}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:12:"node.comment";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"c7a22ee7-de36-4f0c-8c0c-7ccd115c015b";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"ktCna9xmWvYZIUfOCUyDQvedn5RtnS4CRmEIwNmvYjc";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"node";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:12:"node.comment";s:13:"\0*\0field_name";s:7:"comment";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:7:"comment";s:9:"\0*\0module";s:7:"comment";s:11:"\0*\0settings";a:1:{s:12:"comment_type";s:7:"comment";}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}s:10:"field_tags";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";N;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:15:"node.field_tags";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"3c619f34-8241-489a-b3f6-7acb3af2e10b";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs";}s:14:"\0*\0trustedData";b:0;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:15:"node.field_tags";s:13:"\0*\0field_name";s:10:"field_tags";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0module";s:4:"core";s:11:"\0*\0settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:14:"\0*\0cardinality";i:-1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:15:"node.field_tags";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"3c619f34-8241-489a-b3f6-7acb3af2e10b";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:15:"node.field_tags";s:13:"\0*\0field_name";s:10:"field_tags";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0module";s:4:"core";s:11:"\0*\0settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:14:"\0*\0cardinality";i:-1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}s:4:"body";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";N;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:9:"node.body";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"a6ca6360-6e0c-4a92-a944-15bf37fde198";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY";}s:14:"\0*\0trustedData";b:0;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:9:"node.body";s:13:"\0*\0field_name";s:4:"body";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:17:"text_with_summary";s:9:"\0*\0module";s:4:"text";s:11:"\0*\0settings";a:0:{}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:9:"node.body";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"a6ca6360-6e0c-4a92-a944-15bf37fde198";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:9:"node.body";s:13:"\0*\0field_name";s:4:"body";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:17:"text_with_summary";s:9:"\0*\0module";s:4:"text";s:11:"\0*\0settings";a:0:{}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;}}'),
('entity.definitions.installed', 'node_type.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:9:"node_type";s:8:"\0*\0class";s:27:"Drupal\\node\\Entity\\NodeType";s:11:"\0*\0provider";s:4:"node";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:4:"type";s:5:"label";s:4:"name";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:27:"Drupal\\node\\Entity\\NodeType";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:27:"Drupal\\node\\Entity\\NodeType";}s:11:"\0*\0handlers";a:5:{s:6:"access";s:40:"Drupal\\node\\NodeTypeAccessControlHandler";s:4:"form";a:3:{s:3:"add";s:29:"Drupal\\node\\Form\\NodeTypeForm";s:4:"edit";s:29:"Drupal\\node\\Form\\NodeTypeForm";s:6:"delete";s:38:"Drupal\\node\\Form\\NodeTypeDeleteConfirm";}s:14:"route_provider";a:1:{s:11:"permissions";s:49:"Drupal\\user\\Entity\\EntityPermissionsRouteProvider";}s:12:"list_builder";s:31:"Drupal\\node\\NodeTypeListBuilder";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:24:"administer content types";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:9:"edit-form";s:41:"/admin/structure/types/manage/{node_type}";s:11:"delete-form";s:48:"/admin/structure/types/manage/{node_type}/delete";s:23:"entity-permissions-form";s:53:"/admin/structure/types/manage/{node_type}/permissions";s:10:"collection";s:22:"/admin/structure/types";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:4:"node";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Content type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Content types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"content type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"content types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:19:"@count content type";s:6:"plural";s:20:"@count content types";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:21:"config:node_type_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:4:"type";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:7:{i:0;s:4:"name";i:1;s:4:"type";i:2;s:11:"description";i:3;s:4:"help";i:4;s:12:"new_revision";i:5;s:12:"preview_mode";i:6;s:17:"display_submitted";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'path_alias.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:5:"\0*\0id";s:10:"path_alias";s:8:"\0*\0class";s:34:"Drupal\\path_alias\\Entity\\PathAlias";s:11:"\0*\0provider";s:10:"path_alias";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:8:"revision";s:11:"revision_id";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:6:"bundle";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:34:"Drupal\\path_alias\\Entity\\PathAlias";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:34:"Drupal\\path_alias\\Entity\\PathAlias";}s:11:"\0*\0handlers";a:4:{s:7:"storage";s:34:"Drupal\\path_alias\\PathAliasStorage";s:14:"storage_schema";s:40:"Drupal\\path_alias\\PathAliasStorageSchema";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";}s:19:"\0*\0admin_permission";s:22:"administer url aliases";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:10:"path_alias";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";s:19:"path_alias_revision";s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"URL alias";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"URL aliases";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"URL alias";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"URL aliases";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:16:"@count URL alias";s:6:"plural";s:18:"@count URL aliases";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:11:"route_match";}s:14:"\0*\0constraints";a:2:{s:15:"UniquePathAlias";a:0:{}s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'path_alias.field_storage_definitions', 'a:8:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:2:"id";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:36;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:69;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:3:"und";}}s:8:"provider";s:10:"path_alias";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:103;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"path";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"System path";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:36:"The path that this alias belongs to.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"revisionable";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:4:"path";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:2:{s:9:"ValidPath";a:0:{}s:5:"Regex";a:2:{s:7:"pattern";s:6:"/^\\//i";s:7:"message";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:42:"The source path has to start with a slash.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}}}s:18:"\0*\0fieldDefinition";r:141;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"alias";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"URL alias";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"An alias used with this path.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"revisionable";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:5:"alias";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:1:{s:5:"Regex";a:2:{s:7:"pattern";s:6:"/^\\//i";s:7:"message";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:41:"The alias path has to start with a slash.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}}}s:18:"\0*\0fieldDefinition";r:187;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:10:"path_alias";s:10:"field_name";s:6:"status";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:232;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:271;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'search_page.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:11:"search_page";s:8:"\0*\0class";s:31:"Drupal\\search\\Entity\\SearchPage";s:11:"\0*\0provider";s:6:"search";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:6:"weight";s:6:"weight";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:31:"Drupal\\search\\Entity\\SearchPage";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:31:"Drupal\\search\\Entity\\SearchPage";}s:11:"\0*\0handlers";a:4:{s:6:"access";s:44:"Drupal\\search\\SearchPageAccessControlHandler";s:12:"list_builder";s:35:"Drupal\\search\\SearchPageListBuilder";s:4:"form";a:3:{s:3:"add";s:36:"Drupal\\search\\Form\\SearchPageAddForm";s:4:"edit";s:37:"Drupal\\search\\Form\\SearchPageEditForm";s:6:"delete";s:35:"Drupal\\Core\\Entity\\EntityDeleteForm";}s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:17:"administer search";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:6:{s:9:"edit-form";s:47:"/admin/config/search/pages/manage/{search_page}";s:11:"delete-form";s:54:"/admin/config/search/pages/manage/{search_page}/delete";s:6:"enable";s:54:"/admin/config/search/pages/manage/{search_page}/enable";s:7:"disable";s:55:"/admin/config/search/pages/manage/{search_page}/disable";s:11:"set-default";s:59:"/admin/config/search/pages/manage/{search_page}/set-default";s:10:"collection";s:26:"/admin/config/search/pages";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Search page";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Search pages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"search page";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"search pages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:18:"@count search page";s:6:"plural";s:19:"@count search pages";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:23:"config:search_page_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:4:"page";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:6:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:4:"path";i:3;s:6:"weight";i:4;s:6:"plugin";i:5;s:13:"configuration";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'shortcut.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:5:"\0*\0id";s:8:"shortcut";s:8:"\0*\0class";s:31:"Drupal\\shortcut\\Entity\\Shortcut";s:11:"\0*\0provider";s:8:"shortcut";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:4:"uuid";s:4:"uuid";s:6:"bundle";s:12:"shortcut_set";s:5:"label";s:5:"title";s:8:"langcode";s:8:"langcode";s:8:"revision";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:31:"Drupal\\shortcut\\Entity\\Shortcut";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:31:"Drupal\\shortcut\\Entity\\Shortcut";}s:11:"\0*\0handlers";a:5:{s:6:"access";s:44:"Drupal\\shortcut\\ShortcutAccessControlHandler";s:4:"form";a:4:{s:7:"default";s:28:"Drupal\\shortcut\\ShortcutForm";s:3:"add";s:28:"Drupal\\shortcut\\ShortcutForm";s:4:"edit";s:28:"Drupal\\shortcut\\ShortcutForm";s:6:"delete";s:39:"Drupal\\shortcut\\Form\\ShortcutDeleteForm";}s:11:"link_target";a:1:{s:4:"view";s:41:"Drupal\\shortcut\\Entity\\ShortcutLinkTarget";}s:7:"storage";s:46:"Drupal\\Core\\Entity\\Sql\\SqlContentEntityStorage";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"canonical";s:53:"/admin/config/user-interface/shortcut/link/{shortcut}";s:11:"delete-form";s:60:"/admin/config/user-interface/shortcut/link/{shortcut}/delete";s:9:"edit-form";s:53:"/admin/config/user-interface/shortcut/link/{shortcut}";}s:21:"\0*\0bundle_entity_type";s:12:"shortcut_set";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Shortcut set";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:8:"shortcut";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";s:19:"shortcut_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Shortcut link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Shortcut links";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"shortcut link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"shortcut links";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:20:"@count shortcut link";s:6:"plural";s:21:"@count shortcut links";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:shortcut_set_list";}s:14:"\0*\0constraints";a:1:{s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'shortcut.field_storage_definitions', 'a:8:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The ID of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:2:"id";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"The UUID of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"The language code of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"shortcut_set";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Shortcut set";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:27:"The bundle of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:12:"shortcut_set";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:12:"shortcut_set";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:116;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"title";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"The name of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"translatable";b:1;s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-10;s:8:"settings";a:1:{s:4:"size";i:40;}}}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:5:"title";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:154;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"weight";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Weight";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:48:"Weight among shortcuts in the same shortcut set.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:6:"weight";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:197;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"link";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Path";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:37:"The location this shortcut points to.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:12:"link_default";s:6:"weight";i:0;}s:12:"configurable";b:1;}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:4:"link";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:link";s:8:"settings";a:2:{s:5:"title";i:0;s:9:"link_type";i:1;}}s:18:"\0*\0fieldDefinition";r:234;}s:7:"\0*\0type";s:4:"link";s:9:"\0*\0schema";a:4:{s:7:"columns";a:3:{s:3:"uri";a:3:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;}s:5:"title";a:3:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;}s:7:"options";a:4:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;}}s:7:"indexes";a:1:{s:3:"uri";a:1:{i:0;a:2:{i:0;s:3:"uri";i:1;i:30;}}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:287;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}}'),
('entity.definitions.installed', 'shortcut_set.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:12:"shortcut_set";s:8:"\0*\0class";s:34:"Drupal\\shortcut\\Entity\\ShortcutSet";s:11:"\0*\0provider";s:8:"shortcut";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:34:"Drupal\\shortcut\\Entity\\ShortcutSet";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:34:"Drupal\\shortcut\\Entity\\ShortcutSet";}s:11:"\0*\0handlers";a:4:{s:7:"storage";s:34:"Drupal\\shortcut\\ShortcutSetStorage";s:6:"access";s:47:"Drupal\\shortcut\\ShortcutSetAccessControlHandler";s:12:"list_builder";s:38:"Drupal\\shortcut\\ShortcutSetListBuilder";s:4:"form";a:5:{s:7:"default";s:31:"Drupal\\shortcut\\ShortcutSetForm";s:3:"add";s:31:"Drupal\\shortcut\\ShortcutSetForm";s:4:"edit";s:31:"Drupal\\shortcut\\ShortcutSetForm";s:9:"customize";s:33:"Drupal\\shortcut\\Form\\SetCustomize";s:6:"delete";s:42:"Drupal\\shortcut\\Form\\ShortcutSetDeleteForm";}}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:14:"customize-form";s:69:"/admin/config/user-interface/shortcut/manage/{shortcut_set}/customize";s:11:"delete-form";s:66:"/admin/config/user-interface/shortcut/manage/{shortcut_set}/delete";s:9:"edit-form";s:59:"/admin/config/user-interface/shortcut/manage/{shortcut_set}";s:10:"collection";s:37:"/admin/config/user-interface/shortcut";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:8:"shortcut";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Shortcut set";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Shortcut sets";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"shortcut set";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"shortcut sets";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:19:"@count shortcut set";s:6:"plural";s:20:"@count shortcut sets";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:shortcut_set_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:3:"set";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:2:{i:0;s:2:"id";i:1;s:5:"label";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'taxonomy_term.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:5:"\0*\0id";s:13:"taxonomy_term";s:8:"\0*\0class";s:27:"Drupal\\taxonomy\\Entity\\Term";s:11:"\0*\0provider";s:8:"taxonomy";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:3:"tid";s:8:"revision";s:11:"revision_id";s:6:"bundle";s:3:"vid";s:5:"label";s:4:"name";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:27:"Drupal\\taxonomy\\Entity\\Term";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:27:"Drupal\\taxonomy\\Entity\\Term";}s:11:"\0*\0handlers";a:9:{s:7:"storage";s:27:"Drupal\\taxonomy\\TermStorage";s:14:"storage_schema";s:33:"Drupal\\taxonomy\\TermStorageSchema";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";s:12:"list_builder";s:36:"Drupal\\Core\\Entity\\EntityListBuilder";s:6:"access";s:40:"Drupal\\taxonomy\\TermAccessControlHandler";s:10:"views_data";s:29:"Drupal\\taxonomy\\TermViewsData";s:4:"form";a:4:{s:7:"default";s:24:"Drupal\\taxonomy\\TermForm";s:6:"delete";s:35:"Drupal\\taxonomy\\Form\\TermDeleteForm";s:15:"revision-delete";s:42:"Drupal\\Core\\Entity\\Form\\RevisionDeleteForm";s:15:"revision-revert";s:42:"Drupal\\Core\\Entity\\Form\\RevisionRevertForm";}s:14:"route_provider";a:1:{s:8:"revision";s:52:"Drupal\\Core\\Entity\\Routing\\RevisionHtmlRouteProvider";}s:11:"translation";s:38:"Drupal\\taxonomy\\TermTranslationHandler";}s:19:"\0*\0admin_permission";N;s:24:"\0*\0collection_permission";s:24:"access taxonomy overview";s:25:"\0*\0permission_granularity";s:6:"bundle";s:8:"\0*\0links";a:8:{s:9:"canonical";s:30:"/taxonomy/term/{taxonomy_term}";s:11:"delete-form";s:37:"/taxonomy/term/{taxonomy_term}/delete";s:9:"edit-form";s:35:"/taxonomy/term/{taxonomy_term}/edit";s:6:"create";s:14:"/taxonomy/term";s:8:"revision";s:69:"/taxonomy/term/{taxonomy_term}/revision/{taxonomy_term_revision}/view";s:20:"revision-delete-form";s:71:"/taxonomy/term/{taxonomy_term}/revision/{taxonomy_term_revision}/delete";s:20:"revision-revert-form";s:71:"/taxonomy/term/{taxonomy_term}/revision/{taxonomy_term_revision}/revert";s:15:"version-history";s:40:"/taxonomy/term/{taxonomy_term}/revisions";}s:21:"\0*\0bundle_entity_type";s:19:"taxonomy_vocabulary";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Vocabulary";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:18:"taxonomy_term_data";s:22:"\0*\0revision_data_table";s:28:"taxonomy_term_field_revision";s:17:"\0*\0revision_table";s:22:"taxonomy_term_revision";s:13:"\0*\0data_table";s:24:"taxonomy_term_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:1;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Taxonomy term";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Taxonomy terms";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"taxonomy term";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"taxonomy terms";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:20:"@count taxonomy term";s:6:"plural";s:21:"@count taxonomy terms";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:40:"entity.taxonomy_vocabulary.overview_form";s:26:"\0*\0common_reference_target";b:1;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"taxonomy_term_list";}s:14:"\0*\0constraints";a:3:{s:17:"TaxonomyHierarchy";a:0:{}s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:4:{s:13:"revision_user";s:13:"revision_user";s:16:"revision_created";s:16:"revision_created";s:20:"revision_log_message";s:20:"revision_log_message";s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'taxonomy_term.field_storage_definitions', 'a:17:{s:3:"tid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Term ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"The term ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:3:"tid";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"The term UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The term language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:111;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:3:"vid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Vocabulary";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:45:"The vocabulary to which the term is assigned.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:3:"vid";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:19:"taxonomy_vocabulary";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:151;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision create time";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:16:"revision_created";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:189;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:13:"revision_user";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Revision user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:13:"revision_user";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:219;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:20:"revision_log_message";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision log message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Briefly describe the changes you have made.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:25;s:8:"settings";a:1:{s:4:"rows";i:4;}}}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:20:"revision_log_message";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:256;}s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:100;}s:12:"configurable";b:1;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:6:"status";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}s:5:"class";s:22:"Drupal\\user\\StatusItem";}s:18:"\0*\0fieldDefinition";r:298;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"required";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:-5;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:4:"name";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:346;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:11:"description";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Description";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:14:"text_textfield";s:6:"weight";i:0;}s:12:"configurable";b:1;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:11:"description";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:20:"field_item:text_long";s:8:"settings";a:1:{s:15:"allowed_formats";a:0:{}}}s:18:"\0*\0fieldDefinition";r:390;}s:7:"\0*\0type";s:9:"text_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:2:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}s:6:"format";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"weight";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Weight";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:51:"The weight of this term in relation to other terms.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:6:"weight";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:436;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"parent";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Term Parents";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"The parents of this term.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"cardinality";i:-1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:6:"parent";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:13:"taxonomy_term";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:476;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"The time that the term was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:512;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:543;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:586;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:628;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.definitions.installed', 'taxonomy_vocabulary.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:19:"taxonomy_vocabulary";s:8:"\0*\0class";s:33:"Drupal\\taxonomy\\Entity\\Vocabulary";s:11:"\0*\0provider";s:8:"taxonomy";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:3:"vid";s:5:"label";s:4:"name";s:6:"weight";s:6:"weight";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:33:"Drupal\\taxonomy\\Entity\\Vocabulary";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:33:"Drupal\\taxonomy\\Entity\\Vocabulary";}s:11:"\0*\0handlers";a:5:{s:7:"storage";s:33:"Drupal\\taxonomy\\VocabularyStorage";s:12:"list_builder";s:37:"Drupal\\taxonomy\\VocabularyListBuilder";s:6:"access";s:46:"Drupal\\taxonomy\\VocabularyAccessControlHandler";s:4:"form";a:4:{s:7:"default";s:30:"Drupal\\taxonomy\\VocabularyForm";s:5:"reset";s:40:"Drupal\\taxonomy\\Form\\VocabularyResetForm";s:6:"delete";s:41:"Drupal\\taxonomy\\Form\\VocabularyDeleteForm";s:8:"overview";s:34:"Drupal\\taxonomy\\Form\\OverviewTerms";}s:14:"route_provider";a:2:{s:4:"html";s:54:"Drupal\\taxonomy\\Entity\\Routing\\VocabularyRouteProvider";s:11:"permissions";s:49:"Drupal\\user\\Entity\\EntityPermissionsRouteProvider";}}s:19:"\0*\0admin_permission";s:19:"administer taxonomy";s:24:"\0*\0collection_permission";s:24:"access taxonomy overview";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:7:{s:8:"add-form";s:29:"/admin/structure/taxonomy/add";s:11:"delete-form";s:61:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}/delete";s:10:"reset-form";s:60:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}/reset";s:13:"overview-form";s:63:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}/overview";s:9:"edit-form";s:54:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}";s:23:"entity-permissions-form";s:75:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}/overview/permissions";s:10:"collection";s:25:"/admin/structure/taxonomy";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:13:"taxonomy_term";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Taxonomy vocabulary";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Taxonomy";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"vocabulary";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"vocabularies";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:17:"@count vocabulary";s:6:"plural";s:19:"@count vocabularies";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:taxonomy_vocabulary_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:10:"vocabulary";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:4:"name";i:1;s:3:"vid";i:2;s:11:"description";i:3;s:6:"weight";i:4;s:12:"new_revision";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'user.entity_type', 'O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:5:"\0*\0id";s:4:"user";s:8:"\0*\0class";s:23:"Drupal\\user\\Entity\\User";s:11:"\0*\0provider";s:4:"user";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:7:{s:2:"id";s:3:"uid";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:"\0*\0originalClass";s:23:"Drupal\\user\\Entity\\User";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:23:"Drupal\\user\\Entity\\User";}s:11:"\0*\0handlers";a:9:{s:7:"storage";s:23:"Drupal\\user\\UserStorage";s:14:"storage_schema";s:29:"Drupal\\user\\UserStorageSchema";s:6:"access";s:36:"Drupal\\user\\UserAccessControlHandler";s:12:"list_builder";s:27:"Drupal\\user\\UserListBuilder";s:10:"views_data";s:25:"Drupal\\user\\UserViewsData";s:14:"route_provider";a:1:{s:4:"html";s:36:"Drupal\\user\\Entity\\UserRouteProvider";}s:4:"form";a:3:{s:7:"default";s:23:"Drupal\\user\\ProfileForm";s:6:"cancel";s:31:"Drupal\\user\\Form\\UserCancelForm";s:8:"register";s:24:"Drupal\\user\\RegisterForm";}s:11:"translation";s:37:"Drupal\\user\\ProfileTranslationHandler";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";}s:19:"\0*\0admin_permission";s:16:"administer users";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:9:"canonical";s:12:"/user/{user}";s:9:"edit-form";s:17:"/user/{user}/edit";s:11:"cancel-form";s:19:"/user/{user}/cancel";s:10:"collection";s:13:"/admin/people";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:5:"users";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";s:16:"users_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"User";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Users";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"users";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:11:"@count user";s:6:"plural";s:12:"@count users";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:22:"entity.user.admin_form";s:26:"\0*\0common_reference_target";b:1;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:9:"user_list";}s:14:"\0*\0constraints";a:2:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}}'),
('entity.definitions.installed', 'user.field_storage_definitions', 'a:18:{s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"User ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"The user ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}s:18:"\0*\0fieldDefinition";r:2;}s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"The user UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:40;}s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}}s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The user language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:77;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:18:"preferred_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"Preferred language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:77:"The user''s preferred language code for receiving emails and viewing the site.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:18:"preferred_langcode";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:2:{s:13:"AllowedValues";a:1:{s:8:"callback";s:60:"Drupal\\user\\Entity\\User::getAllowedConfigurableLanguageCodes";}s:6:"Length";a:1:{s:3:"max";i:12;}}}}}s:18:"\0*\0fieldDefinition";r:115;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:24:"preferred_admin_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Preferred admin language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:68:"The user''s preferred language code for viewing administration pages.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";N;}}s:8:"provider";s:4:"user";s:10:"field_name";s:24:"preferred_admin_langcode";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:2:{s:13:"AllowedValues";a:1:{s:8:"callback";s:60:"Drupal\\user\\Entity\\User::getAllowedConfigurableLanguageCodes";}s:6:"Length";a:1:{s:3:"max";i:12;}}}}}s:18:"\0*\0fieldDefinition";r:152;}s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:22:"The name of this user.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:11:"constraints";a:2:{s:8:"UserName";a:0:{}s:14:"UserNameUnique";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"name";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:5:"class";s:25:"\\Drupal\\user\\UserNameItem";}s:18:"\0*\0fieldDefinition";r:192;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"pass";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Password";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The password of this user (hashed).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"constraints";a:1:{s:18:"ProtectedUserField";N;}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"pass";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:password";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}s:18:"\0*\0fieldDefinition";r:231;}s:7:"\0*\0type";s:8:"password";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"mail";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Email";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The email of this user.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:11:"constraints";a:3:{s:14:"UserMailUnique";N;s:16:"UserMailRequired";N;s:18:"ProtectedUserField";N;}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"mail";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:16:"field_item:email";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:267;}s:7:"\0*\0type";s:5:"email";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:7:"varchar";s:6:"length";i:254;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:8:"timezone";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Timezone";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"The timezone of this user.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:8:"timezone";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:4:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:32;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:1:{s:13:"AllowedValues";a:1:{s:8:"callback";s:44:"Drupal\\user\\Entity\\User::getAllowedTimezones";}}}}s:5:"class";s:24:"Drupal\\user\\TimeZoneItem";}s:18:"\0*\0fieldDefinition";r:304;}s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"User status";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:38:"Whether the user is active or blocked.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:8:"provider";s:4:"user";s:10:"field_name";s:6:"status";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:3:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}s:5:"class";s:22:"Drupal\\user\\StatusItem";}s:18:"\0*\0fieldDefinition";r:344;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Created";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The time that the user was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:7:"created";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:386;}s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"The time that the user was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:4:"user";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:415;}s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:6:"access";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Last access";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:46:"The time that the user last accessed the site.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:8:"provider";s:4:"user";s:10:"field_name";s:6:"access";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:20:"field_item:timestamp";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:445;}s:7:"\0*\0type";s:9:"timestamp";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"login";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Last login";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:38:"The time that the user last logged in.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:8:"provider";s:4:"user";s:10:"field_name";s:5:"login";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:20:"field_item:timestamp";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:477;}s:7:"\0*\0type";s:9:"timestamp";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:4:"init";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Initial email";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"The email address used for initial account creation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"init";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:16:"field_item:email";s:8:"settings";a:0:{}}s:18:"\0*\0fieldDefinition";r:509;}s:7:"\0*\0type";s:5:"email";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:7:"varchar";s:6:"length";i:254;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:5:"roles";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Roles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"cardinality";i:-1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The roles the user has.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:5:"roles";s:11:"entity_type";s:4:"user";s:6:"bundle";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:9:"user_role";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}s:18:"\0*\0fieldDefinition";r:542;}s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:4:"user";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}s:18:"\0*\0fieldDefinition";r:578;}s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}}s:12:"user_picture";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":31:{s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";N;s:12:"\0*\0typedData";N;s:17:"\0*\0originalEntity";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:17:"user.user_picture";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"e5277c22-8a09-42ab-9808-dae455e3b895";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"0q8-mw8y-Ls5I578sIPQFLp4ljpH7WvVYpzY-I9O-8E";}s:14:"\0*\0trustedData";b:0;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"user";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:17:"user.user_picture";s:13:"\0*\0field_name";s:12:"user_picture";s:14:"\0*\0entity_type";s:4:"user";s:7:"\0*\0type";s:5:"image";s:9:"\0*\0module";s:5:"image";s:11:"\0*\0settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:10:"\0*\0deleted";b:0;}s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:13:"\0*\0originalId";s:17:"user.user_picture";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"e5277c22-8a09-42ab-9808-dae455e3b895";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"0q8-mw8y-Ls5I578sIPQFLp4ljpH7WvVYpzY-I9O-8E";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"user";}}s:12:"\0*\0isSyncing";b:0;s:5:"\0*\0id";s:17:"user.user_picture";s:13:"\0*\0field_name";s:12:"user_picture";s:14:"\0*\0entity_type";s:4:"user";s:7:"\0*\0type";s:5:"image";s:9:"\0*\0module";s:5:"image";s:11:"\0*\0settings";a:5:{s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:10:"\0*\0deleted";b:0;}}'),
('entity.definitions.installed', 'user_role.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:9:"user_role";s:8:"\0*\0class";s:23:"Drupal\\user\\Entity\\Role";s:11:"\0*\0provider";s:4:"user";s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:6:"weight";s:6:"weight";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:23:"Drupal\\user\\Entity\\Role";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:23:"Drupal\\user\\Entity\\Role";}s:11:"\0*\0handlers";a:4:{s:7:"storage";s:23:"Drupal\\user\\RoleStorage";s:6:"access";s:36:"Drupal\\user\\RoleAccessControlHandler";s:12:"list_builder";s:27:"Drupal\\user\\RoleListBuilder";s:4:"form";a:2:{s:7:"default";s:20:"Drupal\\user\\RoleForm";s:6:"delete";s:35:"Drupal\\Core\\Entity\\EntityDeleteForm";}}s:19:"\0*\0admin_permission";s:22:"administer permissions";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:11:"delete-form";s:45:"/admin/people/roles/manage/{user_role}/delete";s:9:"edit-form";s:38:"/admin/people/roles/manage/{user_role}";s:21:"edit-permissions-form";s:37:"/admin/people/permissions/{user_role}";s:10:"collection";s:19:"/admin/people/roles";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Role";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Roles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"role";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"roles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:11:"@count role";s:6:"plural";s:12:"@count roles";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:21:"config:user_role_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";s:4:"role";s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"weight";i:3;s:8:"is_admin";i:4;s:11:"permissions";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.definitions.installed', 'view.entity_type', 'O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":45:{s:5:"\0*\0id";s:4:"view";s:8:"\0*\0class";s:24:"Drupal\\views\\Entity\\View";s:11:"\0*\0provider";s:5:"views";s:15:"\0*\0static_cache";b:0;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:"\0*\0originalClass";s:24:"Drupal\\views\\Entity\\View";s:19:"\0*\0decoratedClasses";a:1:{i:0;s:24:"Drupal\\views\\Entity\\View";}s:11:"\0*\0handlers";a:4:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";s:4:"form";a:6:{s:4:"edit";s:28:"Drupal\\views_ui\\ViewEditForm";s:3:"add";s:27:"Drupal\\views_ui\\ViewAddForm";s:7:"preview";s:31:"Drupal\\views_ui\\ViewPreviewForm";s:9:"duplicate";s:33:"Drupal\\views_ui\\ViewDuplicateForm";s:6:"delete";s:35:"Drupal\\Core\\Entity\\EntityDeleteForm";s:10:"break_lock";s:34:"Drupal\\views_ui\\Form\\BreakLockForm";}s:12:"list_builder";s:31:"Drupal\\views_ui\\ViewListBuilder";}s:19:"\0*\0admin_permission";s:16:"administer views";s:24:"\0*\0collection_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:9:{s:9:"edit-form";s:34:"/admin/structure/views/view/{view}";s:17:"edit-display-form";s:52:"/admin/structure/views/view/{view}/edit/{display_id}";s:12:"preview-form";s:55:"/admin/structure/views/view/{view}/preview/{display_id}";s:14:"duplicate-form";s:44:"/admin/structure/views/view/{view}/duplicate";s:11:"delete-form";s:41:"/admin/structure/views/view/{view}/delete";s:6:"enable";s:41:"/admin/structure/views/view/{view}/enable";s:7:"disable";s:42:"/admin/structure/views/view/{view}/disable";s:15:"break-lock-form";s:45:"/admin/structure/views/view/{view}/break-lock";s:10:"collection";s:22:"/admin/structure/views";}s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"View";s:12:"\0*\0arguments";a:1:{s:7:"context";s:16:"View entity type";}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Views";s:12:"\0*\0arguments";a:1:{s:7:"context";s:16:"View entity type";}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"view";s:12:"\0*\0arguments";a:1:{s:7:"context";s:16:"View entity type";}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"views";s:12:"\0*\0arguments";a:1:{s:7:"context";s:16:"View entity type";}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:2:{s:8:"singular";s:11:"@count view";s:6:"plural";s:12:"@count views";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:16:"config:view_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;s:16:"\0*\0config_prefix";N;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:8:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"module";i:3;s:11:"description";i:4;s:3:"tag";i:5;s:10:"base_table";i:6;s:10:"base_field";i:7;s:7:"display";}s:21:"\0*\0mergedConfigExport";a:0:{}}'),
('entity.storage_schema.sql', 'block_content.entity_schema_data', 'a:4:{s:13:"block_content";a:2:{s:11:"primary key";a:1:{i:0;s:2:"id";}s:11:"unique keys";a:1:{s:26:"block_content__revision_id";a:1:{i:0;s:11:"revision_id";}}}s:22:"block_content_revision";a:2:{s:11:"primary key";a:1:{i:0;s:11:"revision_id";}s:7:"indexes";a:1:{s:17:"block_content__id";a:1:{i:0;s:2:"id";}}}s:24:"block_content_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:2:"id";i:1;s:8:"langcode";}s:7:"indexes";a:3:{s:45:"block_content__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:26:"block_content__revision_id";a:1:{i:0;s:11:"revision_id";}s:26:"block_content__status_type";a:3:{i:0;s:6:"status";i:1;s:4:"type";i:2;s:2:"id";}}}s:28:"block_content_field_revision";a:2:{s:11:"primary key";a:2:{i:0;s:11:"revision_id";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:45:"block_content__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.body', 'a:2:{s:19:"block_content__body";a:4:{s:11:"description";s:42:"Data storage for block_content field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}s:28:"block_content_revision__body";a:4:{s:11:"description";s:54:"Revision archive storage for block_content field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.changed', 'a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.default_langcode', 'a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.id', 'a:4:{s:13:"block_content";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.info', 'a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:4:"info";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:4:"info";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.langcode', 'a:4:{s:13:"block_content";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.reusable', 'a:1:{s:24:"block_content_field_data";a:2:{s:6:"fields";a:1:{s:8:"reusable";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:29:"block_content_field__reusable";a:1:{i:0;s:8:"reusable";}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.revision_created', 'a:1:{s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.revision_default', 'a:1:{s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.revision_id', 'a:4:{s:13:"block_content";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.revision_log', 'a:1:{s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:12:"revision_log";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.revision_translation_affected', 'a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.revision_user', 'a:1:{s:22:"block_content_revision";a:2:{s:6:"fields";a:1:{s:13:"revision_user";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:45:"block_content_field__revision_user__target_id";a:1:{i:0;s:13:"revision_user";}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.status', 'a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.type', 'a:2:{s:13:"block_content";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:36:"block_content_field__type__target_id";a:1:{i:0;s:4:"type";}}}s:24:"block_content_field_data";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:36:"block_content_field__type__target_id";a:1:{i:0;s:4:"type";}}}}'),
('entity.storage_schema.sql', 'block_content.field_schema_data.uuid', 'a:1:{s:13:"block_content";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:32:"block_content_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.storage_schema.sql', 'comment.entity_schema_data', 'a:2:{s:7:"comment";a:1:{s:11:"primary key";a:1:{i:0;s:3:"cid";}}s:18:"comment_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:3:"cid";i:1;s:8:"langcode";}s:7:"indexes";a:5:{s:39:"comment__id__default_langcode__langcode";a:3:{i:0;s:3:"cid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:28:"comment__status_comment_type";a:3:{i:0;s:6:"status";i:1;s:12:"comment_type";i:2;s:3:"cid";}s:19:"comment__status_pid";a:2:{i:0;s:3:"pid";i:1;s:6:"status";}s:16:"comment__num_new";a:7:{i:0;s:9:"entity_id";i:1;s:11:"entity_type";i:2;s:12:"comment_type";i:3;s:6:"status";i:4;s:7:"created";i:5;s:3:"cid";i:6;s:6:"thread";}s:24:"comment__entity_langcode";a:4:{i:0;s:9:"entity_id";i:1;s:11:"entity_type";i:2;s:12:"comment_type";i:3;s:16:"default_langcode";}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.changed', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.cid', 'a:2:{s:7:"comment";a:1:{s:6:"fields";a:1:{s:3:"cid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:3:"cid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.comment_body', 'a:1:{s:21:"comment__comment_body";a:4:{s:11:"description";s:44:"Data storage for comment field comment_body.";s:6:"fields";a:8:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:114:"The entity revision id this data is attached to, which for an unversioned entity type is the same as the entity id";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:18:"comment_body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:19:"comment_body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:19:"comment_body_format";a:1:{i:0;s:19:"comment_body_format";}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.comment_type', 'a:2:{s:7:"comment";a:2:{s:6:"fields";a:1:{s:12:"comment_type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:38:"comment_field__comment_type__target_id";a:1:{i:0;s:12:"comment_type";}}}s:18:"comment_field_data";a:2:{s:6:"fields";a:1:{s:12:"comment_type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:38:"comment_field__comment_type__target_id";a:1:{i:0;s:12:"comment_type";}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.created', 'a:1:{s:18:"comment_field_data";a:2:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:22:"comment_field__created";a:1:{i:0;s:7:"created";}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.default_langcode', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.entity_id', 'a:1:{s:18:"comment_field_data";a:2:{s:6:"fields";a:1:{s:9:"entity_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:0:{}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.entity_type', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:11:"entity_type";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.field_name', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:10:"field_name";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.homepage', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:8:"homepage";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.hostname', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:8:"hostname";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.langcode', 'a:2:{s:7:"comment";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.mail', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:4:"mail";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:254;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.name', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:60;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.pid', 'a:1:{s:18:"comment_field_data";a:2:{s:6:"fields";a:1:{s:3:"pid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:0:{}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.status', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.subject', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:7:"subject";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.thread', 'a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:6:"thread";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.uid', 'a:1:{s:18:"comment_field_data";a:3:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:29:"comment_field__uid__target_id";a:1:{i:0;s:3:"uid";}}s:12:"foreign keys";a:1:{s:18:"comment_field__uid";a:2:{s:5:"table";s:5:"users";s:7:"columns";a:1:{s:3:"uid";s:3:"uid";}}}}}'),
('entity.storage_schema.sql', 'comment.field_schema_data.uuid', 'a:1:{s:7:"comment";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:26:"comment_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'file.entity_schema_data', 'a:1:{s:12:"file_managed";a:1:{s:11:"primary key";a:1:{i:0;s:3:"fid";}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.changed', 'a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"file_field__changed";a:1:{i:0;s:7:"changed";}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.created', 'a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.fid', 'a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:3:"fid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.filemime', 'a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:8:"filemime";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.filename', 'a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:8:"filename";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.filesize', 'a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:8:"filesize";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.langcode', 'a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.status', 'a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:18:"file_field__status";a:1:{i:0;s:6:"status";}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.uid', 'a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:26:"file_field__uid__target_id";a:1:{i:0;s:3:"uid";}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.uri', 'a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:3:"uri";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:15:"file_field__uri";a:1:{i:0;s:3:"uri";}}}}'),
('entity.storage_schema.sql', 'file.field_schema_data.uuid', 'a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:23:"file_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'menu_link_content.entity_schema_data', 'a:4:{s:17:"menu_link_content";a:2:{s:11:"primary key";a:1:{i:0;s:2:"id";}s:11:"unique keys";a:1:{s:30:"menu_link_content__revision_id";a:1:{i:0;s:11:"revision_id";}}}s:26:"menu_link_content_revision";a:2:{s:11:"primary key";a:1:{i:0;s:11:"revision_id";}s:7:"indexes";a:1:{s:21:"menu_link_content__id";a:1:{i:0;s:2:"id";}}}s:22:"menu_link_content_data";a:2:{s:11:"primary key";a:2:{i:0;s:2:"id";i:1;s:8:"langcode";}s:7:"indexes";a:3:{s:49:"menu_link_content__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:30:"menu_link_content__revision_id";a:1:{i:0;s:11:"revision_id";}s:33:"menu_link_content__enabled_bundle";a:3:{i:0;s:7:"enabled";i:1;s:6:"bundle";i:2;s:2:"id";}}}s:32:"menu_link_content_field_revision";a:2:{s:11:"primary key";a:2:{i:0;s:11:"revision_id";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:49:"menu_link_content__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.bundle', 'a:2:{s:17:"menu_link_content";a:1:{s:6:"fields";a:1:{s:6:"bundle";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:1;}}}s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:6:"bundle";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.changed', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.default_langcode', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.description', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:11:"description";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:11:"description";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.enabled', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:7:"enabled";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:7:"enabled";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.expanded', 'a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:8:"expanded";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.external', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:8:"external";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:8:"external";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.id', 'a:4:{s:17:"menu_link_content";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.langcode', 'a:4:{s:17:"menu_link_content";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.link', 'a:2:{s:22:"menu_link_content_data";a:2:{s:6:"fields";a:3:{s:9:"link__uri";a:4:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;s:8:"not null";b:0;}s:11:"link__title";a:4:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;}s:13:"link__options";a:5:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:34:"menu_link_content_field__link__uri";a:1:{i:0;a:2:{i:0;s:9:"link__uri";i:1;i:30;}}}}s:32:"menu_link_content_field_revision";a:2:{s:6:"fields";a:3:{s:9:"link__uri";a:4:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;s:8:"not null";b:0;}s:11:"link__title";a:4:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;}s:13:"link__options";a:5:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:34:"menu_link_content_field__link__uri";a:1:{i:0;a:2:{i:0;s:9:"link__uri";i:1;i:30;}}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.menu_name', 'a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:9:"menu_name";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.parent', 'a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:6:"parent";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.rediscover', 'a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:10:"rediscover";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.revision_created', 'a:1:{s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.revision_default', 'a:1:{s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.revision_id', 'a:4:{s:17:"menu_link_content";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.revision_log_message', 'a:1:{s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:20:"revision_log_message";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.revision_translation_affected', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.revision_user', 'a:1:{s:26:"menu_link_content_revision";a:2:{s:6:"fields";a:1:{s:13:"revision_user";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:29:"menu_link_content__ef029a1897";a:1:{i:0;s:13:"revision_user";}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.title', 'a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.uuid', 'a:1:{s:17:"menu_link_content";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:36:"menu_link_content_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'menu_link_content.field_schema_data.weight', 'a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:6:"weight";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.entity_schema_data', 'a:4:{s:4:"node";a:2:{s:11:"primary key";a:1:{i:0;s:3:"nid";}s:11:"unique keys";a:1:{s:9:"node__vid";a:1:{i:0;s:3:"vid";}}}s:13:"node_revision";a:2:{s:11:"primary key";a:1:{i:0;s:3:"vid";}s:7:"indexes";a:1:{s:9:"node__nid";a:1:{i:0;s:3:"nid";}}}s:15:"node_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:3:"nid";i:1;s:8:"langcode";}s:7:"indexes";a:5:{s:36:"node__id__default_langcode__langcode";a:3:{i:0;s:3:"nid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:9:"node__vid";a:1:{i:0;s:3:"vid";}s:17:"node__status_type";a:3:{i:0;s:6:"status";i:1;s:4:"type";i:2;s:3:"nid";}s:15:"node__frontpage";a:4:{i:0;s:7:"promote";i:1;s:6:"status";i:2;s:6:"sticky";i:3;s:7:"created";}s:16:"node__title_type";a:2:{i:0;s:5:"title";i:1;a:2:{i:0;s:4:"type";i:1;i:4;}}}}s:19:"node_field_revision";a:2:{s:11:"primary key";a:2:{i:0;s:3:"vid";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:36:"node__id__default_langcode__langcode";a:3:{i:0;s:3:"nid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.body', 'a:2:{s:10:"node__body";a:4:{s:11:"description";s:33:"Data storage for node field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}s:19:"node_revision__body";a:4:{s:11:"description";s:45:"Revision archive storage for node field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.changed', 'a:2:{s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"node_field__changed";a:1:{i:0;s:7:"changed";}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.comment', 'a:2:{s:13:"node__comment";a:4:{s:11:"description";s:36:"Data storage for node field comment.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:14:"comment_status";a:4:{s:11:"description";s:99:"Whether comments are allowed on this entity: 0 = no, 1 = closed (read only), 2 = open (read/write).";s:4:"type";s:3:"int";s:7:"default";i:0;s:8:"not null";b:1;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:2:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}}}s:22:"node_revision__comment";a:4:{s:11:"description";s:48:"Revision archive storage for node field comment.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:14:"comment_status";a:4:{s:11:"description";s:99:"Whether comments are allowed on this entity: 0 = no, 1 = closed (read only), 2 = open (read/write).";s:4:"type";s:3:"int";s:7:"default";i:0;s:8:"not null";b:1;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:2:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.created', 'a:2:{s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"node_field__created";a:1:{i:0;s:7:"created";}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.default_langcode', 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.field_image', 'a:2:{s:17:"node__field_image";a:5:{s:11:"description";s:40:"Data storage for node field field_image.";s:6:"fields";a:11:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:21:"field_image_target_id";a:4:{s:11:"description";s:26:"The ID of the file entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:15:"field_image_alt";a:4:{s:11:"description";s:56:"Alternative image text, for the image''s ''alt'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:512;s:8:"not null";b:0;}s:17:"field_image_title";a:4:{s:11:"description";s:52:"Image title text, for the image''s ''title'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:1024;s:8:"not null";b:0;}s:17:"field_image_width";a:4:{s:11:"description";s:33:"The width of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}s:18:"field_image_height";a:4:{s:11:"description";s:34:"The height of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:21:"field_image_target_id";a:1:{i:0;s:21:"field_image_target_id";}}s:12:"foreign keys";a:1:{s:21:"field_image_target_id";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:21:"field_image_target_id";s:3:"fid";}}}}s:26:"node_revision__field_image";a:5:{s:11:"description";s:52:"Revision archive storage for node field field_image.";s:6:"fields";a:11:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:21:"field_image_target_id";a:4:{s:11:"description";s:26:"The ID of the file entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:15:"field_image_alt";a:4:{s:11:"description";s:56:"Alternative image text, for the image''s ''alt'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:512;s:8:"not null";b:0;}s:17:"field_image_title";a:4:{s:11:"description";s:52:"Image title text, for the image''s ''title'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:1024;s:8:"not null";b:0;}s:17:"field_image_width";a:4:{s:11:"description";s:33:"The width of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}s:18:"field_image_height";a:4:{s:11:"description";s:34:"The height of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:21:"field_image_target_id";a:1:{i:0;s:21:"field_image_target_id";}}s:12:"foreign keys";a:1:{s:21:"field_image_target_id";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:21:"field_image_target_id";s:3:"fid";}}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.field_tags', 'a:2:{s:16:"node__field_tags";a:4:{s:11:"description";s:39:"Data storage for node field field_tags.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:20:"field_tags_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:20:"field_tags_target_id";a:1:{i:0;s:20:"field_tags_target_id";}}}s:25:"node_revision__field_tags";a:4:{s:11:"description";s:51:"Revision archive storage for node field field_tags.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:20:"field_tags_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:20:"field_tags_target_id";a:1:{i:0;s:20:"field_tags_target_id";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.langcode', 'a:4:{s:4:"node";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:13:"node_revision";a:2:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:20:"node_field__langcode";a:1:{i:0;s:8:"langcode";}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.nid', 'a:4:{s:4:"node";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.promote', 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:7:"promote";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:7:"promote";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.revision_default', 'a:1:{s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.revision_log', 'a:1:{s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:12:"revision_log";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.revision_timestamp', 'a:1:{s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:18:"revision_timestamp";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.revision_translation_affected', 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.revision_uid', 'a:1:{s:13:"node_revision";a:3:{s:6:"fields";a:1:{s:12:"revision_uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:35:"node_field__revision_uid__target_id";a:1:{i:0;s:12:"revision_uid";}}s:12:"foreign keys";a:1:{s:24:"node_field__revision_uid";a:2:{s:5:"table";s:5:"users";s:7:"columns";a:1:{s:12:"revision_uid";s:3:"uid";}}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.status', 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.sticky', 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:6:"sticky";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:6:"sticky";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.title', 'a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.type', 'a:2:{s:4:"node";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:27:"node_field__type__target_id";a:1:{i:0;s:4:"type";}}}s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:27:"node_field__type__target_id";a:1:{i:0;s:4:"type";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.uid', 'a:2:{s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:26:"node_field__uid__target_id";a:1:{i:0;s:3:"uid";}}}s:19:"node_field_revision";a:2:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:26:"node_field__uid__target_id";a:1:{i:0;s:3:"uid";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.uuid', 'a:1:{s:4:"node";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:23:"node_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'node.field_schema_data.vid', 'a:4:{s:4:"node";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'path_alias.entity_schema_data', 'a:2:{s:10:"path_alias";a:3:{s:11:"primary key";a:1:{i:0;s:2:"id";}s:7:"indexes";a:2:{s:36:"path_alias__alias_langcode_id_status";a:4:{i:0;s:5:"alias";i:1;s:8:"langcode";i:2;s:2:"id";i:3;s:6:"status";}s:35:"path_alias__path_langcode_id_status";a:4:{i:0;s:4:"path";i:1;s:8:"langcode";i:2;s:2:"id";i:3;s:6:"status";}}s:11:"unique keys";a:1:{s:23:"path_alias__revision_id";a:1:{i:0;s:11:"revision_id";}}}s:19:"path_alias_revision";a:2:{s:11:"primary key";a:1:{i:0;s:11:"revision_id";}s:7:"indexes";a:3:{s:14:"path_alias__id";a:1:{i:0;s:2:"id";}s:45:"path_alias_revision__alias_langcode_id_status";a:4:{i:0;s:5:"alias";i:1;s:8:"langcode";i:2;s:2:"id";i:3;s:6:"status";}s:44:"path_alias_revision__path_langcode_id_status";a:4:{i:0;s:4:"path";i:1;s:8:"langcode";i:2;s:2:"id";i:3;s:6:"status";}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.alias', 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:5:"alias";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:5:"alias";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.id', 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.langcode', 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.path', 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:4:"path";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:4:"path";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.revision_default', 'a:1:{s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.revision_id', 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.status', 'a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'path_alias.field_schema_data.uuid', 'a:1:{s:10:"path_alias";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:29:"path_alias_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'shortcut.entity_schema_data', 'a:2:{s:8:"shortcut";a:1:{s:11:"primary key";a:1:{i:0;s:2:"id";}}s:19:"shortcut_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:2:"id";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:40:"shortcut__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.default_langcode', 'a:1:{s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.id', 'a:2:{s:8:"shortcut";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.langcode', 'a:2:{s:8:"shortcut";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('entity.storage_schema.sql', 'shortcut.field_schema_data.link', 'a:1:{s:19:"shortcut_field_data";a:2:{s:6:"fields";a:3:{s:9:"link__uri";a:4:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;s:8:"not null";b:0;}s:11:"link__title";a:4:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;}s:13:"link__options";a:5:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:25:"shortcut_field__link__uri";a:1:{i:0;a:2:{i:0;s:9:"link__uri";i:1;i:30;}}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.shortcut_set', 'a:2:{s:8:"shortcut";a:2:{s:6:"fields";a:1:{s:12:"shortcut_set";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:39:"shortcut_field__shortcut_set__target_id";a:1:{i:0;s:12:"shortcut_set";}}}s:19:"shortcut_field_data";a:2:{s:6:"fields";a:1:{s:12:"shortcut_set";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:39:"shortcut_field__shortcut_set__target_id";a:1:{i:0;s:12:"shortcut_set";}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.title', 'a:1:{s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.uuid', 'a:1:{s:8:"shortcut";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:27:"shortcut_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'shortcut.field_schema_data.weight', 'a:1:{s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:6:"weight";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.entity_schema_data', 'a:5:{s:18:"taxonomy_term_data";a:2:{s:11:"primary key";a:1:{i:0;s:3:"tid";}s:11:"unique keys";a:1:{s:26:"taxonomy_term__revision_id";a:1:{i:0;s:11:"revision_id";}}}s:22:"taxonomy_term_revision";a:2:{s:11:"primary key";a:1:{i:0;s:11:"revision_id";}s:7:"indexes";a:1:{s:18:"taxonomy_term__tid";a:1:{i:0;s:3:"tid";}}}s:24:"taxonomy_term_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:3:"tid";i:1;s:8:"langcode";}s:7:"indexes";a:5:{s:45:"taxonomy_term__id__default_langcode__langcode";a:3:{i:0;s:3:"tid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:26:"taxonomy_term__revision_id";a:1:{i:0;s:11:"revision_id";}s:25:"taxonomy_term__status_vid";a:3:{i:0;s:6:"status";i:1;s:3:"vid";i:2;s:3:"tid";}s:19:"taxonomy_term__tree";a:3:{i:0;s:3:"vid";i:1;s:6:"weight";i:2;s:4:"name";}s:23:"taxonomy_term__vid_name";a:2:{i:0;s:3:"vid";i:1;s:4:"name";}}}s:28:"taxonomy_term_field_revision";a:2:{s:11:"primary key";a:2:{i:0;s:11:"revision_id";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:45:"taxonomy_term__id__default_langcode__langcode";a:3:{i:0;s:3:"tid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}s:14:"taxonomy_index";a:2:{s:11:"primary key";a:2:{i:0;s:3:"nid";i:1;s:3:"tid";}s:7:"indexes";a:1:{s:9:"term_node";a:4:{i:0;s:3:"tid";i:1;s:6:"status";i:2;s:6:"sticky";i:3;s:7:"created";}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.changed', 'a:2:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.default_langcode', 'a:2:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.description', 'a:2:{s:24:"taxonomy_term_field_data";a:2:{s:6:"fields";a:2:{s:18:"description__value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:19:"description__format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:7:"indexes";a:0:{}}s:28:"taxonomy_term_field_revision";a:2:{s:6:"fields";a:2:{s:18:"description__value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:19:"description__format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:40:"taxonomy_term_field__description__format";a:1:{i:0;s:19:"description__format";}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.langcode', 'a:4:{s:18:"taxonomy_term_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.name', 'a:2:{s:24:"taxonomy_term_field_data";a:2:{s:6:"fields";a:1:{s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:25:"taxonomy_term_field__name";a:1:{i:0;s:4:"name";}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.parent', 'a:2:{s:21:"taxonomy_term__parent";a:4:{s:11:"description";s:44:"Data storage for taxonomy_term field parent.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:16:"parent_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:16:"parent_target_id";a:1:{i:0;s:16:"parent_target_id";}s:22:"bundle_delta_target_id";a:3:{i:0;s:6:"bundle";i:1;s:5:"delta";i:2;s:16:"parent_target_id";}}}s:30:"taxonomy_term_revision__parent";a:4:{s:11:"description";s:56:"Revision archive storage for taxonomy_term field parent.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:16:"parent_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:16:"parent_target_id";a:1:{i:0;s:16:"parent_target_id";}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.revision_created', 'a:1:{s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.revision_default', 'a:1:{s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.revision_id', 'a:4:{s:18:"taxonomy_term_data";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.revision_log_message', 'a:1:{s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:20:"revision_log_message";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.revision_translation_affected', 'a:2:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.revision_user', 'a:1:{s:22:"taxonomy_term_revision";a:2:{s:6:"fields";a:1:{s:13:"revision_user";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:45:"taxonomy_term_field__revision_user__target_id";a:1:{i:0;s:13:"revision_user";}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.status', 'a:2:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.tid', 'a:4:{s:18:"taxonomy_term_data";a:1:{s:6:"fields";a:1:{s:3:"tid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:3:"tid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:3:"tid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:3:"tid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.uuid', 'a:1:{s:18:"taxonomy_term_data";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:32:"taxonomy_term_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.vid', 'a:2:{s:18:"taxonomy_term_data";a:2:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:35:"taxonomy_term_field__vid__target_id";a:1:{i:0;s:3:"vid";}}}s:24:"taxonomy_term_field_data";a:2:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:0:{}}}'),
('entity.storage_schema.sql', 'taxonomy_term.field_schema_data.weight', 'a:1:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:6:"weight";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'user.entity_schema_data', 'a:2:{s:5:"users";a:1:{s:11:"primary key";a:1:{i:0;s:3:"uid";}}s:16:"users_field_data";a:3:{s:11:"primary key";a:2:{i:0;s:3:"uid";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:36:"user__id__default_langcode__langcode";a:3:{i:0;s:3:"uid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}s:11:"unique keys";a:1:{s:10:"user__name";a:2:{i:0;s:4:"name";i:1;s:8:"langcode";}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.access', 'a:1:{s:16:"users_field_data";a:2:{s:6:"fields";a:1:{s:6:"access";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:18:"user_field__access";a:1:{i:0;s:6:"access";}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.changed', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.created', 'a:1:{s:16:"users_field_data";a:2:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"user_field__created";a:1:{i:0;s:7:"created";}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.default_langcode', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.init', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:4:"init";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:254;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.langcode', 'a:2:{s:5:"users";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.login', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:5:"login";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.mail', 'a:1:{s:16:"users_field_data";a:2:{s:6:"fields";a:1:{s:4:"mail";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:254;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:16:"user_field__mail";a:1:{i:0;s:4:"mail";}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.name', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:60;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.pass', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:4:"pass";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.preferred_admin_langcode', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:24:"preferred_admin_langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.preferred_langcode', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:18:"preferred_langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.roles', 'a:1:{s:11:"user__roles";a:4:{s:11:"description";s:34:"Data storage for user field roles.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:114:"The entity revision id this data is attached to, which for an unversioned entity type is the same as the entity id";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:15:"roles_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:1;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:15:"roles_target_id";a:1:{i:0;s:15:"roles_target_id";}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.status', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.timezone', 'a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:8:"timezone";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.uid', 'a:2:{s:5:"users";a:1:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.user_picture', 'a:1:{s:18:"user__user_picture";a:5:{s:11:"description";s:41:"Data storage for user field user_picture.";s:6:"fields";a:11:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:114:"The entity revision id this data is attached to, which for an unversioned entity type is the same as the entity id";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:22:"user_picture_target_id";a:4:{s:11:"description";s:26:"The ID of the file entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:16:"user_picture_alt";a:4:{s:11:"description";s:56:"Alternative image text, for the image''s ''alt'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:512;s:8:"not null";b:0;}s:18:"user_picture_title";a:4:{s:11:"description";s:52:"Image title text, for the image''s ''title'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:1024;s:8:"not null";b:0;}s:18:"user_picture_width";a:4:{s:11:"description";s:33:"The width of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}s:19:"user_picture_height";a:4:{s:11:"description";s:34:"The height of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:22:"user_picture_target_id";a:1:{i:0;s:22:"user_picture_target_id";}}s:12:"foreign keys";a:1:{s:22:"user_picture_target_id";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:22:"user_picture_target_id";s:3:"fid";}}}}}'),
('entity.storage_schema.sql', 'user.field_schema_data.uuid', 'a:1:{s:5:"users";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:23:"user_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),
('hook_data', 'group_includes', 'a:0:{}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('hook_data', 'hook_list', 'a:202:{s:3:"uri";a:1:{s:11:"comment_uri";s:7:"comment";}s:7:"preview";a:1:{s:15:"comment_preview";s:7:"comment";}s:9:"hook_info";a:2:{s:16:"system_hook_info";s:6:"system";s:15:"views_hook_info";s:5:"views";}s:15:"authorized_init";a:1:{s:22:"system_authorized_init";s:6:"system";}s:18:"authorized_get_url";a:1:{s:25:"system_authorized_get_url";s:6:"system";}s:31:"authorized_batch_processing_url";a:1:{s:38:"system_authorized_batch_processing_url";s:6:"system";}s:14:"authorized_run";a:1:{s:21:"system_authorized_run";s:6:"system";}s:24:"authorized_batch_process";a:1:{s:31:"system_authorized_batch_process";s:6:"system";}s:15:"check_directory";a:1:{s:22:"system_check_directory";s:6:"system";}s:11:"region_list";a:1:{s:18:"system_region_list";s:6:"system";}s:11:"sort_themes";a:1:{s:18:"system_sort_themes";s:6:"system";}s:14:"default_region";a:1:{s:21:"system_default_region";s:6:"system";}s:18:"admin_compact_mode";a:1:{s:25:"system_admin_compact_mode";s:6:"system";}s:20:"add_contextual_links";a:1:{s:26:"views_add_contextual_links";s:5:"views";}s:16:"invalidate_cache";a:1:{s:22:"views_invalidate_cache";s:5:"views";}s:16:"set_current_view";a:1:{s:22:"views_set_current_view";s:5:"views";}s:16:"get_current_view";a:1:{s:22:"views_get_current_view";s:5:"views";}s:15:"view_is_enabled";a:1:{s:21:"views_view_is_enabled";s:5:"views";}s:16:"view_is_disabled";a:1:{s:22:"views_view_is_disabled";s:5:"views";}s:11:"enable_view";a:1:{s:17:"views_enable_view";s:5:"views";}s:12:"disable_view";a:1:{s:18:"views_disable_view";s:5:"views";}s:10:"embed_view";a:1:{s:16:"views_embed_view";s:5:"views";}s:15:"get_view_result";a:1:{s:21:"views_get_view_result";s:5:"views";}s:21:"element_validate_tags";a:1:{s:27:"views_element_validate_tags";s:5:"views";}s:24:"field_default_views_data";a:1:{s:30:"views_field_default_views_data";s:5:"views";}s:18:"entity_field_label";a:1:{s:24:"views_entity_field_label";s:5:"views";}s:4:"cron";a:10:{s:63:"Drupal\\announcements_feed\\Hook\\AnnouncementsFeedCronHooks::cron";s:18:"announcements_feed";s:38:"Drupal\\comment\\Hook\\CommentHooks::cron";s:7:"comment";s:34:"Drupal\\dblog\\Hook\\DblogHooks::cron";s:5:"dblog";s:34:"Drupal\\field\\Hook\\FieldHooks::cron";s:5:"field";s:35:"Drupal\\file\\Hook\\CronHook::__invoke";s:4:"file";s:38:"Drupal\\history\\Hook\\HistoryHooks::cron";s:7:"history";s:38:"Drupal\\node\\Hook\\NodeSearchHooks::cron";s:4:"node";s:36:"Drupal\\search\\Hook\\SearchHooks::cron";s:6:"search";s:36:"Drupal\\system\\Hook\\SystemHooks::cron";s:6:"system";s:36:"Drupal\\update\\Hook\\UpdateHooks::cron";s:6:"update";}s:4:"help";a:39:{s:63:"Drupal\\announcements_feed\\Hook\\AnnouncementsFeedHelpHooks::help";s:18:"announcements_feed";s:51:"Drupal\\automated_cron\\Hook\\AutomatedCronHooks::help";s:14:"automated_cron";s:39:"Drupal\\big_pipe\\Hook\\BigPipeHooks::help";s:8:"big_pipe";s:34:"Drupal\\block\\Hook\\BlockHooks::help";s:5:"block";s:49:"Drupal\\block_content\\Hook\\BlockContentHooks::help";s:13:"block_content";s:44:"Drupal\\breakpoint\\Hook\\BreakpointHooks::help";s:10:"breakpoint";s:42:"Drupal\\ckeditor5\\Hook\\Ckeditor5Hooks::help";s:9:"ckeditor5";s:38:"Drupal\\comment\\Hook\\CommentHooks::help";s:7:"comment";s:36:"Drupal\\config\\Hook\\ConfigHooks::help";s:6:"config";s:44:"Drupal\\contextual\\Hook\\ContextualHooks::help";s:10:"contextual";s:40:"Drupal\\datetime\\Hook\\DatetimeHooks::help";s:8:"datetime";s:34:"Drupal\\dblog\\Hook\\DblogHooks::help";s:5:"dblog";s:58:"Drupal\\dynamic_page_cache\\Hook\\DynamicPageCacheHooks::help";s:18:"dynamic_page_cache";s:36:"Drupal\\editor\\Hook\\EditorHooks::help";s:6:"editor";s:34:"Drupal\\field\\Hook\\FieldHooks::help";s:5:"field";s:39:"Drupal\\field_ui\\Hook\\FieldUiHooks::help";s:8:"field_ui";s:32:"Drupal\\file\\Hook\\FileHooks::help";s:4:"file";s:36:"Drupal\\filter\\Hook\\FilterHooks::help";s:6:"filter";s:32:"Drupal\\help\\Hook\\HelpHooks::help";s:4:"help";s:38:"Drupal\\history\\Hook\\HistoryHooks::help";s:7:"history";s:34:"Drupal\\image\\Hook\\ImageHooks::help";s:5:"image";s:32:"Drupal\\link\\Hook\\LinkHooks::help";s:4:"link";s:56:"Drupal\\menu_link_content\\Hook\\MenuLinkContentHooks::help";s:17:"menu_link_content";s:37:"Drupal\\menu_ui\\Hook\\MenuUiHooks::help";s:7:"menu_ui";s:34:"Drupal\\mysql\\Hook\\MysqlHooks::help";s:5:"mysql";s:36:"Drupal\\node\\Hook\\NodeHelpHooks::help";s:4:"node";s:38:"Drupal\\options\\Hook\\OptionsHooks::help";s:7:"options";s:43:"Drupal\\page_cache\\Hook\\PageCacheHooks::help";s:10:"page_cache";s:32:"Drupal\\path\\Hook\\PathHooks::help";s:4:"path";s:36:"Drupal\\search\\Hook\\SearchHooks::help";s:6:"search";s:40:"Drupal\\shortcut\\Hook\\ShortcutHooks::help";s:8:"shortcut";s:36:"Drupal\\system\\Hook\\SystemHooks::help";s:6:"system";s:40:"Drupal\\taxonomy\\Hook\\TaxonomyHooks::help";s:8:"taxonomy";s:32:"Drupal\\text\\Hook\\TextHooks::help";s:4:"text";s:38:"Drupal\\toolbar\\Hook\\ToolbarHooks::help";s:7:"toolbar";s:36:"Drupal\\update\\Hook\\UpdateHooks::help";s:6:"update";s:32:"Drupal\\user\\Hook\\UserHooks::help";s:4:"user";s:39:"Drupal\\views_ui\\Hook\\ViewsUiHooks::help";s:8:"views_ui";s:34:"Drupal\\views\\Hook\\ViewsHooks::help";s:5:"views";}s:5:"theme";a:22:{s:65:"Drupal\\announcements_feed\\Hook\\AnnouncementsFeedThemeHooks::theme";s:18:"announcements_feed";s:40:"Drupal\\big_pipe\\Hook\\BigPipeHooks::theme";s:8:"big_pipe";s:35:"Drupal\\block\\Hook\\BlockHooks::theme";s:5:"block";s:50:"Drupal\\block_content\\Hook\\BlockContentHooks::theme";s:13:"block_content";s:43:"Drupal\\ckeditor5\\Hook\\Ckeditor5Hooks::theme";s:9:"ckeditor5";s:44:"Drupal\\comment\\Hook\\CommentThemeHooks::theme";s:7:"comment";s:40:"Drupal\\field_ui\\Hook\\FieldUiHooks::theme";s:8:"field_ui";s:38:"Drupal\\file\\Hook\\FileThemeHooks::theme";s:4:"file";s:42:"Drupal\\filter\\Hook\\FilterThemeHooks::theme";s:6:"filter";s:33:"Drupal\\help\\Hook\\HelpHooks::theme";s:4:"help";s:40:"Drupal\\image\\Hook\\ImageThemeHooks::theme";s:5:"image";s:38:"Drupal\\link\\Hook\\LinkThemeHooks::theme";s:4:"link";s:38:"Drupal\\menu_ui\\Hook\\MenuUiHooks::theme";s:7:"menu_ui";s:38:"Drupal\\node\\Hook\\NodeThemeHooks::theme";s:4:"node";s:42:"Drupal\\search\\Hook\\SearchThemeHooks::theme";s:6:"search";s:42:"Drupal\\system\\Hook\\SystemThemeHooks::theme";s:6:"system";s:46:"Drupal\\taxonomy\\Hook\\TaxonomyThemeHooks::theme";s:8:"taxonomy";s:44:"Drupal\\toolbar\\Hook\\ToolbarThemeHooks::theme";s:7:"toolbar";s:42:"Drupal\\update\\Hook\\UpdateThemeHooks::theme";s:6:"update";s:38:"Drupal\\user\\Hook\\UserThemeHooks::theme";s:4:"user";s:45:"Drupal\\views_ui\\Hook\\ViewsUiThemeHooks::theme";s:8:"views_ui";s:40:"Drupal\\views\\Hook\\ViewsThemeHooks::theme";s:5:"views";}s:7:"toolbar";a:5:{s:69:"Drupal\\announcements_feed\\Hook\\AnnouncementsFeedToolbarHooks::toolbar";s:18:"announcements_feed";s:47:"Drupal\\contextual\\Hook\\ContextualHooks::toolbar";s:10:"contextual";s:43:"Drupal\\shortcut\\Hook\\ShortcutHooks::toolbar";s:8:"shortcut";s:41:"Drupal\\toolbar\\Hook\\ToolbarHooks::toolbar";s:7:"toolbar";s:35:"Drupal\\user\\Hook\\UserHooks::toolbar";s:4:"user";}s:13:"toolbar_alter";a:1:{s:74:"Drupal\\announcements_feed\\Hook\\AnnouncementsFeedToolbarHooks::toolbarAlter";s:18:"announcements_feed";}s:31:"form_system_cron_settings_alter";a:1:{s:74:"Drupal\\automated_cron\\Hook\\AutomatedCronHooks::formSystemCronSettingsAlter";s:14:"automated_cron";}s:16:"page_attachments";a:3:{s:50:"Drupal\\big_pipe\\Hook\\BigPipeHooks::pageAttachments";s:8:"big_pipe";s:55:"Drupal\\contextual\\Hook\\ContextualHooks::pageAttachments";s:10:"contextual";s:55:"Drupal\\system\\Hook\\PageAttachmentsHook::pageAttachments";s:6:"system";}s:44:"theme_suggestions_big_pipe_interface_preview";a:1:{s:79:"Drupal\\big_pipe\\Hook\\BigPipeThemeHooks::themeSuggestionsBigPipeInterfacePreview";s:8:"big_pipe";}s:8:"page_top";a:5:{s:37:"Drupal\\block\\Hook\\BlockHooks::pageTop";s:5:"block";s:40:"Drupal\\node\\Hook\\NodeThemeHooks::pageTop";s:4:"node";s:39:"Drupal\\system\\Hook\\SystemHooks::pageTop";s:6:"system";s:41:"Drupal\\toolbar\\Hook\\ToolbarHooks::pageTop";s:7:"toolbar";s:39:"Drupal\\update\\Hook\\UpdateHooks::pageTop";s:6:"update";}s:17:"modules_installed";a:4:{s:46:"Drupal\\block\\Hook\\BlockHooks::modulesInstalled";s:5:"block";s:44:"Drupal\\help\\Hook\\HelpHooks::modulesInstalled";s:4:"help";s:50:"Drupal\\node\\Hook\\NodeModuleHooks::modulesInstalled";s:4:"node";s:48:"Drupal\\update\\Hook\\UpdateHooks::modulesInstalled";s:6:"update";}s:16:"themes_installed";a:5:{s:45:"Drupal\\block\\Hook\\BlockHooks::themesInstalled";s:5:"block";s:55:"Drupal\\breakpoint\\Hook\\BreakpointHooks::themesInstalled";s:10:"breakpoint";s:43:"Drupal\\help\\Hook\\HelpHooks::themesInstalled";s:4:"help";s:51:"Drupal\\shortcut\\Hook\\ShortcutHooks::themesInstalled";s:8:"shortcut";s:47:"Drupal\\update\\Hook\\UpdateHooks::themesInstalled";s:6:"update";}s:7:"rebuild";a:1:{s:37:"Drupal\\block\\Hook\\BlockHooks::rebuild";s:5:"block";}s:16:"user_role_delete";a:2:{s:44:"Drupal\\block\\Hook\\BlockHooks::userRoleDelete";s:5:"block";s:42:"Drupal\\user\\Hook\\UserHooks::userRoleDelete";s:4:"user";}s:11:"menu_delete";a:3:{s:40:"Drupal\\block\\Hook\\BlockHooks::menuDelete";s:5:"block";s:62:"Drupal\\menu_link_content\\Hook\\MenuLinkContentHooks::menuDelete";s:17:"menu_link_content";s:43:"Drupal\\menu_ui\\Hook\\MenuUiHooks::menuDelete";s:7:"menu_ui";}s:28:"configurable_language_delete";a:2:{s:56:"Drupal\\block\\Hook\\BlockHooks::configurableLanguageDelete";s:5:"block";s:60:"Drupal\\node\\Hook\\NodeEntityHooks::configurableLanguageDelete";s:4:"node";}s:37:"block_build_local_actions_block_alter";a:1:{s:62:"Drupal\\block\\Hook\\BlockHooks::blockBuildLocalActionsBlockAlter";s:5:"block";}s:23:"theme_suggestions_block";a:1:{s:56:"Drupal\\block\\Hook\\BlockThemeHooks::themeSuggestionsBlock";s:5:"block";}s:17:"entity_type_alter";a:3:{s:60:"Drupal\\block_content\\Hook\\BlockContentHooks::entityTypeAlter";s:13:"block_content";s:67:"Drupal\\menu_link_content\\Hook\\MenuLinkContentHooks::entityTypeAlter";s:17:"menu_link_content";s:43:"Drupal\\path\\Hook\\PathHooks::entityTypeAlter";s:4:"path";}s:28:"query_entity_reference_alter";a:2:{s:70:"Drupal\\block_content\\Hook\\BlockContentHooks::queryEntityReferenceAlter";s:13:"block_content";s:57:"Drupal\\system\\Hook\\SystemHooks::queryEntityReferenceAlter";s:6:"system";}s:29:"theme_suggestions_block_alter";a:1:{s:71:"Drupal\\block_content\\Hook\\BlockContentHooks::themeSuggestionsBlockAlter";s:13:"block_content";}s:16:"entity_operation";a:6:{s:60:"Drupal\\block_content\\Hook\\BlockContentHooks::entityOperation";s:13:"block_content";s:50:"Drupal\\field_ui\\Hook\\FieldUiHooks::entityOperation";s:8:"field_ui";s:48:"Drupal\\menu_ui\\Hook\\MenuUiHooks::entityOperation";s:7:"menu_ui";s:51:"Drupal\\taxonomy\\Hook\\TaxonomyHooks::entityOperation";s:8:"taxonomy";s:43:"Drupal\\user\\Hook\\UserHooks::entityOperation";s:4:"user";s:50:"Drupal\\views_ui\\Hook\\ViewsUiHooks::entityOperation";s:8:"views_ui";}s:13:"block_presave";a:3:{s:57:"Drupal\\block_content\\Hook\\BlockContentHooks::blockPreSave";s:13:"block_content";s:44:"Drupal\\search\\Hook\\SearchHooks::blockPresave";s:6:"search";s:42:"Drupal\\views\\Hook\\ViewsHooks::blockPresave";s:5:"views";}s:26:"preprocess_entity_add_list";a:1:{s:73:"Drupal\\block_content\\Hook\\BlockContentThemeHooks::preprocessEntityAddList";s:13:"block_content";}s:18:"themes_uninstalled";a:3:{s:57:"Drupal\\breakpoint\\Hook\\BreakpointHooks::themesUninstalled";s:10:"breakpoint";s:45:"Drupal\\help\\Hook\\HelpHooks::themesUninstalled";s:4:"help";s:49:"Drupal\\update\\Hook\\UpdateHooks::themesUninstalled";s:6:"update";}s:29:"form_filter_format_form_alter";a:2:{s:57:"Drupal\\editor\\Hook\\EditorHooks::formFilterFormatFormAlter";s:6:"editor";s:63:"Drupal\\ckeditor5\\Hook\\Ckeditor5Hooks::formFilterFormatFormAlter";s:9:"ckeditor5";}s:18:"library_info_alter";a:2:{s:54:"Drupal\\ckeditor5\\Hook\\Ckeditor5Hooks::libraryInfoAlter";s:9:"ckeditor5";s:48:"Drupal\\system\\Hook\\SystemHooks::libraryInfoAlter";s:6:"system";}s:8:"js_alter";a:1:{s:45:"Drupal\\ckeditor5\\Hook\\Ckeditor5Hooks::jsAlter";s:9:"ckeditor5";}s:24:"config_schema_info_alter";a:1:{s:59:"Drupal\\ckeditor5\\Hook\\Ckeditor5Hooks::configSchemaInfoAlter";s:9:"ckeditor5";}s:38:"field_widget_single_element_form_alter";a:2:{s:71:"Drupal\\ckeditor5\\Hook\\Ckeditor5Hooks::fieldWidgetSingleElementFormAlter";s:9:"ckeditor5";s:61:"Drupal\\path\\Hook\\PathHooks::fieldWidgetSingleElementFormAlter";s:4:"path";}s:24:"entity_bundle_info_alter";a:1:{s:59:"Drupal\\ckeditor5\\Hook\\Ckeditor5Hooks::entityBundleInfoAlter";s:9:"ckeditor5";}s:14:"editor_presave";a:1:{s:51:"Drupal\\ckeditor5\\Hook\\Ckeditor5Hooks::editorPresave";s:9:"ckeditor5";}s:23:"entity_extra_field_info";a:3:{s:54:"Drupal\\comment\\Hook\\CommentHooks::entityExtraFieldInfo";s:7:"comment";s:54:"Drupal\\node\\Hook\\NodeEntityHooks::entityExtraFieldInfo";s:4:"node";s:48:"Drupal\\user\\Hook\\UserHooks::entityExtraFieldInfo";s:4:"user";}s:19:"field_config_create";a:2:{s:51:"Drupal\\comment\\Hook\\CommentHooks::fieldConfigCreate";s:7:"comment";s:47:"Drupal\\field\\Hook\\FieldHooks::fieldConfigCreate";s:5:"field";}s:19:"field_config_update";a:3:{s:51:"Drupal\\comment\\Hook\\CommentHooks::fieldConfigUpdate";s:7:"comment";s:47:"Drupal\\image\\Hook\\ImageHooks::fieldConfigUpdate";s:5:"image";s:47:"Drupal\\views\\Hook\\ViewsHooks::fieldConfigUpdate";s:5:"views";}s:27:"field_storage_config_insert";a:1:{s:58:"Drupal\\comment\\Hook\\CommentHooks::fieldStorageConfigInsert";s:7:"comment";}s:19:"field_config_delete";a:3:{s:51:"Drupal\\comment\\Hook\\CommentHooks::fieldConfigDelete";s:7:"comment";s:47:"Drupal\\image\\Hook\\ImageHooks::fieldConfigDelete";s:5:"image";s:47:"Drupal\\views\\Hook\\ViewsHooks::fieldConfigDelete";s:5:"views";}s:16:"node_links_alter";a:1:{s:48:"Drupal\\comment\\Hook\\CommentHooks::nodeLinksAlter";s:7:"comment";}s:11:"entity_view";a:1:{s:44:"Drupal\\comment\\Hook\\CommentHooks::entityView";s:7:"comment";}s:43:"field_info_entity_type_ui_definitions_alter";a:1:{s:71:"Drupal\\comment\\Hook\\CommentHooks::fieldInfoEntityTypeUiDefinitionsAlter";s:7:"comment";}s:19:"entity_storage_load";a:1:{s:51:"Drupal\\comment\\Hook\\CommentHooks::entityStorageLoad";s:7:"comment";}s:13:"entity_insert";a:2:{s:46:"Drupal\\comment\\Hook\\CommentHooks::entityInsert";s:7:"comment";s:44:"Drupal\\editor\\Hook\\EditorHooks::entityInsert";s:6:"editor";}s:16:"entity_predelete";a:2:{s:49:"Drupal\\comment\\Hook\\CommentHooks::entityPredelete";s:7:"comment";s:67:"Drupal\\menu_link_content\\Hook\\MenuLinkContentHooks::entityPredelete";s:17:"menu_link_content";}s:17:"node_update_index";a:1:{s:49:"Drupal\\comment\\Hook\\CommentHooks::nodeUpdateIndex";s:7:"comment";}s:18:"node_search_result";a:1:{s:50:"Drupal\\comment\\Hook\\CommentHooks::nodeSearchResult";s:7:"comment";}s:11:"user_cancel";a:4:{s:44:"Drupal\\comment\\Hook\\CommentHooks::userCancel";s:7:"comment";s:44:"Drupal\\history\\Hook\\HistoryHooks::userCancel";s:7:"history";s:56:"Drupal\\node\\Hook\\NodeUserHooks::userCancelBlockUnpublish";s:4:"node";s:50:"Drupal\\node\\Hook\\NodeUserHooks::userCancelReassign";s:4:"node";}s:14:"user_predelete";a:2:{s:47:"Drupal\\comment\\Hook\\CommentHooks::userPredelete";s:7:"comment";s:47:"Drupal\\node\\Hook\\NodeEntityHooks::userPredelete";s:4:"node";}s:19:"node_search_ranking";a:2:{s:41:"Drupal\\comment\\Hook\\CommentHooks::ranking";s:7:"comment";s:41:"Drupal\\node\\Hook\\NodeSearchHooks::ranking";s:4:"node";}s:27:"entity_view_display_presave";a:1:{s:58:"Drupal\\comment\\Hook\\CommentHooks::entityViewDisplayPresave";s:7:"comment";}s:30:"field_type_category_info_alter";a:2:{s:60:"Drupal\\comment\\Hook\\CommentHooks::fieldTypeCategoryInfoAlter";s:7:"comment";s:54:"Drupal\\link\\Hook\\LinkHooks::fieldTypeCategoryInfoAlter";s:4:"link";}s:16:"preprocess_block";a:8:{s:54:"Drupal\\comment\\Hook\\CommentThemeHooks::preprocessBlock";s:7:"comment";s:48:"Drupal\\help\\Hook\\HelpThemeHooks::preprocessBlock";s:4:"help";s:53:"Drupal\\menu_ui\\Hook\\MenuUiThemeHooks::preprocessBlock";s:7:"menu_ui";s:48:"Drupal\\node\\Hook\\NodeThemeHooks::preprocessBlock";s:4:"node";s:52:"Drupal\\search\\Hook\\SearchThemeHooks::preprocessBlock";s:6:"search";s:56:"Drupal\\shortcut\\Hook\\ShortcutThemeHooks::preprocessBlock";s:8:"shortcut";s:52:"Drupal\\system\\Hook\\SystemThemeHooks::preprocessBlock";s:6:"system";s:48:"Drupal\\user\\Hook\\UserThemeHooks::preprocessBlock";s:4:"user";}s:25:"preprocess_field__comment";a:1:{s:54:"Drupal\\comment\\Hook\\CommentThemeHooks::preprocessField";s:7:"comment";}s:10:"token_info";a:8:{s:49:"Drupal\\comment\\Hook\\CommentTokensHooks::tokenInfo";s:7:"comment";s:38:"Drupal\\file\\Hook\\TokenHooks::tokenInfo";s:4:"file";s:49:"Drupal\\history\\Hook\\HistoryTokensHooks::tokenInfo";s:7:"history";s:43:"Drupal\\node\\Hook\\NodeTokensHooks::tokenInfo";s:4:"node";s:47:"Drupal\\system\\Hook\\SystemTokensHooks::tokenInfo";s:6:"system";s:51:"Drupal\\taxonomy\\Hook\\TaxonomyTokensHooks::tokenInfo";s:8:"taxonomy";s:43:"Drupal\\user\\Hook\\UserTokensHooks::tokenInfo";s:4:"user";s:45:"Drupal\\views\\Hook\\ViewsTokensHooks::tokenInfo";s:5:"views";}s:6:"tokens";a:8:{s:46:"Drupal\\comment\\Hook\\CommentTokensHooks::tokens";s:7:"comment";s:35:"Drupal\\file\\Hook\\TokenHooks::tokens";s:4:"file";s:46:"Drupal\\history\\Hook\\HistoryTokensHooks::tokens";s:7:"history";s:40:"Drupal\\node\\Hook\\NodeTokensHooks::tokens";s:4:"node";s:44:"Drupal\\system\\Hook\\SystemTokensHooks::tokens";s:6:"system";s:48:"Drupal\\taxonomy\\Hook\\TaxonomyTokensHooks::tokens";s:8:"taxonomy";s:40:"Drupal\\user\\Hook\\UserTokensHooks::tokens";s:4:"user";s:42:"Drupal\\views\\Hook\\ViewsTokensHooks::tokens";s:5:"views";}s:16:"views_data_alter";a:4:{s:53:"Drupal\\comment\\Hook\\CommentViewsHooks::viewsDataAlter";s:7:"comment";s:59:"Drupal\\contextual\\Hook\\ContextualViewsHooks::viewsDataAlter";s:10:"contextual";s:53:"Drupal\\history\\Hook\\HistoryViewsHooks::viewsDataAlter";s:7:"history";s:55:"Drupal\\taxonomy\\Hook\\TaxonomyViewsHooks::viewsDataAlter";s:8:"taxonomy";}s:13:"file_download";a:5:{s:44:"Drupal\\config\\Hook\\ConfigHooks::fileDownload";s:6:"config";s:44:"Drupal\\editor\\Hook\\EditorHooks::fileDownload";s:6:"editor";s:43:"Drupal\\file\\Hook\\FileDownloadHook::__invoke";s:4:"file";s:42:"Drupal\\image\\Hook\\ImageHooks::fileDownload";s:5:"image";s:44:"Drupal\\system\\Hook\\SystemHooks::fileDownload";s:6:"system";}s:27:"contextual_links_view_alter";a:2:{s:64:"Drupal\\contextual\\Hook\\ContextualHooks::contextualLinksViewAlter";s:10:"contextual";s:59:"Drupal\\views_ui\\Hook\\ViewsUiHooks::contextualLinksViewAlter";s:8:"views_ui";}s:10:"preprocess";a:1:{s:55:"Drupal\\contextual\\Hook\\ContextualThemeHooks::preprocess";s:10:"contextual";}s:16:"field_views_data";a:5:{s:55:"Drupal\\datetime\\Hook\\DatetimeViewsHooks::fieldViewsData";s:8:"datetime";s:47:"Drupal\\file\\Hook\\FileViewsHooks::fieldViewsData";s:4:"file";s:49:"Drupal\\image\\Hook\\ImageViewsHooks::fieldViewsData";s:5:"image";s:53:"Drupal\\options\\Hook\\OptionsViewsHooks::fieldViewsData";s:7:"options";s:49:"Drupal\\views\\Hook\\ViewsViewsHooks::fieldViewsData";s:5:"views";}s:27:"menu_links_discovered_alter";a:2:{s:54:"Drupal\\dblog\\Hook\\DblogHooks::menuLinksDiscoveredAlter";s:5:"dblog";s:56:"Drupal\\editor\\Hook\\EditorHooks::menuLinksDiscoveredAlter";s:6:"editor";}s:34:"form_system_logging_settings_alter";a:1:{s:60:"Drupal\\dblog\\Hook\\DblogHooks::formSystemLoggingSettingsAlter";s:5:"dblog";}s:16:"views_pre_render";a:2:{s:44:"Drupal\\dblog\\Hook\\DblogHooks::viewsPreRender";s:5:"dblog";s:44:"Drupal\\views\\Hook\\ViewsHooks::viewsPreRender";s:5:"views";}s:10:"views_data";a:3:{s:44:"Drupal\\dblog\\Hook\\DblogViewsHooks::viewsData";s:5:"dblog";s:48:"Drupal\\history\\Hook\\HistoryViewsHooks::viewsData";s:7:"history";s:44:"Drupal\\views\\Hook\\ViewsViewsHooks::viewsData";s:5:"views";}s:18:"element_info_alter";a:3:{s:48:"Drupal\\editor\\Hook\\EditorHooks::elementInfoAlter";s:6:"editor";s:48:"Drupal\\system\\Hook\\SystemHooks::elementInfoAlter";s:6:"system";s:44:"Drupal\\user\\Hook\\UserHooks::elementInfoAlter";s:4:"user";}s:32:"form_filter_admin_overview_alter";a:1:{s:60:"Drupal\\editor\\Hook\\EditorHooks::formFilterAdminOverviewAlter";s:6:"editor";}s:13:"entity_update";a:1:{s:44:"Drupal\\editor\\Hook\\EditorHooks::entityUpdate";s:6:"editor";}s:13:"entity_delete";a:1:{s:44:"Drupal\\editor\\Hook\\EditorHooks::entityDelete";s:6:"editor";}s:22:"entity_revision_delete";a:1:{s:52:"Drupal\\editor\\Hook\\EditorHooks::entityRevisionDelete";s:6:"editor";}s:21:"filter_format_presave";a:1:{s:51:"Drupal\\editor\\Hook\\EditorHooks::filterFormatPresave";s:6:"editor";}s:25:"entity_field_storage_info";a:1:{s:52:"Drupal\\field\\Hook\\FieldHooks::entityFieldStorageInfo";s:5:"field";}s:24:"entity_bundle_field_info";a:1:{s:51:"Drupal\\field\\Hook\\FieldHooks::entityBundleFieldInfo";s:5:"field";}s:20:"entity_bundle_delete";a:1:{s:48:"Drupal\\field\\Hook\\FieldHooks::entityBundleDelete";s:5:"field";}s:25:"config_import_steps_alter";a:1:{s:52:"Drupal\\field\\Hook\\FieldHooks::configImportStepsAlter";s:5:"field";}s:35:"form_config_admin_import_form_alter";a:1:{s:60:"Drupal\\field\\Hook\\FieldHooks::formConfigAdminImportFormAlter";s:5:"field";}s:19:"field_config_insert";a:2:{s:47:"Drupal\\field\\Hook\\FieldHooks::fieldConfigInsert";s:5:"field";s:47:"Drupal\\views\\Hook\\ViewsHooks::fieldConfigInsert";s:5:"views";}s:27:"field_storage_config_update";a:3:{s:54:"Drupal\\field\\Hook\\FieldHooks::fieldStorageConfigUpdate";s:5:"field";s:54:"Drupal\\image\\Hook\\ImageHooks::fieldStorageConfigUpdate";s:5:"image";s:58:"Drupal\\options\\Hook\\OptionsHooks::fieldStorageConfigUpdate";s:7:"options";}s:20:"field_config_presave";a:1:{s:48:"Drupal\\field\\Hook\\FieldHooks::fieldConfigPresave";s:5:"field";}s:17:"entity_type_build";a:4:{s:50:"Drupal\\field_ui\\Hook\\FieldUiHooks::entityTypeBuild";s:8:"field_ui";s:48:"Drupal\\menu_ui\\Hook\\MenuUiHooks::entityTypeBuild";s:7:"menu_ui";s:47:"Drupal\\system\\Hook\\SystemHooks::entityTypeBuild";s:6:"system";s:50:"Drupal\\views_ui\\Hook\\ViewsUiHooks::entityTypeBuild";s:8:"views_ui";}s:20:"entity_bundle_create";a:1:{s:53:"Drupal\\field_ui\\Hook\\FieldUiHooks::entityBundleCreate";s:8:"field_ui";}s:24:"entity_view_mode_presave";a:1:{s:56:"Drupal\\field_ui\\Hook\\FieldUiHooks::entityViewModePresave";s:8:"field_ui";}s:24:"entity_form_mode_presave";a:2:{s:56:"Drupal\\field_ui\\Hook\\FieldUiHooks::entityFormModePresave";s:8:"field_ui";s:59:"Drupal\\system\\Hook\\SystemHooks::systemEntityFormModePresave";s:6:"system";}s:23:"entity_view_mode_delete";a:1:{s:55:"Drupal\\field_ui\\Hook\\FieldUiHooks::entityViewModeDelete";s:8:"field_ui";}s:23:"entity_form_mode_delete";a:1:{s:55:"Drupal\\field_ui\\Hook\\FieldUiHooks::entityFormModeDelete";s:8:"field_ui";}s:17:"local_tasks_alter";a:4:{s:50:"Drupal\\field_ui\\Hook\\FieldUiHooks::localTasksAlter";s:8:"field_ui";s:47:"Drupal\\node\\Hook\\NodeMenuHooks::localTasksAlter";s:4:"node";s:51:"Drupal\\taxonomy\\Hook\\TaxonomyHooks::localTasksAlter";s:8:"taxonomy";s:45:"Drupal\\views\\Hook\\ViewsHooks::localTasksAlter";s:5:"views";}s:42:"form_field_ui_field_storage_add_form_alter";a:1:{s:70:"Drupal\\field_ui\\Hook\\FieldUiHooks::formFieldUiFieldStorageAddFormAlter";s:8:"field_ui";}s:10:"form_alter";a:1:{s:44:"Drupal\\field_ui\\Hook\\FieldUiHooks::formAlter";s:8:"field_ui";}s:41:"preprocess_form_element__new_storage_type";a:1:{s:75:"Drupal\\field_ui\\Hook\\FieldUiThemeHooks::preprocessFormElementNewStorageType";s:8:"field_ui";}s:38:"form_system_file_system_settings_alter";a:1:{s:65:"Drupal\\file\\Hook\\FileFormHooks::formSystemFileSystemSettingsAlter";s:4:"file";}s:23:"field_widget_info_alter";a:1:{s:48:"Drupal\\file\\Hook\\FileHooks::fieldWidgetInfoAlter";s:4:"file";}s:14:"file_predelete";a:2:{s:41:"Drupal\\file\\Hook\\FileHooks::filePredelete";s:4:"file";s:43:"Drupal\\image\\Hook\\ImageHooks::filePredelete";s:5:"image";}s:20:"runtime_requirements";a:8:{s:42:"Drupal\\file\\Hook\\FileRequirements::runtime";s:4:"file";s:44:"Drupal\\image\\Hook\\ImageRequirements::runtime";s:5:"image";s:44:"Drupal\\mysql\\Hook\\MysqlRequirements::runtime";s:5:"mysql";s:42:"Drupal\\node\\Hook\\NodeRequirements::runtime";s:4:"node";s:46:"Drupal\\search\\Hook\\SearchRequirements::runtime";s:6:"search";s:63:"Drupal\\system\\Hook\\SystemRequirementsHooks::runtimeRequirements";s:6:"system";s:46:"Drupal\\update\\Hook\\UpdateRequirements::runtime";s:6:"update";s:42:"Drupal\\user\\Hook\\UserRequirements::runtime";s:4:"user";}s:33:"field_views_data_views_data_alter";a:2:{s:61:"Drupal\\file\\Hook\\FileViewsHooks::fieldViewsDataViewsDataAlter";s:4:"file";s:63:"Drupal\\image\\Hook\\ImageViewsHooks::fieldViewsDataViewsDataAlter";s:5:"image";}s:25:"filter_secure_image_alter";a:1:{s:54:"Drupal\\filter\\Hook\\FilterHooks::filterSecureImageAlter";s:6:"filter";}s:27:"block_view_help_block_alter";a:1:{s:51:"Drupal\\help\\Hook\\HelpHooks::blockViewHelpBlockAlter";s:4:"help";}s:19:"modules_uninstalled";a:5:{s:46:"Drupal\\help\\Hook\\HelpHooks::modulesUninstalled";s:4:"help";s:52:"Drupal\\node\\Hook\\NodeModuleHooks::modulesUninstalled";s:4:"node";s:50:"Drupal\\system\\Hook\\SystemHooks::modulesUninstalled";s:6:"system";s:50:"Drupal\\update\\Hook\\UpdateHooks::modulesUninstalled";s:6:"update";s:46:"Drupal\\user\\Hook\\UserHooks::modulesUninstalled";s:4:"user";}s:15:"node_view_alter";a:1:{s:47:"Drupal\\history\\Hook\\HistoryHooks::nodeViewAlter";s:7:"history";}s:11:"node_delete";a:1:{s:44:"Drupal\\history\\Hook\\HistoryHooks::nodeDelete";s:7:"history";}s:11:"user_delete";a:2:{s:44:"Drupal\\history\\Hook\\HistoryHooks::userDelete";s:7:"history";s:46:"Drupal\\shortcut\\Hook\\ShortcutHooks::userDelete";s:8:"shortcut";}s:12:"comment_view";a:1:{s:45:"Drupal\\history\\Hook\\HistoryHooks::commentView";s:7:"history";}s:9:"file_move";a:1:{s:38:"Drupal\\image\\Hook\\ImageHooks::fileMove";s:5:"image";}s:14:"entity_presave";a:1:{s:43:"Drupal\\image\\Hook\\ImageHooks::entityPresave";s:5:"image";}s:27:"field_storage_config_delete";a:2:{s:54:"Drupal\\image\\Hook\\ImageHooks::fieldStorageConfigDelete";s:5:"image";s:58:"Drupal\\options\\Hook\\OptionsHooks::fieldStorageConfigDelete";s:7:"options";}s:17:"path_alias_insert";a:1:{s:67:"Drupal\\menu_link_content\\Hook\\MenuLinkContentHooks::pathAliasInsert";s:17:"menu_link_content";}s:17:"path_alias_update";a:1:{s:67:"Drupal\\menu_link_content\\Hook\\MenuLinkContentHooks::pathAliasUpdate";s:17:"menu_link_content";}s:17:"path_alias_delete";a:1:{s:67:"Drupal\\menu_link_content\\Hook\\MenuLinkContentHooks::pathAliasDelete";s:17:"menu_link_content";}s:34:"block_view_system_menu_block_alter";a:1:{s:62:"Drupal\\menu_ui\\Hook\\MenuUiHooks::blockViewSystemMenuBlockAlter";s:7:"menu_ui";}s:20:"form_node_form_alter";a:1:{s:50:"Drupal\\menu_ui\\Hook\\MenuUiHooks::formNodeFormAlter";s:7:"menu_ui";}s:25:"form_node_type_form_alter";a:1:{s:54:"Drupal\\menu_ui\\Hook\\MenuUiHooks::formNodeTypeFormAlter";s:7:"menu_ui";}s:23:"system_breadcrumb_alter";a:1:{s:54:"Drupal\\menu_ui\\Hook\\MenuUiHooks::systemBreadcrumbAlter";s:7:"menu_ui";}s:11:"block_alter";a:1:{s:43:"Drupal\\node\\Hook\\NodeBlockHooks::blockAlter";s:4:"node";}s:29:"config_translation_info_alter";a:1:{s:71:"Drupal\\node\\Hook\\NodeConfigTranslationHooks::configTranslationInfoAlter";s:4:"node";}s:23:"query_node_access_alter";a:1:{s:56:"Drupal\\node\\Hook\\NodeDatabaseHooks::queryNodeAccessAlter";s:4:"node";}s:25:"entity_view_display_alter";a:1:{s:56:"Drupal\\node\\Hook\\NodeEntityHooks::entityViewDisplayAlter";s:4:"node";}s:11:"node_access";a:1:{s:44:"Drupal\\node\\Hook\\NodeEntityHooks::nodeAccess";s:4:"node";}s:35:"form_system_themes_admin_form_alter";a:1:{s:62:"Drupal\\node\\Hook\\NodeFormHooks::formSystemThemesAdminFormAlter";s:4:"node";}s:11:"node_update";a:2:{s:44:"Drupal\\node\\Hook\\NodeSearchHooks::nodeUpdate";s:4:"node";s:46:"Drupal\\taxonomy\\Hook\\TaxonomyHooks::nodeUpdate";s:8:"taxonomy";}s:14:"comment_insert";a:1:{s:47:"Drupal\\node\\Hook\\NodeSearchHooks::commentInsert";s:4:"node";}s:14:"comment_update";a:1:{s:47:"Drupal\\node\\Hook\\NodeSearchHooks::commentUpdate";s:4:"node";}s:14:"comment_delete";a:1:{s:47:"Drupal\\node\\Hook\\NodeSearchHooks::commentDelete";s:4:"node";}s:22:"theme_suggestions_node";a:1:{s:53:"Drupal\\node\\Hook\\NodeThemeHooks::themeSuggestionsNode";s:4:"node";}s:22:"preprocess_field__node";a:1:{s:52:"Drupal\\node\\Hook\\NodeThemeHooks::preprocessFieldNode";s:4:"node";}s:15:"preprocess_html";a:2:{s:47:"Drupal\\node\\Hook\\NodeThemeHooks::preprocessHtml";s:4:"node";s:53:"Drupal\\toolbar\\Hook\\ToolbarThemeHooks::preprocessHtml";s:7:"toolbar";}s:13:"views_analyze";a:2:{s:45:"Drupal\\node\\Hook\\NodeViewsHooks::viewsAnalyze";s:4:"node";s:47:"Drupal\\views_ui\\Hook\\ViewsUiHooks::viewsAnalyze";s:8:"views_ui";}s:25:"views_query_substitutions";a:3:{s:56:"Drupal\\node\\Hook\\NodeViewsHooks::viewsQuerySubstitutions";s:4:"node";s:65:"Drupal\\user\\Hook\\UserViewsExecutionHooks::viewsQuerySubstitutions";s:4:"user";s:67:"Drupal\\views\\Hook\\ViewsViewsExecutionHooks::viewsQuerySubstitutions";s:5:"views";}s:34:"field_storage_config_update_forbid";a:1:{s:64:"Drupal\\options\\Hook\\OptionsHooks::fieldStorageConfigUpdateForbid";s:7:"options";}s:28:"entity_base_field_info_alter";a:1:{s:52:"Drupal\\path\\Hook\\PathHooks::entityBaseFieldInfoAlter";s:4:"path";}s:22:"entity_base_field_info";a:1:{s:47:"Drupal\\path\\Hook\\PathHooks::entityBaseFieldInfo";s:4:"path";}s:25:"entity_translation_create";a:1:{s:51:"Drupal\\path\\Hook\\PathHooks::entityTranslationCreate";s:4:"path";}s:28:"form_search_block_form_alter";a:1:{s:56:"Drupal\\search\\Hook\\SearchHooks::formSearchBlockFormAlter";s:6:"search";}s:31:"theme_suggestions_search_result";a:1:{s:65:"Drupal\\search\\Hook\\SearchThemeHooks::themeSuggestionsSearchResult";s:6:"search";}s:21:"preprocess_page_title";a:1:{s:60:"Drupal\\shortcut\\Hook\\ShortcutThemeHooks::preprocessPageTitle";s:8:"shortcut";}s:12:"updater_info";a:1:{s:43:"Drupal\\system\\Hook\\SystemHooks::updaterInfo";s:6:"system";}s:17:"filetransfer_info";a:1:{s:48:"Drupal\\system\\Hook\\SystemHooks::filetransferInfo";s:6:"system";}s:17:"js_settings_build";a:1:{s:47:"Drupal\\system\\Hook\\SystemHooks::jsSettingsBuild";s:6:"system";}s:17:"js_settings_alter";a:2:{s:47:"Drupal\\system\\Hook\\SystemHooks::jsSettingsAlter";s:6:"system";s:43:"Drupal\\user\\Hook\\UserHooks::jsSettingsAlter";s:4:"user";}s:17:"system_info_alter";a:1:{s:47:"Drupal\\system\\Hook\\SystemHooks::systemInfoAlter";s:6:"system";}s:4:"mail";a:3:{s:36:"Drupal\\system\\Hook\\SystemHooks::mail";s:6:"system";s:36:"Drupal\\update\\Hook\\UpdateHooks::mail";s:6:"update";s:32:"Drupal\\user\\Hook\\UserHooks::mail";s:4:"user";}s:34:"block_view_system_main_block_alter";a:1:{s:61:"Drupal\\system\\Hook\\SystemHooks::blockViewSystemMainBlockAlter";s:6:"system";}s:20:"theme_registry_alter";a:1:{s:50:"Drupal\\system\\Hook\\SystemHooks::themeRegistryAlter";s:6:"system";}s:19:"archiver_info_alter";a:1:{s:49:"Drupal\\system\\Hook\\SystemHooks::archiverInfoAlter";s:6:"system";}s:19:"update_requirements";a:1:{s:62:"Drupal\\system\\Hook\\SystemRequirementsHooks::updateRequirements";s:6:"system";}s:22:"theme_suggestions_html";a:1:{s:57:"Drupal\\system\\Hook\\SystemThemeHooks::themeSuggestionsHtml";s:6:"system";}s:22:"theme_suggestions_page";a:1:{s:57:"Drupal\\system\\Hook\\SystemThemeHooks::themeSuggestionsPage";s:6:"system";}s:34:"theme_suggestions_maintenance_page";a:1:{s:68:"Drupal\\system\\Hook\\SystemThemeHooks::themeSuggestionsMaintenancePage";s:6:"system";}s:24:"theme_suggestions_region";a:1:{s:59:"Drupal\\system\\Hook\\SystemThemeHooks::themeSuggestionsRegion";s:6:"system";}s:23:"theme_suggestions_field";a:1:{s:58:"Drupal\\system\\Hook\\SystemThemeHooks::themeSuggestionsField";s:6:"system";}s:18:"preprocess_toolbar";a:1:{s:54:"Drupal\\system\\Hook\\SystemThemeHooks::preprocessToolbar";s:6:"system";}s:11:"node_insert";a:1:{s:46:"Drupal\\taxonomy\\Hook\\TaxonomyHooks::nodeInsert";s:8:"taxonomy";}s:14:"node_predelete";a:1:{s:49:"Drupal\\taxonomy\\Hook\\TaxonomyHooks::nodePredelete";s:8:"taxonomy";}s:20:"taxonomy_term_delete";a:1:{s:54:"Drupal\\taxonomy\\Hook\\TaxonomyHooks::taxonomyTermDelete";s:8:"taxonomy";}s:31:"theme_suggestions_taxonomy_term";a:1:{s:69:"Drupal\\taxonomy\\Hook\\TaxonomyThemeHooks::themeSuggestionsTaxonomyTerm";s:8:"taxonomy";}s:22:"field_views_data_alter";a:1:{s:60:"Drupal\\taxonomy\\Hook\\TaxonomyViewsHooks::fieldViewsDataAlter";s:8:"taxonomy";}s:21:"verify_update_archive";a:1:{s:51:"Drupal\\update\\Hook\\UpdateHooks::verifyUpdateArchive";s:6:"update";}s:9:"user_view";a:1:{s:36:"Drupal\\user\\Hook\\UserHooks::userView";s:4:"user";}s:15:"user_view_alter";a:1:{s:41:"Drupal\\user\\Hook\\UserHooks::userViewAlter";s:4:"user";}s:43:"template_preprocess_default_variables_alter";a:1:{s:67:"Drupal\\user\\Hook\\UserHooks::templatePreprocessDefaultVariablesAlter";s:4:"user";}s:10:"user_login";a:1:{s:37:"Drupal\\user\\Hook\\UserHooks::userLogin";s:4:"user";}s:11:"user_logout";a:1:{s:38:"Drupal\\user\\Hook\\UserHooks::userLogout";s:4:"user";}s:16:"user_role_insert";a:1:{s:42:"Drupal\\user\\Hook\\UserHooks::userRoleInsert";s:4:"user";}s:35:"form_system_regional_settings_alter";a:1:{s:59:"Drupal\\user\\Hook\\UserHooks::formSystemRegionalSettingsAlter";s:4:"user";}s:21:"filter_format_disable";a:1:{s:47:"Drupal\\user\\Hook\\UserHooks::filterFormatDisable";s:4:"user";}s:38:"views_plugins_argument_validator_alter";a:1:{s:67:"Drupal\\user\\Hook\\UserViewsHooks::viewsPluginsArgumentValidatorAlter";s:4:"user";}s:27:"views_plugins_display_alter";a:1:{s:59:"Drupal\\views_ui\\Hook\\ViewsUiHooks::viewsPluginsDisplayAlter";s:8:"views_ui";}s:21:"preprocess_views_view";a:1:{s:59:"Drupal\\views_ui\\Hook\\ViewsUiThemeHooks::preprocessViewsView";s:8:"views_ui";}s:47:"theme_suggestions_views_ui_view_preview_section";a:1:{s:81:"Drupal\\views_ui\\Hook\\ViewsUiThemeHooks::themeSuggestionsViewsUiViewPreviewSection";s:8:"views_ui";}s:28:"theme_suggestions_node_alter";a:1:{s:55:"Drupal\\views\\Hook\\ViewsHooks::themeSuggestionsNodeAlter";s:5:"views";}s:31:"theme_suggestions_comment_alter";a:1:{s:58:"Drupal\\views\\Hook\\ViewsHooks::themeSuggestionsCommentAlter";s:5:"views";}s:33:"theme_suggestions_container_alter";a:1:{s:60:"Drupal\\views\\Hook\\ViewsHooks::themeSuggestionsContainerAlter";s:5:"views";}s:26:"base_field_override_insert";a:1:{s:53:"Drupal\\views\\Hook\\ViewsHooks::baseFieldOverrideInsert";s:5:"views";}s:26:"base_field_override_update";a:1:{s:53:"Drupal\\views\\Hook\\ViewsHooks::baseFieldOverrideUpdate";s:5:"views";}s:26:"base_field_override_delete";a:1:{s:53:"Drupal\\views\\Hook\\ViewsHooks::baseFieldOverrideDelete";s:5:"views";}s:29:"form_views_exposed_form_alter";a:1:{s:55:"Drupal\\views\\Hook\\ViewsHooks::formViewsExposedFormAlter";s:5:"views";}s:17:"query_views_alter";a:1:{s:45:"Drupal\\views\\Hook\\ViewsHooks::queryViewsAlter";s:5:"views";}s:12:"view_presave";a:1:{s:41:"Drupal\\views\\Hook\\ViewsHooks::viewPresave";s:5:"views";}s:15:"preprocess_node";a:1:{s:49:"Drupal\\views\\Hook\\ViewsThemeHooks::preprocessNode";s:5:"views";}s:18:"preprocess_comment";a:1:{s:52:"Drupal\\views\\Hook\\ViewsThemeHooks::preprocessComment";s:5:"views";}s:24:"views_form_substitutions";a:1:{s:66:"Drupal\\views\\Hook\\ViewsViewsExecutionHooks::viewsFormSubstitutions";s:5:"views";}}'),
('hook_data', 'includes', 'a:0:{}'),
('hook_data', 'packed_order_operations', 'a:1:{s:29:"form_filter_format_form_alter";a:1:{i:0;a:2:{i:0;b:1;i:1;a:4:{s:10:"identifier";s:63:"Drupal\\ckeditor5\\Hook\\Ckeditor5Hooks::formFilterFormatFormAlter";s:21:"modulesToOrderAgainst";a:1:{i:0;s:6:"editor";}s:25:"identifiersToOrderAgainst";a:0:{}s:7:"isAfter";b:1;}}}}'),
('hook_data', 'preprocess_for_suggestions', 'a:18:{s:33:"comment_preprocess_field__comment";b:1;s:50:"field_ui_preprocess_form_element__new_storage_type";b:1;s:27:"node_preprocess_field__node";b:1;s:39:"olivero_preprocess_field__node__created";b:1;s:33:"olivero_preprocess_field__comment";b:1;s:44:"olivero_preprocess_item_list__search_results";b:1;s:33:"olivero_preprocess_links__comment";b:1;s:42:"claro_preprocess_menu_local_task__views_ui";b:1;s:47:"claro_preprocess_form_element__password_confirm";b:1;s:39:"claro_preprocess_form_element__password";b:1;s:34:"claro_preprocess_links__dropbutton";b:1;s:36:"claro_preprocess_links__action_links";b:1;s:49:"claro_preprocess_views_view_fields__media_library";b:1;s:61:"claro_preprocess_item_list__media_library_add_form_media_list";b:1;s:43:"claro_preprocess_media_library_item__widget";b:1;s:42:"claro_preprocess_media_library_item__small";b:1;s:47:"claro_preprocess_fieldset__media_library_widget";b:1;s:42:"claro_preprocess_links__media_library_menu";b:1;}'),
('hook_data', 'theme_hook_list', 'a:2:{s:7:"olivero";a:37:{s:21:"preprocess_page_title";a:1:{i:0;s:29:"olivero_preprocess_page_title";}s:27:"preprocess_maintenance_page";a:1:{i:0;s:35:"olivero_preprocess_maintenance_page";}s:15:"preprocess_node";a:1:{i:0;s:23:"olivero_preprocess_node";}s:16:"preprocess_block";a:1:{i:0;s:24:"olivero_preprocess_block";}s:28:"theme_suggestions_menu_alter";a:1:{i:0;s:36:"olivero_theme_suggestions_menu_alter";}s:15:"preprocess_menu";a:1:{i:0;s:23:"olivero_preprocess_menu";}s:28:"theme_suggestions_form_alter";a:1:{i:0;s:36:"olivero_theme_suggestions_form_alter";}s:10:"form_alter";a:1:{i:0;s:18:"olivero_form_alter";}s:29:"theme_suggestions_block_alter";a:1:{i:0;s:37:"olivero_theme_suggestions_block_alter";}s:27:"preprocess_menu_local_tasks";a:1:{i:0;s:35:"olivero_preprocess_menu_local_tasks";}s:23:"preprocess_form_element";a:1:{i:0;s:31:"olivero_preprocess_form_element";}s:29:"preprocess_form_element_label";a:1:{i:0;s:37:"olivero_preprocess_form_element_label";}s:16:"preprocess_input";a:1:{i:0;s:24:"olivero_preprocess_input";}s:19:"preprocess_textarea";a:1:{i:0;s:27:"olivero_preprocess_textarea";}s:17:"preprocess_select";a:1:{i:0;s:25:"olivero_preprocess_select";}s:21:"preprocess_checkboxes";a:1:{i:0;s:29:"olivero_preprocess_checkboxes";}s:17:"preprocess_radios";a:1:{i:0;s:25:"olivero_preprocess_radios";}s:16:"preprocess_field";a:1:{i:0;s:24:"olivero_preprocess_field";}s:36:"preprocess_field_multiple_value_form";a:1:{i:0;s:44:"olivero_preprocess_field_multiple_value_form";}s:26:"preprocess_menu_local_task";a:1:{i:0;s:34:"olivero_preprocess_menu_local_task";}s:19:"preprocess_fieldset";a:1:{i:0;s:27:"olivero_preprocess_fieldset";}s:28:"theme_suggestions_user_alter";a:1:{i:0;s:36:"olivero_theme_suggestions_user_alter";}s:31:"preprocess_field__node__created";a:1:{i:0;s:39:"olivero_preprocess_field__node__created";}s:25:"preprocess_filter_caption";a:1:{i:0;s:33:"olivero_preprocess_filter_caption";}s:35:"form_node_preview_form_select_alter";a:1:{i:0;s:43:"olivero_form_node_preview_form_select_alter";}s:18:"preprocess_comment";a:1:{i:0;s:26:"olivero_preprocess_comment";}s:25:"preprocess_field__comment";a:1:{i:0;s:33:"olivero_preprocess_field__comment";}s:18:"element_info_alter";a:1:{i:0;s:26:"olivero_element_info_alter";}s:30:"preprocess_text_format_wrapper";a:1:{i:0;s:38:"olivero_preprocess_text_format_wrapper";}s:24:"preprocess_search_result";a:1:{i:0;s:32:"olivero_preprocess_search_result";}s:36:"preprocess_item_list__search_results";a:1:{i:0;s:44:"olivero_preprocess_item_list__search_results";}s:25:"preprocess_links__comment";a:1:{i:0;s:33:"olivero_preprocess_links__comment";}s:16:"preprocess_table";a:1:{i:0;s:24:"olivero_preprocess_table";}s:27:"preprocess_views_view_table";a:1:{i:0;s:35:"olivero_preprocess_views_view_table";}s:29:"form_views_exposed_form_alter";a:1:{i:0;s:37:"olivero_form_views_exposed_form_alter";}s:32:"form_system_theme_settings_alter";a:1:{i:0;s:40:"olivero_form_system_theme_settings_alter";}s:15:"preprocess_html";a:1:{i:0;s:62:"Drupal\\olivero\\Hook\\OliveroPagePreprocessHooks::preprocessHtml";}}s:5:"claro";a:69:{s:27:"preprocess_maintenance_page";a:1:{i:0;s:33:"claro_preprocess_maintenance_page";}s:16:"preprocess_block";a:1:{i:0;s:22:"claro_preprocess_block";}s:10:"form_alter";a:1:{i:0;s:43:"Drupal\\claro\\Hook\\ClaroFormHooks::formAlter";}s:27:"preprocess_menu_local_tasks";a:1:{i:0;s:33:"claro_preprocess_menu_local_tasks";}s:23:"preprocess_form_element";a:1:{i:0;s:29:"claro_preprocess_form_element";}s:16:"preprocess_input";a:1:{i:0;s:22:"claro_preprocess_input";}s:17:"preprocess_select";a:1:{i:0;s:23:"claro_preprocess_select";}s:36:"preprocess_field_multiple_value_form";a:1:{i:0;s:42:"claro_preprocess_field_multiple_value_form";}s:26:"preprocess_menu_local_task";a:1:{i:0;s:32:"claro_preprocess_menu_local_task";}s:19:"preprocess_fieldset";a:1:{i:0;s:25:"claro_preprocess_fieldset";}s:35:"form_node_preview_form_select_alter";a:1:{i:0;s:41:"claro_form_node_preview_form_select_alter";}s:18:"element_info_alter";a:1:{i:0;s:24:"claro_element_info_alter";}s:30:"preprocess_text_format_wrapper";a:1:{i:0;s:36:"claro_preprocess_text_format_wrapper";}s:16:"preprocess_table";a:1:{i:0;s:22:"claro_preprocess_table";}s:27:"preprocess_views_view_table";a:1:{i:0;s:33:"claro_preprocess_views_view_table";}s:29:"form_views_exposed_form_alter";a:1:{i:0;s:35:"claro_form_views_exposed_form_alter";}s:36:"theme_suggestions_form_element_alter";a:1:{i:0;s:42:"claro_theme_suggestions_form_element_alter";}s:31:"theme_suggestions_details_alter";a:1:{i:0;s:37:"claro_theme_suggestions_details_alter";}s:22:"page_attachments_alter";a:1:{i:0;s:28:"claro_page_attachments_alter";}s:36:"preprocess_menu_local_task__views_ui";a:1:{i:0;s:42:"claro_preprocess_menu_local_task__views_ui";}s:24:"preprocess_node_add_list";a:1:{i:0;s:30:"claro_preprocess_node_add_list";}s:33:"preprocess_block_content_add_list";a:1:{i:0;s:39:"claro_preprocess_block_content_add_list";}s:26:"preprocess_entity_add_list";a:1:{i:0;s:32:"claro_preprocess_entity_add_list";}s:22:"preprocess_admin_block";a:1:{i:0;s:28:"claro_preprocess_admin_block";}s:30:"preprocess_admin_block_content";a:1:{i:0;s:36:"claro_preprocess_admin_block_content";}s:28:"preprocess_menu_local_action";a:1:{i:0;s:34:"claro_preprocess_menu_local_action";}s:20:"theme_registry_alter";a:1:{i:0;s:26:"claro_theme_registry_alter";}s:23:"preprocess_install_page";a:1:{i:0;s:29:"claro_preprocess_install_page";}s:40:"theme_suggestions_maintenance_page_alter";a:1:{i:0;s:46:"claro_theme_suggestions_maintenance_page_alter";}s:18:"preprocess_details";a:1:{i:0;s:24:"claro_preprocess_details";}s:16:"preprocess_links";a:1:{i:0;s:22:"claro_preprocess_links";}s:20:"form_node_form_alter";a:1:{i:0;s:26:"claro_form_node_form_alter";}s:33:"form_menu_link_content_form_alter";a:1:{i:0;s:39:"claro_form_menu_link_content_form_alter";}s:25:"form_menu_link_edit_alter";a:1:{i:0;s:31:"claro_form_menu_link_edit_alter";}s:21:"form_media_form_alter";a:1:{i:0;s:27:"claro_form_media_form_alter";}s:26:"views_ui_display_top_alter";a:1:{i:0;s:32:"claro_views_ui_display_top_alter";}s:26:"views_ui_display_tab_alter";a:1:{i:0;s:32:"claro_views_ui_display_tab_alter";}s:29:"preprocess_views_exposed_form";a:1:{i:0;s:35:"claro_preprocess_views_exposed_form";}s:25:"form_system_modules_alter";a:1:{i:0;s:31:"claro_form_system_modules_alter";}s:27:"preprocess_datetime_wrapper";a:1:{i:0;s:33:"claro_preprocess_datetime_wrapper";}s:41:"preprocess_form_element__password_confirm";a:1:{i:0;s:47:"claro_preprocess_form_element__password_confirm";}s:33:"preprocess_form_element__password";a:1:{i:0;s:39:"claro_preprocess_form_element__password";}s:22:"preprocess_filter_tips";a:1:{i:0;s:28:"claro_preprocess_filter_tips";}s:25:"preprocess_field_ui_table";a:1:{i:0;s:31:"claro_preprocess_field_ui_table";}s:28:"preprocess_links__dropbutton";a:1:{i:0;s:34:"claro_preprocess_links__dropbutton";}s:38:"preprocess_views_ui_display_tab_bucket";a:1:{i:0;s:44:"claro_preprocess_views_ui_display_tab_bucket";}s:26:"preprocess_status_messages";a:1:{i:0;s:32:"claro_preprocess_status_messages";}s:29:"preprocess_system_themes_page";a:1:{i:0;s:35:"claro_preprocess_system_themes_page";}s:30:"preprocess_links__action_links";a:1:{i:0;s:36:"claro_preprocess_links__action_links";}s:28:"preprocess_file_managed_file";a:1:{i:0;s:34:"claro_preprocess_file_managed_file";}s:31:"preprocess_file_widget_multiple";a:1:{i:0;s:37:"claro_preprocess_file_widget_multiple";}s:23:"preprocess_image_widget";a:1:{i:0;s:29:"claro_preprocess_image_widget";}s:43:"preprocess_views_view_fields__media_library";a:1:{i:0;s:49:"claro_preprocess_views_view_fields__media_library";}s:33:"form_media_library_add_form_alter";a:1:{i:0;s:39:"claro_form_media_library_add_form_alter";}s:40:"form_media_library_add_form_upload_alter";a:1:{i:0;s:46:"claro_form_media_library_add_form_upload_alter";}s:40:"form_media_library_add_form_oembed_alter";a:1:{i:0;s:46:"claro_form_media_library_add_form_oembed_alter";}s:55:"preprocess_item_list__media_library_add_form_media_list";a:1:{i:0;s:61:"claro_preprocess_item_list__media_library_add_form_media_list";}s:37:"preprocess_media_library_item__widget";a:1:{i:0;s:43:"claro_preprocess_media_library_item__widget";}s:36:"preprocess_media_library_item__small";a:1:{i:0;s:42:"claro_preprocess_media_library_item__small";}s:41:"preprocess_fieldset__media_library_widget";a:1:{i:0;s:47:"claro_preprocess_fieldset__media_library_widget";}s:16:"views_pre_render";a:1:{i:0;s:22:"claro_views_pre_render";}s:36:"preprocess_links__media_library_menu";a:1:{i:0;s:42:"claro_preprocess_links__media_library_menu";}s:41:"preprocess_views_ui_rearrange_filter_form";a:1:{i:0;s:47:"claro_preprocess_views_ui_rearrange_filter_form";}s:36:"form_views_ui_config_item_form_alter";a:1:{i:0;s:42:"claro_form_views_ui_config_item_form_alter";}s:36:"form_views_ui_add_handler_form_alter";a:1:{i:0;s:42:"claro_form_views_ui_add_handler_form_alter";}s:18:"preprocess_toolbar";a:1:{i:0;s:24:"claro_preprocess_toolbar";}s:40:"system_module_invoked_library_info_alter";a:1:{i:0;s:46:"claro_system_module_invoked_library_info_alter";}s:42:"system_module_invoked_theme_registry_alter";a:1:{i:0;s:48:"claro_system_module_invoked_theme_registry_alter";}s:33:"form_user_admin_permissions_alter";a:1:{i:0;s:39:"claro_form_user_admin_permissions_alter";}}}'),
('hook_data', 'theme_preprocess_for_suggestions', 'a:15:{s:39:"olivero_preprocess_field__node__created";b:1;s:33:"olivero_preprocess_field__comment";b:1;s:44:"olivero_preprocess_item_list__search_results";b:1;s:33:"olivero_preprocess_links__comment";b:1;s:42:"claro_preprocess_menu_local_task__views_ui";b:1;s:47:"claro_preprocess_form_element__password_confirm";b:1;s:39:"claro_preprocess_form_element__password";b:1;s:34:"claro_preprocess_links__dropbutton";b:1;s:36:"claro_preprocess_links__action_links";b:1;s:49:"claro_preprocess_views_view_fields__media_library";b:1;s:61:"claro_preprocess_item_list__media_library_add_form_media_list";b:1;s:43:"claro_preprocess_media_library_item__widget";b:1;s:42:"claro_preprocess_media_library_item__small";b:1;s:47:"claro_preprocess_fieldset__media_library_widget";b:1;s:42:"claro_preprocess_links__media_library_menu";b:1;}');
INSERT INTO `[[dbprefix]]key_value` VALUES
('post_update', 'existing_updates', 'a:173:{i:0;s:70:"system_post_update_convert_empty_country_and_timezone_settings_to_null";i:1;s:70:"system_post_update_convert_empty_description_entity_form_modes_to_null";i:2;s:36:"system_post_update_delete_rss_config";i:3;s:34:"system_post_update_remove_path_key";i:4;s:46:"system_post_update_remove_rss_cdata_subscriber";i:5;s:32:"system_post_update_sdc_uninstall";i:6;s:64:"system_post_update_recalculate_configuration_entity_dependencies";i:7;s:48:"system_post_update_add_region_to_entity_displays";i:8;s:37:"system_post_update_hashes_clear_cache";i:9;s:36:"system_post_update_timestamp_plugins";i:10;s:41:"system_post_update_classy_message_library";i:11;s:37:"system_post_update_field_type_plugins";i:12;s:48:"system_post_update_field_formatter_entity_schema";i:13;s:36:"system_post_update_fix_jquery_extend";i:14;s:40:"system_post_update_change_action_plugins";i:15;s:47:"system_post_update_change_delete_action_plugins";i:16;s:41:"system_post_update_language_item_callback";i:17;s:31:"system_post_update_extra_fields";i:18;s:37:"system_post_update_states_clear_cache";i:19;s:64:"system_post_update_add_expand_all_items_key_in_system_menu_block";i:20;s:35:"system_post_update_clear_menu_cache";i:21;s:46:"system_post_update_layout_plugin_schema_change";i:22;s:60:"system_post_update_entity_reference_autocomplete_match_limit";i:23;s:44:"system_post_update_extra_fields_form_display";i:24;s:39:"system_post_update_uninstall_simpletest";i:25;s:52:"system_post_update_uninstall_entity_reference_module";i:26;s:54:"system_post_update_entity_revision_metadata_bc_cleanup";i:27;s:35:"system_post_update_uninstall_classy";i:28;s:35:"system_post_update_uninstall_stable";i:29;s:44:"system_post_update_claro_dropbutton_variants";i:30;s:37:"system_post_update_schema_version_int";i:31;s:38:"system_post_update_delete_rss_settings";i:32;s:52:"system_post_update_remove_key_value_expire_all_index";i:33;s:44:"system_post_update_service_advisory_settings";i:34;s:44:"system_post_update_delete_authorize_settings";i:35;s:34:"system_post_update_sort_all_config";i:36;s:50:"system_post_update_enable_provider_database_driver";i:37;s:35:"system_post_update_linkset_settings";i:38;s:48:"system_post_update_enable_password_compatibility";i:39;s:39:"system_post_update_remove_asset_entries";i:40;s:44:"system_post_update_remove_asset_query_string";i:41;s:54:"system_post_update_add_description_to_entity_view_mode";i:42;s:54:"system_post_update_add_description_to_entity_form_mode";i:43;s:44:"system_post_update_set_blank_log_url_to_null";i:44;s:38:"system_post_update_mailer_dsn_settings";i:45;s:49:"system_post_update_mailer_structured_dsn_settings";i:46;s:47:"system_post_update_amend_config_sync_readme_url";i:47;s:44:"system_post_update_mail_notification_setting";i:48;s:54:"system_post_update_set_cron_logging_setting_to_boolean";i:49;s:56:"system_post_update_move_development_settings_to_keyvalue";i:50;s:58:"system_post_update_add_langcode_to_all_translatable_config";i:51;s:39:"big_pipe_post_update_html5_placeholders";i:52;s:37:"block_post_update_make_weight_integer";i:53;s:54:"block_post_update_set_menu_block_depth_to_null_if_zero";i:54;s:54:"block_post_update_disable_blocks_with_missing_contexts";i:55;s:40:"block_post_update_disabled_region_update";i:56;s:42:"block_post_update_fix_negate_in_conditions";i:57;s:45:"block_post_update_replace_node_type_condition";i:58;s:60:"block_content_post_update_remove_block_content_listing_empty";i:59;s:63:"block_content_post_update_remove_block_content_status_info_keys";i:60;s:51:"block_content_post_update_add_views_reusable_filter";i:61;s:51:"block_content_post_update_entity_changed_constraint";i:62;s:51:"block_content_post_update_move_custom_block_library";i:63;s:55:"block_content_post_update_block_library_view_permission";i:64;s:42:"block_content_post_update_sort_permissions";i:65;s:39:"block_content_post_update_revision_type";i:66;s:31:"ckeditor5_post_update_list_type";i:67;s:37:"ckeditor5_post_update_list_type_again";i:68;s:39:"ckeditor5_post_update_alignment_buttons";i:69;s:40:"ckeditor5_post_update_image_toolbar_item";i:70;s:51:"ckeditor5_post_update_plugins_settings_export_order";i:71;s:32:"ckeditor5_post_update_code_block";i:72;s:37:"ckeditor5_post_update_list_multiblock";i:73;s:41:"ckeditor5_post_update_list_start_reversed";i:74;s:49:"dblog_post_update_convert_recent_messages_to_view";i:75;s:56:"editor_post_update_clear_cache_for_file_reference_filter";i:76;s:34:"editor_post_update_image_lazy_load";i:77;s:49:"editor_post_update_sanitize_image_upload_settings";i:78;s:46:"field_post_update_save_custom_storage_property";i:79;s:50:"field_post_update_entity_reference_handler_setting";i:80;s:43:"field_post_update_email_widget_size_setting";i:81;s:47:"field_post_update_remove_handler_submit_setting";i:82;s:32:"file_post_update_add_playsinline";i:83;s:54:"file_post_update_add_txt_if_allows_insecure_extensions";i:84;s:41:"file_post_update_add_permissions_to_roles";i:85;s:64:"file_post_update_add_default_filename_sanitization_configuration";i:86;s:31:"filter_post_update_sort_filters";i:87;s:44:"filter_post_update_consolidate_filter_config";i:88;s:35:"help_post_update_help_topics_search";i:89;s:38:"help_post_update_help_topics_uninstall";i:90;s:41:"help_post_update_add_permissions_to_roles";i:91;s:57:"path_alias_post_update_update_path_alias_revision_indexes";i:92;s:51:"path_alias_post_update_drop_path_alias_status_index";i:93;s:43:"search_post_update_block_with_empty_page_id";i:94;s:29:"search_post_update_block_page";i:95;s:55:"search_post_update_reindex_after_diacritics_rule_change";i:96;s:42:"text_post_update_add_required_summary_flag";i:97;s:55:"text_post_update_add_required_summary_flag_form_display";i:98;s:32:"text_post_update_allowed_formats";i:99;s:45:"user_post_update_enforce_order_of_permissions";i:100;s:29:"user_post_update_update_roles";i:101;s:33:"user_post_update_sort_permissions";i:102;s:39:"user_post_update_sort_permissions_again";i:103;s:45:"comment_post_update_enable_comment_admin_view";i:104;s:42:"comment_post_update_add_ip_address_setting";i:105;s:48:"contextual_post_update_fixed_endpoint_and_markup";i:106;s:42:"image_post_update_image_style_dependencies";i:107;s:50:"image_post_update_scale_and_crop_effect_add_anchor";i:108;s:41:"image_post_update_image_loading_attribute";i:109;s:65:"menu_link_content_post_update_make_menu_link_content_revisionable";i:110;s:48:"node_post_update_add_rebuild_permission_to_roles";i:111;s:52:"node_post_update_create_promote_base_field_overrides";i:112;s:46:"node_post_update_configure_status_field_widget";i:113;s:41:"node_post_update_node_revision_views_data";i:114;s:40:"node_post_update_glossary_view_published";i:115;s:45:"node_post_update_rebuild_node_revision_routes";i:116;s:50:"node_post_update_modify_base_field_author_override";i:117;s:59:"node_post_update_set_node_type_description_and_help_to_null";i:118;s:49:"path_post_update_create_language_content_settings";i:119;s:43:"taxonomy_post_update_clear_views_data_cache";i:120;s:64:"taxonomy_post_update_clear_entity_bundle_field_definitions_cache";i:121;s:63:"taxonomy_post_update_handle_publishing_status_addition_in_views";i:122;s:55:"taxonomy_post_update_remove_hierarchy_from_vocabularies";i:123;s:52:"taxonomy_post_update_make_taxonomy_term_revisionable";i:124;s:50:"taxonomy_post_update_configure_status_field_widget";i:125;s:65:"taxonomy_post_update_clear_views_argument_validator_plugins_cache";i:126;s:37:"taxonomy_post_update_set_new_revision";i:127;s:55:"taxonomy_post_update_set_vocabulary_description_to_null";i:128;s:44:"views_post_update_add_date_default_arguments";i:129;s:38:"views_post_update_block_items_per_page";i:130;s:31:"views_post_update_format_plural";i:131;s:33:"views_post_update_table_css_class";i:132;s:44:"views_post_update_update_remember_role_empty";i:133;s:47:"views_post_update_views_data_argument_plugin_id";i:134;s:46:"views_post_update_update_cacheability_metadata";i:135;s:46:"views_post_update_cleanup_duplicate_views_data";i:136;s:46:"views_post_update_field_formatter_dependencies";i:137;s:36:"views_post_update_taxonomy_index_tid";i:138;s:41:"views_post_update_serializer_dependencies";i:139;s:39:"views_post_update_boolean_filter_values";i:140;s:33:"views_post_update_grouped_filters";i:141;s:42:"views_post_update_revision_metadata_fields";i:142;s:33:"views_post_update_entity_link_url";i:143;s:34:"views_post_update_bulk_field_moved";i:144;s:41:"views_post_update_filter_placeholder_text";i:145;s:47:"views_post_update_views_data_table_dependencies";i:146;s:45:"views_post_update_table_display_cache_max_age";i:147;s:53:"views_post_update_exposed_filter_blocks_label_display";i:148;s:48:"views_post_update_make_placeholders_translatable";i:149;s:41:"views_post_update_limit_operator_defaults";i:150;s:33:"views_post_update_remove_core_key";i:151;s:51:"views_post_update_field_names_for_multivalue_fields";i:152;s:52:"views_post_update_configuration_entity_relationships";i:153;s:48:"views_post_update_rename_default_display_setting";i:154;s:50:"views_post_update_remove_sorting_global_text_field";i:155;s:36:"views_post_update_title_translations";i:156;s:33:"views_post_update_sort_identifier";i:157;s:53:"views_post_update_provide_revision_table_relationship";i:158;s:33:"views_post_update_image_lazy_load";i:159;s:39:"views_post_update_boolean_custom_titles";i:160;s:35:"views_post_update_oembed_eager_load";i:161;s:44:"views_post_update_responsive_image_lazy_load";i:162;s:37:"views_post_update_timestamp_formatter";i:163;s:38:"views_post_update_fix_revision_id_part";i:164;s:36:"views_post_update_add_missing_labels";i:165;s:43:"views_post_update_remove_skip_cache_setting";i:166;s:50:"views_post_update_remove_default_argument_skip_url";i:167;s:46:"views_post_update_taxonomy_filter_user_context";i:168;s:31:"views_post_update_pager_heading";i:169;s:54:"views_post_update_rendered_entity_field_cache_metadata";i:170;s:45:"olivero_post_update_add_olivero_primary_color";i:171;s:35:"update_post_update_clear_disk_cache";i:172;s:36:"update_post_update_fix_update_emails";}'),
('state', 'announcements_feed.last_fetch', 'i:[[timestamp]];'),
('state', 'asset.css_js_query_string', '[[css_js_query_string]]'),
('state', 'comment.maintain_entity_statistics', 'b:1;'),
('state', 'comment.node_comment_statistics_scale', 'd:1;'),
('state', 'help_search_unindexed_count', 's:2:"78";'),
('state', 'install_task', 's:4:"done";'),
('state', 'install_time', 'i:[[timestamp]];'),
('state', 'node.min_max_update_time', 'a:2:{s:11:"min_created";N;s:11:"max_created";N;}'),
('state', 'router.path_roots', 'a:29:{i:0;s:5:"admin";i:1;s:8:"big_pipe";i:2;s:14:"block-category";i:3;s:5:"block";i:4;s:9:"ckeditor5";i:5;s:7:"comment";i:6;s:8:"comments";i:7;s:10:"contextual";i:8;s:6:"editor";i:9;s:4:"file";i:10;s:6:"filter";i:11;s:7:"history";i:12;s:5:"sites";i:13;s:6:"system";i:14;s:4:"node";i:15;s:6:"search";i:16;s:4:"user";i:17;s:4:"cron";i:18;s:0:"";i:19;s:9:"<current>";i:20;s:5:"batch";i:21;s:10:"update.php";i:22;s:29:"entity_reference_autocomplete";i:23;s:7:"session";i:24;s:8:"taxonomy";i:25;s:7:"toolbar";i:26;s:11:".well-known";i:27;s:7:"rss.xml";i:28;s:5:"views";}'),
('state', 'routing.menu_masks.router', 'a:46:{i:0;i:988;i:1;i:501;i:2;i:494;i:3;i:493;i:4;i:492;i:5;i:464;i:6;i:253;i:7;i:252;i:8;i:250;i:9;i:247;i:10;i:246;i:11;i:245;i:12;i:244;i:13;i:232;i:14;i:126;i:15;i:125;i:16;i:124;i:17;i:123;i:18;i:122;i:19;i:117;i:20;i:116;i:21;i:63;i:22;i:62;i:23;i:61;i:24;i:60;i:25;i:53;i:26;i:49;i:27;i:42;i:28;i:31;i:29;i:30;i:30;i:29;i:31;i:28;i:32;i:24;i:33;i:21;i:34;i:15;i:35;i:14;i:36;i:13;i:37;i:12;i:38;i:11;i:39;i:8;i:40;i:7;i:41;i:6;i:42;i:5;i:43;i:3;i:44;i:2;i:45;i:1;}'),
('state', 'routing.non_admin_routes', 'a:92:{i:0;s:13:"big_pipe.nojs";i:1;s:27:"block.category_autocomplete";i:2;s:22:"block_content.add_form";i:3;s:31:"ckeditor5.media_entity_metadata";i:4;s:33:"ckeditor5.entity_link_suggestions";i:5;s:24:"entity.comment.edit_form";i:6;s:15:"comment.approve";i:7;s:24:"entity.comment.canonical";i:8;s:26:"entity.comment.delete_form";i:9;s:13:"comment.reply";i:10;s:31:"comment.new_comments_node_links";i:11;s:21:"comment.node_redirect";i:12;s:17:"contextual.render";i:13;s:17:"editor.filter_xss";i:14;s:18:"file.ajax_progress";i:15;s:15:"filter.tips_all";i:16;s:11:"filter.tips";i:17;s:26:"history.get_last_node_view";i:18;s:17:"history.read_node";i:19;s:31:"history.new_comments_node_links";i:20;s:18:"image.style_public";i:21;s:19:"image.style_private";i:22;s:19:"entity.node.preview";i:23;s:27:"entity.node.version_history";i:24;s:20:"entity.node.revision";i:25;s:28:"node.revision_revert_confirm";i:26;s:40:"node.revision_revert_translation_confirm";i:27;s:28:"node.revision_delete_confirm";i:28;s:11:"search.view";i:29;s:23:"search.view_help_search";i:30;s:23:"search.help_help_search";i:31;s:23:"search.view_node_search";i:32;s:23:"search.help_node_search";i:33;s:23:"search.view_user_search";i:34;s:23:"search.help_user_search";i:35;s:19:"shortcut.set_switch";i:36;s:16:"system.css_asset";i:37;s:15:"system.js_asset";i:38;s:10:"system.401";i:39;s:10:"system.403";i:40;s:10:"system.404";i:41;s:10:"system.4xx";i:42;s:11:"system.cron";i:43;s:12:"system.files";i:44;s:28:"system.private_file_download";i:45;s:16:"system.temporary";i:46;s:7:"<front>";i:47;s:6:"<none>";i:48;s:8:"<nolink>";i:49;s:8:"<button>";i:50;s:9:"<current>";i:51;s:15:"system.timezone";i:52;s:22:"system.batch_page.html";i:53;s:16:"system.db_update";i:54;s:26:"system.entity_autocomplete";i:55;s:16:"system.csrftoken";i:56;s:30:"entity.taxonomy_term.edit_form";i:57;s:32:"entity.taxonomy_term.delete_form";i:58;s:16:"toolbar.subtrees";i:59;s:13:"user.register";i:60;s:11:"user.logout";i:61;s:19:"user.logout.confirm";i:62;s:9:"user.pass";i:63;s:9:"user.page";i:64;s:9:"user.edit";i:65;s:10:"user.login";i:66;s:19:"user.cancel_confirm";i:67;s:16:"user.reset.login";i:68;s:10:"user.reset";i:69;s:15:"user.reset.form";i:70;s:31:"user.well-known.change_password";i:71;s:21:"view.frontpage.feed_1";i:72;s:21:"view.frontpage.page_1";i:73;s:25:"view.taxonomy_term.feed_1";i:74;s:25:"view.taxonomy_term.page_1";i:75;s:10:"views.ajax";i:76;s:29:"entity.block_content.add_form";i:77;s:22:"block_content.add_page";i:78;s:23:"entity.file.delete_form";i:79;s:21:"entity.node.canonical";i:80;s:21:"entity.node.edit_form";i:81;s:23:"entity.node.delete_form";i:82;s:13:"node.add_page";i:83;s:8:"node.add";i:84;s:36:"entity.taxonomy_term.version_history";i:85;s:29:"entity.taxonomy_term.revision";i:86;s:41:"entity.taxonomy_term.revision_revert_form";i:87;s:41:"entity.taxonomy_term.revision_delete_form";i:88;s:21:"entity.user.canonical";i:89;s:21:"entity.user.edit_form";i:90;s:23:"entity.user.cancel_form";i:91;s:30:"entity.taxonomy_term.canonical";}'),
('state', 'system.cron_key', '[[system_cron_key]]'),
('state', 'system.private_key', '[[system_private_key]]'),
('state', 'system.profile.files', 'a:3:{s:10:"demo_umami";s:44:"core/profiles/demo_umami/demo_umami.info.yml";s:7:"minimal";s:38:"core/profiles/minimal/minimal.info.yml";s:8:"standard";s:40:"core/profiles/standard/standard.info.yml";}'),
('state', 'system.theme.files', 'a:5:{s:5:"claro";s:32:"core/themes/claro/claro.info.yml";s:7:"olivero";s:36:"core/themes/olivero/olivero.info.yml";s:7:"stable9";s:36:"core/themes/stable9/stable9.info.yml";s:5:"stark";s:32:"core/themes/stark/stark.info.yml";s:16:"starterkit_theme";s:54:"core/themes/starterkit_theme/starterkit_theme.info.yml";}'),
('state', 'twig_extension_hash_prefix', 'a:2:{s:19:"twig_extension_hash";s:0:"";s:17:"twig_cache_prefix";s:0:"";}'),
('state', 'views.view_route_names', 'a:12:{s:13:"watchdog.page";s:14:"dblog.overview";s:24:"user_admin_people.page_1";s:22:"entity.user.collection";s:20:"taxonomy_term.page_1";s:30:"entity.taxonomy_term.canonical";s:14:"content.page_1";s:20:"system.admin_content";s:23:"comment.page_unapproved";s:22:"comment.admin_approval";s:22:"comment.page_published";s:13:"comment.admin";s:20:"block_content.page_1";s:31:"entity.block_content.collection";s:12:"files.page_1";s:17:"view.files.page_1";s:12:"files.page_2";s:17:"view.files.page_2";s:16:"frontpage.feed_1";s:21:"view.frontpage.feed_1";s:16:"frontpage.page_1";s:21:"view.frontpage.page_1";s:20:"taxonomy_term.feed_1";s:25:"view.taxonomy_term.feed_1";}'),
('system.schema', 'announcements_feed', 'i:8000;'),
('system.schema', 'automated_cron', 'i:8000;'),
('system.schema', 'big_pipe', 'i:8000;'),
('system.schema', 'block', 'i:8003;'),
('system.schema', 'block_content', 'i:10300;'),
('system.schema', 'breakpoint', 'i:8000;'),
('system.schema', 'ckeditor5', 'i:8000;'),
('system.schema', 'comment', 'i:10100;'),
('system.schema', 'config', 'i:8000;'),
('system.schema', 'contextual', 'i:8000;'),
('system.schema', 'datetime', 'i:8000;'),
('system.schema', 'dblog', 'i:10101;'),
('system.schema', 'dynamic_page_cache', 'i:8000;'),
('system.schema', 'editor', 'i:8001;'),
('system.schema', 'field', 'i:8500;'),
('system.schema', 'field_ui', 'i:8000;'),
('system.schema', 'file', 'i:8700;'),
('system.schema', 'filter', 'i:8000;'),
('system.schema', 'help', 'i:10200;'),
('system.schema', 'history', 'i:10100;'),
('system.schema', 'image', 'i:8201;'),
('system.schema', 'link', 'i:8000;'),
('system.schema', 'menu_link_content', 'i:8601;'),
('system.schema', 'menu_ui', 'i:8000;'),
('system.schema', 'mysql', 'i:8000;'),
('system.schema', 'node', 'i:8700;'),
('system.schema', 'options', 'i:8000;'),
('system.schema', 'page_cache', 'i:8000;'),
('system.schema', 'path', 'i:8200;'),
('system.schema', 'path_alias', 'i:8000;'),
('system.schema', 'search', 'i:8000;'),
('system.schema', 'shortcut', 'i:8000;'),
('system.schema', 'standard', 'i:8000;'),
('system.schema', 'system', 'i:11300;'),
('system.schema', 'taxonomy', 'i:10100;'),
('system.schema', 'text', 'i:8000;'),
('system.schema', 'toolbar', 'i:8000;'),
('system.schema', 'update', 'i:8001;'),
('system.schema', 'user', 'i:10000;'),
('system.schema', 'views', 'i:11201;'),
('system.schema', 'views_ui', 'i:8000;');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]key_value_expire`
--

CREATE TABLE `[[dbprefix]]key_value_expire` (
  `collection` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'A named collection of key and value pairs.',
  `name` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The key of the key/value pair.',
  `value` longblob NOT NULL COMMENT 'The value of the key/value pair.',
  `expire` int NOT NULL DEFAULT '2147483647' COMMENT 'The time since Unix epoch in seconds when this item expires. Defaults to the maximum possible time.',
  PRIMARY KEY (`collection`,`name`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Generic key/value storage table with an expiration.';

--
-- Dumping data for table `[[dbprefix]]key_value_expire`
--

INSERT INTO `[[dbprefix]]key_value_expire` VALUES
('announcements_feed', 'announcements', 'a:21:{i:0;a:7:{s:2:"id";s:7:"3566490";s:5:"title";s:63:"Get ready to celebrate Drupal''s 25th birthday on Jan 15th, 2026";s:12:"content_html";s:353:"<p>Drupal turns 25 on 15 January 2026! 🥳 That’s 25 years of open source, collaboration, innovation, and an incredible global community.</p>\n<p>We’re planning a few ways to celebrate Drupal’s birthday week (Jan 8-15). Meanwhile, you can start dreaming up your own ways to join the fun 👉 meetups, posts, stories, creativity, and more. ✨</p>\n";s:3:"url";s:109:"https://www.drupal.org/about/announcements/blog/get-ready-to-celebrate-drupals-25th-birthday-on-jan-15th-2026";s:13:"date_modified";s:25:"2026-01-08T21:14:40+00:00";s:14:"date_published";s:25:"2026-01-08T19:58:58+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:1;a:7:{s:2:"id";s:7:"3563660";s:5:"title";s:30:"Drupal 11.3.0 is now available";s:12:"content_html";s:508:"<p>The <a href="https://www.drupal.org/project/drupal/releases/11.3.0" rel="nofollow">third feature release of Drupal 11</a> is here with the biggest performance boost in a decade. Serve 26-33% more requests with the same database load. New native HTMX support enables rich UX with up to 71% less JavaScript. Plus, enjoy the new stable Navigation module, improved CKEditor content editing, native content export, and cleaner OOP hooks for themes.</p>\n<p><img alt="" src="/files/Drupal113Available.png" /></p>";s:3:"url";s:41:"https://www.drupal.org/blog/drupal-11-3-0";s:13:"date_modified";s:25:"2025-12-18T15:15:07+00:00";s:14:"date_published";s:25:"2025-12-17T12:04:38+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:2;a:7:{s:2:"id";s:7:"3561543";s:5:"title";s:71:"Drupal Canvas is Now Available: Inside Drupal''s New Visual Page Builder";s:12:"content_html";s:451:"<p><img alt="" height="428" src="/files/Canvas%20graphic.png" width="816" /></p>\n<p>For years, Drupal has been the platform of choice for organizations that need serious digital capabilities—think universities managing millions of pages, government agencies with complex workflows, and Fortune 500 companies running mission-critical websites. The power is undeniable, but there''s always been a catch: you needed technical expertise to unlock it.</p>";s:3:"url";s:97:"https://www.drupal.org/blog/drupal-canvas-is-now-available-inside-drupals-new-visual-page-builder";s:13:"date_modified";s:25:"2025-12-18T10:41:24+00:00";s:14:"date_published";s:25:"2025-12-04T18:24:05+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:3;a:7:{s:2:"id";s:7:"3548048";s:5:"title";s:54:"DrupalCon Chicago 2026: Your Stage to Shape the Future";s:12:"content_html";s:270:"<p id="docs-internal-guid-a810d194-7fff-97e4-cc43-6d2b9095cdb4"><em>March 23–26, 2026 | Chicago, IL</em></p>\n<p>Chicago isn''t just hosting DrupalCon 2026—it''s providing the stage where the Drupal community writes its next chapter. And that story starts with you.</p>";s:3:"url";s:101:"https://www.drupal.org/about/announcements/blog/drupalcon-chicago-2026-your-stage-to-shape-the-future";s:13:"date_modified";s:25:"2025-09-22T20:30:38+00:00";s:14:"date_published";s:25:"2025-09-22T20:30:38+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:4;a:7:{s:2:"id";s:7:"3546850";s:5:"title";s:76:"DrupalCon Nara 2025: Building Tomorrow in One of Japan''s Most Ancient Cities";s:12:"content_html";s:389:"<p id="docs-internal-guid-cfdebe19-7fff-3b3b-ba27-bc768674ee8c"><em>November 17–19, 2025 | Nara, Japan</em></p>\n<p>The energy is building in Asia. Following July''s groundbreaking first-ever Contribution Day in Tokyo—where developers, translators, and UX experts came together to push Drupal forward—that momentum is heading straight to one of Japan''s most culturally rich cities.</p>";s:3:"url";s:122:"https://www.drupal.org/about/announcements/blog/drupalcon-nara-2025-building-tomorrow-in-one-of-japans-most-ancient-cities";s:13:"date_modified";s:25:"2025-09-15T21:58:39+00:00";s:14:"date_published";s:25:"2025-09-15T21:58:39+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:5;a:7:{s:2:"id";s:7:"3545545";s:5:"title";s:93:"DrupalCon Vienna 2025: Where Digital Ambitions Meet Community Innovation - Will you be there?";s:12:"content_html";s:363:"<p id="docs-internal-guid-76ec9440-7fff-0ce8-e907-506bc36a1f27"><em id="docs-internal-guid-ab650729-7fff-376e-b6bd-e2a6b4a06c58">October 14–17, 2025 | Austria Center Vienna</em></p>\n<p>Vienna is calling the global Drupal community home this October, and we can''t wait to see what happens when ambitious minds gather in one of Europe''s most inspiring cities.</p>";s:3:"url";s:137:"https://www.drupal.org/about/announcements/blog/drupalcon-vienna-2025-where-digital-ambitions-meet-community-innovation-will-you-be-there";s:13:"date_modified";s:25:"2025-09-08T20:20:15+00:00";s:14:"date_published";s:25:"2025-09-08T20:19:27+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:6;a:7:{s:2:"id";s:7:"3530875";s:5:"title";s:30:"Drupal 11.2.0 is now available";s:12:"content_html";s:324:"<p>The <a href="https://www.drupal.org/project/drupal/releases/11.2.0">second feature release of Drupal 11</a> improves backend and frontend performance and scalability, completes the introduction of OOP support of hooks, adds JSON Schema support, includes AVIF image format capability, supports SDC variants, and more.</p>\n";s:3:"url";s:41:"https://www.drupal.org/blog/drupal-11-2-0";s:13:"date_modified";s:25:"2025-07-17T01:20:03+00:00";s:14:"date_published";s:25:"2025-06-19T05:05:25+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:1:"*";}}i:7;a:7:{s:2:"id";s:7:"3516956";s:5:"title";s:41:"State of Drupal presentation (March 2025)";s:12:"content_html";s:459:"<p>Three months ago, <a href="https://dri.es/drupal-cms-1-released">we launched Drupal CMS 1.0</a>, our biggest step forward in years. Our goal is ambitious: to <a href="https://dri.es/introducing-drupal-starshot-product-strategy">reimagine Drupal</a> as both radically easier to use and a platform for faster innovation.</p>\n<p>In Dries'' DrupalCon Atlanta keynote last week, he reflected on the journey so far, but mostly talked about the work ahead.</p>\n";s:3:"url";s:87:"https://www.drupal.org/about/announcements/blog/state-of-drupal-presentation-march-2025";s:13:"date_modified";s:25:"2025-04-07T17:05:05+00:00";s:14:"date_published";s:25:"2025-04-02T18:27:47+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:8;a:7:{s:2:"id";s:7:"3509234";s:5:"title";s:48:"DrupalCon Atlanta is almost here! 24-27 of March";s:12:"content_html";s:444:"<p>DrupalCon is an exciting and invaluable event for anyone involved in the Drupal community, whether you’re a developer, website owner, or digital professional. If you’re heading to <a href="https://events.drupal.org/atlanta2025" rel="nofollow">DrupalCon Atlanta 2025</a> for the first time, you’re in for a treat! Here''s everything you need to know to make the most of your experience, along with some top tips for how to prepare.</p>";s:3:"url";s:95:"https://www.drupal.org/about/announcements/blog/drupalcon-atlanta-is-almost-here-24-27-of-march";s:13:"date_modified";s:25:"2025-02-26T20:33:54+00:00";s:14:"date_published";s:25:"2025-02-26T20:33:27+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:3:">=7";}}i:9;a:7:{s:2:"id";s:7:"3499892";s:5:"title";s:32:"Drupal CMS 1.0 is now available!";s:12:"content_html";s:436:"<p>We’re excited to share that Drupal CMS 1.0 has officially launched! This new platform is designed to make it easier than ever for marketers and content teams to create amazing digital experiences, all while staying true to Drupal’s open-source roots.</p>\n<p><img alt="Getting started takes minutes" height="720" src="/files/CMS1-1_1.png" width="1280" /></p>\n<p>Drupal CMS 1.0 is packed with features to make your life easier:</p>";s:3:"url";s:42:"https://www.drupal.org/blog/drupal-cms-1-0";s:13:"date_modified";s:25:"2025-01-15T18:40:24+00:00";s:14:"date_published";s:25:"2025-01-15T17:00:28+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:2:">7";}}i:11;a:7:{s:2:"id";s:7:"3494304";s:5:"title";s:30:"Drupal 11.1.0 is now available";s:12:"content_html";s:263:"<p>The <a href="https://www.drupal.org/project/drupal/releases/11.1.0" rel="nofollow">first feature release of Drupal 11</a> improves the recipe system, introduces support for hooks written as classes, makes Workspaces more flexible and enhances performance.</p>";s:3:"url";s:41:"https://www.drupal.org/blog/drupal-11-1-0";s:13:"date_modified";s:25:"2024-12-16T20:28:53+00:00";s:14:"date_published";s:25:"2024-12-16T17:50:29+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:13;a:7:{s:2:"id";s:7:"3480615";s:5:"title";s:58:"DrupalCon Singapore 2024: What Awaits You in the Lion City";s:12:"content_html";s:528:"<p>It’s time to dust off those suitcases and start thinking about where your passport is - <a href="https://events.drupal.org/singapore2024" rel="nofollow">DrupalCon Singapore 2024</a> is just around the corner, and this year’s event promises to be amazing! From 9-11 December, our much-anticipated event will bring together the brightest minds and most passionate contributors from the Drupal community for three days of innovation, learning, and inspiration at the luxurious Parkroyal Collection Marina Bay, Singapore.</p>";s:3:"url";s:105:"https://www.drupal.org/about/announcements/blog/drupalcon-singapore-2024-what-awaits-you-in-the-lion-city";s:13:"date_modified";s:25:"2024-10-14T16:49:44+00:00";s:14:"date_published";s:25:"2024-10-14T16:49:44+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:14;a:7:{s:2:"id";s:7:"3465580";s:5:"title";s:18:"Drupal 11 released";s:12:"content_html";s:114:"<p>Today is a big day for <a href="https://www.drupal.org/">Drupal</a> as we officially released Drupal 11!</p>\n";s:3:"url";s:46:"https://www.drupal.org/blog/drupal-11-released";s:13:"date_modified";s:25:"2024-08-15T15:10:39+00:00";s:14:"date_published";s:25:"2024-08-01T22:57:58+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:1:"*";}}i:15;a:7:{s:2:"id";s:7:"3456034";s:5:"title";s:28:"Drupal 10.3 is now available";s:12:"content_html";s:370:"<p>The <a href="https://www.drupal.org/project/drupal/releases/10.3.0" rel="nofollow">third and final feature release of Drupal 10</a> ships with a new experimental Navigation user interface, stable Workspaces functionality, stable Single-Directory Components support, simplified menu editing, taxonomy moderation support, new recipe and access policy APIs and more.</p>";s:3:"url";s:41:"https://www.drupal.org/blog/drupal-10-3-0";s:13:"date_modified";s:25:"2024-09-05T23:00:47+00:00";s:14:"date_published";s:25:"2024-06-20T20:00:04+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:17;a:7:{s:2:"id";s:7:"3427138";s:5:"title";s:52:"You''re invited to DrupalCon Portland | 6-9 May, 2024";s:12:"content_html";s:384:"<p>DrupalCon is an event for developers, marketers/content editors, site owners, and the Drupal-curious to join with the community. You''ll find incredible keynotes, session content from expert speakers who have helped to build Drupal, networking opportunities with your peers, fun social events, and the chance to deepen your connection by contributing to the open source project.</p>";s:3:"url";s:96:"https://www.drupal.org/about/announcements/blog/youre-invited-to-drupalcon-portland-6-9-may-2024";s:13:"date_modified";s:25:"2024-03-18T19:40:04+00:00";s:14:"date_published";s:25:"2024-03-11T16:49:53+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:18;a:7:{s:2:"id";s:7:"3408836";s:5:"title";s:28:"Drupal 10.2 is now available";s:12:"content_html";s:378:"<p>The <a href="https://www.drupal.org/project/drupal/releases/10.2.0">second feature release of Drupal 10</a> improves content modeling, block management, menu and taxonomy organization, and permission administration. New options to sanitize file names make it possible to clean up the names of uploaded files, and media item revisions now have a dedicated user interface.</p>\n";s:3:"url";s:41:"https://www.drupal.org/blog/drupal-10-2-0";s:13:"date_modified";s:25:"2024-01-25T18:24:28+00:00";s:14:"date_published";s:25:"2023-12-15T18:27:47+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:19;a:7:{s:2:"id";s:7:"3403229";s:5:"title";s:75:"Drupal 10 will be supported until the release of Drupal 12 in mid-late 2026";s:12:"content_html";s:190:"<p>Announcing a new major release schedule with long term support for Drupal 10 until mid-late 2026. Drupal 11 will be released in 2024 and work on the dedicated branch starts this week.</p>";s:3:"url";s:103:"https://www.drupal.org/blog/drupal-10-will-be-supported-until-the-release-of-drupal-12-in-mid-late-2026";s:13:"date_modified";s:25:"2024-01-25T18:31:05+00:00";s:14:"date_published";s:25:"2023-11-22T07:13:55+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:21;a:7:{s:2:"id";s:7:"3368367";s:5:"title";s:28:"Drupal 10.1 is now available";s:12:"content_html";s:257:"<p>This first feature release of Drupal 10 is packed with amazing improvements! It makes customizing the look of your site easier, adds support for decoupled navigation, improves content modeling and editing, block management, performance and many more.</p>";s:3:"url";s:41:"https://www.drupal.org/blog/drupal-10-1-0";s:13:"date_modified";s:25:"2023-10-30T16:22:24+00:00";s:14:"date_published";s:25:"2023-06-22T09:11:30+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:22;a:7:{s:2:"id";s:7:"3347976";s:5:"title";s:37:"Contribute to Drupal and the Open Web";s:12:"content_html";s:146:"<p>Drupal is an open source project. But what does that mean? How can you as a site-owner participate in the project of building a better web?</p>";s:3:"url";s:85:"https://www.drupal.org/about/announcements/blog/contribute-to-drupal-and-the-open-web";s:13:"date_modified";s:25:"2023-03-14T19:43:12+00:00";s:14:"date_published";s:25:"2023-03-14T19:39:44+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:23;a:7:{s:2:"id";s:7:"3343486";s:5:"title";s:43:"What to expect from the Announcements feed?";s:12:"content_html";s:197:"<p>Drupal is introducing a new project Announcements feature so that you can see news and updates about the Drupal project and community directly in your Drupal dashboard. Learn what to expect.</p>";s:3:"url";s:90:"https://www.drupal.org/about/announcements/blog/what-to-expect-from-the-announcements-feed";s:13:"date_modified";s:25:"2023-02-21T19:45:53+00:00";s:14:"date_published";s:25:"2023-02-21T19:45:53+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}i:24;a:7:{s:2:"id";s:7:"3327047";s:5:"title";s:26:"Drupal 10.0.0 is available";s:12:"content_html";s:296:"<p>Thanks to 2129 contributors from 616 organizations resolving 4083 issues in the past two and a half years, Drupal 10.0.0 is available today! This new version sets Drupal up for continued stability and security for the longer term. All new features will be added to Drupal 10 going forward.</p>";s:3:"url";s:41:"https://www.drupal.org/blog/drupal-10-0-0";s:13:"date_modified";s:25:"2023-10-30T16:21:38+00:00";s:14:"date_published";s:25:"2022-12-15T17:43:23+00:00";s:10:"_drupalorg";a:2:{s:8:"featured";b:0;s:7:"version";s:5:">=7.0";}}}', [[timestamp_nextday]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_link_content`
--

CREATE TABLE `[[dbprefix]]menu_link_content` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `revision_id` int unsigned DEFAULT NULL,
  `bundle` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `uuid` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menu_link_content_field__uuid__value` (`uuid`),
  UNIQUE KEY `menu_link_content__revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for menu_link_content entities.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_link_content_data`
--

CREATE TABLE `[[dbprefix]]menu_link_content_data` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL,
  `bundle` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `enabled` tinyint NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `menu_name` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  `link__uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `link__title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `link__options` longblob COMMENT 'Serialized array of options for the link.',
  `external` tinyint DEFAULT NULL,
  `rediscover` tinyint DEFAULT NULL,
  `weight` int DEFAULT NULL,
  `expanded` tinyint DEFAULT NULL,
  `parent` varchar(255) DEFAULT NULL,
  `changed` int DEFAULT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`,`langcode`),
  KEY `menu_link_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`),
  KEY `menu_link_content__revision_id` (`revision_id`),
  KEY `menu_link_content_field__link__uri` (`link__uri`(30)),
  KEY `menu_link_content__enabled_bundle` (`enabled`,`bundle`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The data table for menu_link_content entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_link_content_field_revision`
--

CREATE TABLE `[[dbprefix]]menu_link_content_field_revision` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `enabled` tinyint NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `link__uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `link__title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `link__options` longblob COMMENT 'Serialized array of options for the link.',
  `external` tinyint DEFAULT NULL,
  `changed` int DEFAULT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`revision_id`,`langcode`),
  KEY `menu_link_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`),
  KEY `menu_link_content_field__link__uri` (`link__uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision data table for menu_link_content entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_link_content_revision`
--

CREATE TABLE `[[dbprefix]]menu_link_content_revision` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL AUTO_INCREMENT,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `revision_user` int unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `revision_created` int DEFAULT NULL,
  `revision_log_message` longtext,
  `revision_default` tinyint DEFAULT NULL,
  PRIMARY KEY (`revision_id`),
  KEY `menu_link_content__id` (`id`),
  KEY `menu_link_content__ef029a1897` (`revision_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision table for menu_link_content entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_tree`
--

CREATE TABLE `[[dbprefix]]menu_tree` (
  `menu_name` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The menu name. All links with the same menu name (such as ''tools'') are part of the same menu.',
  `mlid` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'The menu link ID (mlid) is the integer primary key.',
  `id` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'Unique machine name: the plugin ID.',
  `parent` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The plugin ID for the parent of this link.',
  `route_name` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL COMMENT 'The machine name of a defined Symfony Route this menu link represents.',
  `route_param_key` varchar(2048) DEFAULT NULL COMMENT 'An encoded string of route parameters for loading by route.',
  `route_parameters` longblob COMMENT 'Serialized array of route parameters of this menu link.',
  `url` varchar(2048) NOT NULL DEFAULT '' COMMENT 'The external path this link points to (when not using a route).',
  `title` longblob COMMENT 'The serialized title for the link. May be a TranslatableMarkup.',
  `description` longblob COMMENT 'The serialized description of this link - used for admin pages and title attribute. May be a TranslatableMarkup.',
  `class` text COMMENT 'The class for this link plugin.',
  `options` longblob COMMENT 'A serialized array of URL options, such as a query string or HTML attributes.',
  `provider` varchar(50) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT 'system' COMMENT 'The name of the module that generated this link.',
  `enabled` smallint NOT NULL DEFAULT '1' COMMENT 'A flag for whether the link should be rendered in menus. (0 = a disabled menu link that may be shown on admin screens, 1 = a normal, visible link)',
  `discovered` smallint NOT NULL DEFAULT '0' COMMENT 'A flag for whether the link was discovered, so can be purged on rebuild',
  `expanded` smallint NOT NULL DEFAULT '0' COMMENT 'Flag for whether this link should be rendered as expanded in menus - expanded links always have their child links displayed, instead of only when the link is in the active trail (1 = expanded, 0 = not expanded)',
  `weight` int NOT NULL DEFAULT '0' COMMENT 'Link weight among links in the same menu at the same depth.',
  `metadata` longblob COMMENT 'A serialized array of data that may be used by the plugin instance.',
  `has_children` smallint NOT NULL DEFAULT '0' COMMENT 'Flag indicating whether any enabled links have this link as a parent (1 = enabled children exist, 0 = no enabled children).',
  `depth` smallint NOT NULL DEFAULT '0' COMMENT 'The depth relative to the top level. A link with empty parent will have depth == 1.',
  `p1` int unsigned NOT NULL DEFAULT '0' COMMENT 'The first mlid in the materialized path. If N = depth, then pN must equal the mlid. If depth > 1 then p(N-1) must equal the parent link mlid. All pX where X > depth must equal zero. The columns p1 .. p9 are also called the parents.',
  `p2` int unsigned NOT NULL DEFAULT '0' COMMENT 'The second mlid in the materialized path. See p1.',
  `p3` int unsigned NOT NULL DEFAULT '0' COMMENT 'The third mlid in the materialized path. See p1.',
  `p4` int unsigned NOT NULL DEFAULT '0' COMMENT 'The fourth mlid in the materialized path. See p1.',
  `p5` int unsigned NOT NULL DEFAULT '0' COMMENT 'The fifth mlid in the materialized path. See p1.',
  `p6` int unsigned NOT NULL DEFAULT '0' COMMENT 'The sixth mlid in the materialized path. See p1.',
  `p7` int unsigned NOT NULL DEFAULT '0' COMMENT 'The seventh mlid in the materialized path. See p1.',
  `p8` int unsigned NOT NULL DEFAULT '0' COMMENT 'The eighth mlid in the materialized path. See p1.',
  `p9` int unsigned NOT NULL DEFAULT '0' COMMENT 'The ninth mlid in the materialized path. See p1.',
  `form_class` varchar(255) DEFAULT NULL COMMENT 'meh',
  PRIMARY KEY (`mlid`),
  UNIQUE KEY `id` (`id`),
  KEY `menu_parents` (`menu_name`,`p1`,`p2`,`p3`,`p4`,`p5`,`p6`,`p7`,`p8`,`p9`),
  KEY `menu_parent_expand_child` (`menu_name`,`expanded`,`has_children`,`parent`(16)),
  KEY `route_values` (`route_name`(32),`route_param_key`(16))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='Contains the menu tree hierarchy.' AUTO_INCREMENT=64 ;

--
-- Dumping data for table `[[dbprefix]]menu_tree`
--

INSERT INTO `[[dbprefix]]menu_tree` VALUES
('tools', 1, 'filter.tips_all', '', 'filter.tips_all', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Compose tips";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 's:0:"";', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'filter', 0, 1, 0, 0, 'a:0:{}', 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('tools', 2, 'node.add_page', '', 'entity.node.add_page', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Add content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 's:0:"";', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'node', 1, 1, 0, 0, 'a:0:{}', 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('tools', 3, 'search.view', '', 'search.view', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Search";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 's:0:"";', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'search', 0, 1, 0, 0, 'a:0:{}', 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('main', 4, 'standard.front_page', '', '<front>', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Home";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 's:0:"";', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'standard', 1, 1, 0, 0, 'a:0:{}', 0, 1, 4, 0, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 5, 'system.admin', '', 'system.admin', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Administration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 's:0:"";', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, 9, 'a:0:{}', 1, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 6, 'announcements_feed.announcement', 'system.admin', 'announcements_feed.announcement', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Announcements";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:49:"Displays announcements from the Drupal community.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'announcements_feed', 1, 1, 0, 10, 'a:0:{}', 0, 2, 5, 6, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 7, 'help.main', 'system.admin', 'help.main', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Help";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:48:"Reference for usage, configuration, and modules.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'help', 1, 1, 0, 9, 'a:0:{}', 0, 2, 5, 7, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 8, 'system.admin_content', 'system.admin', 'system.admin_content', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"Find and manage content.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -10, 'a:0:{}', 1, 2, 5, 8, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 9, 'comment.admin', 'system.admin_content', 'comment.admin', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Comments";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:59:"List and edit site comments and the comment approval queue.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'comment', 1, 1, 0, 0, 'a:0:{}', 0, 3, 5, 8, 9, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 10, 'system.admin_structure', 'system.admin', 'system.admin_structure', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Structure";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:45:"Administer blocks, content types, menus, etc.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -8, 'a:0:{}', 1, 2, 5, 10, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 11, 'block.admin_display', 'system.admin_structure', 'block.admin_display', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Block layout";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:79:"Configure what block content appears in your site''s sidebars and other regions.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'block', 1, 1, 0, 0, 'a:0:{}', 0, 3, 5, 10, 11, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 12, 'entity.block_content_type.collection', 'system.admin_structure', 'entity.block_content_type.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Block types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:78:"Create and manage fields, forms, and display settings for your content blocks.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'block_content', 1, 1, 0, 0, 'a:0:{}', 0, 3, 5, 10, 12, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 13, 'entity.comment_type.collection', 'system.admin_structure', 'entity.comment_type.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Comment types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:46:"Manage form and displays settings of comments.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'comment', 1, 1, 0, 0, 'a:0:{}', 0, 3, 5, 10, 13, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 14, 'field_ui.display_mode', 'system.admin_structure', 'field_ui.display_mode', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Display modes";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:65:"Configure what displays are available for your content and forms.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'field_ui', 1, 1, 0, 0, 'a:0:{}', 1, 3, 5, 10, 14, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 15, 'entity.entity_view_mode.collection', 'field_ui.display_mode', 'entity.entity_view_mode.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"View modes";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"Manage custom view modes.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'field_ui', 1, 1, 0, 0, 'a:0:{}', 0, 4, 5, 10, 14, 15, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 16, 'entity.entity_form_mode.collection', 'field_ui.display_mode', 'entity.entity_form_mode.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Form modes";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"Manage custom form modes.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'field_ui', 1, 1, 0, 0, 'a:0:{}', 0, 4, 5, 10, 14, 16, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 17, 'entity.menu.collection', 'system.admin_structure', 'entity.menu.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Menus";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:28:"Manage menus and menu links.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'menu_ui', 1, 1, 0, 0, 'a:0:{}', 0, 3, 5, 10, 17, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 18, 'entity.node_type.collection', 'system.admin_structure', 'entity.node_type.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Content types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:71:"Create and manage fields, forms, and display settings for your content.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'node', 1, 1, 0, 0, 'a:0:{}', 0, 3, 5, 10, 18, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 19, 'entity.taxonomy_vocabulary.collection', 'system.admin_structure', 'entity.taxonomy_vocabulary.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Taxonomy";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:67:"Manage tagging, categorization, and classification of your content.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'taxonomy', 1, 1, 0, 0, 'a:0:{}', 0, 3, 5, 10, 19, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 20, 'entity.view.collection', 'system.admin_structure', 'entity.view.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Views";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"Manage customized lists of content.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'views_ui', 1, 1, 0, 0, 'a:0:{}', 0, 3, 5, 10, 20, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 21, 'system.themes_page', 'system.admin', 'system.themes_page', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Appearance";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:28:"Select and configure themes.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -6, 'a:0:{}', 0, 2, 5, 21, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 22, 'system.modules_list', 'system.admin', 'system.modules_list', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Extend";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:53:"Add and install modules to extend site functionality.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -2, 'a:0:{}', 0, 2, 5, 22, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 23, 'system.admin_config', 'system.admin', 'system.admin_config', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Administer settings.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, 0, 'a:0:{}', 1, 2, 5, 23, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 24, 'system.admin_config_media', 'system.admin_config', 'system.admin_config_media', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Media";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 's:0:"";', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -10, 'a:0:{}', 1, 3, 5, 23, 24, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 25, 'entity.image_style.collection', 'system.admin_config_media', 'entity.image_style.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Image styles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:78:"Configure styles that can be used for resizing or adjusting images on display.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'image', 1, 1, 0, 0, 'a:0:{}', 0, 4, 5, 23, 24, 25, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 26, 'system.file_system_settings', 'system.admin_config_media', 'system.file_system_settings', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"File system";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:67:"Configure the location of uploaded files and how they are accessed.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, 0, 'a:0:{}', 0, 4, 5, 23, 24, 26, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 27, 'system.image_toolkit_settings', 'system.admin_config_media', 'system.image_toolkit_settings', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Image toolkit";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, 20, 'a:0:{}', 0, 4, 5, 23, 24, 27, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 28, 'system.admin_config_services', 'system.admin_config', 'system.admin_config_services', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Web services";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 's:0:"";', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, 0, 'a:0:{}', 1, 3, 5, 23, 28, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 29, 'system.linkset_settings', 'system.admin_config_services', 'system.linkset_settings', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:21:"Menu Linkset Settings";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Enable or disable the menu linkset endpoint";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, 10, 'a:0:{}', 0, 4, 5, 23, 28, 29, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 30, 'system.admin_config_development', 'system.admin_config', 'system.admin_config_development', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Development";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:36:"Configure and use development tools.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -10, 'a:0:{}', 1, 3, 5, 23, 30, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 31, 'config.sync', 'system.admin_config_development', 'config.sync', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Configuration synchronization";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:37:"Import and export your configuration.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'config', 1, 1, 0, 0, 'a:0:{}', 0, 4, 5, 23, 30, 31, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 32, 'system.site_maintenance_mode', 'system.admin_config_development', 'system.site_maintenance_mode', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Maintenance mode";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:62:"Take the site offline for updates and other maintenance tasks.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -10, 'a:0:{}', 0, 4, 5, 23, 30, 32, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 33, 'system.performance_settings', 'system.admin_config_development', 'system.performance_settings', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Performance";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:45:"Configure caching and bandwidth optimization.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -20, 'a:0:{}', 0, 4, 5, 23, 30, 33, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 34, 'system.development_settings', 'system.admin_config_development', 'system.development_settings', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Development settings";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:36:"Configure theme development settings";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -19, 'a:0:{}', 0, 4, 5, 23, 30, 34, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 35, 'system.logging_settings', 'system.admin_config_development', 'system.logging_settings', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"Logging and errors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:61:"Configure the display of error messages and database logging.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -15, 'a:0:{}', 0, 4, 5, 23, 30, 35, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 36, 'system.admin_config_regional', 'system.admin_config', 'system.admin_config_regional', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Region and language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:59:"Configure regional settings, localization, and translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -5, 'a:0:{}', 1, 3, 5, 23, 36, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 37, 'system.regional_settings', 'system.admin_config_regional', 'system.regional_settings', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Regional settings";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Configure the locale and timezone settings.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -20, 'a:0:{}', 0, 4, 5, 23, 36, 37, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 38, 'entity.date_format.collection', 'system.admin_config_regional', 'entity.date_format.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:21:"Date and time formats";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:44:"Configure how dates and times are displayed.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -9, 'a:0:{}', 0, 4, 5, 23, 36, 38, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 39, 'system.admin_config_search', 'system.admin_config', 'system.admin_config_search', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Search and metadata";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:64:"Configure site search, metadata, and search engine optimization.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -10, 'a:0:{}', 1, 3, 5, 23, 39, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 40, 'entity.path_alias.collection', 'system.admin_config_search', 'entity.path_alias.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"URL aliases";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"Add custom URLs to existing paths.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'path', 1, 1, 0, -5, 'a:0:{}', 0, 4, 5, 23, 39, 40, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 41, 'entity.search_page.collection', 'system.admin_config_search', 'entity.search_page.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Search pages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:51:"Configure search pages and search indexing options.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'search', 1, 1, 0, -10, 'a:0:{}', 0, 4, 5, 23, 39, 41, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 42, 'system.admin_config_system', 'system.admin_config', 'system.admin_config_system', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"System";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:49:"Configure basic site settings, actions, and cron.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -20, 'a:0:{}', 1, 3, 5, 23, 42, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 43, 'system.site_information_settings', 'system.admin_config_system', 'system.site_information_settings', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Basic site settings";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:77:"Change site name, email address, slogan, default front page, and error pages.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -20, 'a:0:{}', 0, 4, 5, 23, 42, 43, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 44, 'system.cron_settings', 'system.admin_config_system', 'system.cron_settings', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Cron";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:40:"Manage automatic site maintenance tasks.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, 20, 'a:0:{}', 0, 4, 5, 23, 42, 44, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 45, 'system.admin_config_ui', 'system.admin_config', 'system.admin_config_ui', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"User interface";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:44:"Configure the administrative user interface.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -15, 'a:0:{}', 1, 3, 5, 23, 45, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 46, 'entity.shortcut_set.collection', 'system.admin_config_ui', 'entity.shortcut_set.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Shortcuts";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Add and modify shortcut sets.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'shortcut', 1, 1, 0, 0, 'a:0:{}', 0, 4, 5, 23, 45, 46, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 47, 'system.admin_config_workflow', 'system.admin_config', 'system.admin_config_workflow', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Workflow";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:28:"Manage the content workflow.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, 5, 'a:0:{}', 0, 3, 5, 23, 47, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 48, 'system.admin_config_content', 'system.admin_config', 'system.admin_config_content', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Content authoring";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Configure content formatting and authoring.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -15, 'a:0:{}', 1, 3, 5, 23, 48, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 49, 'filter.admin_overview', 'system.admin_config_content', 'filter.admin_overview', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"Text formats and editors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:78:"Select and configure text editors, and how content is filtered when displayed.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'filter', 1, 1, 0, 0, 'a:0:{}', 0, 4, 5, 23, 48, 49, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 50, 'user.admin_index', 'system.admin_config', 'user.admin_index', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"People";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"Configure user accounts.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'user', 1, 1, 0, -20, 'a:0:{}', 1, 3, 5, 23, 50, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 51, 'entity.user.admin_form', 'user.admin_index', 'entity.user.admin_form', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Account settings";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:105:"Configure default user account settings, including fields, registration requirements, and email messages.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'user', 1, 1, 0, -10, 'a:0:{}', 0, 4, 5, 23, 50, 51, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 52, 'system.admin_reports', 'system.admin', 'system.admin_reports', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Reports";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"View reports, updates, and errors.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, 5, 'a:0:{}', 1, 2, 5, 52, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 53, 'dblog.overview', 'system.admin_reports', 'dblog.overview', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Recent log messages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"View events that have recently been logged.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'dblog', 1, 1, 0, -1, 'a:0:{}', 0, 3, 5, 52, 53, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 54, 'dblog.page_not_found', 'system.admin_reports', 'dblog.page_not_found', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:27:"Top ''page not found'' errors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:36:"View ''page not found'' errors (404s).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'dblog', 1, 1, 0, 0, 'a:0:{}', 0, 3, 5, 52, 54, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 55, 'dblog.access_denied', 'system.admin_reports', 'dblog.access_denied', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"Top ''access denied'' errors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"View ''access denied'' errors (403s).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'dblog', 1, 1, 0, 0, 'a:0:{}', 0, 3, 5, 52, 55, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 56, 'entity.field_storage_config.collection', 'system.admin_reports', 'entity.field_storage_config.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Field list";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"Overview of fields on all entity types.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'field_ui', 1, 1, 0, 0, 'a:0:{}', 0, 3, 5, 52, 56, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 57, 'system.status', 'system.admin_reports', 'system.status', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Status report";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:48:"Get a status report about your site''s operation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'system', 1, 1, 0, -60, 'a:0:{}', 0, 3, 5, 52, 57, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 58, 'views_ui.reports_plugins', 'system.admin_reports', 'views_ui.reports_plugins', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Views plugins";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:38:"Overview of plugins used in all views.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'views_ui', 1, 1, 0, 0, 'a:0:{}', 0, 3, 5, 52, 58, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 59, 'dblog.search', 'system.admin_reports', 'dblog.search', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"Top search phrases";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:33:"View most popular search phrases.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', '', 1, 1, 0, 0, 'a:0:{}', 0, 3, 5, 52, 59, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 60, 'entity.user.collection', 'system.admin', 'entity.user.collection', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"People";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:45:"Manage user accounts, roles, and permissions.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'user', 1, 1, 0, 4, 'a:0:{}', 0, 2, 5, 60, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('account', 61, 'user.page', '', 'user.page', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"My account";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 's:0:"";', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'user', 1, 1, 0, -10, 'a:0:{}', 0, 1, 61, 0, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('account', 62, 'user.logout', '', '', '', 'a:0:{}', '', 's:0:"";', 's:0:"";', 'Drupal\\user\\Plugin\\Menu\\LoginLogoutMenuLink', 'a:0:{}', 'user', 1, 1, 0, 10, 'a:0:{}', 0, 1, 62, 0, 0, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),
('admin', 63, 'update.status', 'system.admin_reports', 'update.status', '', 'a:0:{}', '', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Available updates";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:82:"Get a status report about available updates for your installed modules and themes.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}', 'Drupal\\Core\\Menu\\MenuLinkDefault', 'a:0:{}', 'update', 1, 1, 0, -50, 'a:0:{}', 0, 3, 5, 52, 63, 0, 0, 0, 0, 0, 0, 'Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node`
--

CREATE TABLE `[[dbprefix]]node` (
  `nid` int unsigned NOT NULL AUTO_INCREMENT,
  `vid` int unsigned DEFAULT NULL,
  `type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `uuid` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  PRIMARY KEY (`nid`),
  UNIQUE KEY `node_field__uuid__value` (`uuid`),
  UNIQUE KEY `node__vid` (`vid`),
  KEY `node_field__type__target_id` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for node entities.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node_access`
--

CREATE TABLE `[[dbprefix]]node_access` (
  `nid` int unsigned NOT NULL DEFAULT '0' COMMENT 'The "[[dbprefix]]node".nid this record affects.',
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The "[[dbprefix]]language".langcode of this node.',
  `fallback` tinyint unsigned NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether this record should be used as a fallback if a language condition is not provided.',
  `gid` int unsigned NOT NULL DEFAULT '0' COMMENT 'The grant ID a user must possess in the specified realm to gain this row''s privileges on the node.',
  `realm` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The realm in which the user must possess the grant ID. Modules can define one or more realms by implementing hook_node_grants().',
  `grant_view` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can view this node.',
  `grant_update` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can edit this node.',
  `grant_delete` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can delete this node.',
  PRIMARY KEY (`nid`,`gid`,`realm`,`langcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Identifies which realm/grant pairs a user must possess in…';

--
-- Dumping data for table `[[dbprefix]]node_access`
--

INSERT INTO `[[dbprefix]]node_access` VALUES
(0, '', 1, 0, 'all', 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node_field_data`
--

CREATE TABLE `[[dbprefix]]node_field_data` (
  `nid` int unsigned NOT NULL,
  `vid` int unsigned NOT NULL,
  `type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `status` tinyint NOT NULL,
  `uid` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `title` varchar(255) NOT NULL,
  `created` int NOT NULL,
  `changed` int NOT NULL,
  `promote` tinyint NOT NULL,
  `sticky` tinyint NOT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`nid`,`langcode`),
  KEY `node__id__default_langcode__langcode` (`nid`,`default_langcode`,`langcode`),
  KEY `node__vid` (`vid`),
  KEY `node_field__type__target_id` (`type`),
  KEY `node_field__uid__target_id` (`uid`),
  KEY `node_field__created` (`created`),
  KEY `node_field__changed` (`changed`),
  KEY `node__status_type` (`status`,`type`,`nid`),
  KEY `node__frontpage` (`promote`,`status`,`sticky`,`created`),
  KEY `node__title_type` (`title`(191),`type`(4))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The data table for node entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node_field_revision`
--

CREATE TABLE `[[dbprefix]]node_field_revision` (
  `nid` int unsigned NOT NULL,
  `vid` int unsigned NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `status` tinyint NOT NULL,
  `uid` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `title` varchar(255) DEFAULT NULL,
  `created` int DEFAULT NULL,
  `changed` int DEFAULT NULL,
  `promote` tinyint DEFAULT NULL,
  `sticky` tinyint DEFAULT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`vid`,`langcode`),
  KEY `node__id__default_langcode__langcode` (`nid`,`default_langcode`,`langcode`),
  KEY `node_field__uid__target_id` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision data table for node entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node_revision`
--

CREATE TABLE `[[dbprefix]]node_revision` (
  `nid` int unsigned NOT NULL,
  `vid` int unsigned NOT NULL AUTO_INCREMENT,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `revision_uid` int unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `revision_timestamp` int DEFAULT NULL,
  `revision_log` longtext,
  `revision_default` tinyint DEFAULT NULL,
  PRIMARY KEY (`vid`),
  KEY `node__nid` (`nid`),
  KEY `node_field__langcode` (`langcode`),
  KEY `node_field__revision_uid__target_id` (`revision_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision table for node entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node_revision__body`
--

CREATE TABLE `[[dbprefix]]node_revision__body` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext NOT NULL,
  `body_summary` longtext,
  `body_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for node field body.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node_revision__comment`
--

CREATE TABLE `[[dbprefix]]node_revision__comment` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_status` int NOT NULL DEFAULT '0' COMMENT 'Whether comments are allowed on this entity: 0 = no, 1 = closed (read only), 2 = open (read/write).',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for node field comment.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node_revision__field_image`
--

CREATE TABLE `[[dbprefix]]node_revision__field_image` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_target_id` int unsigned NOT NULL COMMENT 'The ID of the file entity.',
  `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image''s ''alt'' attribute.',
  `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image''s ''title'' attribute.',
  `field_image_width` int unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_image_target_id` (`field_image_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for node field field_image.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node_revision__field_tags`
--

CREATE TABLE `[[dbprefix]]node_revision__field_tags` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_tags_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_tags_target_id` (`field_tags_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for node field field_tags.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node__body`
--

CREATE TABLE `[[dbprefix]]node__body` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext NOT NULL,
  `body_summary` longtext,
  `body_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for node field body.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node__comment`
--

CREATE TABLE `[[dbprefix]]node__comment` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_status` int NOT NULL DEFAULT '0' COMMENT 'Whether comments are allowed on this entity: 0 = no, 1 = closed (read only), 2 = open (read/write).',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for node field comment.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node__field_image`
--

CREATE TABLE `[[dbprefix]]node__field_image` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_target_id` int unsigned NOT NULL COMMENT 'The ID of the file entity.',
  `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image''s ''alt'' attribute.',
  `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image''s ''title'' attribute.',
  `field_image_width` int unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_image_target_id` (`field_image_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for node field field_image.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]node__field_tags`
--

CREATE TABLE `[[dbprefix]]node__field_tags` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_tags_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_tags_target_id` (`field_tags_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for node field field_tags.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]path_alias`
--

CREATE TABLE `[[dbprefix]]path_alias` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `revision_id` int unsigned DEFAULT NULL,
  `uuid` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `path` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `status` tinyint NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `path_alias_field__uuid__value` (`uuid`),
  UNIQUE KEY `path_alias__revision_id` (`revision_id`),
  KEY `path_alias__alias_langcode_id_status` (`alias`(191),`langcode`,`id`,`status`),
  KEY `path_alias__path_langcode_id_status` (`path`(191),`langcode`,`id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for path_alias entities.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]path_alias_revision`
--

CREATE TABLE `[[dbprefix]]path_alias_revision` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL AUTO_INCREMENT,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `path` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `status` tinyint NOT NULL,
  `revision_default` tinyint DEFAULT NULL,
  PRIMARY KEY (`revision_id`),
  KEY `path_alias__id` (`id`),
  KEY `path_alias_revision__alias_langcode_id_status` (`alias`(191),`langcode`,`id`,`status`),
  KEY `path_alias_revision__path_langcode_id_status` (`path`(191),`langcode`,`id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision table for path_alias entities.';

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue`
--

CREATE TABLE `[[dbprefix]]queue` (
  `item_id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique item ID.',
  `name` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The queue name.',
  `data` longblob COMMENT 'The arbitrary data for the item.',
  `expire` bigint NOT NULL DEFAULT '0' COMMENT 'Timestamp when the claim lease expires on the item.',
  `created` bigint NOT NULL DEFAULT '0' COMMENT 'Timestamp when the item was created.',
  PRIMARY KEY (`item_id`),
  KEY `name_created` (`name`,`created`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COMMENT='Stores items in queues.' AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]router`
--

CREATE TABLE `[[dbprefix]]router` (
  `name` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'Primary Key: Machine name of this route',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'The path for this URI',
  `pattern_outline` varchar(255) NOT NULL DEFAULT '' COMMENT 'The pattern',
  `fit` int NOT NULL DEFAULT '0' COMMENT 'A numeric representation of how specific the path is.',
  `route` longblob COMMENT 'A serialized Route object',
  `number_parts` smallint NOT NULL DEFAULT '0' COMMENT 'Number of parts in this router path.',
  `alias` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL COMMENT 'The alias of the route, if applicable.',
  PRIMARY KEY (`name`),
  KEY `pattern_outline_parts` (`pattern_outline`(191),`number_parts`),
  KEY `alias` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Maps paths to various callbacks (access, page and title)';

--
-- Dumping data for table `[[dbprefix]]router`
--

INSERT INTO `[[dbprefix]]router` VALUES
('<button>', '/', '/', 1, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:1:"/";s:4:"host";s:0:"";s:8:"defaults";a:0:{}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:8:"_no_path";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:8:"{^/$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:1:"/";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:1:"/";s:8:"numParts";i:1;}}', 1, NULL),
('<current>', '/<current>', '/<current>', 1, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:10:"/<current>";s:4:"host";s:0:"";s:8:"defaults";a:0:{}s:12:"requirements";a:0:{}s:7:"options";a:2:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:19:"{^/\\<current\\>$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:10:"/<current>";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:10:"/<current>";s:8:"numParts";i:1;}}', 1, NULL),
('<front>', '/', '/', 1, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:1:"/";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:6:"_title";s:4:"Home";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:8:"{^/$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:1:"/";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:1:"/";s:8:"numParts";i:1;}}', 1, NULL),
('<nolink>', '/', '/', 1, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:1:"/";s:4:"host";s:0:"";s:8:"defaults";a:0:{}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:8:"_no_path";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:8:"{^/$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:1:"/";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:1:"/";s:8:"numParts";i:1;}}', 1, NULL),
('<none>', '/', '/', 1, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:1:"/";s:4:"host";s:0:"";s:8:"defaults";a:0:{}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:8:"_no_path";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:8:"{^/$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:1:"/";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:1:"/";s:8:"numParts";i:1;}}', 1, NULL),
('announcements_feed.announcement', '/admin/announcements_feed', '/admin/announcements_feed', 3, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:25:"/admin/announcements_feed";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:74:"\\Drupal\\announcements_feed\\Controller\\AnnounceController::getAnnouncements";s:6:"_title";s:23:"Community announcements";}s:12:"requirements";a:1:{s:11:"_permission";s:20:"access announcements";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:32:"{^/admin/announcements_feed$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:25:"/admin/announcements_feed";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:25:"/admin/announcements_feed";s:8:"numParts";i:2;}}', 2, NULL),
('big_pipe.nojs', '/big_pipe/no-js', '/big_pipe/no-js', 3, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:15:"/big_pipe/no-js";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:59:"\\Drupal\\big_pipe\\Controller\\BigPipeController:setNoJsCookie";s:6:"_title";s:19:"BigPipe no-JS check";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:8:"no_cache";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:23:"{^/big_pipe/no\\-js$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:15:"/big_pipe/no-js";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:15:"/big_pipe/no-js";s:8:"numParts";i:2;}}', 2, NULL),
('block.admin_add', '/admin/structure/block/add/{plugin_id}/{theme}', '/admin/structure/block/add/%', 30, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:46:"/admin/structure/block/add/{plugin_id}/{theme}";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:11:"_controller";s:66:"\\Drupal\\block\\Controller\\BlockAddController::blockAddConfigureForm";s:5:"theme";N;s:6:"_title";s:15:"Configure block";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:9:"plugin_id";i:1;s:5:"theme";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:78:"{^/admin/structure/block/add/(?P<plugin_id>[^/]++)(?:/(?P<theme>[^/]++))?$}sDu";s:11:"path_tokens";a:3:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"theme";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"plugin_id";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:26:"/admin/structure/block/add";}}s:9:"path_vars";a:2:{i:0;s:9:"plugin_id";i:1;s:5:"theme";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:28:"/admin/structure/block/add/%";s:8:"numParts";i:6;}}', 6, NULL),
('block.admin_demo', '/admin/structure/block/demo/{theme}', '/admin/structure/block/demo/%', 30, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:35:"/admin/structure/block/demo/{theme}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:46:"\\Drupal\\block\\Controller\\BlockController::demo";s:15:"_title_callback";s:21:"theme_handler:getName";}s:12:"requirements";a:2:{s:13:"_access_theme";s:4:"TRUE";s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:0;s:4:"utf8";b:1;s:14:"_access_checks";a:2:{i:0;s:18:"access_check.theme";i:1;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"theme";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:52:"{^/admin/structure/block/demo/(?P<theme>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"theme";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/block/demo";}}s:9:"path_vars";a:1:{i:0;s:5:"theme";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:29:"/admin/structure/block/demo/%";s:8:"numParts";i:5;}}', 5, NULL),
('block.admin_display', '/admin/structure/block', '/admin/structure/block', 7, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:22:"/admin/structure/block";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:53:"\\Drupal\\block\\Controller\\BlockListController::listing";s:6:"_title";s:12:"Block layout";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:29:"{^/admin/structure/block$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:22:"/admin/structure/block";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:22:"/admin/structure/block";s:8:"numParts";i:3;}}', 3, NULL),
('block.admin_display_theme', '/admin/structure/block/list/{theme}', '/admin/structure/block/list/%', 30, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:35:"/admin/structure/block/list/{theme}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:53:"\\Drupal\\block\\Controller\\BlockListController::listing";s:6:"_title";s:12:"Block layout";}s:12:"requirements";a:2:{s:13:"_access_theme";s:4:"TRUE";s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:18:"access_check.theme";i:1;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"theme";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:52:"{^/admin/structure/block/list/(?P<theme>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"theme";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/block/list";}}s:9:"path_vars";a:1:{i:0;s:5:"theme";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:29:"/admin/structure/block/list/%";s:8:"numParts";i:5;}}', 5, NULL),
('block.admin_library', '/admin/structure/block/library/{theme}', '/admin/structure/block/library/%', 30, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:38:"/admin/structure/block/library/{theme}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:59:"\\Drupal\\block\\Controller\\BlockLibraryController::listBlocks";s:6:"_title";s:11:"Place block";}s:12:"requirements";a:2:{s:13:"_access_theme";s:4:"TRUE";s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:18:"access_check.theme";i:1;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"theme";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:55:"{^/admin/structure/block/library/(?P<theme>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"theme";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:30:"/admin/structure/block/library";}}s:9:"path_vars";a:1:{i:0;s:5:"theme";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:32:"/admin/structure/block/library/%";s:8:"numParts";i:5;}}', 5, NULL),
('block.category_autocomplete', '/block-category/autocomplete', '/block-category/autocomplete', 3, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:28:"/block-category/autocomplete";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:69:"\\Drupal\\block\\Controller\\CategoryAutocompleteController::autocomplete";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"{^/block\\-category/autocomplete$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:28:"/block-category/autocomplete";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:28:"/block-category/autocomplete";s:8:"numParts";i:2;}}', 2, NULL),
('block_content.add_form', '/block/add/{block_content_type}', '/block/add/%', 6, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:31:"/block/add/{block_content_type}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:64:"\\Drupal\\block_content\\Controller\\BlockContentController::addForm";s:15:"_title_callback";s:72:"\\Drupal\\block_content\\Controller\\BlockContentController::getAddFormTitle";}s:12:"requirements";a:1:{s:21:"_entity_create_access";s:34:"block_content:{block_content_type}";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:10:"parameters";a:1:{s:18:"block_content_type";a:2:{s:4:"type";s:25:"entity:block_content_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:14:"_access_checks";a:1:{i:0;s:26:"access_check.entity_create";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:18:"block_content_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:48:"{^/block/add/(?P<block_content_type>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:18:"block_content_type";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:10:"/block/add";}}s:9:"path_vars";a:1:{i:0;s:18:"block_content_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:6;s:14:"patternOutline";s:12:"/block/add/%";s:8:"numParts";i:3;}}', 3, NULL),
('block_content.add_page', '/block/add', '/block/add', 3, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:10:"/block/add";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:11:"_controller";s:55:"Drupal\\Core\\Entity\\Controller\\EntityController::addPage";s:15:"_title_callback";s:56:"Drupal\\Core\\Entity\\Controller\\EntityController::addTitle";s:14:"entity_type_id";s:13:"block_content";}s:12:"requirements";a:1:{s:25:"_entity_create_any_access";s:13:"block_content";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:30:"access_check.entity_create_any";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:17:"{^/block/add$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:10:"/block/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:10:"/block/add";s:8:"numParts";i:2;}}', 2, NULL),
('block_content.type_add', '/admin/structure/block-content/add', '/admin/structure/block-content/add', 15, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:34:"/admin/structure/block-content/add";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:12:"_entity_form";s:22:"block_content_type.add";s:14:"entity_type_id";s:18:"block_content_type";s:15:"_title_callback";s:56:"Drupal\\Core\\Entity\\Controller\\EntityController::addTitle";}s:12:"requirements";a:1:{s:21:"_entity_create_access";s:18:"block_content_type";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:26:"access_check.entity_create";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:42:"{^/admin/structure/block\\-content/add$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:34:"/admin/structure/block-content/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:34:"/admin/structure/block-content/add";s:8:"numParts";i:4;}}', 4, NULL),
('ckeditor5.entity_link_suggestions', '/ckeditor5/{editor}/entity-link-suggestions', '/ckeditor5/%/entity-link-suggestions', 5, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:43:"/ckeditor5/{editor}/entity-link-suggestions";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:73:"\\Drupal\\ckeditor5\\Controller\\EntityLinkSuggestionsController::suggestions";}s:12:"requirements";a:3:{s:14:"_entity_access";s:10:"editor.use";s:14:"_custom_access";s:89:"\\Drupal\\ckeditor5\\Controller\\EntityLinkSuggestionsController::formatUsesEntityLinksFilter";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:6:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:6:"editor";a:2:{s:4:"type";s:13:"entity:editor";s:9:"converter";s:21:"paramconverter.entity";}}s:8:"no_cache";b:1;s:6:"_theme";s:14:"ajax_base_page";s:4:"utf8";b:1;s:14:"_access_checks";a:3:{i:0;s:19:"access_check.entity";i:1;s:19:"access_check.custom";i:2;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:1:{i:0;s:3:"GET";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:6:"editor";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:62:"{^/ckeditor5/(?P<editor>[^/]++)/entity\\-link\\-suggestions$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:24:"/entity-link-suggestions";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:6:"editor";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:10:"/ckeditor5";}}s:9:"path_vars";a:1:{i:0;s:6:"editor";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:36:"/ckeditor5/%/entity-link-suggestions";s:8:"numParts";i:3;}}', 3, NULL),
('ckeditor5.media_entity_metadata', '/ckeditor5/{editor}/media-entity-metadata', '/ckeditor5/%/media-entity-metadata', 5, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:41:"/ckeditor5/{editor}/media-entity-metadata";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:74:"\\Drupal\\ckeditor5\\Controller\\CKEditor5MediaController::mediaEntityMetadata";}s:12:"requirements";a:3:{s:14:"_entity_access";s:10:"editor.use";s:14:"_custom_access";s:61:"\\Drupal\\ckeditor5\\Controller\\CKEditor5MediaController::access";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:6:"editor";a:2:{s:4:"type";s:13:"entity:editor";s:9:"converter";s:21:"paramconverter.entity";}}s:4:"utf8";b:1;s:14:"_access_checks";a:3:{i:0;s:19:"access_check.entity";i:1;s:19:"access_check.custom";i:2;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:1:{i:0;s:3:"GET";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:6:"editor";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:60:"{^/ckeditor5/(?P<editor>[^/]++)/media\\-entity\\-metadata$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:22:"/media-entity-metadata";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:6:"editor";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:10:"/ckeditor5";}}s:9:"path_vars";a:1:{i:0;s:6:"editor";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:34:"/ckeditor5/%/media-entity-metadata";s:8:"numParts";i:3;}}', 3, NULL),
('ckeditor5.upload_image', '/ckeditor5/upload-image/{editor}', '/ckeditor5/upload-image/%', 6, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:32:"/ckeditor5/upload-image/{editor}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:61:"\\Drupal\\ckeditor5\\Controller\\CKEditor5ImageController::upload";}s:12:"requirements";a:3:{s:14:"_entity_access";s:10:"editor.use";s:14:"_custom_access";s:79:"\\Drupal\\ckeditor5\\Controller\\CKEditor5ImageController::imageUploadEnabledAccess";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:6:"editor";a:2:{s:4:"type";s:13:"entity:editor";s:9:"converter";s:21:"paramconverter.entity";}}s:4:"utf8";b:1;s:14:"_access_checks";a:3:{i:0;s:19:"access_check.entity";i:1;s:19:"access_check.custom";i:2;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:1:{i:0;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:6:"editor";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:50:"{^/ckeditor5/upload\\-image/(?P<editor>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:6:"editor";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:23:"/ckeditor5/upload-image";}}s:9:"path_vars";a:1:{i:0;s:6:"editor";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:6;s:14:"patternOutline";s:25:"/ckeditor5/upload-image/%";s:8:"numParts";i:3;}}', 3, NULL),
('comment.admin', '/admin/content/comment', '/admin/content/comment', 7, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:22:"/admin/content/comment";s:4:"host";s:0:"";s:8:"defaults";a:5:{s:11:"_controller";s:47:"Drupal\\views\\Routing\\ViewPageController::handle";s:15:"_title_callback";s:49:"Drupal\\views\\Routing\\ViewPageController::getTitle";s:7:"view_id";s:7:"comment";s:10:"display_id";s:14:"page_published";s:30:"_view_display_show_admin_links";b:1;}s:12:"requirements";a:2:{s:11:"_permission";s:19:"administer comments";s:7:"_format";s:4:"html";}s:7:"options";a:9:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:18:"_view_argument_map";a:0:{}s:23:"_view_display_plugin_id";s:4:"page";s:26:"_view_display_plugin_class";s:38:"Drupal\\views\\Plugin\\views\\display\\Page";s:30:"_view_display_show_admin_links";b:1;s:16:"returns_response";b:0;s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:0:{}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:29:"{^/admin/content/comment$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:22:"/admin/content/comment";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:22:"/admin/content/comment";s:8:"numParts";i:3;}}', 3, NULL),
('comment.admin_approval', '/admin/content/comment/approval', '/admin/content/comment/approval', 15, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:31:"/admin/content/comment/approval";s:4:"host";s:0:"";s:8:"defaults";a:5:{s:11:"_controller";s:47:"Drupal\\views\\Routing\\ViewPageController::handle";s:15:"_title_callback";s:49:"Drupal\\views\\Routing\\ViewPageController::getTitle";s:7:"view_id";s:7:"comment";s:10:"display_id";s:15:"page_unapproved";s:30:"_view_display_show_admin_links";b:1;}s:12:"requirements";a:2:{s:11:"_permission";s:19:"administer comments";s:7:"_format";s:4:"html";}s:7:"options";a:9:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:18:"_view_argument_map";a:0:{}s:23:"_view_display_plugin_id";s:4:"page";s:26:"_view_display_plugin_class";s:38:"Drupal\\views\\Plugin\\views\\display\\Page";s:30:"_view_display_show_admin_links";b:1;s:16:"returns_response";b:0;s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:0:{}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:38:"{^/admin/content/comment/approval$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/content/comment/approval";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:31:"/admin/content/comment/approval";s:8:"numParts";i:4;}}', 4, NULL),
('comment.approve', '/comment/{comment}/approve', '/comment/%/approve', 5, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:26:"/comment/{comment}/approve";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:6:"_title";s:7:"Approve";s:11:"_controller";s:60:"\\Drupal\\comment\\Controller\\CommentController::commentApprove";s:11:"entity_type";s:7:"comment";}s:12:"requirements";a:3:{s:14:"_entity_access";s:15:"comment.approve";s:11:"_csrf_token";s:4:"TRUE";s:7:"comment";s:3:"\\d+";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:7:"comment";a:2:{s:4:"type";s:14:"entity:comment";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:7:"comment";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:40:"{^/comment/(?P<comment>\\d+)/approve$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:8:"/approve";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:7:"comment";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:8:"/comment";}}s:9:"path_vars";a:1:{i:0;s:7:"comment";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:18:"/comment/%/approve";s:8:"numParts";i:3;}}', 3, NULL),
('comment.multiple_delete_confirm', '/admin/content/comment/delete', '/admin/content/comment/delete', 15, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:29:"/admin/content/comment/delete";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:6:"_title";s:6:"Delete";s:5:"_form";s:42:"\\Drupal\\comment\\Form\\ConfirmDeleteMultiple";s:14:"entity_type_id";s:7:"comment";}s:12:"requirements";a:1:{s:30:"_entity_delete_multiple_access";s:7:"comment";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:35:"access_check.entity_delete_multiple";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"{^/admin/content/comment/delete$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/content/comment/delete";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:29:"/admin/content/comment/delete";s:8:"numParts";i:4;}}', 4, NULL),
('comment.new_comments_node_links', '/comments/render_new_comments_node_links', '/comments/render_new_comments_node_links', 3, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:40:"/comments/render_new_comments_node_links";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:72:"\\Drupal\\comment\\Controller\\CommentController::renderNewCommentsNodeLinks";}s:12:"requirements";a:1:{s:11:"_permission";s:14:"access content";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:47:"{^/comments/render_new_comments_node_links$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:40:"/comments/render_new_comments_node_links";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:40:"/comments/render_new_comments_node_links";s:8:"numParts";i:2;}}', 2, NULL),
('comment.node_redirect', '/comment/{node}/reply', '/comment/%/reply', 5, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:21:"/comment/{node}/reply";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:58:"\\Drupal\\comment\\Controller\\CommentController::redirectNode";}s:12:"requirements";a:3:{s:14:"_entity_access";s:9:"node.view";s:20:"_module_dependencies";s:4:"node";s:4:"node";s:3:"\\d+";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:4:"node";a:2:{s:4:"type";s:11:"entity:node";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:4:"node";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:35:"{^/comment/(?P<node>\\d+)/reply$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:6:"/reply";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:4:"node";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:8:"/comment";}}s:9:"path_vars";a:1:{i:0;s:4:"node";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:16:"/comment/%/reply";s:8:"numParts";i:3;}}', 3, NULL),
('comment.reply', '/comment/reply/{entity_type}/{entity}/{field_name}/{pid}', '/comment/reply/%/%/%', 24, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:56:"/comment/reply/{entity_type}/{entity}/{field_name}/{pid}";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:11:"_controller";s:58:"\\Drupal\\comment\\Controller\\CommentController::getReplyForm";s:6:"_title";s:15:"Add new comment";s:15:"_title_callback";s:60:"\\Drupal\\comment\\Controller\\CommentController::replyFormTitle";s:3:"pid";N;}s:12:"requirements";a:1:{s:14:"_custom_access";s:61:"\\Drupal\\comment\\Controller\\CommentController::replyFormAccess";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:6:"entity";a:2:{s:4:"type";s:20:"entity:{entity_type}";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.custom";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:4:{i:0;s:11:"entity_type";i:1;s:6:"entity";i:2;s:10:"field_name";i:3;s:3:"pid";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:108:"{^/comment/reply/(?P<entity_type>[^/]++)/(?P<entity>[^/]++)/(?P<field_name>[^/]++)(?:/(?P<pid>[^/]++))?$}sDu";s:11:"path_tokens";a:5:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:3:"pid";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:10:"field_name";i:4;b:1;}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:6:"entity";i:4;b:1;}i:3;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"entity_type";i:4;b:1;}i:4;a:2:{i:0;s:4:"text";i:1;s:14:"/comment/reply";}}s:9:"path_vars";a:4:{i:0;s:11:"entity_type";i:1;s:6:"entity";i:2;s:10:"field_name";i:3;s:3:"pid";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:24;s:14:"patternOutline";s:20:"/comment/reply/%/%/%";s:8:"numParts";i:6;}}', 6, NULL),
('config.diff', '/admin/config/development/configuration/sync/diff/{source_name}/{target_name}', '/admin/config/development/configuration/sync/diff/%', 126, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:77:"/admin/config/development/configuration/sync/diff/{source_name}/{target_name}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:48:"\\Drupal\\config\\Controller\\ConfigController::diff";s:11:"target_name";N;}s:12:"requirements";a:1:{s:11:"_permission";s:25:"synchronize configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:11:"source_name";i:1;s:11:"target_name";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:109:"{^/admin/config/development/configuration/sync/diff/(?P<source_name>[^/]++)(?:/(?P<target_name>[^/]++))?$}sDu";s:11:"path_tokens";a:3:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"target_name";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"source_name";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:49:"/admin/config/development/configuration/sync/diff";}}s:9:"path_vars";a:2:{i:0;s:11:"source_name";i:1;s:11:"target_name";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:126;s:14:"patternOutline";s:51:"/admin/config/development/configuration/sync/diff/%";s:8:"numParts";i:8;}}', 8, NULL),
('config.diff_collection', '/admin/config/development/configuration/sync/diff_collection/{collection}/{source_name}/{target_name}', '/admin/config/development/configuration/sync/diff_collection/%/%', 252, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:101:"/admin/config/development/configuration/sync/diff_collection/{collection}/{source_name}/{target_name}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:48:"\\Drupal\\config\\Controller\\ConfigController::diff";s:11:"target_name";N;}s:12:"requirements";a:1:{s:11:"_permission";s:25:"synchronize configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:3:{i:0;s:10:"collection";i:1;s:11:"source_name";i:2;s:11:"target_name";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:143:"{^/admin/config/development/configuration/sync/diff_collection/(?P<collection>[^/]++)/(?P<source_name>[^/]++)(?:/(?P<target_name>[^/]++))?$}sDu";s:11:"path_tokens";a:4:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"target_name";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"source_name";i:4;b:1;}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:10:"collection";i:4;b:1;}i:3;a:2:{i:0;s:4:"text";i:1;s:60:"/admin/config/development/configuration/sync/diff_collection";}}s:9:"path_vars";a:3:{i:0;s:10:"collection";i:1;s:11:"source_name";i:2;s:11:"target_name";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:252;s:14:"patternOutline";s:64:"/admin/config/development/configuration/sync/diff_collection/%/%";s:8:"numParts";i:9;}}', 9, NULL),
('config.export_download', '/admin/config/development/configuration/full/export-download', '/admin/config/development/configuration/full/export-download', 63, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:60:"/admin/config/development/configuration/full/export-download";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:58:"\\Drupal\\config\\Controller\\ConfigController::downloadExport";}s:12:"requirements";a:1:{s:11:"_permission";s:20:"export configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:68:"{^/admin/config/development/configuration/full/export\\-download$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:60:"/admin/config/development/configuration/full/export-download";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:60:"/admin/config/development/configuration/full/export-download";s:8:"numParts";i:6;}}', 6, NULL),
('config.export_full', '/admin/config/development/configuration/full/export', '/admin/config/development/configuration/full/export', 63, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:51:"/admin/config/development/configuration/full/export";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:36:"\\Drupal\\config\\Form\\ConfigExportForm";s:6:"_title";s:6:"Export";}s:12:"requirements";a:1:{s:11:"_permission";s:20:"export configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:58:"{^/admin/config/development/configuration/full/export$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:51:"/admin/config/development/configuration/full/export";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:51:"/admin/config/development/configuration/full/export";s:8:"numParts";i:6;}}', 6, NULL),
('config.export_single', '/admin/config/development/configuration/single/export/{config_type}/{config_name}', '/admin/config/development/configuration/single/export', 63, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:81:"/admin/config/development/configuration/single/export/{config_type}/{config_name}";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:6:"_title";s:13:"Single export";s:5:"_form";s:42:"\\Drupal\\config\\Form\\ConfigSingleExportForm";s:11:"config_type";s:0:"";s:11:"config_name";s:0:"";}s:12:"requirements";a:1:{s:11:"_permission";s:20:"export configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:11:"config_type";i:1;s:11:"config_name";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:118:"{^/admin/config/development/configuration/single/export(?:/(?P<config_type>[^/]++)(?:/(?P<config_name>[^/]++))?)?$}sDu";s:11:"path_tokens";a:3:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"config_name";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"config_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:53:"/admin/config/development/configuration/single/export";}}s:9:"path_vars";a:2:{i:0;s:11:"config_type";i:1;s:11:"config_name";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:53:"/admin/config/development/configuration/single/export";s:8:"numParts";i:8;}}', 8, NULL),
('config.import_full', '/admin/config/development/configuration/full/import', '/admin/config/development/configuration/full/import', 63, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:51:"/admin/config/development/configuration/full/import";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:36:"\\Drupal\\config\\Form\\ConfigImportForm";s:6:"_title";s:6:"Import";}s:12:"requirements";a:1:{s:11:"_permission";s:20:"import configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:58:"{^/admin/config/development/configuration/full/import$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:51:"/admin/config/development/configuration/full/import";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:51:"/admin/config/development/configuration/full/import";s:8:"numParts";i:6;}}', 6, NULL),
('config.import_single', '/admin/config/development/configuration/single/import', '/admin/config/development/configuration/single/import', 63, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:53:"/admin/config/development/configuration/single/import";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:13:"Single import";s:5:"_form";s:42:"\\Drupal\\config\\Form\\ConfigSingleImportForm";}s:12:"requirements";a:1:{s:11:"_permission";s:20:"import configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:60:"{^/admin/config/development/configuration/single/import$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:53:"/admin/config/development/configuration/single/import";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:53:"/admin/config/development/configuration/single/import";s:8:"numParts";i:6;}}', 6, NULL),
('config.sync', '/admin/config/development/configuration', '/admin/config/development/configuration', 15, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:39:"/admin/config/development/configuration";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:30:"\\Drupal\\config\\Form\\ConfigSync";s:6:"_title";s:11:"Synchronize";}s:12:"requirements";a:1:{s:11:"_permission";s:25:"synchronize configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:46:"{^/admin/config/development/configuration$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:39:"/admin/config/development/configuration";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:39:"/admin/config/development/configuration";s:8:"numParts";i:4;}}', 4, NULL),
('contextual.render', '/contextual/render', '/contextual/render', 3, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:18:"/contextual/render";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:47:"\\Drupal\\contextual\\ContextualController::render";}s:12:"requirements";a:1:{s:11:"_permission";s:23:"access contextual links";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:25:"{^/contextual/render$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:18:"/contextual/render";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:18:"/contextual/render";s:8:"numParts";i:2;}}', 2, NULL),
('dblog.access_denied', '/admin/reports/access-denied', '/admin/reports/access-denied', 7, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:28:"/admin/reports/access-denied";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:6:"_title";s:26:"Top ''access denied'' errors";s:11:"_controller";s:56:"\\Drupal\\dblog\\Controller\\DbLogController::topLogMessages";s:4:"type";s:13:"access denied";}s:12:"requirements";a:1:{s:11:"_permission";s:19:"access site reports";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"{^/admin/reports/access\\-denied$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:28:"/admin/reports/access-denied";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:28:"/admin/reports/access-denied";s:8:"numParts";i:3;}}', 3, NULL),
('dblog.confirm', '/admin/reports/dblog/confirm', '/admin/reports/dblog/confirm', 15, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:28:"/admin/reports/dblog/confirm";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:43:"\\Drupal\\dblog\\Form\\DblogClearLogConfirmForm";s:6:"_title";s:34:"Confirm delete recent log messages";}s:12:"requirements";a:1:{s:11:"_permission";s:19:"access site reports";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:35:"{^/admin/reports/dblog/confirm$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:28:"/admin/reports/dblog/confirm";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:28:"/admin/reports/dblog/confirm";s:8:"numParts";i:4;}}', 4, NULL),
('dblog.event', '/admin/reports/dblog/event/{event_id}', '/admin/reports/dblog/event/%', 30, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:37:"/admin/reports/dblog/event/{event_id}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:54:"\\Drupal\\dblog\\Controller\\DbLogController::eventDetails";s:6:"_title";s:7:"Details";}s:12:"requirements";a:1:{s:11:"_permission";s:19:"access site reports";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:8:"event_id";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:54:"{^/admin/reports/dblog/event/(?P<event_id>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:8:"event_id";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:26:"/admin/reports/dblog/event";}}s:9:"path_vars";a:1:{i:0;s:8:"event_id";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:28:"/admin/reports/dblog/event/%";s:8:"numParts";i:5;}}', 5, NULL);
INSERT INTO `[[dbprefix]]router` VALUES
('dblog.overview', '/admin/reports/dblog', '/admin/reports/dblog', 7, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:20:"/admin/reports/dblog";s:4:"host";s:0:"";s:8:"defaults";a:5:{s:11:"_controller";s:47:"Drupal\\views\\Routing\\ViewPageController::handle";s:15:"_title_callback";s:49:"Drupal\\views\\Routing\\ViewPageController::getTitle";s:7:"view_id";s:8:"watchdog";s:10:"display_id";s:4:"page";s:30:"_view_display_show_admin_links";b:1;}s:12:"requirements";a:2:{s:11:"_permission";s:19:"access site reports";s:7:"_format";s:4:"html";}s:7:"options";a:9:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:18:"_view_argument_map";a:0:{}s:23:"_view_display_plugin_id";s:4:"page";s:26:"_view_display_plugin_class";s:38:"Drupal\\views\\Plugin\\views\\display\\Page";s:30:"_view_display_show_admin_links";b:1;s:16:"returns_response";b:0;s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:0:{}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:27:"{^/admin/reports/dblog$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:20:"/admin/reports/dblog";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:20:"/admin/reports/dblog";s:8:"numParts";i:3;}}', 3, NULL),
('dblog.page_not_found', '/admin/reports/page-not-found', '/admin/reports/page-not-found', 7, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:29:"/admin/reports/page-not-found";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:6:"_title";s:27:"Top ''page not found'' errors";s:11:"_controller";s:56:"\\Drupal\\dblog\\Controller\\DbLogController::topLogMessages";s:4:"type";s:14:"page not found";}s:12:"requirements";a:1:{s:11:"_permission";s:19:"access site reports";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:38:"{^/admin/reports/page\\-not\\-found$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/reports/page-not-found";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:29:"/admin/reports/page-not-found";s:8:"numParts";i:3;}}', 3, NULL),
('dblog.search', '/admin/reports/search', '/admin/reports/search', 7, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:21:"/admin/reports/search";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:11:"_controller";s:56:"\\Drupal\\dblog\\Controller\\DbLogController::topLogMessages";s:6:"_title";s:18:"Top search phrases";s:4:"type";s:6:"search";}s:12:"requirements";a:2:{s:20:"_module_dependencies";s:6:"search";s:11:"_permission";s:19:"access site reports";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:28:"{^/admin/reports/search$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:21:"/admin/reports/search";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:21:"/admin/reports/search";s:8:"numParts";i:3;}}', 3, NULL),
('editor.filter_xss', '/editor/filter_xss/{filter_format}', '/editor/filter_xss/%', 6, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:34:"/editor/filter_xss/{filter_format}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:42:"\\Drupal\\editor\\EditorController::filterXss";}s:12:"requirements";a:1:{s:14:"_entity_access";s:17:"filter_format.use";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:13:"filter_format";a:2:{s:4:"type";s:20:"entity:filter_format";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:13:"filter_format";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:51:"{^/editor/filter_xss/(?P<filter_format>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:13:"filter_format";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:18:"/editor/filter_xss";}}s:9:"path_vars";a:1:{i:0;s:13:"filter_format";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:6;s:14:"patternOutline";s:20:"/editor/filter_xss/%";s:8:"numParts";i:3;}}', 3, NULL),
('entity.block.delete_form', '/admin/structure/block/manage/{block}/delete', '/admin/structure/block/manage/%/delete', 61, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:44:"/admin/structure/block/manage/{block}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:12:"block.delete";s:6:"_title";s:12:"Remove block";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:5:"block";a:2:{s:4:"type";s:12:"entity:block";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"block";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:61:"{^/admin/structure/block/manage/(?P<block>[^/]++)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"block";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/block/manage";}}s:9:"path_vars";a:1:{i:0;s:5:"block";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:38:"/admin/structure/block/manage/%/delete";s:8:"numParts";i:6;}}', 6, NULL),
('entity.block.disable', '/admin/structure/block/manage/{block}/disable', '/admin/structure/block/manage/%/disable', 61, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:45:"/admin/structure/block/manage/{block}/disable";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:58:"\\Drupal\\block\\Controller\\BlockController::performOperation";s:2:"op";s:7:"disable";}s:12:"requirements";a:2:{s:14:"_entity_access";s:13:"block.disable";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:5:"block";a:2:{s:4:"type";s:12:"entity:block";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"block";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:62:"{^/admin/structure/block/manage/(?P<block>[^/]++)/disable$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:8:"/disable";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"block";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/block/manage";}}s:9:"path_vars";a:1:{i:0;s:5:"block";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:39:"/admin/structure/block/manage/%/disable";s:8:"numParts";i:6;}}', 6, NULL),
('entity.block.edit_form', '/admin/structure/block/manage/{block}', '/admin/structure/block/manage/%', 30, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:37:"/admin/structure/block/manage/{block}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:13:"block.default";s:6:"_title";s:15:"Configure block";}s:12:"requirements";a:1:{s:14:"_entity_access";s:12:"block.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:5:"block";a:2:{s:4:"type";s:12:"entity:block";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"block";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:54:"{^/admin/structure/block/manage/(?P<block>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"block";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/block/manage";}}s:9:"path_vars";a:1:{i:0;s:5:"block";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:31:"/admin/structure/block/manage/%";s:8:"numParts";i:5;}}', 5, NULL),
('entity.block.enable', '/admin/structure/block/manage/{block}/enable', '/admin/structure/block/manage/%/enable', 61, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:44:"/admin/structure/block/manage/{block}/enable";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:58:"\\Drupal\\block\\Controller\\BlockController::performOperation";s:2:"op";s:6:"enable";}s:12:"requirements";a:2:{s:14:"_entity_access";s:12:"block.enable";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:5:"block";a:2:{s:4:"type";s:12:"entity:block";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:5:"block";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:61:"{^/admin/structure/block/manage/(?P<block>[^/]++)/enable$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/enable";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"block";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/block/manage";}}s:9:"path_vars";a:1:{i:0;s:5:"block";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:38:"/admin/structure/block/manage/%/enable";s:8:"numParts";i:6;}}', 6, NULL),
('entity.block_content.add_form', '/block/add/{block_content_type}', '/block/add/%', 6, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:31:"/block/add/{block_content_type}";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:12:"_entity_form";s:17:"block_content.add";s:14:"entity_type_id";s:13:"block_content";s:15:"_title_callback";s:62:"Drupal\\Core\\Entity\\Controller\\EntityController::addBundleTitle";s:16:"bundle_parameter";s:18:"block_content_type";}s:12:"requirements";a:1:{s:21:"_entity_create_access";s:34:"block_content:{block_content_type}";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:18:"block_content_type";a:3:{s:4:"type";s:25:"entity:block_content_type";s:21:"with_config_overrides";b:1;s:9:"converter";s:21:"paramconverter.entity";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:26:"access_check.entity_create";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:18:"block_content_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:48:"{^/block/add/(?P<block_content_type>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:18:"block_content_type";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:10:"/block/add";}}s:9:"path_vars";a:1:{i:0;s:18:"block_content_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:6;s:14:"patternOutline";s:12:"/block/add/%";s:8:"numParts";i:3;}}', 3, NULL),
('entity.block_content.add_page', '', '', 0, 'O:31:"Symfony\\Component\\Routing\\Alias":2:{s:44:"\0Symfony\\Component\\Routing\\Alias\0deprecation";a:0:{}s:35:"\0Symfony\\Component\\Routing\\Alias\0id";s:22:"block_content.add_page";}', 0, 'block_content.add_page'),
('entity.block_content.canonical', '/admin/content/block/{block_content}', '/admin/content/block/%', 14, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:36:"/admin/content/block/{block_content}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:18:"block_content.edit";s:15:"_title_callback";s:58:"\\Drupal\\Core\\Entity\\Controller\\EntityController::editTitle";}s:12:"requirements";a:3:{s:14:"_entity_access";s:20:"block_content.update";s:13:"block_content";s:3:"\\d+";s:23:"_block_content_reusable";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:13:"block_content";a:2:{s:4:"type";s:20:"entity:block_content";s:9:"converter";s:21:"paramconverter.entity";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:35:"access_check.block_content_reusable";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:13:"block_content";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:50:"{^/admin/content/block/(?P<block_content>\\d+)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:13:"block_content";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:20:"/admin/content/block";}}s:9:"path_vars";a:1:{i:0;s:13:"block_content";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:14;s:14:"patternOutline";s:22:"/admin/content/block/%";s:8:"numParts";i:4;}}', 4, NULL),
('entity.block_content.collection', '/admin/content/block', '/admin/content/block', 7, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:20:"/admin/content/block";s:4:"host";s:0:"";s:8:"defaults";a:5:{s:11:"_controller";s:47:"Drupal\\views\\Routing\\ViewPageController::handle";s:15:"_title_callback";s:49:"Drupal\\views\\Routing\\ViewPageController::getTitle";s:7:"view_id";s:13:"block_content";s:10:"display_id";s:6:"page_1";s:30:"_view_display_show_admin_links";b:1;}s:12:"requirements";a:2:{s:11:"_permission";s:20:"access block library";s:7:"_format";s:4:"html";}s:7:"options";a:9:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:18:"_view_argument_map";a:0:{}s:23:"_view_display_plugin_id";s:4:"page";s:26:"_view_display_plugin_class";s:38:"Drupal\\views\\Plugin\\views\\display\\Page";s:30:"_view_display_show_admin_links";b:1;s:16:"returns_response";b:0;s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:0:{}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:27:"{^/admin/content/block$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:20:"/admin/content/block";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:20:"/admin/content/block";s:8:"numParts";i:3;}}', 3, NULL),
('entity.block_content.delete_form', '/admin/content/block/{block_content}/delete', '/admin/content/block/%/delete', 29, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:43:"/admin/content/block/{block_content}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:20:"block_content.delete";s:15:"_title_callback";s:60:"\\Drupal\\Core\\Entity\\Controller\\EntityController::deleteTitle";}s:12:"requirements";a:3:{s:14:"_entity_access";s:20:"block_content.delete";s:13:"block_content";s:3:"\\d+";s:23:"_block_content_reusable";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:13:"block_content";a:2:{s:4:"type";s:20:"entity:block_content";s:9:"converter";s:21:"paramconverter.entity";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:35:"access_check.block_content_reusable";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:13:"block_content";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:57:"{^/admin/content/block/(?P<block_content>\\d+)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:13:"block_content";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:20:"/admin/content/block";}}s:9:"path_vars";a:1:{i:0;s:13:"block_content";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:29;s:14:"patternOutline";s:29:"/admin/content/block/%/delete";s:8:"numParts";i:5;}}', 5, NULL),
('entity.block_content.edit_form', '/admin/content/block/{block_content}', '/admin/content/block/%', 14, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:36:"/admin/content/block/{block_content}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:18:"block_content.edit";s:15:"_title_callback";s:58:"\\Drupal\\Core\\Entity\\Controller\\EntityController::editTitle";}s:12:"requirements";a:3:{s:14:"_entity_access";s:20:"block_content.update";s:13:"block_content";s:3:"\\d+";s:23:"_block_content_reusable";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:13:"block_content";a:2:{s:4:"type";s:20:"entity:block_content";s:9:"converter";s:21:"paramconverter.entity";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:35:"access_check.block_content_reusable";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:13:"block_content";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:50:"{^/admin/content/block/(?P<block_content>\\d+)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:13:"block_content";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:20:"/admin/content/block";}}s:9:"path_vars";a:1:{i:0;s:13:"block_content";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:14;s:14:"patternOutline";s:22:"/admin/content/block/%";s:8:"numParts";i:4;}}', 4, NULL),
('entity.block_content.field_ui_fields', '/admin/structure/block-content/manage/{block_content_type}/fields', '/admin/structure/block-content/manage/%/fields', 61, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:65:"/admin/structure/block-content/manage/{block_content_type}/fields";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:11:"_controller";s:62:"\\Drupal\\field_ui\\Controller\\FieldConfigListController::listing";s:6:"_title";s:13:"Manage fields";s:14:"entity_type_id";s:13:"block_content";s:6:"bundle";s:0:"";}s:12:"requirements";a:1:{s:11:"_permission";s:31:"administer block_content fields";}s:7:"options";a:6:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:18:"block_content_type";a:2:{s:4:"type";s:25:"entity:block_content_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:9:"_field_ui";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:0:{}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:18:"block_content_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:83:"{^/admin/structure/block\\-content/manage/(?P<block_content_type>[^/]++)/fields$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/fields";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:18:"block_content_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/structure/block-content/manage";}}s:9:"path_vars";a:1:{i:0;s:18:"block_content_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:46:"/admin/structure/block-content/manage/%/fields";s:8:"numParts";i:6;}}', 6, NULL),
('entity.block_content.revision_delete_form', '/admin/content/block/{block_content}/revision/{block_content_revision}/delete', '/admin/content/block/%/revision/%/delete', 117, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:77:"/admin/content/block/{block_content}/revision/{block_content_revision}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:29:"block_content.revision-delete";s:6:"_title";s:15:"Delete revision";}s:12:"requirements";a:1:{s:14:"_entity_access";s:38:"block_content_revision.delete revision";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:10:"parameters";a:2:{s:13:"block_content";a:2:{s:4:"type";s:20:"entity:block_content";s:9:"converter";s:21:"paramconverter.entity";}s:22:"block_content_revision";a:2:{s:4:"type";s:29:"entity_revision:block_content";s:9:"converter";s:30:"paramconverter.entity_revision";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:13:"block_content";i:1;s:22:"block_content_revision";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:104:"{^/admin/content/block/(?P<block_content>[^/]++)/revision/(?P<block_content_revision>[^/]++)/delete$}sDu";s:11:"path_tokens";a:5:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:22:"block_content_revision";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:9:"/revision";}i:3;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:13:"block_content";i:4;b:1;}i:4;a:2:{i:0;s:4:"text";i:1;s:20:"/admin/content/block";}}s:9:"path_vars";a:2:{i:0;s:13:"block_content";i:1;s:22:"block_content_revision";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:117;s:14:"patternOutline";s:40:"/admin/content/block/%/revision/%/delete";s:8:"numParts";i:7;}}', 7, NULL),
('entity.block_content.revision_revert_form', '/admin/content/block/{block_content}/revision/{block_content_revision}/revert', '/admin/content/block/%/revision/%/revert', 117, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:77:"/admin/content/block/{block_content}/revision/{block_content_revision}/revert";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:29:"block_content.revision-revert";s:6:"_title";s:15:"Revert revision";}s:12:"requirements";a:1:{s:14:"_entity_access";s:29:"block_content_revision.revert";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:10:"parameters";a:2:{s:13:"block_content";a:2:{s:4:"type";s:20:"entity:block_content";s:9:"converter";s:21:"paramconverter.entity";}s:22:"block_content_revision";a:2:{s:4:"type";s:29:"entity_revision:block_content";s:9:"converter";s:30:"paramconverter.entity_revision";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:2:{i:0;s:13:"block_content";i:1;s:22:"block_content_revision";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:104:"{^/admin/content/block/(?P<block_content>[^/]++)/revision/(?P<block_content_revision>[^/]++)/revert$}sDu";s:11:"path_tokens";a:5:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/revert";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:22:"block_content_revision";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:9:"/revision";}i:3;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:13:"block_content";i:4;b:1;}i:4;a:2:{i:0;s:4:"text";i:1;s:20:"/admin/content/block";}}s:9:"path_vars";a:2:{i:0;s:13:"block_content";i:1;s:22:"block_content_revision";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:117;s:14:"patternOutline";s:40:"/admin/content/block/%/revision/%/revert";s:8:"numParts";i:7;}}', 7, NULL),
('entity.block_content.version_history', '/admin/content/block/{block_content}/revisions', '/admin/content/block/%/revisions', 29, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:46:"/admin/content/block/{block_content}/revisions";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:54:"Drupal\\Core\\Entity\\Controller\\VersionHistoryController";s:6:"_title";s:9:"Revisions";}s:12:"requirements";a:1:{s:14:"_entity_access";s:32:"block_content.view all revisions";}s:7:"options";a:6:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:14:"entity_type_id";s:13:"block_content";s:12:"_admin_route";b:1;s:10:"parameters";a:1:{s:13:"block_content";a:2:{s:4:"type";s:20:"entity:block_content";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:13:"block_content";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:63:"{^/admin/content/block/(?P<block_content>[^/]++)/revisions$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:10:"/revisions";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:13:"block_content";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:20:"/admin/content/block";}}s:9:"path_vars";a:1:{i:0;s:13:"block_content";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:29;s:14:"patternOutline";s:32:"/admin/content/block/%/revisions";s:8:"numParts";i:5;}}', 5, NULL),
('entity.block_content_type.add_form', '', '', 0, 'O:31:"Symfony\\Component\\Routing\\Alias":2:{s:44:"\0Symfony\\Component\\Routing\\Alias\0deprecation";a:0:{}s:35:"\0Symfony\\Component\\Routing\\Alias\0id";s:22:"block_content.type_add";}', 0, 'block_content.type_add'),
('entity.block_content_type.collection', '/admin/structure/block-content', '/admin/structure/block-content', 7, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:30:"/admin/structure/block-content";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:12:"_entity_list";s:18:"block_content_type";s:6:"_title";s:11:"Block types";s:16:"_title_arguments";a:0:{}s:14:"_title_context";s:0:"";}s:12:"requirements";a:1:{s:11:"_permission";s:22:"administer block types";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:38:"{^/admin/structure/block\\-content$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:30:"/admin/structure/block-content";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:30:"/admin/structure/block-content";s:8:"numParts";i:3;}}', 3, NULL),
('entity.block_content_type.delete_form', '/admin/structure/block-content/manage/{block_content_type}/delete', '/admin/structure/block-content/manage/%/delete', 61, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:65:"/admin/structure/block-content/manage/{block_content_type}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:25:"block_content_type.delete";s:15:"_title_callback";s:60:"\\Drupal\\Core\\Entity\\Controller\\EntityController::deleteTitle";}s:12:"requirements";a:1:{s:14:"_entity_access";s:25:"block_content_type.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:18:"block_content_type";a:2:{s:4:"type";s:25:"entity:block_content_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:18:"block_content_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:83:"{^/admin/structure/block\\-content/manage/(?P<block_content_type>[^/]++)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:18:"block_content_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/structure/block-content/manage";}}s:9:"path_vars";a:1:{i:0;s:18:"block_content_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:46:"/admin/structure/block-content/manage/%/delete";s:8:"numParts";i:6;}}', 6, NULL),
('entity.block_content_type.edit_form', '/admin/structure/block-content/manage/{block_content_type}', '/admin/structure/block-content/manage/%', 30, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:58:"/admin/structure/block-content/manage/{block_content_type}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:23:"block_content_type.edit";s:15:"_title_callback";s:58:"\\Drupal\\Core\\Entity\\Controller\\EntityController::editTitle";}s:12:"requirements";a:1:{s:14:"_entity_access";s:25:"block_content_type.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:18:"block_content_type";a:2:{s:4:"type";s:25:"entity:block_content_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:18:"block_content_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:76:"{^/admin/structure/block\\-content/manage/(?P<block_content_type>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:18:"block_content_type";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/structure/block-content/manage";}}s:9:"path_vars";a:1:{i:0;s:18:"block_content_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:39:"/admin/structure/block-content/manage/%";s:8:"numParts";i:5;}}', 5, NULL),
('entity.block_content_type.entity_permissions_form', '/admin/structure/block-content/manage/{block_content_type}/permissions', '/admin/structure/block-content/manage/%/permissions', 61, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:70:"/admin/structure/block-content/manage/{block_content_type}/permissions";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:6:"_title";s:18:"Manage permissions";s:5:"_form";s:38:"Drupal\\user\\Form\\EntityPermissionsForm";s:14:"entity_type_id";s:13:"block_content";s:18:"bundle_entity_type";s:18:"block_content_type";}s:12:"requirements";a:1:{s:11:"_permission";s:22:"administer permissions";}s:7:"options";a:6:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:9:"_field_ui";b:1;s:10:"parameters";a:1:{s:18:"block_content_type";a:3:{s:4:"type";s:25:"entity:block_content_type";s:21:"with_config_overrides";b:1;s:9:"converter";s:21:"paramconverter.entity";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:18:"block_content_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:88:"{^/admin/structure/block\\-content/manage/(?P<block_content_type>[^/]++)/permissions$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:12:"/permissions";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:18:"block_content_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:37:"/admin/structure/block-content/manage";}}s:9:"path_vars";a:1:{i:0;s:18:"block_content_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:51:"/admin/structure/block-content/manage/%/permissions";s:8:"numParts";i:6;}}', 6, NULL),
('entity.comment.canonical', '/comment/{comment}', '/comment/%', 2, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:18:"/comment/{comment}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:15:"_title_callback";s:67:"\\Drupal\\comment\\Controller\\CommentController::commentPermalinkTitle";s:11:"_controller";s:62:"\\Drupal\\comment\\Controller\\CommentController::commentPermalink";}s:12:"requirements";a:2:{s:14:"_entity_access";s:12:"comment.view";s:7:"comment";s:3:"\\d+";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:7:"comment";a:2:{s:4:"type";s:14:"entity:comment";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:7:"comment";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:32:"{^/comment/(?P<comment>\\d+)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:7:"comment";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:8:"/comment";}}s:9:"path_vars";a:1:{i:0;s:7:"comment";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:2;s:14:"patternOutline";s:10:"/comment/%";s:8:"numParts";i:2;}}', 2, NULL),
('entity.comment.delete_form', '/comment/{comment}/delete', '/comment/%/delete', 5, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:25:"/comment/{comment}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:6:"Delete";s:12:"_entity_form";s:14:"comment.delete";}s:12:"requirements";a:2:{s:14:"_entity_access";s:14:"comment.delete";s:7:"comment";s:3:"\\d+";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:7:"comment";a:2:{s:4:"type";s:14:"entity:comment";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:7:"comment";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:39:"{^/comment/(?P<comment>\\d+)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:7:"comment";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:8:"/comment";}}s:9:"path_vars";a:1:{i:0;s:7:"comment";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:17:"/comment/%/delete";s:8:"numParts";i:3;}}', 3, NULL),
('entity.comment.delete_multiple_form', '/admin/content/comment/delete', '/admin/content/comment/delete', 15, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:29:"/admin/content/comment/delete";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:6:"_title";s:6:"Delete";s:5:"_form";s:42:"\\Drupal\\comment\\Form\\ConfirmDeleteMultiple";s:14:"entity_type_id";s:7:"comment";}s:12:"requirements";a:1:{s:30:"_entity_delete_multiple_access";s:7:"comment";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:35:"access_check.entity_delete_multiple";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"{^/admin/content/comment/delete$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/content/comment/delete";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:29:"/admin/content/comment/delete";s:8:"numParts";i:4;}}', 4, NULL),
('entity.comment.edit_form', '/comment/{comment}/edit', '/comment/%/edit', 5, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:23:"/comment/{comment}/edit";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:4:"Edit";s:12:"_entity_form";s:15:"comment.default";}s:12:"requirements";a:2:{s:14:"_entity_access";s:14:"comment.update";s:7:"comment";s:3:"\\d+";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:7:"comment";a:2:{s:4:"type";s:14:"entity:comment";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:7:"comment";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:37:"{^/comment/(?P<comment>\\d+)/edit$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:5:"/edit";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:7:"comment";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:8:"/comment";}}s:9:"path_vars";a:1:{i:0;s:7:"comment";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:15:"/comment/%/edit";s:8:"numParts";i:3;}}', 3, NULL),
('entity.comment.field_ui_fields', '/admin/structure/comment/manage/{comment_type}/fields', '/admin/structure/comment/manage/%/fields', 61, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:53:"/admin/structure/comment/manage/{comment_type}/fields";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:11:"_controller";s:62:"\\Drupal\\field_ui\\Controller\\FieldConfigListController::listing";s:6:"_title";s:13:"Manage fields";s:14:"entity_type_id";s:7:"comment";s:6:"bundle";s:0:"";}s:12:"requirements";a:1:{s:11:"_permission";s:25:"administer comment fields";}s:7:"options";a:6:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:10:"parameters";a:1:{s:12:"comment_type";a:2:{s:4:"type";s:19:"entity:comment_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:9:"_field_ui";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:0:{}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:12:"comment_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:70:"{^/admin/structure/comment/manage/(?P<comment_type>[^/]++)/fields$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/fields";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"comment_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/structure/comment/manage";}}s:9:"path_vars";a:1:{i:0;s:12:"comment_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:40:"/admin/structure/comment/manage/%/fields";s:8:"numParts";i:6;}}', 6, NULL),
('entity.comment_type.add_form', '/admin/structure/comment/types/add', '/admin/structure/comment/types/add', 31, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:34:"/admin/structure/comment/types/add";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:16:"comment_type.add";s:6:"_title";s:16:"Add comment type";}s:12:"requirements";a:1:{s:11:"_permission";s:24:"administer comment types";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:41:"{^/admin/structure/comment/types/add$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:34:"/admin/structure/comment/types/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:31;s:14:"patternOutline";s:34:"/admin/structure/comment/types/add";s:8:"numParts";i:5;}}', 5, NULL),
('entity.comment_type.collection', '/admin/structure/comment', '/admin/structure/comment', 7, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:24:"/admin/structure/comment";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:12:"comment_type";s:6:"_title";s:13:"Comment types";}s:12:"requirements";a:1:{s:11:"_permission";s:24:"administer comment types";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:31:"{^/admin/structure/comment$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:24:"/admin/structure/comment";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:24:"/admin/structure/comment";s:8:"numParts";i:3;}}', 3, NULL),
('entity.comment_type.delete_form', '/admin/structure/comment/manage/{comment_type}/delete', '/admin/structure/comment/manage/%/delete', 61, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:53:"/admin/structure/comment/manage/{comment_type}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:19:"comment_type.delete";s:6:"_title";s:6:"Delete";}s:12:"requirements";a:1:{s:14:"_entity_access";s:19:"comment_type.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:10:"parameters";a:1:{s:12:"comment_type";a:2:{s:4:"type";s:19:"entity:comment_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:12:"comment_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:70:"{^/admin/structure/comment/manage/(?P<comment_type>[^/]++)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"comment_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/structure/comment/manage";}}s:9:"path_vars";a:1:{i:0;s:12:"comment_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:40:"/admin/structure/comment/manage/%/delete";s:8:"numParts";i:6;}}', 6, NULL),
('entity.comment_type.edit_form', '/admin/structure/comment/manage/{comment_type}', '/admin/structure/comment/manage/%', 30, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:46:"/admin/structure/comment/manage/{comment_type}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:17:"comment_type.edit";s:15:"_title_callback";s:54:"\\Drupal\\Core\\Entity\\Controller\\EntityController::title";}s:12:"requirements";a:1:{s:14:"_entity_access";s:19:"comment_type.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:10:"parameters";a:1:{s:12:"comment_type";a:2:{s:4:"type";s:19:"entity:comment_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:12:"comment_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:63:"{^/admin/structure/comment/manage/(?P<comment_type>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"comment_type";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/structure/comment/manage";}}s:9:"path_vars";a:1:{i:0;s:12:"comment_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:33:"/admin/structure/comment/manage/%";s:8:"numParts";i:5;}}', 5, NULL),
('entity.comment_type.entity_permissions_form', '/admin/structure/comment/manage/{comment_type}/permissions', '/admin/structure/comment/manage/%/permissions', 61, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:58:"/admin/structure/comment/manage/{comment_type}/permissions";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:6:"_title";s:18:"Manage permissions";s:5:"_form";s:38:"Drupal\\user\\Form\\EntityPermissionsForm";s:14:"entity_type_id";s:7:"comment";s:18:"bundle_entity_type";s:12:"comment_type";}s:12:"requirements";a:1:{s:11:"_permission";s:22:"administer permissions";}s:7:"options";a:6:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:9:"_field_ui";b:1;s:10:"parameters";a:1:{s:12:"comment_type";a:3:{s:4:"type";s:19:"entity:comment_type";s:21:"with_config_overrides";b:1;s:9:"converter";s:21:"paramconverter.entity";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:12:"comment_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:75:"{^/admin/structure/comment/manage/(?P<comment_type>[^/]++)/permissions$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:12:"/permissions";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"comment_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/structure/comment/manage";}}s:9:"path_vars";a:1:{i:0;s:12:"comment_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:45:"/admin/structure/comment/manage/%/permissions";s:8:"numParts";i:6;}}', 6, NULL),
('entity.date_format.collection', '/admin/config/regional/date-time', '/admin/config/regional/date-time', 15, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:32:"/admin/config/regional/date-time";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:11:"date_format";s:6:"_title";s:21:"Date and time formats";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer site configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:40:"{^/admin/config/regional/date\\-time$}sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:32:"/admin/config/regional/date-time";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:32:"/admin/config/regional/date-time";s:8:"numParts";i:4;}}', 4, NULL);
INSERT INTO `[[dbprefix]]router` VALUES
('entity.date_format.delete_form', '/admin/config/regional/date-time/formats/manage/{date_format}/delete', '/admin/config/regional/date-time/formats/manage/%/delete', 253, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:68:"/admin/config/regional/date-time/formats/manage/{date_format}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:18:"date_format.delete";s:6:"_title";s:18:"Delete date format";}s:12:"requirements";a:1:{s:14:"_entity_access";s:18:"date_format.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:11:"date_format";a:2:{s:4:"type";s:18:"entity:date_format";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:11:"date_format";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:86:"{^/admin/config/regional/date\\-time/formats/manage/(?P<date_format>[^/]++)/delete$}sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"date_format";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:47:"/admin/config/regional/date-time/formats/manage";}}s:9:"path_vars";a:1:{i:0;s:11:"date_format";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:253;s:14:"patternOutline";s:56:"/admin/config/regional/date-time/formats/manage/%/delete";s:8:"numParts";i:8;}}', 8, NULL),
('entity.date_format.edit_form', '/admin/config/regional/date-time/formats/manage/{date_format}', '/admin/config/regional/date-time/formats/manage/%', 126, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:61:"/admin/config/regional/date-time/formats/manage/{date_format}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:16:"date_format.edit";s:6:"_title";s:16:"Edit date format";}s:12:"requirements";a:1:{s:14:"_entity_access";s:18:"date_format.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:11:"date_format";a:2:{s:4:"type";s:18:"entity:date_format";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";O:33:"Drupal\\Core\\Routing\\CompiledRoute":11:{s:4:"vars";a:1:{i:0;s:11:"date_format";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:79:"{^/admin/config/regional/date\\-time/formats/manage/(?P<date_format>[^/]++)$}sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"date_format";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:47:"/admin/config/regional/date-time/formats/manage";}}s:9:"path_vars";a:1:{i:0;s:11:"date_format";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:126;s:14:"patternOutline";s:49:"/admin/config/regional/date-time/formats/manage/%";s:8:"numParts";i:7;}}', 7, NULL),
('entity.entity_form_display.block_content.default', '/admin/structure/block-content/manage/{block_content_type}/form-display', '/admin/structure/block-content/manage/%/form-display', 61, 'O:31:"Symfony\\Component\\Routing\\Route":9:{s:4:"path";s:71:"/admin/structure/block-content/manage/{block_content_type}/form-display";s:4:"host";s:0:"";s:8:"defaults";a:5:{s:12:"_entity_form";s:24:"entity_form_display.edit";s:6:"_title";s:19:"Manage form display";s:14:"form_mode_name";s:7:"default";s:14:"entity_type_id";s:13:"block_content";s:6:"bundle";s:0:"";}s