import { ICellCss, ICol, IFooter, IGridConfig, IGridTooltipConfig, IHeader, IRow, ISpan } from "../types";
import { ITooltipConfig } from "../../../ts-message";
import { Id } from "../../../ts-common/types";
import { ITreeCollection } from "../../../ts-data";
export declare function transpose(arr: any[][], transform?: any): any[][];
export declare function getStyleByClass(cssClass: string, targetClass: string, def: ICellCss, container?: HTMLElement): ICellCss;
export declare function removeHTMLTags(str: string): string;
export declare function isCssSupport(property: string, value: string): boolean;
export declare function isRowEmpty(row: IRow): boolean;
export declare function isSortable(config: IGridConfig, col: ICol): boolean;
export declare function isAutoWidth(config: IGridConfig, col?: ICol): boolean;
export declare function showTooltip(value: any, config: ITooltipConfig): void;
export declare function isContentTooltip(config: IGridConfig, col: ICol, cell: any, type: "footer" | "header"): boolean;
export declare function getTooltipConfig(config: IGridConfig, col?: ICol, cell?: IHeader | IFooter | ISpan, type?: "footer" | "header"): IGridTooltipConfig;
export declare function isTooltip(config: IGridConfig, element: ICol | ISpan): boolean | IGridTooltipConfig;
export declare function isHtmlEnable(config: IGridConfig, col: ICol, content?: IHeader | IFooter): boolean;
export declare function getTotalWidth(columns: ICol[]): number;
export declare function getTotalHeight(rows: IRow[]): number;
export declare function scrollFixedColsAndRows(e: WheelEvent): void;
export declare function isWasmSupported(): boolean;
export declare function getLastChild(id: any, data: any, deep?: boolean): Id | null;
export declare function getClosestTop(id: Id, data: ITreeCollection): Id | null;
export declare function getClosestBottom(id: Id, data: ITreeCollection, ignore?: boolean): Id | null;
