<div class="content{if empty($PRODUCT.description)} active{/if}" id="product_spec">
    <table>
        <tbody>
            <tr>
                <td>{$LANG.catalogue.product_code}</td>
                <td>{$PRODUCT.product_code}</td>
            </tr>
            {if $PRODUCT.manufacturer}
            <tr>
                <td>{$LANG.catalogue.manufacturer}</td>
                <td>{$MANUFACTURER}</td>
            </tr>
            {/if}
            {if $MANUFACTURER_GPSR}
            <tr>
                <td valign="top">{$LANG.catalogue.manufacturer_address}</td>
                <td>{if !empty($MANUFACTURER_GPSR.line1)}{$MANUFACTURER_GPSR.line1}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.line2)}{$MANUFACTURER_GPSR.line2}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.town)}{$MANUFACTURER_GPSR.town}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.state)}{$MANUFACTURER_GPSR.state}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.postcode)}{$MANUFACTURER_GPSR.postcode}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.country)}{$MANUFACTURER_GPSR.country}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.phone)}{$MANUFACTURER_GPSR.phone}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.email)}<a href="mailto:{$MANUFACTURER_GPSR.email}">{$MANUFACTURER_GPSR.email}</a><br>{/if}
                    {if !empty($MANUFACTURER_GPSR.contact_url)}<a href="{$MANUFACTURER_GPSR.contact_url}" target="_blank">{$MANUFACTURER_GPSR.contact_url}</a>{/if}
                </td>
            </tr>
            {/if}
            {if $MANUFACTURER_GPSR}
            <tr>
                <td valign="top">{$LANG.catalogue.manufacturer_eu_contact}</td>
                <td>
                    {if !empty($MANUFACTURER_GPSR.eu_name)}{$MANUFACTURER_GPSR.eu_name}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.eu_line1)}{$MANUFACTURER_GPSR.eu_line1}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.eu_line2)}{$MANUFACTURER_GPSR.eu_line2}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.eu_town)}{$MANUFACTURER_GPSR.eu_town}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.eu_state)}{$MANUFACTURER_GPSR.eu_state}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.eu_postcode)}{$MANUFACTURER_GPSR.eu_postcode}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.eu_country)}{$MANUFACTURER_GPSR.eu_country}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.eu_phone)}{$MANUFACTURER_GPSR.eu_phone}<br>{/if}
                    {if !empty($MANUFACTURER_GPSR.eu_email)}<a href="mailto:{$MANUFACTURER_GPSR.eu_email}">{$MANUFACTURER_GPSR.eu_email}</a><br>{/if}
                    {if !empty($MANUFACTURER_GPSR.eu_contact_url)}<a href="{$MANUFACTURER_GPSR.eu_contact_url}" target="_blank">{$MANUFACTURER_GPSR.eu_contact_url}</a>{/if}
                </td>
            </tr>
            {/if}
            {if $PRODUCT.stock_level}
            <tr>
                <td>{$LANG.catalogue.stock_level}</td>
                <td>{$PRODUCT.stock_level}</td>
            </tr>
            {/if}
            <tr>
                <td>{$LANG.common.condition}</td>
                <td>{$PRODUCT.condition}</td>
            </tr>
            {if $PRODUCT.product_weight > 0}
            <tr>
                <td>{$LANG.common.weight}</td>
                <td>{$PRODUCT.product_weight}{$CONFIG.product_weight_unit|lower}</td>
            </tr>
            {/if}
            {if $PRODUCT.product_width > 0}
            <tr>
                <td>{$LANG.common.width}</td>
                <td>{floatval($PRODUCT.product_width)}{if $PRODUCT.dimension_unit=='in'}&#8243;{else}{$PRODUCT.dimension_unit}{/if}</td>
            </tr>
            {/if}
            {if $PRODUCT.product_height > 0}
            <tr>
                <td>{$LANG.common.height}</td>
                <td>{floatval($PRODUCT.product_height)}{if $PRODUCT.dimension_unit=='in'}&#8243;{else}{$PRODUCT.dimension_unit}{/if}</td>
            </tr>
            {/if}
            {if $PRODUCT.product_depth > 0}
            <tr>
                <td>{$LANG.common.depth}</td>
                <td>{floatval($PRODUCT.product_depth)}{if $PRODUCT.dimension_unit=='in'}&#8243;{else}{$PRODUCT.dimension_unit}{/if}</td>
            </tr>
            {/if}
            {if $PRODUCT.digital > 0}
            <tr>
                <td>{$LANG.catalogue.product_type_digital}</td>
                <td>{$LANG.common.download}</td>
            </tr>
            {/if}
            {if $PRODUCT.spec_array}
            {foreach from=$PRODUCT.spec_array key=spec_key item=spec_val}
            <tr>
                <td>{$spec_val.0}</td>
                <td>{$spec_val.1}</td>
            </tr>
            {/foreach}
            {/if}
        </tbody>
    </table>
    {$PRODUCT.spec_copy}
</div>