<?php
/**
 * ImportersApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.7.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * ImportersApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ImportersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'analyzeImportMigration' => [
            'application/json',
        ],
        'checkImportMigrationResources' => [
            'application/json',
        ],
        'createImportMigration' => [
            'application/json',
        ],
        'createImportServerSettings' => [
            'application/json',
        ],
        'deleteImportMigration' => [
            'application/json',
        ],
        'deleteImportServerSettings' => [
            'application/json',
        ],
        'getImportMigration' => [
            'application/json',
        ],
        'getImportMigrationData' => [
            'application/json',
        ],
        'getImportMigrationLog' => [
            'application/json',
        ],
        'getImportMigrations' => [
            'application/json',
        ],
        'getImportServerDomainsCached' => [
            'application/json',
        ],
        'getImportServerPullDomains' => [
            'application/json',
        ],
        'getImportServerSettings' => [
            'application/json',
        ],
        'listImportServerSettings' => [
            'application/json',
        ],
        'scanImportMigrations' => [
            'application/json',
        ],
        'transferCPanelUserAccount' => [
            'application/json',
        ],
        'transferPleskDomain' => [
            'application/json',
        ],
        'updateImportServerSettings' => [
            'application/json',
        ],
        'uploadImportMigration' => [
            'multipart/form-data',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation analyzeImportMigration
     *
     * Analyze imported migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['analyzeImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function analyzeImportMigration($org_id, $import_migration_id, string $contentType = self::contentTypes['analyzeImportMigration'][0])
    {
        $this->analyzeImportMigrationWithHttpInfo($org_id, $import_migration_id, $contentType);
    }

    /**
     * Operation analyzeImportMigrationWithHttpInfo
     *
     * Analyze imported migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['analyzeImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function analyzeImportMigrationWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['analyzeImportMigration'][0])
    {
        $request = $this->analyzeImportMigrationRequest($org_id, $import_migration_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation analyzeImportMigrationAsync
     *
     * Analyze imported migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['analyzeImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function analyzeImportMigrationAsync($org_id, $import_migration_id, string $contentType = self::contentTypes['analyzeImportMigration'][0])
    {
        return $this->analyzeImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation analyzeImportMigrationAsyncWithHttpInfo
     *
     * Analyze imported migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['analyzeImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function analyzeImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['analyzeImportMigration'][0])
    {
        $returnType = '';
        $request = $this->analyzeImportMigrationRequest($org_id, $import_migration_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'analyzeImportMigration'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['analyzeImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function analyzeImportMigrationRequest($org_id, $import_migration_id, string $contentType = self::contentTypes['analyzeImportMigration'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling analyzeImportMigration'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling analyzeImportMigration'
            );
        }


        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}/analyze';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation checkImportMigrationResources
     *
     * Check if all resources from the imported migration could be created.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody|null $importer_migration_req_body importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkImportMigrationResources'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ResourceCheckError
     */
    public function checkImportMigrationResources($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['checkImportMigrationResources'][0])
    {
        list($response) = $this->checkImportMigrationResourcesWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body, $contentType);
        return $response;
    }

    /**
     * Operation checkImportMigrationResourcesWithHttpInfo
     *
     * Check if all resources from the imported migration could be created.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody|null $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkImportMigrationResources'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ResourceCheckError, HTTP status code, HTTP response headers (array of strings)
     */
    public function checkImportMigrationResourcesWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['checkImportMigrationResources'][0])
    {
        $request = $this->checkImportMigrationResourcesRequest($org_id, $import_migration_id, $importer_migration_req_body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ResourceCheckError',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ResourceCheckError',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ResourceCheckError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation checkImportMigrationResourcesAsync
     *
     * Check if all resources from the imported migration could be created.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody|null $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkImportMigrationResources'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkImportMigrationResourcesAsync($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['checkImportMigrationResources'][0])
    {
        return $this->checkImportMigrationResourcesAsyncWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation checkImportMigrationResourcesAsyncWithHttpInfo
     *
     * Check if all resources from the imported migration could be created.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody|null $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkImportMigrationResources'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkImportMigrationResourcesAsyncWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['checkImportMigrationResources'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ResourceCheckError';
        $request = $this->checkImportMigrationResourcesRequest($org_id, $import_migration_id, $importer_migration_req_body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'checkImportMigrationResources'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody|null $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkImportMigrationResources'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function checkImportMigrationResourcesRequest($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['checkImportMigrationResources'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling checkImportMigrationResources'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling checkImportMigrationResources'
            );
        }



        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}/resource';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($importer_migration_req_body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($importer_migration_req_body));
            } else {
                $httpBody = $importer_migration_req_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createImportMigration
     *
     * Create a new import migration.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody|null $importer_migration_req_body importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createImportMigration($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['createImportMigration'][0])
    {
        $this->createImportMigrationWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body, $contentType);
    }

    /**
     * Operation createImportMigrationWithHttpInfo
     *
     * Create a new import migration.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody|null $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createImportMigrationWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['createImportMigration'][0])
    {
        $request = $this->createImportMigrationRequest($org_id, $import_migration_id, $importer_migration_req_body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation createImportMigrationAsync
     *
     * Create a new import migration.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody|null $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createImportMigrationAsync($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['createImportMigration'][0])
    {
        return $this->createImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createImportMigrationAsyncWithHttpInfo
     *
     * Create a new import migration.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody|null $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['createImportMigration'][0])
    {
        $returnType = '';
        $request = $this->createImportMigrationRequest($org_id, $import_migration_id, $importer_migration_req_body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createImportMigration'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  \OpenAPI\Client\Model\ImporterMigrationReqBody|null $importer_migration_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createImportMigrationRequest($org_id, $import_migration_id, $importer_migration_req_body = null, string $contentType = self::contentTypes['createImportMigration'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createImportMigration'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling createImportMigration'
            );
        }



        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($importer_migration_req_body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($importer_migration_req_body));
            } else {
                $httpBody = $importer_migration_req_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createImportServerSettings
     *
     * Create settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewImportServerSettings $new_import_server_settings new_import_server_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportServerSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceUuid
     */
    public function createImportServerSettings($org_id, $new_import_server_settings, string $contentType = self::contentTypes['createImportServerSettings'][0])
    {
        list($response) = $this->createImportServerSettingsWithHttpInfo($org_id, $new_import_server_settings, $contentType);
        return $response;
    }

    /**
     * Operation createImportServerSettingsWithHttpInfo
     *
     * Create settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewImportServerSettings $new_import_server_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportServerSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceUuid, HTTP status code, HTTP response headers (array of strings)
     */
    public function createImportServerSettingsWithHttpInfo($org_id, $new_import_server_settings, string $contentType = self::contentTypes['createImportServerSettings'][0])
    {
        $request = $this->createImportServerSettingsRequest($org_id, $new_import_server_settings, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\NewResourceUuid',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createImportServerSettingsAsync
     *
     * Create settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewImportServerSettings $new_import_server_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createImportServerSettingsAsync($org_id, $new_import_server_settings, string $contentType = self::contentTypes['createImportServerSettings'][0])
    {
        return $this->createImportServerSettingsAsyncWithHttpInfo($org_id, $new_import_server_settings, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createImportServerSettingsAsyncWithHttpInfo
     *
     * Create settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewImportServerSettings $new_import_server_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createImportServerSettingsAsyncWithHttpInfo($org_id, $new_import_server_settings, string $contentType = self::contentTypes['createImportServerSettings'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
        $request = $this->createImportServerSettingsRequest($org_id, $new_import_server_settings, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createImportServerSettings'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  \OpenAPI\Client\Model\NewImportServerSettings $new_import_server_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createImportServerSettingsRequest($org_id, $new_import_server_settings, string $contentType = self::contentTypes['createImportServerSettings'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createImportServerSettings'
            );
        }

        // verify the required parameter 'new_import_server_settings' is set
        if ($new_import_server_settings === null || (is_array($new_import_server_settings) && count($new_import_server_settings) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_import_server_settings when calling createImportServerSettings'
            );
        }


        $resourcePath = '/orgs/{org_id}/import/server/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_import_server_settings)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_import_server_settings));
            } else {
                $httpBody = $new_import_server_settings;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteImportMigration
     *
     * Delete single migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteImportMigration($org_id, $import_migration_id, string $contentType = self::contentTypes['deleteImportMigration'][0])
    {
        $this->deleteImportMigrationWithHttpInfo($org_id, $import_migration_id, $contentType);
    }

    /**
     * Operation deleteImportMigrationWithHttpInfo
     *
     * Delete single migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteImportMigrationWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['deleteImportMigration'][0])
    {
        $request = $this->deleteImportMigrationRequest($org_id, $import_migration_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteImportMigrationAsync
     *
     * Delete single migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteImportMigrationAsync($org_id, $import_migration_id, string $contentType = self::contentTypes['deleteImportMigration'][0])
    {
        return $this->deleteImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteImportMigrationAsyncWithHttpInfo
     *
     * Delete single migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['deleteImportMigration'][0])
    {
        $returnType = '';
        $request = $this->deleteImportMigrationRequest($org_id, $import_migration_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteImportMigration'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteImportMigrationRequest($org_id, $import_migration_id, string $contentType = self::contentTypes['deleteImportMigration'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteImportMigration'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling deleteImportMigration'
            );
        }


        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteImportServerSettings
     *
     * Delete settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportServerSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteImportServerSettings($org_id, $server_id, string $contentType = self::contentTypes['deleteImportServerSettings'][0])
    {
        $this->deleteImportServerSettingsWithHttpInfo($org_id, $server_id, $contentType);
    }

    /**
     * Operation deleteImportServerSettingsWithHttpInfo
     *
     * Delete settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportServerSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteImportServerSettingsWithHttpInfo($org_id, $server_id, string $contentType = self::contentTypes['deleteImportServerSettings'][0])
    {
        $request = $this->deleteImportServerSettingsRequest($org_id, $server_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteImportServerSettingsAsync
     *
     * Delete settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteImportServerSettingsAsync($org_id, $server_id, string $contentType = self::contentTypes['deleteImportServerSettings'][0])
    {
        return $this->deleteImportServerSettingsAsyncWithHttpInfo($org_id, $server_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteImportServerSettingsAsyncWithHttpInfo
     *
     * Delete settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteImportServerSettingsAsyncWithHttpInfo($org_id, $server_id, string $contentType = self::contentTypes['deleteImportServerSettings'][0])
    {
        $returnType = '';
        $request = $this->deleteImportServerSettingsRequest($org_id, $server_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteImportServerSettings'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteImportServerSettingsRequest($org_id, $server_id, string $contentType = self::contentTypes['deleteImportServerSettings'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteImportServerSettings'
            );
        }

        // verify the required parameter 'server_id' is set
        if ($server_id === null || (is_array($server_id) && count($server_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $server_id when calling deleteImportServerSettings'
            );
        }


        $resourcePath = '/orgs/{org_id}/import/server/{server_id}/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($server_id !== null) {
            $resourcePath = str_replace(
                '{' . 'server_id' . '}',
                ObjectSerializer::toPathValue($server_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getImportMigration
     *
     * Fetches single migration details
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ImportMigrationEntry
     */
    public function getImportMigration($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigration'][0])
    {
        list($response) = $this->getImportMigrationWithHttpInfo($org_id, $import_migration_id, $contentType);
        return $response;
    }

    /**
     * Operation getImportMigrationWithHttpInfo
     *
     * Fetches single migration details
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ImportMigrationEntry, HTTP status code, HTTP response headers (array of strings)
     */
    public function getImportMigrationWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigration'][0])
    {
        $request = $this->getImportMigrationRequest($org_id, $import_migration_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ImportMigrationEntry',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ImportMigrationEntry',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ImportMigrationEntry',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getImportMigrationAsync
     *
     * Fetches single migration details
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationAsync($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigration'][0])
    {
        return $this->getImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getImportMigrationAsyncWithHttpInfo
     *
     * Fetches single migration details
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationAsyncWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigration'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ImportMigrationEntry';
        $request = $this->getImportMigrationRequest($org_id, $import_migration_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getImportMigration'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getImportMigrationRequest($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigration'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getImportMigration'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling getImportMigration'
            );
        }


        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getImportMigrationData
     *
     * Get import migration information
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationData'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ImporterAnalyzedData
     */
    public function getImportMigrationData($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationData'][0])
    {
        list($response) = $this->getImportMigrationDataWithHttpInfo($org_id, $import_migration_id, $contentType);
        return $response;
    }

    /**
     * Operation getImportMigrationDataWithHttpInfo
     *
     * Get import migration information
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationData'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ImporterAnalyzedData, HTTP status code, HTTP response headers (array of strings)
     */
    public function getImportMigrationDataWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationData'][0])
    {
        $request = $this->getImportMigrationDataRequest($org_id, $import_migration_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ImporterAnalyzedData',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ImporterAnalyzedData',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ImporterAnalyzedData',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getImportMigrationDataAsync
     *
     * Get import migration information
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationData'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationDataAsync($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationData'][0])
    {
        return $this->getImportMigrationDataAsyncWithHttpInfo($org_id, $import_migration_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getImportMigrationDataAsyncWithHttpInfo
     *
     * Get import migration information
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationData'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationDataAsyncWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationData'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ImporterAnalyzedData';
        $request = $this->getImportMigrationDataRequest($org_id, $import_migration_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getImportMigrationData'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationData'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getImportMigrationDataRequest($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationData'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getImportMigrationData'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling getImportMigrationData'
            );
        }


        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}/analyze';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getImportMigrationLog
     *
     * Get the log for an import migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationLog'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ImportMigrationLogEntry[]
     */
    public function getImportMigrationLog($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationLog'][0])
    {
        list($response) = $this->getImportMigrationLogWithHttpInfo($org_id, $import_migration_id, $contentType);
        return $response;
    }

    /**
     * Operation getImportMigrationLogWithHttpInfo
     *
     * Get the log for an import migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationLog'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ImportMigrationLogEntry[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getImportMigrationLogWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationLog'][0])
    {
        $request = $this->getImportMigrationLogRequest($org_id, $import_migration_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ImportMigrationLogEntry[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ImportMigrationLogEntry[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ImportMigrationLogEntry[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getImportMigrationLogAsync
     *
     * Get the log for an import migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationLog'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationLogAsync($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationLog'][0])
    {
        return $this->getImportMigrationLogAsyncWithHttpInfo($org_id, $import_migration_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getImportMigrationLogAsyncWithHttpInfo
     *
     * Get the log for an import migration
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationLog'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationLogAsyncWithHttpInfo($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationLog'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ImportMigrationLogEntry[]';
        $request = $this->getImportMigrationLogRequest($org_id, $import_migration_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getImportMigrationLog'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_id The ID of the import migration being acted upon. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrationLog'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getImportMigrationLogRequest($org_id, $import_migration_id, string $contentType = self::contentTypes['getImportMigrationLog'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getImportMigrationLog'
            );
        }

        // verify the required parameter 'import_migration_id' is set
        if ($import_migration_id === null || (is_array($import_migration_id) && count($import_migration_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_id when calling getImportMigrationLog'
            );
        }


        $resourcePath = '/v2/orgs/{org_id}/import/{import_migration_id}/log';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_id !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_id' . '}',
                ObjectSerializer::toPathValue($import_migration_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getImportMigrations
     *
     * List all import migrations
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrations'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ImportMigrationFullListing
     */
    public function getImportMigrations($org_id, string $contentType = self::contentTypes['getImportMigrations'][0])
    {
        list($response) = $this->getImportMigrationsWithHttpInfo($org_id, $contentType);
        return $response;
    }

    /**
     * Operation getImportMigrationsWithHttpInfo
     *
     * List all import migrations
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrations'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ImportMigrationFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getImportMigrationsWithHttpInfo($org_id, string $contentType = self::contentTypes['getImportMigrations'][0])
    {
        $request = $this->getImportMigrationsRequest($org_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ImportMigrationFullListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ImportMigrationFullListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ImportMigrationFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getImportMigrationsAsync
     *
     * List all import migrations
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationsAsync($org_id, string $contentType = self::contentTypes['getImportMigrations'][0])
    {
        return $this->getImportMigrationsAsyncWithHttpInfo($org_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getImportMigrationsAsyncWithHttpInfo
     *
     * List all import migrations
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportMigrationsAsyncWithHttpInfo($org_id, string $contentType = self::contentTypes['getImportMigrations'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ImportMigrationFullListing';
        $request = $this->getImportMigrationsRequest($org_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getImportMigrations'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportMigrations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getImportMigrationsRequest($org_id, string $contentType = self::contentTypes['getImportMigrations'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getImportMigrations'
            );
        }


        $resourcePath = '/v2/orgs/{org_id}/import';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getImportServerDomainsCached
     *
     * Returns cached domains
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $search_domain Look for a specific domain in the result set. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerDomainsCached'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ImportServerDomainsListing
     */
    public function getImportServerDomainsCached($org_id, $server_id, $offset = null, $limit = null, $sort_order = null, $search_domain = null, $sort_by = null, string $contentType = self::contentTypes['getImportServerDomainsCached'][0])
    {
        list($response) = $this->getImportServerDomainsCachedWithHttpInfo($org_id, $server_id, $offset, $limit, $sort_order, $search_domain, $sort_by, $contentType);
        return $response;
    }

    /**
     * Operation getImportServerDomainsCachedWithHttpInfo
     *
     * Returns cached domains
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $search_domain Look for a specific domain in the result set. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerDomainsCached'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ImportServerDomainsListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getImportServerDomainsCachedWithHttpInfo($org_id, $server_id, $offset = null, $limit = null, $sort_order = null, $search_domain = null, $sort_by = null, string $contentType = self::contentTypes['getImportServerDomainsCached'][0])
    {
        $request = $this->getImportServerDomainsCachedRequest($org_id, $server_id, $offset, $limit, $sort_order, $search_domain, $sort_by, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ImportServerDomainsListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ImportServerDomainsListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ImportServerDomainsListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getImportServerDomainsCachedAsync
     *
     * Returns cached domains
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $search_domain Look for a specific domain in the result set. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerDomainsCached'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportServerDomainsCachedAsync($org_id, $server_id, $offset = null, $limit = null, $sort_order = null, $search_domain = null, $sort_by = null, string $contentType = self::contentTypes['getImportServerDomainsCached'][0])
    {
        return $this->getImportServerDomainsCachedAsyncWithHttpInfo($org_id, $server_id, $offset, $limit, $sort_order, $search_domain, $sort_by, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getImportServerDomainsCachedAsyncWithHttpInfo
     *
     * Returns cached domains
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $search_domain Look for a specific domain in the result set. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerDomainsCached'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportServerDomainsCachedAsyncWithHttpInfo($org_id, $server_id, $offset = null, $limit = null, $sort_order = null, $search_domain = null, $sort_by = null, string $contentType = self::contentTypes['getImportServerDomainsCached'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ImportServerDomainsListing';
        $request = $this->getImportServerDomainsCachedRequest($org_id, $server_id, $offset, $limit, $sort_order, $search_domain, $sort_by, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getImportServerDomainsCached'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  int|null $offset The offset from which to return items. (optional)
     * @param  int|null $limit The maximum number of items to return. (optional)
     * @param  string|null $sort_order The direction in which to sort. Possible values are &#39;asc&#39; and &#39;desc&#39;, defaulting to &#39;asc&#39;. (optional)
     * @param  string|null $search_domain Look for a specific domain in the result set. (optional)
     * @param  string|null $sort_by The field by which to sort. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerDomainsCached'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getImportServerDomainsCachedRequest($org_id, $server_id, $offset = null, $limit = null, $sort_order = null, $search_domain = null, $sort_by = null, string $contentType = self::contentTypes['getImportServerDomainsCached'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getImportServerDomainsCached'
            );
        }

        // verify the required parameter 'server_id' is set
        if ($server_id === null || (is_array($server_id) && count($server_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $server_id when calling getImportServerDomainsCached'
            );
        }







        $resourcePath = '/orgs/{org_id}/import/server/{server_id}/cached-domains';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $offset,
            'offset', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $limit,
            'limit', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order,
            'sortOrder', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search_domain,
            'searchDomain', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_by,
            'sortBy', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($server_id !== null) {
            $resourcePath = str_replace(
                '{' . 'server_id' . '}',
                ObjectSerializer::toPathValue($server_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getImportServerPullDomains
     *
     * Pull domains form the remote server.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerPullDomains'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ImportServerDomainsFullListing
     */
    public function getImportServerPullDomains($org_id, $server_id, string $contentType = self::contentTypes['getImportServerPullDomains'][0])
    {
        list($response) = $this->getImportServerPullDomainsWithHttpInfo($org_id, $server_id, $contentType);
        return $response;
    }

    /**
     * Operation getImportServerPullDomainsWithHttpInfo
     *
     * Pull domains form the remote server.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerPullDomains'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ImportServerDomainsFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getImportServerPullDomainsWithHttpInfo($org_id, $server_id, string $contentType = self::contentTypes['getImportServerPullDomains'][0])
    {
        $request = $this->getImportServerPullDomainsRequest($org_id, $server_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ImportServerDomainsFullListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ImportServerDomainsFullListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ImportServerDomainsFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getImportServerPullDomainsAsync
     *
     * Pull domains form the remote server.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerPullDomains'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportServerPullDomainsAsync($org_id, $server_id, string $contentType = self::contentTypes['getImportServerPullDomains'][0])
    {
        return $this->getImportServerPullDomainsAsyncWithHttpInfo($org_id, $server_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getImportServerPullDomainsAsyncWithHttpInfo
     *
     * Pull domains form the remote server.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerPullDomains'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportServerPullDomainsAsyncWithHttpInfo($org_id, $server_id, string $contentType = self::contentTypes['getImportServerPullDomains'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ImportServerDomainsFullListing';
        $request = $this->getImportServerPullDomainsRequest($org_id, $server_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getImportServerPullDomains'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerPullDomains'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getImportServerPullDomainsRequest($org_id, $server_id, string $contentType = self::contentTypes['getImportServerPullDomains'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getImportServerPullDomains'
            );
        }

        // verify the required parameter 'server_id' is set
        if ($server_id === null || (is_array($server_id) && count($server_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $server_id when calling getImportServerPullDomains'
            );
        }


        $resourcePath = '/orgs/{org_id}/import/server/{server_id}/pull-domains';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($server_id !== null) {
            $resourcePath = str_replace(
                '{' . 'server_id' . '}',
                ObjectSerializer::toPathValue($server_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getImportServerSettings
     *
     * Get settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ImportServerSettings
     */
    public function getImportServerSettings($org_id, $server_id, string $contentType = self::contentTypes['getImportServerSettings'][0])
    {
        list($response) = $this->getImportServerSettingsWithHttpInfo($org_id, $server_id, $contentType);
        return $response;
    }

    /**
     * Operation getImportServerSettingsWithHttpInfo
     *
     * Get settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ImportServerSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function getImportServerSettingsWithHttpInfo($org_id, $server_id, string $contentType = self::contentTypes['getImportServerSettings'][0])
    {
        $request = $this->getImportServerSettingsRequest($org_id, $server_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ImportServerSettings',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ImportServerSettings',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ImportServerSettings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getImportServerSettingsAsync
     *
     * Get settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportServerSettingsAsync($org_id, $server_id, string $contentType = self::contentTypes['getImportServerSettings'][0])
    {
        return $this->getImportServerSettingsAsyncWithHttpInfo($org_id, $server_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getImportServerSettingsAsyncWithHttpInfo
     *
     * Get settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImportServerSettingsAsyncWithHttpInfo($org_id, $server_id, string $contentType = self::contentTypes['getImportServerSettings'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ImportServerSettings';
        $request = $this->getImportServerSettingsRequest($org_id, $server_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getImportServerSettings'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getImportServerSettingsRequest($org_id, $server_id, string $contentType = self::contentTypes['getImportServerSettings'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getImportServerSettings'
            );
        }

        // verify the required parameter 'server_id' is set
        if ($server_id === null || (is_array($server_id) && count($server_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $server_id when calling getImportServerSettings'
            );
        }


        $resourcePath = '/orgs/{org_id}/import/server/{server_id}/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($server_id !== null) {
            $resourcePath = str_replace(
                '{' . 'server_id' . '}',
                ObjectSerializer::toPathValue($server_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listImportServerSettings
     *
     * List all server import settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listImportServerSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\ImportServerSettingsFullListing
     */
    public function listImportServerSettings($org_id, string $contentType = self::contentTypes['listImportServerSettings'][0])
    {
        list($response) = $this->listImportServerSettingsWithHttpInfo($org_id, $contentType);
        return $response;
    }

    /**
     * Operation listImportServerSettingsWithHttpInfo
     *
     * List all server import settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listImportServerSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\ImportServerSettingsFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function listImportServerSettingsWithHttpInfo($org_id, string $contentType = self::contentTypes['listImportServerSettings'][0])
    {
        $request = $this->listImportServerSettingsRequest($org_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ImportServerSettingsFullListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\ImportServerSettingsFullListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ImportServerSettingsFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation listImportServerSettingsAsync
     *
     * List all server import settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listImportServerSettingsAsync($org_id, string $contentType = self::contentTypes['listImportServerSettings'][0])
    {
        return $this->listImportServerSettingsAsyncWithHttpInfo($org_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listImportServerSettingsAsyncWithHttpInfo
     *
     * List all server import settings
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listImportServerSettingsAsyncWithHttpInfo($org_id, string $contentType = self::contentTypes['listImportServerSettings'][0])
    {
        $returnType = '\OpenAPI\Client\Model\ImportServerSettingsFullListing';
        $request = $this->listImportServerSettingsRequest($org_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listImportServerSettings'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listImportServerSettingsRequest($org_id, string $contentType = self::contentTypes['listImportServerSettings'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling listImportServerSettings'
            );
        }


        $resourcePath = '/orgs/{org_id}/import/server/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation scanImportMigrations
     *
     * Scan for manually uploaded cPanel backups.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['scanImportMigrations'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function scanImportMigrations(string $contentType = self::contentTypes['scanImportMigrations'][0])
    {
        list($response) = $this->scanImportMigrationsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation scanImportMigrationsWithHttpInfo
     *
     * Scan for manually uploaded cPanel backups.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['scanImportMigrations'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function scanImportMigrationsWithHttpInfo(string $contentType = self::contentTypes['scanImportMigrations'][0])
    {
        $request = $this->scanImportMigrationsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        'string[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation scanImportMigrationsAsync
     *
     * Scan for manually uploaded cPanel backups.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['scanImportMigrations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function scanImportMigrationsAsync(string $contentType = self::contentTypes['scanImportMigrations'][0])
    {
        return $this->scanImportMigrationsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation scanImportMigrationsAsyncWithHttpInfo
     *
     * Scan for manually uploaded cPanel backups.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['scanImportMigrations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function scanImportMigrationsAsyncWithHttpInfo(string $contentType = self::contentTypes['scanImportMigrations'][0])
    {
        $returnType = 'string[]';
        $request = $this->scanImportMigrationsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'scanImportMigrations'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['scanImportMigrations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function scanImportMigrationsRequest(string $contentType = self::contentTypes['scanImportMigrations'][0])
    {


        $resourcePath = '/v2/import/scan';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation transferCPanelUserAccount
     *
     * Transfer user account from remote cPanel server
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $user_id The ID of the remote cPanel user (required)
     * @param  \OpenAPI\Client\Model\TransferUserAccountReqBody|null $transfer_user_account_req_body transfer_user_account_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['transferCPanelUserAccount'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceUuid
     */
    public function transferCPanelUserAccount($org_id, $server_id, $user_id, $transfer_user_account_req_body = null, string $contentType = self::contentTypes['transferCPanelUserAccount'][0])
    {
        list($response) = $this->transferCPanelUserAccountWithHttpInfo($org_id, $server_id, $user_id, $transfer_user_account_req_body, $contentType);
        return $response;
    }

    /**
     * Operation transferCPanelUserAccountWithHttpInfo
     *
     * Transfer user account from remote cPanel server
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $user_id The ID of the remote cPanel user (required)
     * @param  \OpenAPI\Client\Model\TransferUserAccountReqBody|null $transfer_user_account_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['transferCPanelUserAccount'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceUuid, HTTP status code, HTTP response headers (array of strings)
     */
    public function transferCPanelUserAccountWithHttpInfo($org_id, $server_id, $user_id, $transfer_user_account_req_body = null, string $contentType = self::contentTypes['transferCPanelUserAccount'][0])
    {
        $request = $this->transferCPanelUserAccountRequest($org_id, $server_id, $user_id, $transfer_user_account_req_body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\NewResourceUuid',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation transferCPanelUserAccountAsync
     *
     * Transfer user account from remote cPanel server
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $user_id The ID of the remote cPanel user (required)
     * @param  \OpenAPI\Client\Model\TransferUserAccountReqBody|null $transfer_user_account_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['transferCPanelUserAccount'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function transferCPanelUserAccountAsync($org_id, $server_id, $user_id, $transfer_user_account_req_body = null, string $contentType = self::contentTypes['transferCPanelUserAccount'][0])
    {
        return $this->transferCPanelUserAccountAsyncWithHttpInfo($org_id, $server_id, $user_id, $transfer_user_account_req_body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation transferCPanelUserAccountAsyncWithHttpInfo
     *
     * Transfer user account from remote cPanel server
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $user_id The ID of the remote cPanel user (required)
     * @param  \OpenAPI\Client\Model\TransferUserAccountReqBody|null $transfer_user_account_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['transferCPanelUserAccount'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function transferCPanelUserAccountAsyncWithHttpInfo($org_id, $server_id, $user_id, $transfer_user_account_req_body = null, string $contentType = self::contentTypes['transferCPanelUserAccount'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
        $request = $this->transferCPanelUserAccountRequest($org_id, $server_id, $user_id, $transfer_user_account_req_body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'transferCPanelUserAccount'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  string $user_id The ID of the remote cPanel user (required)
     * @param  \OpenAPI\Client\Model\TransferUserAccountReqBody|null $transfer_user_account_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['transferCPanelUserAccount'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function transferCPanelUserAccountRequest($org_id, $server_id, $user_id, $transfer_user_account_req_body = null, string $contentType = self::contentTypes['transferCPanelUserAccount'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling transferCPanelUserAccount'
            );
        }

        // verify the required parameter 'server_id' is set
        if ($server_id === null || (is_array($server_id) && count($server_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $server_id when calling transferCPanelUserAccount'
            );
        }

        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling transferCPanelUserAccount'
            );
        }



        $resourcePath = '/orgs/{org_id}/import/server/{server_id}/account/{user_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($server_id !== null) {
            $resourcePath = str_replace(
                '{' . 'server_id' . '}',
                ObjectSerializer::toPathValue($server_id),
                $resourcePath
            );
        }
        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_id' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($transfer_user_account_req_body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($transfer_user_account_req_body));
            } else {
                $httpBody = $transfer_user_account_req_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation transferPleskDomain
     *
     * Transfer user account from remote cPanel server
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  \OpenAPI\Client\Model\TransferPleskDomainReqBody|null $transfer_plesk_domain_req_body transfer_plesk_domain_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['transferPleskDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceUuid
     */
    public function transferPleskDomain($org_id, $server_id, $transfer_plesk_domain_req_body = null, string $contentType = self::contentTypes['transferPleskDomain'][0])
    {
        list($response) = $this->transferPleskDomainWithHttpInfo($org_id, $server_id, $transfer_plesk_domain_req_body, $contentType);
        return $response;
    }

    /**
     * Operation transferPleskDomainWithHttpInfo
     *
     * Transfer user account from remote cPanel server
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  \OpenAPI\Client\Model\TransferPleskDomainReqBody|null $transfer_plesk_domain_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['transferPleskDomain'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceUuid, HTTP status code, HTTP response headers (array of strings)
     */
    public function transferPleskDomainWithHttpInfo($org_id, $server_id, $transfer_plesk_domain_req_body = null, string $contentType = self::contentTypes['transferPleskDomain'][0])
    {
        $request = $this->transferPleskDomainRequest($org_id, $server_id, $transfer_plesk_domain_req_body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\NewResourceUuid',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation transferPleskDomainAsync
     *
     * Transfer user account from remote cPanel server
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  \OpenAPI\Client\Model\TransferPleskDomainReqBody|null $transfer_plesk_domain_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['transferPleskDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function transferPleskDomainAsync($org_id, $server_id, $transfer_plesk_domain_req_body = null, string $contentType = self::contentTypes['transferPleskDomain'][0])
    {
        return $this->transferPleskDomainAsyncWithHttpInfo($org_id, $server_id, $transfer_plesk_domain_req_body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation transferPleskDomainAsyncWithHttpInfo
     *
     * Transfer user account from remote cPanel server
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  \OpenAPI\Client\Model\TransferPleskDomainReqBody|null $transfer_plesk_domain_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['transferPleskDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function transferPleskDomainAsyncWithHttpInfo($org_id, $server_id, $transfer_plesk_domain_req_body = null, string $contentType = self::contentTypes['transferPleskDomain'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
        $request = $this->transferPleskDomainRequest($org_id, $server_id, $transfer_plesk_domain_req_body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'transferPleskDomain'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  \OpenAPI\Client\Model\TransferPleskDomainReqBody|null $transfer_plesk_domain_req_body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['transferPleskDomain'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function transferPleskDomainRequest($org_id, $server_id, $transfer_plesk_domain_req_body = null, string $contentType = self::contentTypes['transferPleskDomain'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling transferPleskDomain'
            );
        }

        // verify the required parameter 'server_id' is set
        if ($server_id === null || (is_array($server_id) && count($server_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $server_id when calling transferPleskDomain'
            );
        }



        $resourcePath = '/orgs/{org_id}/import/plesk-server/{server_id}/domain';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($server_id !== null) {
            $resourcePath = str_replace(
                '{' . 'server_id' . '}',
                ObjectSerializer::toPathValue($server_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($transfer_plesk_domain_req_body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($transfer_plesk_domain_req_body));
            } else {
                $httpBody = $transfer_plesk_domain_req_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateImportServerSettings
     *
     * Update settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  \OpenAPI\Client\Model\UpdateImportServerSettings $update_import_server_settings update_import_server_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateImportServerSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateImportServerSettings($org_id, $server_id, $update_import_server_settings, string $contentType = self::contentTypes['updateImportServerSettings'][0])
    {
        $this->updateImportServerSettingsWithHttpInfo($org_id, $server_id, $update_import_server_settings, $contentType);
    }

    /**
     * Operation updateImportServerSettingsWithHttpInfo
     *
     * Update settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  \OpenAPI\Client\Model\UpdateImportServerSettings $update_import_server_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateImportServerSettings'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateImportServerSettingsWithHttpInfo($org_id, $server_id, $update_import_server_settings, string $contentType = self::contentTypes['updateImportServerSettings'][0])
    {
        $request = $this->updateImportServerSettingsRequest($org_id, $server_id, $update_import_server_settings, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateImportServerSettingsAsync
     *
     * Update settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  \OpenAPI\Client\Model\UpdateImportServerSettings $update_import_server_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateImportServerSettingsAsync($org_id, $server_id, $update_import_server_settings, string $contentType = self::contentTypes['updateImportServerSettings'][0])
    {
        return $this->updateImportServerSettingsAsyncWithHttpInfo($org_id, $server_id, $update_import_server_settings, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateImportServerSettingsAsyncWithHttpInfo
     *
     * Update settings for the server import
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  \OpenAPI\Client\Model\UpdateImportServerSettings $update_import_server_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateImportServerSettingsAsyncWithHttpInfo($org_id, $server_id, $update_import_server_settings, string $contentType = self::contentTypes['updateImportServerSettings'][0])
    {
        $returnType = '';
        $request = $this->updateImportServerSettingsRequest($org_id, $server_id, $update_import_server_settings, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateImportServerSettings'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $server_id The UUID of the server (required)
     * @param  \OpenAPI\Client\Model\UpdateImportServerSettings $update_import_server_settings (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateImportServerSettings'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateImportServerSettingsRequest($org_id, $server_id, $update_import_server_settings, string $contentType = self::contentTypes['updateImportServerSettings'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateImportServerSettings'
            );
        }

        // verify the required parameter 'server_id' is set
        if ($server_id === null || (is_array($server_id) && count($server_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $server_id when calling updateImportServerSettings'
            );
        }

        // verify the required parameter 'update_import_server_settings' is set
        if ($update_import_server_settings === null || (is_array($update_import_server_settings) && count($update_import_server_settings) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_import_server_settings when calling updateImportServerSettings'
            );
        }


        $resourcePath = '/orgs/{org_id}/import/server/{server_id}/settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($server_id !== null) {
            $resourcePath = str_replace(
                '{' . 'server_id' . '}',
                ObjectSerializer::toPathValue($server_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_import_server_settings)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_import_server_settings));
            } else {
                $httpBody = $update_import_server_settings;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadImportMigration
     *
     * Upload file for analyzing and processing.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_kind The type of migration file being uploaded. (required)
     * @param  \SplFileObject|null $backup backup (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceUuid
     */
    public function uploadImportMigration($org_id, $import_migration_kind, $backup = null, string $contentType = self::contentTypes['uploadImportMigration'][0])
    {
        list($response) = $this->uploadImportMigrationWithHttpInfo($org_id, $import_migration_kind, $backup, $contentType);
        return $response;
    }

    /**
     * Operation uploadImportMigrationWithHttpInfo
     *
     * Upload file for analyzing and processing.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_kind The type of migration file being uploaded. (required)
     * @param  \SplFileObject|null $backup (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImportMigration'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceUuid, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadImportMigrationWithHttpInfo($org_id, $import_migration_kind, $backup = null, string $contentType = self::contentTypes['uploadImportMigration'][0])
    {
        $request = $this->uploadImportMigrationRequest($org_id, $import_migration_kind, $backup, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\NewResourceUuid',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation uploadImportMigrationAsync
     *
     * Upload file for analyzing and processing.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_kind The type of migration file being uploaded. (required)
     * @param  \SplFileObject|null $backup (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadImportMigrationAsync($org_id, $import_migration_kind, $backup = null, string $contentType = self::contentTypes['uploadImportMigration'][0])
    {
        return $this->uploadImportMigrationAsyncWithHttpInfo($org_id, $import_migration_kind, $backup, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadImportMigrationAsyncWithHttpInfo
     *
     * Upload file for analyzing and processing.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_kind The type of migration file being uploaded. (required)
     * @param  \SplFileObject|null $backup (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadImportMigrationAsyncWithHttpInfo($org_id, $import_migration_kind, $backup = null, string $contentType = self::contentTypes['uploadImportMigration'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
        $request = $this->uploadImportMigrationRequest($org_id, $import_migration_kind, $backup, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadImportMigration'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $import_migration_kind The type of migration file being uploaded. (required)
     * @param  \SplFileObject|null $backup (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadImportMigration'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadImportMigrationRequest($org_id, $import_migration_kind, $backup = null, string $contentType = self::contentTypes['uploadImportMigration'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling uploadImportMigration'
            );
        }

        // verify the required parameter 'import_migration_kind' is set
        if ($import_migration_kind === null || (is_array($import_migration_kind) && count($import_migration_kind) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $import_migration_kind when calling uploadImportMigration'
            );
        }



        $resourcePath = '/v2/orgs/{org_id}/import/upload/{import_migration_kind}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($import_migration_kind !== null) {
            $resourcePath = str_replace(
                '{' . 'import_migration_kind' . '}',
                ObjectSerializer::toPathValue($import_migration_kind),
                $resourcePath
            );
        }

        // form params
        $formDataProcessor = new FormDataProcessor();

        $formData = $formDataProcessor->prepare([
            'backup' => $backup,
        ]);

        $formParams = $formDataProcessor->flatten($formData);
        $multipart = $formDataProcessor->has_file;

        $multipart = true;
        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
