<?php
/**
 * DnsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.7.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * DnsApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class DnsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createDefaultDnsRecord' => [
            'application/json',
        ],
        'createDnsThirdPartyProvider' => [
            'application/json',
        ],
        'createWebsiteDomainDnsZoneRecord' => [
            'application/json',
        ],
        'deleteDefaultDnsRecord' => [
            'application/json',
        ],
        'deleteDnsThirdPartyProvider' => [
            'application/json',
        ],
        'deleteWebsiteDomainDnsZoneRecord' => [
            'application/json',
        ],
        'disableDomainDnsSec' => [
            'application/json',
        ],
        'enableDomainDnsSec' => [
            'application/json',
        ],
        'getDnsThirdPartyProviders' => [
            'application/json',
        ],
        'getWebsiteDomainDnsZone' => [
            'application/json',
        ],
        'listDefaultDnsRecords' => [
            'application/json',
        ],
        'updateDefaultDnsRecord' => [
            'application/json',
        ],
        'updateWebsiteDomainDnsZone' => [
            'application/json',
        ],
        'updateWebsiteDomainDnsZoneRecord' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createDefaultDnsRecord
     *
     * Create a default DNS record
     *
     * @param  \OpenAPI\Client\Model\NewDefaultDnsRecord $new_default_dns_record new_default_dns_record (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function createDefaultDnsRecord($new_default_dns_record, string $contentType = self::contentTypes['createDefaultDnsRecord'][0])
    {
        list($response) = $this->createDefaultDnsRecordWithHttpInfo($new_default_dns_record, $contentType);
        return $response;
    }

    /**
     * Operation createDefaultDnsRecordWithHttpInfo
     *
     * Create a default DNS record
     *
     * @param  \OpenAPI\Client\Model\NewDefaultDnsRecord $new_default_dns_record (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDefaultDnsRecordWithHttpInfo($new_default_dns_record, string $contentType = self::contentTypes['createDefaultDnsRecord'][0])
    {
        $request = $this->createDefaultDnsRecordRequest($new_default_dns_record, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createDefaultDnsRecordAsync
     *
     * Create a default DNS record
     *
     * @param  \OpenAPI\Client\Model\NewDefaultDnsRecord $new_default_dns_record (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDefaultDnsRecordAsync($new_default_dns_record, string $contentType = self::contentTypes['createDefaultDnsRecord'][0])
    {
        return $this->createDefaultDnsRecordAsyncWithHttpInfo($new_default_dns_record, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createDefaultDnsRecordAsyncWithHttpInfo
     *
     * Create a default DNS record
     *
     * @param  \OpenAPI\Client\Model\NewDefaultDnsRecord $new_default_dns_record (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDefaultDnsRecordAsyncWithHttpInfo($new_default_dns_record, string $contentType = self::contentTypes['createDefaultDnsRecord'][0])
    {
        $returnType = 'string';
        $request = $this->createDefaultDnsRecordRequest($new_default_dns_record, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createDefaultDnsRecord'
     *
     * @param  \OpenAPI\Client\Model\NewDefaultDnsRecord $new_default_dns_record (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createDefaultDnsRecordRequest($new_default_dns_record, string $contentType = self::contentTypes['createDefaultDnsRecord'][0])
    {

        // verify the required parameter 'new_default_dns_record' is set
        if ($new_default_dns_record === null || (is_array($new_default_dns_record) && count($new_default_dns_record) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_default_dns_record when calling createDefaultDnsRecord'
            );
        }


        $resourcePath = '/v2/settings/dns/default-records';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_default_dns_record)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_default_dns_record));
            } else {
                $httpBody = $new_default_dns_record;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createDnsThirdPartyProvider
     *
     * Create new third party provider.
     *
     * @param  \OpenAPI\Client\Model\NewDnsThirdPartyProvider $new_dns_third_party_provider Url where the updates are sent and map of header names to their values. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDnsThirdPartyProvider'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createDnsThirdPartyProvider($new_dns_third_party_provider, string $contentType = self::contentTypes['createDnsThirdPartyProvider'][0])
    {
        $this->createDnsThirdPartyProviderWithHttpInfo($new_dns_third_party_provider, $contentType);
    }

    /**
     * Operation createDnsThirdPartyProviderWithHttpInfo
     *
     * Create new third party provider.
     *
     * @param  \OpenAPI\Client\Model\NewDnsThirdPartyProvider $new_dns_third_party_provider Url where the updates are sent and map of header names to their values. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDnsThirdPartyProvider'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDnsThirdPartyProviderWithHttpInfo($new_dns_third_party_provider, string $contentType = self::contentTypes['createDnsThirdPartyProvider'][0])
    {
        $request = $this->createDnsThirdPartyProviderRequest($new_dns_third_party_provider, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation createDnsThirdPartyProviderAsync
     *
     * Create new third party provider.
     *
     * @param  \OpenAPI\Client\Model\NewDnsThirdPartyProvider $new_dns_third_party_provider Url where the updates are sent and map of header names to their values. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDnsThirdPartyProvider'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDnsThirdPartyProviderAsync($new_dns_third_party_provider, string $contentType = self::contentTypes['createDnsThirdPartyProvider'][0])
    {
        return $this->createDnsThirdPartyProviderAsyncWithHttpInfo($new_dns_third_party_provider, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createDnsThirdPartyProviderAsyncWithHttpInfo
     *
     * Create new third party provider.
     *
     * @param  \OpenAPI\Client\Model\NewDnsThirdPartyProvider $new_dns_third_party_provider Url where the updates are sent and map of header names to their values. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDnsThirdPartyProvider'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDnsThirdPartyProviderAsyncWithHttpInfo($new_dns_third_party_provider, string $contentType = self::contentTypes['createDnsThirdPartyProvider'][0])
    {
        $returnType = '';
        $request = $this->createDnsThirdPartyProviderRequest($new_dns_third_party_provider, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createDnsThirdPartyProvider'
     *
     * @param  \OpenAPI\Client\Model\NewDnsThirdPartyProvider $new_dns_third_party_provider Url where the updates are sent and map of header names to their values. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createDnsThirdPartyProvider'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createDnsThirdPartyProviderRequest($new_dns_third_party_provider, string $contentType = self::contentTypes['createDnsThirdPartyProvider'][0])
    {

        // verify the required parameter 'new_dns_third_party_provider' is set
        if ($new_dns_third_party_provider === null || (is_array($new_dns_third_party_provider) && count($new_dns_third_party_provider) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_dns_third_party_provider when calling createDnsThirdPartyProvider'
            );
        }


        $resourcePath = '/dns/third-party-providers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_dns_third_party_provider)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_dns_third_party_provider));
            } else {
                $httpBody = $new_dns_third_party_provider;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createWebsiteDomainDnsZoneRecord
     *
     * Create a new dns record for website domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\NewDnsRecord $new_dns_record New dns record details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewResourceUuid
     */
    public function createWebsiteDomainDnsZoneRecord($org_id, $website_id, $domain_id, $new_dns_record, string $contentType = self::contentTypes['createWebsiteDomainDnsZoneRecord'][0])
    {
        list($response) = $this->createWebsiteDomainDnsZoneRecordWithHttpInfo($org_id, $website_id, $domain_id, $new_dns_record, $contentType);
        return $response;
    }

    /**
     * Operation createWebsiteDomainDnsZoneRecordWithHttpInfo
     *
     * Create a new dns record for website domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\NewDnsRecord $new_dns_record New dns record details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewResourceUuid, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWebsiteDomainDnsZoneRecordWithHttpInfo($org_id, $website_id, $domain_id, $new_dns_record, string $contentType = self::contentTypes['createWebsiteDomainDnsZoneRecord'][0])
    {
        $request = $this->createWebsiteDomainDnsZoneRecordRequest($org_id, $website_id, $domain_id, $new_dns_record, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\NewResourceUuid',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewResourceUuid',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createWebsiteDomainDnsZoneRecordAsync
     *
     * Create a new dns record for website domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\NewDnsRecord $new_dns_record New dns record details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteDomainDnsZoneRecordAsync($org_id, $website_id, $domain_id, $new_dns_record, string $contentType = self::contentTypes['createWebsiteDomainDnsZoneRecord'][0])
    {
        return $this->createWebsiteDomainDnsZoneRecordAsyncWithHttpInfo($org_id, $website_id, $domain_id, $new_dns_record, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createWebsiteDomainDnsZoneRecordAsyncWithHttpInfo
     *
     * Create a new dns record for website domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\NewDnsRecord $new_dns_record New dns record details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWebsiteDomainDnsZoneRecordAsyncWithHttpInfo($org_id, $website_id, $domain_id, $new_dns_record, string $contentType = self::contentTypes['createWebsiteDomainDnsZoneRecord'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewResourceUuid';
        $request = $this->createWebsiteDomainDnsZoneRecordRequest($org_id, $website_id, $domain_id, $new_dns_record, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createWebsiteDomainDnsZoneRecord'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\NewDnsRecord $new_dns_record New dns record details. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createWebsiteDomainDnsZoneRecordRequest($org_id, $website_id, $domain_id, $new_dns_record, string $contentType = self::contentTypes['createWebsiteDomainDnsZoneRecord'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling createWebsiteDomainDnsZoneRecord'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling createWebsiteDomainDnsZoneRecord'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling createWebsiteDomainDnsZoneRecord'
            );
        }

        // verify the required parameter 'new_dns_record' is set
        if ($new_dns_record === null || (is_array($new_dns_record) && count($new_dns_record) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $new_dns_record when calling createWebsiteDomainDnsZoneRecord'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}/dns-zone/records';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($new_dns_record)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($new_dns_record));
            } else {
                $httpBody = $new_dns_record;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteDefaultDnsRecord
     *
     * Delete a default DNS record
     *
     * @param  string $record_id record_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteDefaultDnsRecord($record_id, string $contentType = self::contentTypes['deleteDefaultDnsRecord'][0])
    {
        $this->deleteDefaultDnsRecordWithHttpInfo($record_id, $contentType);
    }

    /**
     * Operation deleteDefaultDnsRecordWithHttpInfo
     *
     * Delete a default DNS record
     *
     * @param  string $record_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDefaultDnsRecordWithHttpInfo($record_id, string $contentType = self::contentTypes['deleteDefaultDnsRecord'][0])
    {
        $request = $this->deleteDefaultDnsRecordRequest($record_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteDefaultDnsRecordAsync
     *
     * Delete a default DNS record
     *
     * @param  string $record_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteDefaultDnsRecordAsync($record_id, string $contentType = self::contentTypes['deleteDefaultDnsRecord'][0])
    {
        return $this->deleteDefaultDnsRecordAsyncWithHttpInfo($record_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteDefaultDnsRecordAsyncWithHttpInfo
     *
     * Delete a default DNS record
     *
     * @param  string $record_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteDefaultDnsRecordAsyncWithHttpInfo($record_id, string $contentType = self::contentTypes['deleteDefaultDnsRecord'][0])
    {
        $returnType = '';
        $request = $this->deleteDefaultDnsRecordRequest($record_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteDefaultDnsRecord'
     *
     * @param  string $record_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteDefaultDnsRecordRequest($record_id, string $contentType = self::contentTypes['deleteDefaultDnsRecord'][0])
    {

        // verify the required parameter 'record_id' is set
        if ($record_id === null || (is_array($record_id) && count($record_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $record_id when calling deleteDefaultDnsRecord'
            );
        }


        $resourcePath = '/v2/settings/dns/default-records/{record_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($record_id !== null) {
            $resourcePath = str_replace(
                '{' . 'record_id' . '}',
                ObjectSerializer::toPathValue($record_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteDnsThirdPartyProvider
     *
     * Deletes a third party dns provider.
     *
     * @param  int $provider_id The id of the third party provider which can be obtained by querying the GET /dns/third-party-providers endpoint. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDnsThirdPartyProvider'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteDnsThirdPartyProvider($provider_id, string $contentType = self::contentTypes['deleteDnsThirdPartyProvider'][0])
    {
        $this->deleteDnsThirdPartyProviderWithHttpInfo($provider_id, $contentType);
    }

    /**
     * Operation deleteDnsThirdPartyProviderWithHttpInfo
     *
     * Deletes a third party dns provider.
     *
     * @param  int $provider_id The id of the third party provider which can be obtained by querying the GET /dns/third-party-providers endpoint. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDnsThirdPartyProvider'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDnsThirdPartyProviderWithHttpInfo($provider_id, string $contentType = self::contentTypes['deleteDnsThirdPartyProvider'][0])
    {
        $request = $this->deleteDnsThirdPartyProviderRequest($provider_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteDnsThirdPartyProviderAsync
     *
     * Deletes a third party dns provider.
     *
     * @param  int $provider_id The id of the third party provider which can be obtained by querying the GET /dns/third-party-providers endpoint. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDnsThirdPartyProvider'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteDnsThirdPartyProviderAsync($provider_id, string $contentType = self::contentTypes['deleteDnsThirdPartyProvider'][0])
    {
        return $this->deleteDnsThirdPartyProviderAsyncWithHttpInfo($provider_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteDnsThirdPartyProviderAsyncWithHttpInfo
     *
     * Deletes a third party dns provider.
     *
     * @param  int $provider_id The id of the third party provider which can be obtained by querying the GET /dns/third-party-providers endpoint. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDnsThirdPartyProvider'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteDnsThirdPartyProviderAsyncWithHttpInfo($provider_id, string $contentType = self::contentTypes['deleteDnsThirdPartyProvider'][0])
    {
        $returnType = '';
        $request = $this->deleteDnsThirdPartyProviderRequest($provider_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteDnsThirdPartyProvider'
     *
     * @param  int $provider_id The id of the third party provider which can be obtained by querying the GET /dns/third-party-providers endpoint. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteDnsThirdPartyProvider'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteDnsThirdPartyProviderRequest($provider_id, string $contentType = self::contentTypes['deleteDnsThirdPartyProvider'][0])
    {

        // verify the required parameter 'provider_id' is set
        if ($provider_id === null || (is_array($provider_id) && count($provider_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $provider_id when calling deleteDnsThirdPartyProvider'
            );
        }


        $resourcePath = '/dns/third-party-providers/{provider_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($provider_id !== null) {
            $resourcePath = str_replace(
                '{' . 'provider_id' . '}',
                ObjectSerializer::toPathValue($provider_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteWebsiteDomainDnsZoneRecord
     *
     * Delete dns zone record
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $record_id The id of the record. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteWebsiteDomainDnsZoneRecord($org_id, $website_id, $domain_id, $record_id, string $contentType = self::contentTypes['deleteWebsiteDomainDnsZoneRecord'][0])
    {
        $this->deleteWebsiteDomainDnsZoneRecordWithHttpInfo($org_id, $website_id, $domain_id, $record_id, $contentType);
    }

    /**
     * Operation deleteWebsiteDomainDnsZoneRecordWithHttpInfo
     *
     * Delete dns zone record
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $record_id The id of the record. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWebsiteDomainDnsZoneRecordWithHttpInfo($org_id, $website_id, $domain_id, $record_id, string $contentType = self::contentTypes['deleteWebsiteDomainDnsZoneRecord'][0])
    {
        $request = $this->deleteWebsiteDomainDnsZoneRecordRequest($org_id, $website_id, $domain_id, $record_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteWebsiteDomainDnsZoneRecordAsync
     *
     * Delete dns zone record
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $record_id The id of the record. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteDomainDnsZoneRecordAsync($org_id, $website_id, $domain_id, $record_id, string $contentType = self::contentTypes['deleteWebsiteDomainDnsZoneRecord'][0])
    {
        return $this->deleteWebsiteDomainDnsZoneRecordAsyncWithHttpInfo($org_id, $website_id, $domain_id, $record_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteWebsiteDomainDnsZoneRecordAsyncWithHttpInfo
     *
     * Delete dns zone record
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $record_id The id of the record. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteDomainDnsZoneRecordAsyncWithHttpInfo($org_id, $website_id, $domain_id, $record_id, string $contentType = self::contentTypes['deleteWebsiteDomainDnsZoneRecord'][0])
    {
        $returnType = '';
        $request = $this->deleteWebsiteDomainDnsZoneRecordRequest($org_id, $website_id, $domain_id, $record_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteWebsiteDomainDnsZoneRecord'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $record_id The id of the record. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteWebsiteDomainDnsZoneRecordRequest($org_id, $website_id, $domain_id, $record_id, string $contentType = self::contentTypes['deleteWebsiteDomainDnsZoneRecord'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteWebsiteDomainDnsZoneRecord'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling deleteWebsiteDomainDnsZoneRecord'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling deleteWebsiteDomainDnsZoneRecord'
            );
        }

        // verify the required parameter 'record_id' is set
        if ($record_id === null || (is_array($record_id) && count($record_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $record_id when calling deleteWebsiteDomainDnsZoneRecord'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}/dns-zone/records/{record_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }
        // path params
        if ($record_id !== null) {
            $resourcePath = str_replace(
                '{' . 'record_id' . '}',
                ObjectSerializer::toPathValue($record_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation disableDomainDnsSec
     *
     * Disable DNSSEC on this domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disableDomainDnsSec'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function disableDomainDnsSec($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['disableDomainDnsSec'][0])
    {
        $this->disableDomainDnsSecWithHttpInfo($org_id, $website_id, $domain_id, $contentType);
    }

    /**
     * Operation disableDomainDnsSecWithHttpInfo
     *
     * Disable DNSSEC on this domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disableDomainDnsSec'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function disableDomainDnsSecWithHttpInfo($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['disableDomainDnsSec'][0])
    {
        $request = $this->disableDomainDnsSecRequest($org_id, $website_id, $domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation disableDomainDnsSecAsync
     *
     * Disable DNSSEC on this domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disableDomainDnsSec'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function disableDomainDnsSecAsync($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['disableDomainDnsSec'][0])
    {
        return $this->disableDomainDnsSecAsyncWithHttpInfo($org_id, $website_id, $domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation disableDomainDnsSecAsyncWithHttpInfo
     *
     * Disable DNSSEC on this domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disableDomainDnsSec'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function disableDomainDnsSecAsyncWithHttpInfo($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['disableDomainDnsSec'][0])
    {
        $returnType = '';
        $request = $this->disableDomainDnsSecRequest($org_id, $website_id, $domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'disableDomainDnsSec'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disableDomainDnsSec'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function disableDomainDnsSecRequest($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['disableDomainDnsSec'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling disableDomainDnsSec'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling disableDomainDnsSec'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling disableDomainDnsSec'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}/dns-zone/dnssec';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation enableDomainDnsSec
     *
     * Enable DNSSEC on this domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['enableDomainDnsSec'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function enableDomainDnsSec($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['enableDomainDnsSec'][0])
    {
        list($response) = $this->enableDomainDnsSecWithHttpInfo($org_id, $website_id, $domain_id, $contentType);
        return $response;
    }

    /**
     * Operation enableDomainDnsSecWithHttpInfo
     *
     * Enable DNSSEC on this domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['enableDomainDnsSec'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function enableDomainDnsSecWithHttpInfo($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['enableDomainDnsSec'][0])
    {
        $request = $this->enableDomainDnsSecRequest($org_id, $website_id, $domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation enableDomainDnsSecAsync
     *
     * Enable DNSSEC on this domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['enableDomainDnsSec'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function enableDomainDnsSecAsync($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['enableDomainDnsSec'][0])
    {
        return $this->enableDomainDnsSecAsyncWithHttpInfo($org_id, $website_id, $domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation enableDomainDnsSecAsyncWithHttpInfo
     *
     * Enable DNSSEC on this domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['enableDomainDnsSec'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function enableDomainDnsSecAsyncWithHttpInfo($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['enableDomainDnsSec'][0])
    {
        $returnType = 'string';
        $request = $this->enableDomainDnsSecRequest($org_id, $website_id, $domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'enableDomainDnsSec'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['enableDomainDnsSec'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function enableDomainDnsSecRequest($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['enableDomainDnsSec'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling enableDomainDnsSec'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling enableDomainDnsSec'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling enableDomainDnsSec'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}/dns-zone/dnssec';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDnsThirdPartyProviders
     *
     * Lists all third party providers.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDnsThirdPartyProviders'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DnsThirdPartyProvider[]
     */
    public function getDnsThirdPartyProviders(string $contentType = self::contentTypes['getDnsThirdPartyProviders'][0])
    {
        list($response) = $this->getDnsThirdPartyProvidersWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getDnsThirdPartyProvidersWithHttpInfo
     *
     * Lists all third party providers.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDnsThirdPartyProviders'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DnsThirdPartyProvider[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getDnsThirdPartyProvidersWithHttpInfo(string $contentType = self::contentTypes['getDnsThirdPartyProviders'][0])
    {
        $request = $this->getDnsThirdPartyProvidersRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\DnsThirdPartyProvider[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\DnsThirdPartyProvider[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DnsThirdPartyProvider[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getDnsThirdPartyProvidersAsync
     *
     * Lists all third party providers.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDnsThirdPartyProviders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDnsThirdPartyProvidersAsync(string $contentType = self::contentTypes['getDnsThirdPartyProviders'][0])
    {
        return $this->getDnsThirdPartyProvidersAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getDnsThirdPartyProvidersAsyncWithHttpInfo
     *
     * Lists all third party providers.
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDnsThirdPartyProviders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDnsThirdPartyProvidersAsyncWithHttpInfo(string $contentType = self::contentTypes['getDnsThirdPartyProviders'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DnsThirdPartyProvider[]';
        $request = $this->getDnsThirdPartyProvidersRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDnsThirdPartyProviders'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getDnsThirdPartyProviders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getDnsThirdPartyProvidersRequest(string $contentType = self::contentTypes['getDnsThirdPartyProviders'][0])
    {


        $resourcePath = '/dns/third-party-providers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWebsiteDomainDnsZone
     *
     * Get a dns zone for given domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainDnsZone'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DnsZone
     */
    public function getWebsiteDomainDnsZone($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainDnsZone'][0])
    {
        list($response) = $this->getWebsiteDomainDnsZoneWithHttpInfo($org_id, $website_id, $domain_id, $contentType);
        return $response;
    }

    /**
     * Operation getWebsiteDomainDnsZoneWithHttpInfo
     *
     * Get a dns zone for given domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainDnsZone'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DnsZone, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWebsiteDomainDnsZoneWithHttpInfo($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainDnsZone'][0])
    {
        $request = $this->getWebsiteDomainDnsZoneRequest($org_id, $website_id, $domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\DnsZone',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\DnsZone',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DnsZone',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWebsiteDomainDnsZoneAsync
     *
     * Get a dns zone for given domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainDnsZone'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteDomainDnsZoneAsync($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainDnsZone'][0])
    {
        return $this->getWebsiteDomainDnsZoneAsyncWithHttpInfo($org_id, $website_id, $domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWebsiteDomainDnsZoneAsyncWithHttpInfo
     *
     * Get a dns zone for given domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainDnsZone'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteDomainDnsZoneAsyncWithHttpInfo($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainDnsZone'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DnsZone';
        $request = $this->getWebsiteDomainDnsZoneRequest($org_id, $website_id, $domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWebsiteDomainDnsZone'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainDnsZone'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWebsiteDomainDnsZoneRequest($org_id, $website_id, $domain_id, string $contentType = self::contentTypes['getWebsiteDomainDnsZone'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWebsiteDomainDnsZone'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWebsiteDomainDnsZone'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling getWebsiteDomainDnsZone'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}/dns-zone';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listDefaultDnsRecords
     *
     * List default DNS records
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listDefaultDnsRecords'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DefaultDnsRecord[]
     */
    public function listDefaultDnsRecords(string $contentType = self::contentTypes['listDefaultDnsRecords'][0])
    {
        list($response) = $this->listDefaultDnsRecordsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation listDefaultDnsRecordsWithHttpInfo
     *
     * List default DNS records
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listDefaultDnsRecords'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DefaultDnsRecord[], HTTP status code, HTTP response headers (array of strings)
     */
    public function listDefaultDnsRecordsWithHttpInfo(string $contentType = self::contentTypes['listDefaultDnsRecords'][0])
    {
        $request = $this->listDefaultDnsRecordsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\DefaultDnsRecord[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\DefaultDnsRecord[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DefaultDnsRecord[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation listDefaultDnsRecordsAsync
     *
     * List default DNS records
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listDefaultDnsRecords'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listDefaultDnsRecordsAsync(string $contentType = self::contentTypes['listDefaultDnsRecords'][0])
    {
        return $this->listDefaultDnsRecordsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listDefaultDnsRecordsAsyncWithHttpInfo
     *
     * List default DNS records
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listDefaultDnsRecords'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listDefaultDnsRecordsAsyncWithHttpInfo(string $contentType = self::contentTypes['listDefaultDnsRecords'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DefaultDnsRecord[]';
        $request = $this->listDefaultDnsRecordsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listDefaultDnsRecords'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listDefaultDnsRecords'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listDefaultDnsRecordsRequest(string $contentType = self::contentTypes['listDefaultDnsRecords'][0])
    {


        $resourcePath = '/v2/settings/dns/default-records';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateDefaultDnsRecord
     *
     * Update a default DNS record
     *
     * @param  string $record_id record_id (required)
     * @param  \OpenAPI\Client\Model\UpdateDefaultDnsRecord $update_default_dns_record update_default_dns_record (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateDefaultDnsRecord($record_id, $update_default_dns_record, string $contentType = self::contentTypes['updateDefaultDnsRecord'][0])
    {
        $this->updateDefaultDnsRecordWithHttpInfo($record_id, $update_default_dns_record, $contentType);
    }

    /**
     * Operation updateDefaultDnsRecordWithHttpInfo
     *
     * Update a default DNS record
     *
     * @param  string $record_id (required)
     * @param  \OpenAPI\Client\Model\UpdateDefaultDnsRecord $update_default_dns_record (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDefaultDnsRecordWithHttpInfo($record_id, $update_default_dns_record, string $contentType = self::contentTypes['updateDefaultDnsRecord'][0])
    {
        $request = $this->updateDefaultDnsRecordRequest($record_id, $update_default_dns_record, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateDefaultDnsRecordAsync
     *
     * Update a default DNS record
     *
     * @param  string $record_id (required)
     * @param  \OpenAPI\Client\Model\UpdateDefaultDnsRecord $update_default_dns_record (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateDefaultDnsRecordAsync($record_id, $update_default_dns_record, string $contentType = self::contentTypes['updateDefaultDnsRecord'][0])
    {
        return $this->updateDefaultDnsRecordAsyncWithHttpInfo($record_id, $update_default_dns_record, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateDefaultDnsRecordAsyncWithHttpInfo
     *
     * Update a default DNS record
     *
     * @param  string $record_id (required)
     * @param  \OpenAPI\Client\Model\UpdateDefaultDnsRecord $update_default_dns_record (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateDefaultDnsRecordAsyncWithHttpInfo($record_id, $update_default_dns_record, string $contentType = self::contentTypes['updateDefaultDnsRecord'][0])
    {
        $returnType = '';
        $request = $this->updateDefaultDnsRecordRequest($record_id, $update_default_dns_record, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateDefaultDnsRecord'
     *
     * @param  string $record_id (required)
     * @param  \OpenAPI\Client\Model\UpdateDefaultDnsRecord $update_default_dns_record (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateDefaultDnsRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateDefaultDnsRecordRequest($record_id, $update_default_dns_record, string $contentType = self::contentTypes['updateDefaultDnsRecord'][0])
    {

        // verify the required parameter 'record_id' is set
        if ($record_id === null || (is_array($record_id) && count($record_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $record_id when calling updateDefaultDnsRecord'
            );
        }

        // verify the required parameter 'update_default_dns_record' is set
        if ($update_default_dns_record === null || (is_array($update_default_dns_record) && count($update_default_dns_record) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_default_dns_record when calling updateDefaultDnsRecord'
            );
        }


        $resourcePath = '/v2/settings/dns/default-records/{record_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($record_id !== null) {
            $resourcePath = str_replace(
                '{' . 'record_id' . '}',
                ObjectSerializer::toPathValue($record_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_default_dns_record)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_default_dns_record));
            } else {
                $httpBody = $update_default_dns_record;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateWebsiteDomainDnsZone
     *
     * Updates a dns zone SOA for website domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\UpdateDnsZone $update_dns_zone Fields to update. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainDnsZone'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateWebsiteDomainDnsZone($org_id, $website_id, $domain_id, $update_dns_zone, string $contentType = self::contentTypes['updateWebsiteDomainDnsZone'][0])
    {
        $this->updateWebsiteDomainDnsZoneWithHttpInfo($org_id, $website_id, $domain_id, $update_dns_zone, $contentType);
    }

    /**
     * Operation updateWebsiteDomainDnsZoneWithHttpInfo
     *
     * Updates a dns zone SOA for website domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\UpdateDnsZone $update_dns_zone Fields to update. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainDnsZone'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWebsiteDomainDnsZoneWithHttpInfo($org_id, $website_id, $domain_id, $update_dns_zone, string $contentType = self::contentTypes['updateWebsiteDomainDnsZone'][0])
    {
        $request = $this->updateWebsiteDomainDnsZoneRequest($org_id, $website_id, $domain_id, $update_dns_zone, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateWebsiteDomainDnsZoneAsync
     *
     * Updates a dns zone SOA for website domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\UpdateDnsZone $update_dns_zone Fields to update. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainDnsZone'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWebsiteDomainDnsZoneAsync($org_id, $website_id, $domain_id, $update_dns_zone, string $contentType = self::contentTypes['updateWebsiteDomainDnsZone'][0])
    {
        return $this->updateWebsiteDomainDnsZoneAsyncWithHttpInfo($org_id, $website_id, $domain_id, $update_dns_zone, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateWebsiteDomainDnsZoneAsyncWithHttpInfo
     *
     * Updates a dns zone SOA for website domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\UpdateDnsZone $update_dns_zone Fields to update. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainDnsZone'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWebsiteDomainDnsZoneAsyncWithHttpInfo($org_id, $website_id, $domain_id, $update_dns_zone, string $contentType = self::contentTypes['updateWebsiteDomainDnsZone'][0])
    {
        $returnType = '';
        $request = $this->updateWebsiteDomainDnsZoneRequest($org_id, $website_id, $domain_id, $update_dns_zone, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateWebsiteDomainDnsZone'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\UpdateDnsZone $update_dns_zone Fields to update. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainDnsZone'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateWebsiteDomainDnsZoneRequest($org_id, $website_id, $domain_id, $update_dns_zone, string $contentType = self::contentTypes['updateWebsiteDomainDnsZone'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateWebsiteDomainDnsZone'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling updateWebsiteDomainDnsZone'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling updateWebsiteDomainDnsZone'
            );
        }

        // verify the required parameter 'update_dns_zone' is set
        if ($update_dns_zone === null || (is_array($update_dns_zone) && count($update_dns_zone) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_dns_zone when calling updateWebsiteDomainDnsZone'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}/dns-zone';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_dns_zone)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_dns_zone));
            } else {
                $httpBody = $update_dns_zone;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateWebsiteDomainDnsZoneRecord
     *
     * Updates a dns record for given domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $record_id The id of the record. (required)
     * @param  \OpenAPI\Client\Model\UpdateDnsRecord $update_dns_record Fields to update. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateWebsiteDomainDnsZoneRecord($org_id, $website_id, $domain_id, $record_id, $update_dns_record, string $contentType = self::contentTypes['updateWebsiteDomainDnsZoneRecord'][0])
    {
        $this->updateWebsiteDomainDnsZoneRecordWithHttpInfo($org_id, $website_id, $domain_id, $record_id, $update_dns_record, $contentType);
    }

    /**
     * Operation updateWebsiteDomainDnsZoneRecordWithHttpInfo
     *
     * Updates a dns record for given domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $record_id The id of the record. (required)
     * @param  \OpenAPI\Client\Model\UpdateDnsRecord $update_dns_record Fields to update. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWebsiteDomainDnsZoneRecordWithHttpInfo($org_id, $website_id, $domain_id, $record_id, $update_dns_record, string $contentType = self::contentTypes['updateWebsiteDomainDnsZoneRecord'][0])
    {
        $request = $this->updateWebsiteDomainDnsZoneRecordRequest($org_id, $website_id, $domain_id, $record_id, $update_dns_record, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateWebsiteDomainDnsZoneRecordAsync
     *
     * Updates a dns record for given domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $record_id The id of the record. (required)
     * @param  \OpenAPI\Client\Model\UpdateDnsRecord $update_dns_record Fields to update. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWebsiteDomainDnsZoneRecordAsync($org_id, $website_id, $domain_id, $record_id, $update_dns_record, string $contentType = self::contentTypes['updateWebsiteDomainDnsZoneRecord'][0])
    {
        return $this->updateWebsiteDomainDnsZoneRecordAsyncWithHttpInfo($org_id, $website_id, $domain_id, $record_id, $update_dns_record, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateWebsiteDomainDnsZoneRecordAsyncWithHttpInfo
     *
     * Updates a dns record for given domain
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $record_id The id of the record. (required)
     * @param  \OpenAPI\Client\Model\UpdateDnsRecord $update_dns_record Fields to update. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWebsiteDomainDnsZoneRecordAsyncWithHttpInfo($org_id, $website_id, $domain_id, $record_id, $update_dns_record, string $contentType = self::contentTypes['updateWebsiteDomainDnsZoneRecord'][0])
    {
        $returnType = '';
        $request = $this->updateWebsiteDomainDnsZoneRecordRequest($org_id, $website_id, $domain_id, $record_id, $update_dns_record, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateWebsiteDomainDnsZoneRecord'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $record_id The id of the record. (required)
     * @param  \OpenAPI\Client\Model\UpdateDnsRecord $update_dns_record Fields to update. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWebsiteDomainDnsZoneRecord'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateWebsiteDomainDnsZoneRecordRequest($org_id, $website_id, $domain_id, $record_id, $update_dns_record, string $contentType = self::contentTypes['updateWebsiteDomainDnsZoneRecord'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling updateWebsiteDomainDnsZoneRecord'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling updateWebsiteDomainDnsZoneRecord'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling updateWebsiteDomainDnsZoneRecord'
            );
        }

        // verify the required parameter 'record_id' is set
        if ($record_id === null || (is_array($record_id) && count($record_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $record_id when calling updateWebsiteDomainDnsZoneRecord'
            );
        }

        // verify the required parameter 'update_dns_record' is set
        if ($update_dns_record === null || (is_array($update_dns_record) && count($update_dns_record) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_dns_record when calling updateWebsiteDomainDnsZoneRecord'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/domains/{domain_id}/dns-zone/records/{record_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }
        // path params
        if ($record_id !== null) {
            $resourcePath = str_replace(
                '{' . 'record_id' . '}',
                ObjectSerializer::toPathValue($record_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_dns_record)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_dns_record));
            } else {
                $httpBody = $update_dns_record;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
