<?php
/**
 * State Total Income Report
 *
 * @category Report
 * @package  ClientExec
 * @author   Juan Bolivar <juan@clientexec.com>
 * @license  ClientExec License
 * @version  1.0
 * @link     http://www.clientexec.com
 */

require_once 'modules/admin/models/Package.php';
require_once 'modules/clients/models/UserPackage.php';
require_once 'modules/billing/models/Currency.php';
require_once 'modules/clients/models/User.php';
require_once 'modules/billing/models/Invoice.php';

/**
 * State_Total_Income Report Class
 *
 * @category Report
 * @package  ClientExec
 * @author   Juan Bolivar <juan@clientexec.com>
 * @license  ClientExec License
 * @version  1.0
 * @link     http://www.clientexec.com
 */
class State_Total_Income extends Report
{
    private $lang;

    protected $featureSet = 'billing';

    function __construct($user = null, $customer = null)
    {
        $this->lang = lang('State Total Income');
        parent::__construct($user, $customer);
    }

    /**
     * Report Process Method
     *
     * @return null - direct output
     */
    function process()
    {
        @set_time_limit(0);

        // Set the report information
        $this->SetDescription($this->user->lang('Displays the total income between 2 dates broken by state of the clients of the selected country.'));

        // Load the country information
        $countries = new Countries($this->user);
        $countryCode = ((isset($_REQUEST['countrycode']))? $_REQUEST['countrycode'] : $this->settings->get('Default Country'));
        $countryName = $countries->validCountryCode($countryCode, false, 'name');

        if (isset($_REQUEST['startdate'])) {
            $startDateArray = explode('/', $_REQUEST['startdate']);

            if ($this->settings->get('Date Format') == 'm/d/Y') {
                $tempStartDate = date("Y-m-d", mktime(0, 0, 0, $startDateArray[0], $startDateArray[1], $startDateArray[2]));
            } else {
                $tempStartDate = date("Y-m-d", mktime(0, 0, 0, $startDateArray[1], $startDateArray[0], $startDateArray[2]));
            }
        } else {
            $tempStartDate = date("Y-m-d", mktime(0, 0, 0, date("m"), 1, date("Y")-1));
        }

        if (isset($_REQUEST['enddate'])) {
            $endDateArray = explode('/', $_REQUEST['enddate']);

            if ($this->settings->get('Date Format') == 'm/d/Y') {
                $tempEndDate = date("Y-m-d", mktime(0, 0, 0, $endDateArray[0], $endDateArray[1], $endDateArray[2]));
            } else {
                $tempEndDate = date("Y-m-d", mktime(0, 0, 0, $endDateArray[1], $endDateArray[0], $endDateArray[2]));
            }
        } else {
            $tempEndDate = date("Y-m-d");
        }

        // Load the currency information
        $currency = new Currency($this->user);
        $currencyCode = ((isset($_REQUEST['currencycode']))? $_REQUEST['currencycode'] : $this->settings->get('Default Currency'));
        $currencyName = $currency->getName($currencyCode);

        //Get id of the country custom field
        $countryCustomFieldIdSQL = "SELECT `id` "
            ."FROM `customuserfields` "
            ."WHERE `type` = ? ";
        $countryCustomFieldIdResult = $this->db->query($countryCustomFieldIdSQL, typeCOUNTRY);
        list($countryCustomFieldId) = $countryCustomFieldIdResult->fetch();

        //Get all countries with paid invoices
        $countriesSQL = "SELECT DISTINCT c.`name`, c.`iso` "
            ."FROM `country` c "
            ."INNER JOIN `user_customuserfields` ucuf ON ucuf.`value` = c.`iso` AND ucuf.`customid` = ? "
            ."INNER JOIN `invoice` i ON i.`customerid` = ucuf.`userid` AND i.`status` = ? "
            ."ORDER BY c.`name` ASC ";
        $countriesResult = $this->db->query($countriesSQL, $countryCustomFieldId, INVOICE_STATUS_PAID);

        //Get all currencies when were paid invoices from clients of the selected country
        $currenciesSQL = "SELECT DISTINCT c.`abrv`, c.`name` "
            ."FROM `invoice` i "
            ."INNER JOIN `users` u ON u.`id` = i.`customerid` "
            ."INNER JOIN `user_customuserfields` ucuf ON ucuf.`userid` = u.`id` "
            ."INNER JOIN `currency` c ON c.`abrv` = i.`currency` "
            ."WHERE i.`status` = ? "
            ."AND ucuf.`customid` = ? "
            ."AND ucuf.`value` = ? "
            ."ORDER BY c.`name` ASC ";
        $currenciesResult = $this->db->query($currenciesSQL, INVOICE_STATUS_PAID, $countryCustomFieldId, $countryCode);

        //Get id of the state custom field
        $stateCustomFieldIdSQL = "SELECT `id` "
            ."FROM `customuserfields` "
            ."WHERE `type` = ? ";
        $stateCustomFieldIdResult = $this->db->query($stateCustomFieldIdSQL, typeSTATE);
        list($stateCustomFieldId) = $stateCustomFieldIdResult->fetch();

        //Get all paid invoices amount from clients of the selected country paid the selected date range with the selected currency
        $reportSQL = "SELECT ucuf2.`value`, SUM(i.`amount`) AS `totalAmount`, SUM(i.`amount` - i.`subtotal`) AS `totalTax`, COUNT(*) AS totalNumber "
            ."FROM `invoice` i "
            ."INNER JOIN `users` u ON u.`id` = i.`customerid` "
            ."INNER JOIN `user_customuserfields` ucuf ON ucuf.`userid` = u.`id` "
            ."INNER JOIN `currency` c ON c.`abrv` = i.`currency` "
            ."LEFT JOIN `user_customuserfields` ucuf2 ON ucuf2.`userid` = u.`id` "
            ."WHERE i.`status` = ? "
            ."AND ucuf.`customid` = ? "
            ."AND ucuf.`value` = ? "
            ."AND ucuf2.`customid` = ? "
            ."AND i.`datepaid` >= '$tempStartDate' "
            ."AND i.`datepaid` <= '$tempEndDate 23:59:59' "
            ."AND i.`currency` = ? "
            ."GROUP BY ucuf2.`value` "
            ."ORDER BY `totalAmount` DESC ";
        $reportResult = $this->db->query($reportSQL, INVOICE_STATUS_PAID, $countryCustomFieldId, $countryCode, $stateCustomFieldId, $currencyCode);

        $subGroup = array();
        $totalAmount = 0;
        $totalTax = 0;
        $totalInvoices = 0;

        while (list($stateCode, $amount, $tax, $invoices) = $reportResult->fetch()) {
            $totalAmount += $amount;
            $totalTax += $tax;
            $totalInvoices += $invoices;

            $states = new States($this);
            $stateProvince = $states->validStateCode($countryCode, $stateCode, 'iso', false, 'name');
            $formattedAmount = $currency->format($currencyCode, $amount, true, false);
            $formattedTax = $currency->format($currencyCode, $tax, true, false);

            $subGroup[] = array(
                (isset($stateProvince))? $stateProvince : '---',
                $formattedAmount,
                $formattedTax,
                $invoices
            );
        }

        $subGroup[] = array('', '', '', '');
        $formattedTotalAmount = $currency->format($currencyCode, $totalAmount, true, false);
        $formattedTotalTax = $currency->format($currencyCode, $totalTax, true, false);
        $subGroup[] = array('<b>'.$this->user->lang('Totals').'</b>', '<b>'.$formattedTotalAmount.'</b>', '<b>'.$formattedTotalTax.'</b>', '<b>'.$totalInvoices.'</b>');

        $labels = array(
            $this->user->lang('State/Province'),
            $this->user->lang('Total Paid Amount'),
            $this->user->lang('Total Paid Tax'),
            $this->user->lang('Number of Paid Invoices')
        );

        if (isset($_REQUEST['download']) && $_REQUEST['download'] == 1) {
            $this->download($labels, $subGroup, $countryName.' '.'total income from '.$tempStartDate.' to '.$tempEndDate.' for '.$currencyCode.'.csv');
        }

        $filter = '<form id="report" method="GET">'
            .'    <div style="text-align:center">'
            .'        '.$this->user->lang('Country').': '
            .'        <select name="countrycode" id="countrycode" value="'.CE_Lib::viewEscape($countryCode).'" > ';

        $isSelectedCountryInTheList = false;
        while (list($singleCountryName, $singleCountryISO) = $countriesResult->fetch()) {
            if (!$isSelectedCountryInTheList && $countryName < $singleCountryName) {
                $filter .= '<option value="'.$countryCode.'" selected>'.$countryName.'</option>';
                $isSelectedCountryInTheList = true;
            } elseif ($countryCode == $singleCountryISO) {
                $isSelectedCountryInTheList = true;
            }
            $filter .= '<option value="'.$singleCountryISO.'" '.(($countryCode == $singleCountryISO)? 'selected' : '').'>'.$singleCountryName.'</option>';
        }
        if (!$isSelectedCountryInTheList) {
            $filter .= '<option value="'.$countryCode.'" selected>'.$countryName.'</option>';
            $isSelectedCountryInTheList = true;
        }

        $filter .= '</select>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';

        $filter .= '        '.$this->user->lang('Date Paid').': '
            .'        <input class="datepicker" type="text" name="startdate" id="startdate" value=\''.CE_Lib::db_to_form($tempStartDate, $this->settings->get('Date Format'), "/").'\' />'
            .' - '
            .'<input class="datepicker" type="text" name="enddate" id="enddate" value=\''.CE_Lib::db_to_form($tempEndDate, $this->settings->get('Date Format'), "/").'\' />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';

        $filter .= '        '.$this->user->lang('Currency').': '
            .'        <select name="currencycode" id="currencycode" value="'.CE_Lib::viewEscape($currencyCode).'" > ';

        $isSelectedCurrencyInTheList = false;
        while (list($singleCurrencyCode, $singleCurrencyName) = $currenciesResult->fetch()) {
            if (!$isSelectedCurrencyInTheList && $currencyName < $singleCurrencyName) {
                $filter .= '<option value="'.$currencyCode.'" selected>'.$currencyName.'</option>';
                $isSelectedCurrencyInTheList = true;
            } elseif ($currencyCode == $singleCurrencyCode) {
                $isSelectedCurrencyInTheList = true;
            }
            $filter .= '<option value="'.$singleCurrencyCode.'" '.(($currencyCode == $singleCurrencyCode)? 'selected' : '').'>'.$singleCurrencyName.'</option>';
        }
        if (!$isSelectedCurrencyInTheList) {
            $filter .= '<option value="'.$currencyCode.'" selected>'.$currencyName.'</option>';
            $isSelectedCurrencyInTheList = true;
        }

        $filter .= '</select>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';

        $filter .= '        <input type=button name=search class="btn" value=\''.$this->user->lang('Search').'\' onclick="ChangeTable(document.getElementById(\'countrycode\').value, document.getElementById(\'startdate\').value, document.getElementById(\'enddate\').value, document.getElementById(\'currencycode\').value, 0);">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';

        $filter .= '        <button class="btn" type="button" data-loading-text="Loading..." onclick="ChangeTable(document.getElementById(\'countrycode\').value, document.getElementById(\'startdate\').value, document.getElementById(\'enddate\').value, document.getElementById(\'currencycode\').value, 1);">'.$this->user->lang("Download .csv").'</button>';

        $filter .= '    </div>'
            .'</form>'
            .'</br>'
            .'<script type="text/javascript">'
            .'    function ChangeTable(countrycode, startdate, enddate, currencycode, download){'
            .'        location.href="index.php?fuse=reports&view=viewreport&controller=index&report=State+Total+Income&type=Income&countrycode="+countrycode+"&startdate="+encodeURIComponent(startdate)+"&enddate="+encodeURIComponent(enddate)+"&currencycode="+currencycode+"&download="+download;'
            .'    }'
            .'</script>';
        echo $filter;

        $this->reportData[] = array(
            "group" => $subGroup,
            "groupname" => "",
            "label" => $labels
        );
    }
}