# Drop old table
DROP TABLE `registrars`;

# Add new table
CREATE TABLE IF NOT EXISTS `tld_extra_attributes` (
  `tld` varchar(10) NOT NULL,
  `extra_attributes` text NOT NULL,
  PRIMARY KEY (`tld`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Remove old data
DELETE FROM `tld_extra_attributes` WHERE `tld` IN ('us', 'ca', 'co.uk', 'org.uk', 'de', 'ac', 'io', 'sh', 'at', 'co.nz', 'nl', 'gs', 'net.nz', 'org.nz', 'jp', 'com.mx', 'kids.us', 'me.uk', 'jobs', 'eu', 'am', 'be', 'it', 'fm', 'tel');

# Insert new data
INSERT INTO `tld_extra_attributes` VALUES('us', 'a:2:{s:8:"us_nexus";a:3:{s:2:"ID";s:1:"1";s:11:"description";s:14:"Nexus Category";s:7:"options";a:5:{s:10:"US Citizen";a:2:{s:11:"description";s:37:"A natural person who is a US Citizen.";s:5:"value";s:3:"C11";}s:18:"Permanent Resident";a:2:{s:11:"description";s:45:"A natural person who is a Permanent Resident.";s:5:"value";s:3:"C12";}s:15:"Business Entity";a:2:{s:11:"description";s:449:"An entity or organization that is (i) incorporated within one of the fifty US states, the District of Columbia, or any of the US possessions or territories, or (ii) organized or otherwise constituted under the laws of a state of the US, the District of Columbia or any of its possessions and territories (including federal, state, or local government of the US, or a political subdivision thereof, and non-commercial organizations based in the US.).";s:5:"value";s:3:"C21";}s:14:"Foreign Entity";a:3:{s:11:"description";s:286:"A foreign organization that regularly engages in lawful activities (sales of goods or services or other business, commercial, or non-commercial, including not for profit relations) in the United States. The CC equals to the country code of the organization, as defined in ISO 3166 [10].";s:5:"value";s:3:"C31";s:8:"requires";a:1:{i:0;s:1:"4";}}s:15:"US Based Office";a:3:{s:11:"description";s:146:"An organization has an office or other facility in the U.S., where CC equals to the country code of the organization, as defined in ISO 3166 [10].";s:5:"value";s:3:"C32";s:8:"requires";a:1:{i:0;s:1:"4";}}}}s:10:"us_purpose";a:3:{s:2:"ID";s:1:"2";s:11:"description";s:19:"Application Purpose";s:7:"options";a:5:{s:10:"For Profit";a:2:{s:11:"description";s:23:"Business use for profit";s:5:"value";s:2:"P1";}s:10:"Non-profit";a:2:{s:11:"description";s:68:"Non-profit business, club, association, religious organization, etc.";s:5:"value";s:2:"P2";}s:8:"Personal";a:2:{s:11:"description";s:12:"Personal use";s:5:"value";s:2:"P3";}s:11:"Educational";a:2:{s:11:"description";s:20:"Educational purposes";s:5:"value";s:2:"P4";}s:10:"Government";a:2:{s:11:"description";s:19:"Government purposes";s:5:"value";s:2:"P5";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('ca', 'a:5:{s:15:"cira_legal_type";a:3:{s:2:"ID";s:1:"5";s:11:"description";s:32:"Legal type of registrant contact";s:7:"options";a:18:{s:11:"Corporation";a:2:{s:11:"description";s:571:"A corporation under the laws of Canada or any province or territory of Canada, Charities, Cooperative, Council.<br/>Requirements: Registrant name must be the full legal name of the corporation and must be followed by the jurisdiction of incorporation (eg. Canada, Ontario, NWT...), unless it is obvious from the corporation''s name. Canadian Internet Registration Authority (Canada). For Charities, the NFP should be included in the organization name. If this is a not-for-profit organization, you are also required to submit the registration number i.e.: 123456789 RR0001";s:5:"value";s:3:"CCO";}s:16:"Canadian Citizen";a:3:{s:11:"description";s:885:"A Canadian citizen of the age of majority under the laws of the province or territory in Canada in which he or she resides or last resided.<br/>Requirements: The Registrant''s name must be the full legal name of the Canadian Citizen who will hold the domain name registration as the name would appear on a passport, driver''s license or other identification document issued by a government. The name can be followed by a space and "o/a xxxx" where "o/a" stands for "Operating As" and "xxxx" can be any alpha-numeric string designated by the applicant and subject to applicable rules and length restrictions (e.g. "John Doe o/a Doe Consulting Group"). The name may also be followed by a space and a degree granted to the registrant (eg. PhD.) Full legal names of individuals may only consist of alphabetic characters and the special characters: single quote mark(''), hyphen(-), period(.).";s:5:"value";s:3:"CCT";s:8:"requires";a:1:{i:0;s:3:"182";}}s:17:"Canadian Resident";a:3:{s:11:"description";s:1534:"A permanent resident as defined in the Immigration and Refugee Protection Act (Canada) S.C. 2001, c.27, as amended from time to time, who is "ordinarily resident" (as defined below) in Canada and of the age of majority under the laws of the province or territory in Canada in which he or she resides or last resided. "Ordinarily resident in Canada" means an individual who resides in Canada for more than 183 days in the twelve month period immediately preceding the date of the applicable request for registration of the .ca domain name or sub-domain name and in each twelve month period thereafter for the duration of the domain name registration.<br/>Requirements: The Registrant''s name must be the full legal name of the Permanent Resident who will hold the domain name registration as the name would appear on a driver''s license or other identification document issued by a government. The full legal name may be followed by a space and "o/a xxxx" where "o/a" stands for "Operating As" and "xxxx" can be any alpha-numeric string designated by the applicant and subject to applicable rules and length restrictions (e.g. "John Doe o/a Doe Consulting Group"). The name may also be followed by a space and a degree granted to the registrant by a recognized degree granting institution or a recognized professional designation which the registrant has the right to use (eg. PhD, MD, DDS.) Full legal names of individuals may only consist of alphabetic characters and the special characters: single quote mark(''), hyphen(-), period(.).";s:5:"value";s:3:"RES";s:8:"requires";a:1:{i:0;s:3:"182";}}s:17:"Government Entity";a:2:{s:11:"description";s:732:"Her Majesty the Queen in right of Canada, a province or a territory; an agent of Her Majesty the Queen in right of Canada, of a province or of a territory; a federal, provincial or territorial Crown corporation, government agency or government entity; or a regional, municipal or local area government.<br />Requirements: The Registrant''s name must be the complete official name of the entity that will hold the domain name registration, without any abbreviations. (A common abbreviation may follow the official name in parentheses). If the Registrant is not a government, the Registrant''s name must be followed by the name of the jurisdiction (eg. Canada, province, territory, municipality, etc) to which the Registrant is related.";s:5:"value";s:3:"GOV";}s:11:"Educational";a:2:{s:11:"description";s:983:"(i) A university or college which is located in Canada and which is authorized or recognized as a university or college under an Act of the legislature of a province or territory of Canada; or<br />(ii) A college, post-secondary school, vocational school, secondary school, pre-school or other school or educational institution which is located in Canada and which is recognized by the educational authorities of a province or territory of Canada or licensed under or maintained by an Act of Parliament of Canada or of the legislature of a province or territory of Canada.<br />Requirements: The Registrant''s name must be the complete official name of the institution that will hold the domain name registration, without any abbreviations. A common abbreviation may follow the official name in parentheses. The Registrant name must be followed by the jurisdiction (e.g. name of province, municipality) in which the institution is accredited if not obvious from the Registrant''s name.";s:5:"value";s:3:"EDU";}s:26:"Unincorporated Association";a:2:{s:11:"description";s:1067:"This Registrant Type is principally intended for religious congregations, social and sports clubs and community groups, council (not registered) or society (not registered) which are based and operating in Canada. An unincorporated organization, association or club:<br />(i) At least 80% of whose members: (A) are ordinarily resident in Canada (if such members are individuals); or (B) meet the requirements of any one of the following Registrant Types: Corporation (Canada or Canadian province or territory), Canadian citizen, Permanent Resident of Canada, Partnership Registered in Canada, Trust established in Canada, Legal Representative of a Canadian Citizen or Permanent Resident; and<br />(ii) At least 80% of whose directors, officers, employees, managers, administrators or other representatives are ordinarily resident in Canada.<br />Requirements: The Registrant''s name must be the complete name of the association that will hold the domain name registration, without any abbreviations. (A common abbreviation may follow the complete name in parentheses).";s:5:"value";s:3:"ASS";}s:8:"Hospital";a:2:{s:11:"description";s:565:"A hospital which is located in Canada and which is licensed, authorized or approved to operate as a hospital under an Act of the legislature of a province or territory of Canada<br />Requirements: The Registrant''s name must be the complete official name of the hospital that will hold the domain name registration, without any abbreviations. (A common abbreviation may follow the complete name in parentheses.) The Registrant''s name must be followed by the jurisdiction (eg. name of province) which accredited the hospital if not obvious from the Registrant''s name.";s:5:"value";s:3:"HOP";}s:11:"Partnership";a:2:{s:11:"description";s:666:"A partnership, more than 66 2/3 per cent of whose partners meet the requirements of one of the following Registrant Types: Corporation (Canada or Canadian province or territory), Canadian citizen, Permanent Resident of Canada, Trust established in Canada or a Legal Representative of a Canadian Citizen or Permanent Resident, which is registered as a partnership under the laws of any province or territory of Canada.<br />Requirements: The Registrant''s name must be the registered name of the partnership that will hold the domain name registration. The Registrant name must be followed by the jurisdiction of registration (eg. Alberta) and the registration number.";s:5:"value";s:3:"PRT";}s:10:"Trade-mark";a:2:{s:11:"description";s:898:"A Person which does not fall under any other registrant type, but which is the owner of a trade-mark which is the subject of a registration under the Trade-marks Act (Canada) R.S.C. 1985, c.T-13 as amended from time to time, but in this case such permission is limited to a request to register a .ca domain name consisting of or including the exact word component of that registered trade-mark.<br />This Registrant Type is only intended for Registrants which do not meet the requirements associated with any other registrant type but which have a trade-mark registered in Canada. (Trade-marks subject of trade-mark applications and trade-marks registered in other jurisdictions, such as the United States, do not qualify.)<br />The domain name to be registered must include the trade-mark. (eg. If the trade-mark is AVEA this type of registrant can register avea.ca or aveaisus.ca but not xyz.ca).";s:5:"value";s:3:"TDM";}s:11:"Trade Union";a:2:{s:11:"description";s:526:"A trade union which is recognized by a labour board under the laws of Canada or any province or territory of Canada and which has its head office in Canada.<br />Requirements: The Registrant''s name must be the complete official name of the trade union that will hold the domain name registration, without abbreviations. (A common abbreviation may follow the official name in parentheses.) The Registrant name must be followed by the jurisdiction in Canada which recognizes it (if it is not obvious from the Registrant''s name.)";s:5:"value";s:3:"TRD";}s:15:"Political Party";a:2:{s:11:"description";s:482:"A political party registered under a relevant electoral law of Canada or any province or territory of Canada<br />Requirements: The Registrant''s name must be the complete official name of the political party holding the domain name registration, without abbreviations. (A common abbreviation may follow the official name in parentheses.) The Registrant name must also by followed by the jurisdiction in Canada in which it is registered (if it is not obvious from the official name).";s:5:"value";s:3:"PLT";}s:26:"Library, Archive or Museum";a:2:{s:11:"description";s:633:"An institution, whether or not incorporated, that:<br />(i) is located in Canada; and<br />(ii) is not established or conducted for profit or does not form part of, or is not administered or directly or indirectly controlled by, a body that is established or conducted for profit in which is held and maintained a collection of documents and other materials that is open to the public or to researchers.<br />Requirements: The Registrant''s name  must be the complete legal name of the institution which will hold the domain name registration without abbreviations. (A common abbreviation may follow the complete name in parentheses.)";s:5:"value";s:3:"LAM";}s:5:"Trust";a:2:{s:11:"description";s:760:"A trust established and subsisting under the laws of a province or territory of Canada, more than 66 2/3 % of whose trustees meet the requirements of one of the following Registrant Types: Corporation (Canada or Canadian province or territory), Canadian citizen, Permanent Resident of Canada, or a Legal Representative of a Canadian Citizen or Permanent Resident.<br />Requirements: The Registrant''s name must be the complete official name of the trust, without any abbreviations. (A common abbreviation may follow the official name in parentheses.) The Registrant name must also indicate the total percentage of the trustees that meet one or more of the following requirements: Canadian citizen, permanent resident, Canadian corporation, legal representative.";s:5:"value";s:3:"TRS";}s:18:"Aboriginal Peoples";a:3:{s:11:"description";s:1346:"Any individual belonging to any Inuit, First Nation, Metis or other people indigenous to Canada.<br />Requirements: The Registrant''s name must be the full legal name of the Aboriginal Person applying for the Registration as it would appear on a driver''s license or other identification document issued by government.<br />The Registrant may enter its full legal name followed by a space and "o/a xxxx" where "o/a" stands for "Operating As" and "xxxx" can be any alpha-numeric string designated by the applicant and subject to applicable rules and length restrictions (e.g. "John Doe o/a Doe Consulting Group"). The name may also be followed by a space and a degree granted to the registrant by a recognized degree granting institution or a recognized professional designation which the registrant has the right to use  (eg. PhD, MD, DDS.)<br />Full legal names of individuals may only consist of alphabetic characters and the special characters: single quote mark(''''), hyphen(-), period(.).<br/>Groups: Any Inuit, First Nation, Metis or other people indigenous to Canada, and any collectivity of such Aboriginal peoples.<br />Requirements: The Registrant''s name must be the complete official name of the indigenous people a collectivity of Aboriginal Persons or, if there is no official name, the name by which the collectivity is commonly known.";s:5:"value";s:3:"ABO";s:8:"requires";a:1:{i:0;s:3:"182";}}s:11:"Indian Band";a:2:{s:11:"description";s:272:"Any Indian band as defined in the Indian Act, R.S.C. 1985, c. I-5, as amended from time to time, and any group of Indian bands;<br />Requirements: The name of Registrant must be the Indian Band Name as registered with the Department of Indian and Northern Affairs, Canada.";s:5:"value";s:3:"INB";}s:20:"Legal Representative";a:3:{s:11:"description";s:865:"An executor, administrator or other legal representative of a Person listed as a Canadian Citizen or Permanent Resident of Canada.<br />Note: This registrant type is only available to a person or entity that has been appointed by legal process to represent an individual who is not competent to represent him or herself. It is not available to anyone who represents a Canadian or foreign corporation  in any capacity.<br />Requirements: The Registrant''s name must be the full legal name of the Canadian Citizen or Permanent Resident of Canada who is being represented as it would appear on a passport, driver''s license or other government identification document. This must be followed by the full legal name and capacity of at least one of the official representatives. The representative should be identified as the administrative contact for these registrations.";s:5:"value";s:3:"LGR";s:8:"requires";a:1:{i:0;s:3:"182";}}s:13:"Official Mark";a:2:{s:11:"description";s:1242:"A Person which does not meet the requirements for any other Registrant Type, but which is a Person intended to be protected by Subsection 9(1) of the Trade-Marks Act (Canada) at whose request the Registrar of Trade-marks has published notice of adoption of any badge, crest, emblem, official mark or other mark pursuant to Subsection 9(1), but in this case such permission is limited to a request to register a .ca domain name consisting of or including the exact word component of such badge, crest, emblem, official mark or other mark in respect of which such Person requested publications.<br />Notes: This registrant type is only intended for Registrants which do not meet the requirements associated with any other registrant type but which have an Official Mark registered in Canada. The domain name must include the official mark (eg. If the official mark is WIPO, the registrant can register wipo.ca but not intellectual-property.ca)<br />Requirements: The Registrant''s name must be the complete official name of the entity holding the domain name registration without any abbreviations. (A common abbreviation may follow the complete name in parentheses.) The registration number of the official mark must follow the Registrant Name.";s:5:"value";s:3:"OMK";}s:9:"The Queen";a:2:{s:11:"description";s:183:"Her Majesty Queen Elizabeth the Second and her successors. Requirements: The Registrant''s name must be that of Her Majesty the Queen or, after a succession, the name of her successor.";s:5:"value";s:3:"MAJ";}}}s:18:"cira_whois_display";a:3:{s:2:"ID";s:3:"182";s:11:"description";s:34:"Hide registrant data in CIRA WHOIS";s:7:"options";a:2:{s:2:"No";a:2:{s:11:"description";s:61:"Do not hide the registrant contact information in CIRA WHOIS.";s:5:"value";s:4:"FULL";}s:3:"Yes";a:2:{s:11:"description";s:86:"Hide the registrant contact information in Cira WHOIS (only available to individuals).";s:5:"value";s:7:"PRIVATE";}}}s:13:"cira_language";a:3:{s:2:"ID";s:3:"180";s:11:"description";s:50:"The contact''s preferred language for communication";s:7:"options";a:2:{s:7:"English";a:2:{s:11:"description";s:52:"Use English for Registry to Registrant communication";s:5:"value";s:2:"en";}s:6:"French";a:2:{s:11:"description";s:51:"Use French for Registry to Registrant communication";s:5:"value";s:2:"fr";}}}s:22:"cira_agreement_version";a:3:{s:2:"ID";s:3:"181";s:11:"description";s:107:"Version of the CIRA Registrant Agreement displayed and agreed to by the Registrant on the Registrar website";s:7:"options";a:1:{s:3:"2.0";a:2:{s:11:"description";s:39:"Current Version of Registrant Agreement";s:5:"value";s:3:"2.0";}}}s:20:"cira_agreement_value";a:3:{s:2:"ID";s:3:"183";s:11:"description";s:52:"Registrant has agreed to CIRA''s Registrant Agreement";s:7:"options";a:2:{s:2:"No";a:2:{s:11:"description";s:875:""You have read, understood and agree to the terms and conditions of the Registrant\nAgreement, and that CIRA may, from time to time and at its discretion, amend any or all of\nthe terms and conditions of the Registrant Agreement, as CIRA deems appropriate, by\nposting a notice of the changes on the CIRA website and by sending a notice of any\nmaterial changes to Registrant.""You meet all the requirements of the Registrant Agreement to be a Registrant, to apply for\nthe registration of a Domain Name Registration, and to hold and maintain a Domain Name\nRegistration, including without limitation CIRA''s Canadian Presence Requirements for\nRegistrants, at: www.cira.ca/assets/Documents/Legal/Registrants/CPR.pdf.""CIRA will collect, use and disclose your personal information, as set out in CIRA''s\nPrivacy Policy, at: www.cira.ca/assets/Documents/Legal/Registrants/privacy.pdf."";s:5:"value";s:1:"N";}s:3:"Yes";a:2:{s:11:"description";s:875:""You have read, understood and agree to the terms and conditions of the Registrant\nAgreement, and that CIRA may, from time to time and at its discretion, amend any or all of\nthe terms and conditions of the Registrant Agreement, as CIRA deems appropriate, by\nposting a notice of the changes on the CIRA website and by sending a notice of any\nmaterial changes to Registrant.""You meet all the requirements of the Registrant Agreement to be a Registrant, to apply for\nthe registration of a Domain Name Registration, and to hold and maintain a Domain Name\nRegistration, including without limitation CIRA''s Canadian Presence Requirements for\nRegistrants, at: www.cira.ca/assets/Documents/Legal/Registrants/CPR.pdf.""CIRA will collect, use and disclose your personal information, as set out in CIRA''s\nPrivacy Policy, at: www.cira.ca/assets/Documents/Legal/Registrants/privacy.pdf."";s:5:"value";s:1:"Y";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('co.uk', 'a:3:{s:13:"uk_legal_type";a:3:{s:2:"ID";s:1:"6";s:11:"description";s:32:"Legal type of registrant contact";s:7:"options";a:17:{s:13:"UK Individual";a:2:{s:11:"description";s:33:"UK Individual (our default value)";s:5:"value";s:3:"IND";}s:37:"Non-UK Individual (representing self)";a:2:{s:11:"description";s:37:"Non-UK Individual (representing self)";s:5:"value";s:4:"FIND";}s:18:"UK Limited Company";a:3:{s:11:"description";s:18:"UK Limited Company";s:5:"value";s:3:"LTD";s:8:"requires";a:1:{i:0;s:1:"8";}}s:25:"UK Public Limited Company";a:3:{s:11:"description";s:25:"UK Public Limited Company";s:5:"value";s:3:"PLC";s:8:"requires";a:1:{i:0;s:1:"8";}}s:14:"UK Partnership";a:2:{s:11:"description";s:14:"UK Partnership";s:5:"value";s:4:"PTNR";}s:6:"UK LLP";a:3:{s:11:"description";s:32:"UK Limited Liability Partnership";s:5:"value";s:3:"LLP";s:8:"requires";a:1:{i:0;s:1:"8";}}s:14:"UK Sole Trader";a:2:{s:11:"description";s:14:"UK Sole Trader";s:5:"value";s:4:"STRA";}s:21:"UK Registered Charity";a:3:{s:11:"description";s:21:"UK Registered Charity";s:5:"value";s:5:"RCHAR";s:8:"requires";a:1:{i:0;s:1:"8";}}s:42:"UK Industrial/Provident Registered Company";a:2:{s:11:"description";s:42:"UK Industrial/Provident Registered Company";s:5:"value";s:2:"IP";}s:9:"UK School";a:2:{s:11:"description";s:9:"UK School";s:5:"value";s:3:"SCH";}s:13:"Other Foreign";a:2:{s:11:"description";s:27:"Other foreign organizations";s:5:"value";s:6:"FOTHER";}s:18:"UK Government Body";a:2:{s:11:"description";s:18:"UK Government Body";s:5:"value";s:3:"GOV";}s:31:"UK Corporation by Royal Charter";a:2:{s:11:"description";s:31:"UK Corporation by Royal Charter";s:5:"value";s:3:"CRC";}s:22:"UK Statutory Body FIND";a:2:{s:11:"description";s:22:"UK Statutory Body FIND";s:5:"value";s:4:"STAT";}s:17:"UK Entity (other)";a:2:{s:11:"description";s:17:"UK Entity (other)";s:5:"value";s:5:"OTHER";}s:18:"Non-UK Corporation";a:2:{s:11:"description";s:18:"Non-UK Corporation";s:5:"value";s:5:"FCORP";}s:27:"Non-UK Organization (other)";a:2:{s:11:"description";s:19:"Non-UK Organization";s:5:"value";s:6:"FOTHER";}}}s:12:"uk_reg_co_no";a:3:{s:2:"ID";s:1:"8";s:11:"description";s:29:"Company identification number";s:7:"options";a:0:{}}s:14:"registered_for";a:3:{s:2:"ID";s:2:"15";s:11:"description";s:88:"Company or person domain is registered for (this must be accurate and CANNOT BE CHANGED)";s:7:"options";a:0:{}}}');
INSERT INTO `tld_extra_attributes` VALUES('org.uk', 'a:3:{s:13:"uk_legal_type";a:3:{s:2:"ID";s:1:"7";s:11:"description";s:32:"Legal type of registrant contact";s:7:"options";a:17:{s:13:"UK Individual";a:2:{s:11:"description";s:33:"UK Individual (our default value)";s:5:"value";s:3:"IND";}s:37:"Non-UK Individual (representing self)";a:2:{s:11:"description";s:37:"Non-UK Individual (representing self)";s:5:"value";s:4:"FIND";}s:18:"UK Limited Company";a:3:{s:11:"description";s:18:"UK Limited Company";s:5:"value";s:3:"LTD";s:8:"requires";a:1:{i:0;s:1:"9";}}s:25:"UK Public Limited Company";a:3:{s:11:"description";s:25:"UK Public Limited Company";s:5:"value";s:3:"PLC";s:8:"requires";a:1:{i:0;s:1:"9";}}s:14:"UK Partnership";a:2:{s:11:"description";s:14:"UK Partnership";s:5:"value";s:4:"PTNR";}s:6:"UK LLP";a:3:{s:11:"description";s:32:"UK Limited Liability Partnership";s:5:"value";s:3:"LLP";s:8:"requires";a:1:{i:0;s:1:"9";}}s:14:"UK Sole Trader";a:2:{s:11:"description";s:14:"UK Sole Trader";s:5:"value";s:4:"STRA";}s:21:"UK Registered Charity";a:3:{s:11:"description";s:21:"UK Registered Charity";s:5:"value";s:5:"RCHAR";s:8:"requires";a:1:{i:0;s:1:"9";}}s:42:"UK Industrial/Provident Registered Company";a:2:{s:11:"description";s:42:"UK Industrial/Provident Registered Company";s:5:"value";s:2:"IP";}s:9:"UK School";a:2:{s:11:"description";s:9:"UK School";s:5:"value";s:3:"SCH";}s:13:"Other Foreign";a:2:{s:11:"description";s:27:"Other foreign organizations";s:5:"value";s:6:"FOTHER";}s:18:"UK Government Body";a:2:{s:11:"description";s:18:"UK Government Body";s:5:"value";s:3:"GOV";}s:31:"UK Corporation by Royal Charter";a:2:{s:11:"description";s:31:"UK Corporation by Royal Charter";s:5:"value";s:3:"CRC";}s:22:"UK Statutory Body FIND";a:2:{s:11:"description";s:22:"UK Statutory Body FIND";s:5:"value";s:4:"STAT";}s:17:"UK Entity (other)";a:2:{s:11:"description";s:17:"UK Entity (other)";s:5:"value";s:5:"OTHER";}s:18:"Non-UK Corporation";a:2:{s:11:"description";s:18:"Non-UK Corporation";s:5:"value";s:5:"FCORP";}s:27:"Non-UK Organization (other)";a:2:{s:11:"description";s:19:"Non-UK Organization";s:5:"value";s:6:"FOTHER";}}}s:12:"uk_reg_co_no";a:3:{s:2:"ID";s:1:"9";s:11:"description";s:29:"Company identification number";s:7:"options";a:0:{}}s:14:"registered_for";a:3:{s:2:"ID";s:2:"16";s:11:"description";s:88:"Company or person domain is registered for (this must be accurate and CANNOT BE CHANGED)";s:7:"options";a:0:{}}}');
INSERT INTO `tld_extra_attributes` VALUES('de', 'a:2:{s:14:"confirmaddress";a:3:{s:2:"ID";s:2:"18";s:11:"description";s:23:"Confirmation of address";s:7:"options";a:1:{s:47:"I confirm the below Admin contact is in Germany";a:2:{s:11:"description";s:68:"I confirm the Administrative address below is a valid German address";s:5:"value";s:2:"DE";}}}s:14:"de_agreedelete";a:3:{s:2:"ID";s:2:"60";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('ac', 'a:1:{s:14:"ac_agreedelete";a:3:{s:2:"ID";s:2:"57";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('io', 'a:1:{s:14:"io_agreedelete";a:3:{s:2:"ID";s:2:"58";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('sh', 'a:1:{s:14:"sh_agreedelete";a:3:{s:2:"ID";s:2:"59";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('at', 'a:1:{s:14:"at_agreedelete";a:3:{s:2:"ID";s:2:"46";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('co.nz', 'a:1:{s:17:"co.nz_agreedelete";a:3:{s:2:"ID";s:2:"53";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('nl', 'a:1:{s:14:"nl_agreedelete";a:3:{s:2:"ID";s:2:"47";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('gs', 'a:1:{s:14:"gs_agreedelete";a:3:{s:2:"ID";s:2:"51";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('net.nz', 'a:1:{s:18:"net.nz_agreedelete";a:3:{s:2:"ID";s:2:"52";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('org.nz', 'a:1:{s:18:"org.nz_agreedelete";a:3:{s:2:"ID";s:2:"54";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('jp', 'a:1:{s:14:"jp_agreedelete";a:3:{s:2:"ID";s:2:"62";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('com.mx', 'a:1:{s:18:"com_mx_agreedelete";a:3:{s:2:"ID";s:2:"55";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('kids.us', 'a:2:{s:8:"us_nexus";a:3:{s:2:"ID";s:2:"11";s:11:"description";s:14:"Nexus Category";s:7:"options";a:5:{s:10:"US Citizen";a:2:{s:11:"description";s:37:"A natural person who is a US Citizen.";s:5:"value";s:3:"C11";}s:18:"Permanent Resident";a:2:{s:11:"description";s:45:"A natural person who is a Permanent Resident.";s:5:"value";s:3:"C12";}s:15:"Business Entity";a:2:{s:11:"description";s:449:"An entity or organization that is (i) incorporated within one of the fifty US states, the District of Columbia, or any of the US possessions or territories, or (ii) organized or otherwise constituted under the laws of a state of the US, the District of Columbia or any of its possessions and territories (including federal, state, or local government of the US, or a political subdivision thereof, and non-commercial organizations based in the US.).";s:5:"value";s:3:"C21";}s:14:"Foreign Entity";a:3:{s:11:"description";s:286:"A foreign organization that regularly engages in lawful activities (sales of goods or services or other business, commercial, or non-commercial, including not for profit relations) in the United States. The CC equals to the country code of the organization, as defined in ISO 3166 [10].";s:5:"value";s:3:"C31";s:8:"requires";a:1:{i:0;s:2:"12";}}s:15:"US Based Office";a:3:{s:11:"description";s:146:"An organization has an office or other facility in the U.S., where CC equals to the country code of the organization, as defined in ISO 3166 [10].";s:5:"value";s:3:"C32";s:8:"requires";a:1:{i:0;s:2:"12";}}}}s:10:"us_purpose";a:3:{s:2:"ID";s:2:"13";s:11:"description";s:19:"Application Purpose";s:7:"options";a:5:{s:10:"For Profit";a:2:{s:11:"description";s:23:"Business use for profit";s:5:"value";s:2:"P1";}s:10:"Non-profit";a:2:{s:11:"description";s:68:"Non-profit business, club, association, religious organization, etc.";s:5:"value";s:2:"P2";}s:8:"Personal";a:2:{s:11:"description";s:12:"Personal use";s:5:"value";s:2:"P3";}s:11:"Educational";a:2:{s:11:"description";s:20:"Educational purposes";s:5:"value";s:2:"P4";}s:10:"Government";a:2:{s:11:"description";s:19:"Government purposes";s:5:"value";s:2:"P5";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('me.uk', 'a:3:{s:13:"uk_legal_type";a:3:{s:2:"ID";s:2:"33";s:11:"description";s:32:"Legal type of registrant contact";s:7:"options";a:17:{s:13:"UK Individual";a:2:{s:11:"description";s:33:"UK Individual (our default value)";s:5:"value";s:3:"IND";}s:37:"Non-UK Individual (representing self)";a:2:{s:11:"description";s:37:"Non-UK Individual (representing self)";s:5:"value";s:4:"FIND";}s:18:"UK Limited Company";a:3:{s:11:"description";s:18:"UK Limited Company";s:5:"value";s:3:"LTD";s:8:"requires";a:1:{i:0;s:2:"34";}}s:25:"UK Public Limited Company";a:3:{s:11:"description";s:25:"UK Public Limited Company";s:5:"value";s:3:"PLC";s:8:"requires";a:1:{i:0;s:2:"34";}}s:14:"UK Partnership";a:2:{s:11:"description";s:14:"UK Partnership";s:5:"value";s:4:"PTNR";}s:6:"UK LLP";a:3:{s:11:"description";s:32:"UK Limited Liability Partnership";s:5:"value";s:3:"LLP";s:8:"requires";a:1:{i:0;s:2:"34";}}s:14:"UK Sole Trader";a:2:{s:11:"description";s:14:"UK Sole Trader";s:5:"value";s:4:"STRA";}s:21:"UK Registered Charity";a:3:{s:11:"description";s:21:"UK Registered Charity";s:5:"value";s:5:"RCHAR";s:8:"requires";a:1:{i:0;s:2:"34";}}s:42:"UK Industrial/Provident Registered Company";a:2:{s:11:"description";s:42:"UK Industrial/Provident Registered Company";s:5:"value";s:2:"IP";}s:9:"UK School";a:2:{s:11:"description";s:9:"UK School";s:5:"value";s:3:"SCH";}s:13:"Other Foreign";a:2:{s:11:"description";s:27:"Other foreign organizations";s:5:"value";s:6:"FOTHER";}s:18:"UK Government Body";a:2:{s:11:"description";s:18:"UK Government Body";s:5:"value";s:3:"GOV";}s:31:"UK Corporation by Royal Charter";a:2:{s:11:"description";s:31:"UK Corporation by Royal Charter";s:5:"value";s:3:"CRC";}s:22:"UK Statutory Body FIND";a:2:{s:11:"description";s:22:"UK Statutory Body FIND";s:5:"value";s:4:"STAT";}s:17:"UK Entity (other)";a:2:{s:11:"description";s:17:"UK Entity (other)";s:5:"value";s:5:"OTHER";}s:18:"Non-UK Corporation";a:2:{s:11:"description";s:18:"Non-UK Corporation";s:5:"value";s:5:"FCORP";}s:27:"Non-UK Organization (other)";a:2:{s:11:"description";s:19:"Non-UK Organization";s:5:"value";s:6:"FOTHER";}}}s:12:"uk_reg_co_no";a:3:{s:2:"ID";s:2:"34";s:11:"description";s:29:"Company identification number";s:7:"options";a:0:{}}s:14:"registered_for";a:3:{s:2:"ID";s:2:"32";s:11:"description";s:88:"Company or person domain is registered for (this must be accurate and CANNOT BE CHANGED)";s:7:"options";a:0:{}}}');
INSERT INTO `tld_extra_attributes` VALUES('jobs', 'a:1:{s:16:"jobs_agreedelete";a:3:{s:2:"ID";s:2:"56";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('eu', 'a:1:{s:14:"eu_whoispolicy";a:3:{s:2:"ID";s:2:"45";s:11:"description";s:29:"Registry Data Transfer Policy";s:7:"options";a:1:{s:7:"I AGREE";a:2:{s:11:"description";s:458:"I hereby agree that the Registry is entitled to transfer the data contained in this application to third parties (i) if ordered to do so by a public authority, carrying out its legitimate tasks; and (ii) upon demand of an ADR Provider as mentioned in section 16 of the Terms and Conditions which are published at www.eurid.eu; and (iii) as provided in Section 2 (WHOIS look-up facility) of the .eu Domain Name WHOIS Policy which is published at www.eurid.eu.";s:5:"value";s:7:"I AGREE";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('am', 'a:1:{s:14:"am_agreedelete";a:3:{s:2:"ID";s:2:"48";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('be', 'a:1:{s:14:"be_agreedelete";a:3:{s:2:"ID";s:2:"61";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('it', 'a:8:{s:14:"it_agreedelete";a:3:{s:2:"ID";s:2:"49";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:487:"I agree to and acknowledge the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement. I understand that Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account. If the RENEWAL DATE has passed and Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}s:6:"it_pin";a:3:{s:2:"ID";s:3:"151";s:11:"description";s:342:"Tax ID. If the requester is an Italian natural person it contains his/her Codice Fiscale. \nFor foreigners it can contain a  document number. For associations without VAT number and tax code must be equal to "n.a.". \nIn all the other cases must be equal to VAT number (in the 11 numbers format if Nationality=IT) or the numeric Codice Fiscale.";s:7:"options";a:1:{s:14:"Codice Fiscale";a:2:{s:11:"description";s:334:"If the requester is an Italian natural person it contains his/her Codice Fiscale. \nFor foreigners it can contain a  document number. For associations without VAT number and tax code must be equal to "n.a.". \nIn all the other cases must be equal to VAT number (in the 11 numbers format if Nationality=IT) or the numeric Codice Fiscale.";s:5:"value";s:1:"1";}}}s:14:"it_entity_type";a:3:{s:2:"ID";s:3:"152";s:11:"description";s:25:"Type of Registrant Entity";s:7:"options";a:7:{s:38:"1. Italian and foreign natural persons";a:2:{s:11:"description";s:35:"Italian and foreign natural persons";s:5:"value";s:1:"1";}s:30:"2. Companies/One Man Companies";a:2:{s:11:"description";s:27:"Companies/One Man Companies";s:5:"value";s:1:"2";}s:34:"3. Freelance workers/professionals";a:2:{s:11:"description";s:31:"Freelance workers/professionals";s:5:"value";s:1:"3";}s:27:"4. Non-Profit Organizations";a:2:{s:11:"description";s:24:"Non-Profit Organizations";s:5:"value";s:1:"4";}s:23:"5. Public Organizations";a:2:{s:11:"description";s:20:"Public Organizations";s:5:"value";s:1:"5";}s:17:"6. Other Subjects";a:2:{s:11:"description";s:14:"Other Subjects";s:5:"value";s:1:"6";}s:27:"7. Foreigners who match 2-6";a:2:{s:11:"description";s:24:"Foreigners who match 2-6";s:5:"value";s:1:"7";}}}s:23:"it_consentforpublishing";a:3:{s:2:"ID";s:3:"153";s:11:"description";s:59:"Allow the publication of contact''s personal data (optional)";s:7:"options";a:1:{s:17:"Allow Publication";a:2:{s:11:"description";s:17:"Allow Publication";s:5:"value";s:1:"1";}}}s:24:"it_personal_data_for_reg";a:3:{s:2:"ID";s:3:"154";s:11:"description";s:37:"Consent for Processing of Information";s:7:"options";a:1:{s:5:"Agree";a:2:{s:11:"description";s:323:"The interested party, after reading the above disclosure, gives consent to the processing of\ninformation required for registration, as defined in the above disclosure.\nGiving consent is optional, but if no consent is given, it will not be possible to finalize the\nregistration, assignment and management of the domain name.";s:5:"value";s:1:"1";}}}s:19:"it_datafordiffusion";a:3:{s:2:"ID";s:3:"174";s:11:"description";s:60:"Consent for Dissemination and Accessibility via the Internet";s:7:"options";a:1:{s:5:"Agree";a:2:{s:11:"description";s:284:"The interested party, after reading the above disclosure, gives consent to the dissemination\nand accessibility via the Internet, as defined in the disclosure above.\nGiving consent is optional, but absence of consent does not allow the dissemination and\naccessibility of Internet data.";s:5:"value";s:1:"1";}}}s:18:"it_sect3_liability";a:3:{s:2:"ID";s:3:"155";s:11:"description";s:20:"Terms and Conditions";s:7:"options";a:1:{s:5:"Agree";a:2:{s:11:"description";s:1713:"The Registrant of the domain name in question, declares under their own responsibility that\nthey are:<br>\na) in possession of the citizenship or resident in a country belonging to the European\n   Union (in the case of registration for natural persons);<br>\nb) established in a country belonging to the European Union (in the case of registration\n   for other organizations););<br>\nc) aware and accept that the registration and management of a domain name is subject to\n   the "Rules of assignment and management of domain names in ccTLD. it" and"Regulations for the resolution of disputes in the ccTLD.it" and their subsequent\n   amendments;);<br>\nd) entitled to the use and/or legal availability of the domain name applied for, and that\n   they do not prejudice, with the request for registration, the rights of others;);<br>\ne) aware that for the inclusion of personal data in the Database of assigned domain\n   names, and their possible dissemination and accessibility via the Internet, consent\n   must be given explicitly by ticking the appropriate boxes in the information below.\n   See "The policy of the .it Registry in the Whois Database" on the website of the\n   Registry (http://www.nic.it););<br>\nf) aware and agree that in the case of erroneous or false declarations in this request, the\n   Registry shall immediately revoke the domain name, or proceed with other legal\n   actions. In such case the revocation shall not in any way give rise to claims against the\n   Registry;);<br>\ng) release the Registry from any liability resulting from the assignment and use of the\n   domain name by the natural person that has made the request;);<br>\nh) accept Italian jurisdiction and laws of the Italian State.";s:5:"value";s:1:"1";}}}s:22:"it_explicit_acceptance";a:3:{s:2:"ID";s:3:"175";s:11:"description";s:37:"Explicit Acceptance of Registry Terms";s:7:"options";a:1:{s:5:"Agree";a:2:{s:11:"description";s:844:"For explicit acceptance, the interested party declares that they:<br>\nc) are aware and agree that the registration and management of a domain name is subject to\n   the "Rules of assignment and management of domain names in ccTLD.it" and "Regulations\n   for the resolution of disputes in the ccTLD.it "and their subsequent amendments;<br>\nf) are aware and agree that in the case of erroneous or false declarations in this request, the\n   Registry shall immediately revoke the domain name, or proceed with other legal actions. In\n   such case the revocation shall not in any way give rise to claims against the Registry;<br>\ng) release the Registry from any liability resulting from the assignment and use of the\n   domain name by the natural person that has made the request;<br>\nh) accept the Italian jurisdiction and laws of the Italian State.";s:5:"value";s:1:"1";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('fm', 'a:1:{s:14:"fm_agreedelete";a:3:{s:2:"ID";s:2:"50";s:11:"description";s:49:"I agree to the renewal terms for this domain name";s:7:"options";a:1:{s:3:"YES";a:2:{s:11:"description";s:499:"I agree and acknowledge to the special renewal and expiration terms set forth below for this domain name, including those terms set forth in the Registration Agreement.  I understand that Auto Renew must be enabled for this domain name prior to the RENEWAL DATE or this domain will be deleted from my account.  If the RENEWAL DATE has passed and Auto Renew has not been enabled, no modifications will be allowed for this domain and this domain will continue to resolve until deleted by the registry.";s:5:"value";s:3:"YES";}}}}');
INSERT INTO `tld_extra_attributes` VALUES('tel', 'a:4:{s:13:"tel_whoistype";a:3:{s:2:"ID";s:3:"144";s:11:"description";s:23:"Natural or Legal Person";s:7:"options";a:2:{s:14:"Natural Person";a:3:{s:11:"description";s:14:"Natural Person";s:5:"value";s:14:"natural_person";s:8:"requires";a:1:{i:0;s:3:"145";}}s:12:"Legal Person";a:2:{s:11:"description";s:12:"Legal Person";s:5:"value";s:12:"legal_person";}}}s:12:"tel_username";a:3:{s:2:"ID";s:3:"147";s:11:"description";s:8:"Username";s:7:"options";a:0:{}}s:12:"tel_password";a:3:{s:2:"ID";s:3:"148";s:11:"description";s:8:"Password";s:7:"options";a:0:{}}s:16:"tel_emailaddress";a:3:{s:2:"ID";s:3:"150";s:11:"description";s:13:"Email Address";s:7:"options";a:0:{}}}');
