<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * LoyaltyReward Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 * Note: This endpoint is in beta.
 */
class LoyaltyReward implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'id' => 'string',
        'status' => 'string',
        'loyalty_account_id' => 'string',
        'reward_tier_id' => 'string',
        'points' => 'int',
        'order_id' => 'string',
        'created_at' => 'string',
        'updated_at' => 'string',
        'redeemed_at' => 'string'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'id' => 'id',
        'status' => 'status',
        'loyalty_account_id' => 'loyalty_account_id',
        'reward_tier_id' => 'reward_tier_id',
        'points' => 'points',
        'order_id' => 'order_id',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'redeemed_at' => 'redeemed_at'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'id' => 'setId',
        'status' => 'setStatus',
        'loyalty_account_id' => 'setLoyaltyAccountId',
        'reward_tier_id' => 'setRewardTierId',
        'points' => 'setPoints',
        'order_id' => 'setOrderId',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'redeemed_at' => 'setRedeemedAt'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'id' => 'getId',
        'status' => 'getStatus',
        'loyalty_account_id' => 'getLoyaltyAccountId',
        'reward_tier_id' => 'getRewardTierId',
        'points' => 'getPoints',
        'order_id' => 'getOrderId',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'redeemed_at' => 'getRedeemedAt'
    );
  
    /**
      * $id The Square-assigned ID of the loyalty reward.
      * @var string
      */
    protected $id;
    /**
      * $status The status of a loyalty reward. See [LoyaltyRewardStatus](#type-loyaltyrewardstatus) for possible values
      * @var string
      */
    protected $status;
    /**
      * $loyalty_account_id The Square-assigned ID of the `loyalty account` to which the reward belongs.
      * @var string
      */
    protected $loyalty_account_id;
    /**
      * $reward_tier_id The Square-assigned ID of the `reward tier` used to create the reward.
      * @var string
      */
    protected $reward_tier_id;
    /**
      * $points The number of loyalty points used for the reward.
      * @var int
      */
    protected $points;
    /**
      * $order_id The Square-assigned ID of the `order` to which the reward is attached.
      * @var string
      */
    protected $order_id;
    /**
      * $created_at The timestamp when the reward was created, in RFC 3339 format.
      * @var string
      */
    protected $created_at;
    /**
      * $updated_at The timestamp when the reward was last updated, in RFC 3339 format.
      * @var string
      */
    protected $updated_at;
    /**
      * $redeemed_at The timestamp when the reward was redeemed, in RFC 3339 format.
      * @var string
      */
    protected $redeemed_at;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["id"])) {
              $this->id = $data["id"];
            } else {
              $this->id = null;
            }
            if (isset($data["status"])) {
              $this->status = $data["status"];
            } else {
              $this->status = null;
            }
            if (isset($data["loyalty_account_id"])) {
              $this->loyalty_account_id = $data["loyalty_account_id"];
            } else {
              $this->loyalty_account_id = null;
            }
            if (isset($data["reward_tier_id"])) {
              $this->reward_tier_id = $data["reward_tier_id"];
            } else {
              $this->reward_tier_id = null;
            }
            if (isset($data["points"])) {
              $this->points = $data["points"];
            } else {
              $this->points = null;
            }
            if (isset($data["order_id"])) {
              $this->order_id = $data["order_id"];
            } else {
              $this->order_id = null;
            }
            if (isset($data["created_at"])) {
              $this->created_at = $data["created_at"];
            } else {
              $this->created_at = null;
            }
            if (isset($data["updated_at"])) {
              $this->updated_at = $data["updated_at"];
            } else {
              $this->updated_at = null;
            }
            if (isset($data["redeemed_at"])) {
              $this->redeemed_at = $data["redeemed_at"];
            } else {
              $this->redeemed_at = null;
            }
        }
    }
    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
  
    /**
     * Sets id
     * @param string $id The Square-assigned ID of the loyalty reward.
     * @return $this
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
  
    /**
     * Sets status
     * @param string $status The status of a loyalty reward. See [LoyaltyRewardStatus](#type-loyaltyrewardstatus) for possible values
     * @return $this
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Gets loyalty_account_id
     * @return string
     */
    public function getLoyaltyAccountId()
    {
        return $this->loyalty_account_id;
    }
  
    /**
     * Sets loyalty_account_id
     * @param string $loyalty_account_id The Square-assigned ID of the `loyalty account` to which the reward belongs.
     * @return $this
     */
    public function setLoyaltyAccountId($loyalty_account_id)
    {
        $this->loyalty_account_id = $loyalty_account_id;
        return $this;
    }
    /**
     * Gets reward_tier_id
     * @return string
     */
    public function getRewardTierId()
    {
        return $this->reward_tier_id;
    }
  
    /**
     * Sets reward_tier_id
     * @param string $reward_tier_id The Square-assigned ID of the `reward tier` used to create the reward.
     * @return $this
     */
    public function setRewardTierId($reward_tier_id)
    {
        $this->reward_tier_id = $reward_tier_id;
        return $this;
    }
    /**
     * Gets points
     * @return int
     */
    public function getPoints()
    {
        return $this->points;
    }
  
    /**
     * Sets points
     * @param int $points The number of loyalty points used for the reward.
     * @return $this
     */
    public function setPoints($points)
    {
        $this->points = $points;
        return $this;
    }
    /**
     * Gets order_id
     * @return string
     */
    public function getOrderId()
    {
        return $this->order_id;
    }
  
    /**
     * Sets order_id
     * @param string $order_id The Square-assigned ID of the `order` to which the reward is attached.
     * @return $this
     */
    public function setOrderId($order_id)
    {
        $this->order_id = $order_id;
        return $this;
    }
    /**
     * Gets created_at
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->created_at;
    }
  
    /**
     * Sets created_at
     * @param string $created_at The timestamp when the reward was created, in RFC 3339 format.
     * @return $this
     */
    public function setCreatedAt($created_at)
    {
        $this->created_at = $created_at;
        return $this;
    }
    /**
     * Gets updated_at
     * @return string
     */
    public function getUpdatedAt()
    {
        return $this->updated_at;
    }
  
    /**
     * Sets updated_at
     * @param string $updated_at The timestamp when the reward was last updated, in RFC 3339 format.
     * @return $this
     */
    public function setUpdatedAt($updated_at)
    {
        $this->updated_at = $updated_at;
        return $this;
    }
    /**
     * Gets redeemed_at
     * @return string
     */
    public function getRedeemedAt()
    {
        return $this->redeemed_at;
    }
  
    /**
     * Sets redeemed_at
     * @param string $redeemed_at The timestamp when the reward was redeemed, in RFC 3339 format.
     * @return $this
     */
    public function setRedeemedAt($redeemed_at)
    {
        $this->redeemed_at = $redeemed_at;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
